/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.hadooptransjobexecutor;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs.FileObject;
import org.apache.log4j.Appender;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.annotations.JobEntry;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.hadoop.HadoopConfigurationBootstrap;
import org.pentaho.di.core.logging.Log4jFileAppender;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.namedcluster.NamedClusterManager;
import org.pentaho.di.core.namedcluster.model.NamedCluster;
import org.pentaho.di.core.plugins.JobEntryPluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransConfiguration;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.hadoopexit.HadoopExitMeta;
import org.pentaho.di.ui.job.entries.hadoopjobexecutor.UserDefinedItem;
import org.pentaho.di.version.BuildVersion;
import org.pentaho.hadoop.PluginPropertiesUtil;
import org.pentaho.hadoop.mapreduce.InKeyValueOrdinals;
import org.pentaho.hadoop.mapreduce.OutKeyValueOrdinals;
import org.pentaho.hadoop.shim.ConfigurationException;
import org.pentaho.hadoop.shim.HadoopConfiguration;
import org.pentaho.hadoop.shim.api.Configuration;
import org.pentaho.hadoop.shim.api.fs.FileSystem;
import org.pentaho.hadoop.shim.api.fs.Path;
import org.pentaho.hadoop.shim.api.mapred.RunningJob;
import org.pentaho.hadoop.shim.api.mapred.TaskCompletionEvent;
import org.pentaho.hadoop.shim.spi.HadoopShim;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.w3c.dom.Node;

@JobEntry(id="HadoopTransJobExecutorPlugin", image="HDT.png", name="HadoopTransJobExecutorPlugin.Name", description="HadoopTransJobExecutorPlugin.Description", categoryDescription="i18n:org.pentaho.di.job:JobCategory.Category.BigData", i18nPackageName="org.pentaho.di.job.entries.hadooptransjobexecutor")
public class JobEntryHadoopTransJobExecutor
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryHadoopTransJobExecutor.class;
    private String hadoopJobName;
    private String mapRepositoryDir;
    private String mapRepositoryFile;
    private ObjectId mapRepositoryReference;
    private String mapTrans;
    private String combinerRepositoryDir;
    private String combinerRepositoryFile;
    private ObjectId combinerRepositoryReference;
    private String combinerTrans;
    private boolean combiningSingleThreaded = true;
    private String reduceRepositoryDir;
    private String reduceRepositoryFile;
    private ObjectId reduceRepositoryReference;
    private String reduceTrans;
    private boolean reducingSingleThreaded = true;
    private String mapInputStepName;
    private String mapOutputStepName;
    private String combinerInputStepName;
    private String combinerOutputStepName;
    private String reduceInputStepName;
    private String reduceOutputStepName;
    private boolean suppressOutputMapKey;
    private boolean suppressOutputMapValue;
    private boolean suppressOutputKey;
    private boolean suppressOutputValue;
    private String inputFormatClass;
    private String outputFormatClass;
    private String clusterName;
    private String hdfsHostname;
    private String hdfsPort;
    private String jobTrackerHostname;
    private String jobTrackerPort;
    private String inputPath;
    private String outputPath;
    private boolean cleanOutputPath;
    private boolean blocking;
    private String loggingInterval = "60";
    private String numMapTasks = "1";
    private String numReduceTasks = "1";
    private List<UserDefinedItem> userDefined = new ArrayList<UserDefinedItem>();
    public static final String PENTAHO_MAPREDUCE_PROPERTY_USE_DISTRIBUTED_CACHE = "pmr.use.distributed.cache";
    public static final String PENTAHO_MAPREDUCE_PROPERTY_PMR_LIBRARIES_ARCHIVE_FILE = "pmr.libraries.archive.file";
    public static final String PENTAHO_MAPREDUCE_PROPERTY_KETTLE_HDFS_INSTALL_DIR = "pmr.kettle.dfs.install.dir";
    public static final String PENTAHO_MAPREDUCE_PROPERTY_KETTLE_INSTALLATION_ID = "pmr.kettle.installation.id";
    public static final String PENTAHO_MAPREDUCE_PROPERTY_ADDITIONAL_PLUGINS = "pmr.kettle.additional.plugins";

    public String getHadoopJobName() {
        return this.hadoopJobName;
    }

    public void setHadoopJobName(String hadoopJobName) {
        this.hadoopJobName = hadoopJobName;
    }

    public String getMapTrans() {
        return this.mapTrans;
    }

    public void setMapTrans(String mapTrans) {
        this.mapTrans = mapTrans;
    }

    public String getCombinerTrans() {
        return this.combinerTrans;
    }

    public void setCombinerTrans(String combinerTrans) {
        this.combinerTrans = combinerTrans;
    }

    public String getReduceTrans() {
        return this.reduceTrans;
    }

    public void setReduceTrans(String reduceTrans) {
        this.reduceTrans = reduceTrans;
    }

    public String getMapRepositoryDir() {
        return this.mapRepositoryDir;
    }

    public void setMapRepositoryDir(String mapRepositoryDir) {
        this.mapRepositoryDir = mapRepositoryDir;
    }

    public String getMapRepositoryFile() {
        return this.mapRepositoryFile;
    }

    public void setMapRepositoryFile(String mapRepositoryFile) {
        this.mapRepositoryFile = mapRepositoryFile;
    }

    public ObjectId getMapRepositoryReference() {
        return this.mapRepositoryReference;
    }

    public void setMapRepositoryReference(ObjectId mapRepositoryReference) {
        this.mapRepositoryReference = mapRepositoryReference;
    }

    public String getCombinerRepositoryDir() {
        return this.combinerRepositoryDir;
    }

    public void setCombinerRepositoryDir(String combinerRepositoryDir) {
        this.combinerRepositoryDir = combinerRepositoryDir;
    }

    public String getCombinerRepositoryFile() {
        return this.combinerRepositoryFile;
    }

    public void setCombinerRepositoryFile(String combinerRepositoryFile) {
        this.combinerRepositoryFile = combinerRepositoryFile;
    }

    public ObjectId getCombinerRepositoryReference() {
        return this.combinerRepositoryReference;
    }

    public void setCombinerRepositoryReference(ObjectId combinerRepositoryReference) {
        this.combinerRepositoryReference = combinerRepositoryReference;
    }

    public String getReduceRepositoryDir() {
        return this.reduceRepositoryDir;
    }

    public void setReduceRepositoryDir(String reduceRepositoryDir) {
        this.reduceRepositoryDir = reduceRepositoryDir;
    }

    public String getReduceRepositoryFile() {
        return this.reduceRepositoryFile;
    }

    public void setReduceRepositoryFile(String reduceRepositoryFile) {
        this.reduceRepositoryFile = reduceRepositoryFile;
    }

    public ObjectId getReduceRepositoryReference() {
        return this.reduceRepositoryReference;
    }

    public void setReduceRepositoryReference(ObjectId reduceRepositoryReference) {
        this.reduceRepositoryReference = reduceRepositoryReference;
    }

    public String getMapInputStepName() {
        return this.mapInputStepName;
    }

    public void setMapInputStepName(String mapInputStepName) {
        this.mapInputStepName = mapInputStepName;
    }

    public String getMapOutputStepName() {
        return this.mapOutputStepName;
    }

    public void setMapOutputStepName(String mapOutputStepName) {
        this.mapOutputStepName = mapOutputStepName;
    }

    public String getCombinerInputStepName() {
        return this.combinerInputStepName;
    }

    public void setCombinerInputStepName(String combinerInputStepName) {
        this.combinerInputStepName = combinerInputStepName;
    }

    public String getCombinerOutputStepName() {
        return this.combinerOutputStepName;
    }

    public void setCombinerOutputStepName(String combinerOutputStepName) {
        this.combinerOutputStepName = combinerOutputStepName;
    }

    public String getReduceInputStepName() {
        return this.reduceInputStepName;
    }

    public void setReduceInputStepName(String reduceInputStepName) {
        this.reduceInputStepName = reduceInputStepName;
    }

    public String getReduceOutputStepName() {
        return this.reduceOutputStepName;
    }

    public void setReduceOutputStepName(String reduceOutputStepName) {
        this.reduceOutputStepName = reduceOutputStepName;
    }

    public void setSuppressOutputOfMapKey(boolean suppress) {
        this.suppressOutputMapKey = suppress;
    }

    public boolean getSuppressOutputOfMapKey() {
        return this.suppressOutputMapKey;
    }

    public void setSuppressOutputOfMapValue(boolean suppress) {
        this.suppressOutputMapValue = suppress;
    }

    public boolean getSuppressOutputOfMapValue() {
        return this.suppressOutputMapValue;
    }

    public void setSuppressOutputOfKey(boolean suppress) {
        this.suppressOutputKey = suppress;
    }

    public boolean getSuppressOutputOfKey() {
        return this.suppressOutputKey;
    }

    public void setSuppressOutputOfValue(boolean suppress) {
        this.suppressOutputValue = suppress;
    }

    public boolean getSuppressOutputOfValue() {
        return this.suppressOutputValue;
    }

    public String getInputFormatClass() {
        return this.inputFormatClass;
    }

    public void setInputFormatClass(String inputFormatClass) {
        this.inputFormatClass = inputFormatClass;
    }

    public String getOutputFormatClass() {
        return this.outputFormatClass;
    }

    public void setOutputFormatClass(String outputFormatClass) {
        this.outputFormatClass = outputFormatClass;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getHdfsHostname() {
        return this.hdfsHostname;
    }

    public void setHdfsHostname(String hdfsHostname) {
        this.hdfsHostname = hdfsHostname;
    }

    public String getHdfsPort() {
        return this.hdfsPort;
    }

    public void setHdfsPort(String hdfsPort) {
        this.hdfsPort = hdfsPort;
    }

    public String getJobTrackerHostname() {
        return this.jobTrackerHostname;
    }

    public void setJobTrackerHostname(String jobTrackerHostname) {
        this.jobTrackerHostname = jobTrackerHostname;
    }

    public String getJobTrackerPort() {
        return this.jobTrackerPort;
    }

    public void setJobTrackerPort(String jobTrackerPort) {
        this.jobTrackerPort = jobTrackerPort;
    }

    public String getInputPath() {
        return this.inputPath;
    }

    public void setInputPath(String inputPath) {
        this.inputPath = inputPath;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public boolean isCleanOutputPath() {
        return this.cleanOutputPath;
    }

    public void setCleanOutputPath(boolean cleanOutputPath) {
        this.cleanOutputPath = cleanOutputPath;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    public String getLoggingInterval() {
        return this.loggingInterval;
    }

    public void setLoggingInterval(String loggingInterval) {
        this.loggingInterval = loggingInterval;
    }

    public List<UserDefinedItem> getUserDefined() {
        return this.userDefined;
    }

    public void setUserDefined(List<UserDefinedItem> userDefined) {
        this.userDefined = userDefined;
    }

    public String getNumMapTasks() {
        return this.numMapTasks;
    }

    public void setNumMapTasks(String numMapTasks) {
        this.numMapTasks = numMapTasks;
    }

    public String getNumReduceTasks() {
        return this.numReduceTasks;
    }

    public void setNumReduceTasks(String numReduceTasks) {
        this.numReduceTasks = numReduceTasks;
    }

    private static final TransMeta loadTransMeta(VariableSpace space, Repository rep, String filename, ObjectId transformationId, String repositoryDir, String repositoryFile) throws KettleException {
        TransMeta transMeta = null;
        if (!Const.isEmpty((String)filename)) {
            String realFilename = space.environmentSubstitute(filename);
            transMeta = new TransMeta(realFilename);
        } else if (transformationId != null) {
            if (rep != null) {
                transMeta = rep.loadTransformation(transformationId, null);
            }
        } else if (!Const.isEmpty((String)repositoryDir) && !Const.isEmpty((String)repositoryFile) && rep != null) {
            String mapRepositoryDirS = space.environmentSubstitute(repositoryDir);
            String mapRepositoryFileS = space.environmentSubstitute(repositoryFile);
            RepositoryDirectoryInterface repositoryDirectory = rep.loadRepositoryDirectoryTree().findDirectory(mapRepositoryDirS);
            transMeta = rep.loadTransformation(mapRepositoryFileS, repositoryDirectory, null, true, null);
        }
        return transMeta;
    }

    public Result execute(Result result, int arg1) throws KettleException {
        Log4jFileAppender appender;
        block66: {
            result.setNrErrors(0L);
            appender = null;
            String logFileName = "pdi-" + this.getName();
            try {
                appender = LogWriter.createFileAppender((String)logFileName, (boolean)true, (boolean)false);
                LogWriter.getInstance().addAppender((Appender)appender);
                this.log.setLogLevel(this.parentJob.getLogLevel());
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.FailedToOpenLogFile", (String[])new String[]{logFileName, e.toString()}));
                this.logError(Const.getStackTracker((Throwable)e));
            }
            try {
                Properties pmrProperties;
                String numReduceTasksS;
                String numMapTasksS;
                Path outputPathPath;
                FileSystem fs;
                Configuration conf;
                HadoopShim shim;
                HadoopConfiguration hadoopConfig;
                block65: {
                    block64: {
                        hadoopConfig = this.getHadoopConfiguration();
                        shim = hadoopConfig.getHadoopShim();
                        ClassLoader loader = shim.getClass().getClassLoader();
                        conf = shim.createConfiguration();
                        String hadoopJobNameS = this.environmentSubstitute(this.hadoopJobName);
                        conf.setJobName(hadoopJobNameS);
                        TransExecutionConfiguration transExecConfig = new TransExecutionConfiguration();
                        TransMeta transMeta = JobEntryHadoopTransJobExecutor.loadTransMeta((VariableSpace)this, this.rep, this.mapTrans, this.mapRepositoryReference, this.mapRepositoryDir, this.mapRepositoryFile);
                        TransConfiguration transConfig = new TransConfiguration(transMeta, transExecConfig);
                        String mapInputStepNameS = this.environmentSubstitute(this.mapInputStepName);
                        String mapOutputStepNameS = this.environmentSubstitute(this.mapOutputStepName);
                        try {
                            JobEntryHadoopTransJobExecutor.verifyTransMeta(transMeta, mapInputStepNameS, mapOutputStepNameS);
                        }
                        catch (Exception ex) {
                            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.MapConfiguration.Error", (String[])new String[0]), (Throwable)ex);
                        }
                        conf.set("transformation-map-xml", transConfig.getXML());
                        conf.set("transformation-map-input-stepname", mapInputStepNameS);
                        conf.set("transformation-map-output-stepname", mapOutputStepNameS);
                        conf.set("transformation-combine-single-threaded", this.combiningSingleThreaded ? "true" : "false");
                        conf.set("transformation-reduce-single-threaded", this.reducingSingleThreaded ? "true" : "false");
                        if (this.getSuppressOutputOfMapKey()) {
                            conf.setMapOutputKeyClass(shim.getHadoopWritableCompatibleClass(null));
                        }
                        if (this.getSuppressOutputOfMapValue()) {
                            conf.setMapOutputValueClass(shim.getHadoopWritableCompatibleClass(null));
                        }
                        if (!this.getSuppressOutputOfMapKey() || !this.getSuppressOutputOfMapValue() && transMeta != null) {
                            StepMeta mapOut = transMeta.findStep(mapOutputStepNameS);
                            RowMetaInterface prevStepFields = transMeta.getPrevStepFields(mapOut);
                            if (mapOut.getStepMetaInterface() instanceof HadoopExitMeta) {
                                ValueMetaInterface valueVM;
                                String keyName = ((HadoopExitMeta)mapOut.getStepMetaInterface()).getOutKeyFieldname();
                                String valName = ((HadoopExitMeta)mapOut.getStepMetaInterface()).getOutValueFieldname();
                                int keyI = prevStepFields.indexOfValue(keyName);
                                ValueMetaInterface keyVM = keyI >= 0 ? prevStepFields.getValueMeta(keyI) : null;
                                int valI = prevStepFields.indexOfValue(valName);
                                ValueMetaInterface valueMetaInterface = valueVM = valI >= 0 ? prevStepFields.getValueMeta(valI) : null;
                                if (!this.getSuppressOutputOfMapKey()) {
                                    if (keyVM == null) {
                                        throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.NoMapOutputKeyDefined.Error", (String[])new String[0]));
                                    }
                                    Class hadoopWritableKey = shim.getHadoopWritableCompatibleClass(keyVM);
                                    conf.setMapOutputKeyClass(hadoopWritableKey);
                                    this.logDebug(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.Message.MapOutputKeyMessage", (String[])new String[]{hadoopWritableKey.getName()}));
                                }
                                if (!this.getSuppressOutputOfMapValue()) {
                                    if (valueVM == null) {
                                        throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.NoMapOutputValueDefined.Error", (String[])new String[0]));
                                    }
                                    Class hadoopWritableValue = shim.getHadoopWritableCompatibleClass(valueVM);
                                    conf.setMapOutputValueClass(hadoopWritableValue);
                                    this.logDebug(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.Message.MapOutputValueMessage", (String[])new String[]{hadoopWritableValue.getName()}));
                                }
                            }
                        }
                        if ((transMeta = JobEntryHadoopTransJobExecutor.loadTransMeta((VariableSpace)this, this.rep, this.combinerTrans, this.combinerRepositoryReference, this.combinerRepositoryDir, this.combinerRepositoryFile)) != null) {
                            if (this.combiningSingleThreaded) {
                                this.verifySingleThreadingValidity(transMeta);
                            }
                            transConfig = new TransConfiguration(transMeta, transExecConfig);
                            conf.set("transformation-combiner-xml", transConfig.getXML());
                            String combinerInputStepNameS = this.environmentSubstitute(this.combinerInputStepName);
                            String combinerOutputStepNameS = this.environmentSubstitute(this.combinerOutputStepName);
                            conf.set("transformation-combiner-input-stepname", combinerInputStepNameS);
                            conf.set("transformation-combiner-output-stepname", combinerOutputStepNameS);
                            conf.setCombinerClass(shim.getPentahoMapReduceCombinerClass());
                            try {
                                JobEntryHadoopTransJobExecutor.verifyTransMeta(transMeta, combinerInputStepNameS, combinerOutputStepNameS);
                            }
                            catch (Exception ex) {
                                throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.CombinerConfiguration.Error", (String[])new String[0]), (Throwable)ex);
                            }
                        }
                        if ((transMeta = JobEntryHadoopTransJobExecutor.loadTransMeta((VariableSpace)this, this.rep, this.reduceTrans, this.reduceRepositoryReference, this.reduceRepositoryDir, this.reduceRepositoryFile)) != null) {
                            if (this.reducingSingleThreaded) {
                                this.verifySingleThreadingValidity(transMeta);
                            }
                            transConfig = new TransConfiguration(transMeta, transExecConfig);
                            conf.set("transformation-reduce-xml", transConfig.getXML());
                            String reduceInputStepNameS = this.environmentSubstitute(this.reduceInputStepName);
                            String reduceOutputStepNameS = this.environmentSubstitute(this.reduceOutputStepName);
                            conf.set("transformation-reduce-input-stepname", reduceInputStepNameS);
                            conf.set("transformation-reduce-output-stepname", reduceOutputStepNameS);
                            conf.setReducerClass(shim.getPentahoMapReduceReducerClass());
                            try {
                                JobEntryHadoopTransJobExecutor.verifyTransMeta(transMeta, reduceInputStepNameS, reduceOutputStepNameS);
                            }
                            catch (Exception ex) {
                                throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.ReducerConfiguration.Error", (String[])new String[0]), (Throwable)ex);
                            }
                            if (this.getSuppressOutputOfKey()) {
                                conf.setOutputKeyClass(shim.getHadoopWritableCompatibleClass(null));
                            }
                            if (this.getSuppressOutputOfValue()) {
                                conf.setOutputValueClass(shim.getHadoopWritableCompatibleClass(null));
                            }
                            if (!this.getSuppressOutputOfKey() || !this.getSuppressOutputOfValue()) {
                                StepMeta reduceOut = transMeta.findStep(reduceOutputStepNameS);
                                RowMetaInterface prevStepFields = transMeta.getPrevStepFields(reduceOut);
                                if (reduceOut.getStepMetaInterface() instanceof HadoopExitMeta) {
                                    ValueMetaInterface valueVM;
                                    String keyName = ((HadoopExitMeta)reduceOut.getStepMetaInterface()).getOutKeyFieldname();
                                    String valName = ((HadoopExitMeta)reduceOut.getStepMetaInterface()).getOutValueFieldname();
                                    int keyI = prevStepFields.indexOfValue(keyName);
                                    ValueMetaInterface keyVM = keyI >= 0 ? prevStepFields.getValueMeta(keyI) : null;
                                    int valI = prevStepFields.indexOfValue(valName);
                                    ValueMetaInterface valueMetaInterface = valueVM = valI >= 0 ? prevStepFields.getValueMeta(valI) : null;
                                    if (!this.getSuppressOutputOfKey()) {
                                        if (keyVM == null) {
                                            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.NoOutputKeyDefined.Error", (String[])new String[0]));
                                        }
                                        Class hadoopWritableKey = shim.getHadoopWritableCompatibleClass(keyVM);
                                        conf.setOutputKeyClass(hadoopWritableKey);
                                        this.logDebug(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.Message.OutputKeyMessage", (String[])new String[]{hadoopWritableKey.getName()}));
                                    }
                                    if (!this.getSuppressOutputOfValue()) {
                                        if (valueVM == null) {
                                            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.NoOutputValueDefined.Error", (String[])new String[0]));
                                        }
                                        Class hadoopWritableValue = shim.getHadoopWritableCompatibleClass(valueVM);
                                        conf.setOutputValueClass(hadoopWritableValue);
                                        this.logDebug(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.Message.OutputValueMessage", (String[])new String[]{hadoopWritableValue.getName()}));
                                    }
                                }
                            }
                        }
                        conf.setMapRunnerClass(shim.getPentahoMapReduceMapRunnerClass());
                        if (this.inputFormatClass != null) {
                            String inputFormatClassS = this.environmentSubstitute(this.inputFormatClass).trim();
                            Class<?> inputFormat = loader.loadClass(inputFormatClassS);
                            conf.setInputFormat(inputFormat);
                        }
                        if (this.outputFormatClass != null) {
                            String outputFormatClassS = this.environmentSubstitute(this.outputFormatClass).trim();
                            Class<?> outputFormat = loader.loadClass(outputFormatClassS);
                            conf.setOutputFormat(outputFormat);
                        }
                        String hdfsHostnameS = this.environmentSubstitute(this.hdfsHostname);
                        String hdfsPortS = this.environmentSubstitute(this.hdfsPort);
                        String jobTrackerHostnameS = this.environmentSubstitute(this.jobTrackerHostname);
                        String jobTrackerPortS = this.environmentSubstitute(this.jobTrackerPort);
                        ArrayList configMessages = new ArrayList();
                        shim.configureConnectionInformation(hdfsHostnameS, hdfsPortS, jobTrackerHostnameS, jobTrackerPortS, conf, configMessages);
                        for (String m : configMessages) {
                            this.logBasic(m);
                        }
                        fs = shim.getFileSystem(conf);
                        String inputPathS = this.environmentSubstitute(this.inputPath);
                        Matcher m = Pattern.compile("[{][^{]*[}]").matcher(inputPathS);
                        StringBuffer sb = new StringBuffer();
                        while (m.find()) {
                            m.appendReplacement(sb, m.group().replace(",", "@!@"));
                        }
                        m.appendTail(sb);
                        String[] inputPathParts = sb.toString().split(",");
                        ArrayList<Path> paths = new ArrayList<Path>();
                        for (String path : inputPathParts) {
                            paths.add(fs.asPath(conf.getDefaultFileSystemURL(), path.replaceAll("@!@", ",")));
                        }
                        Path[] finalPaths = paths.toArray(new Path[paths.size()]);
                        outputPathPath = fs.asPath(conf.getDefaultFileSystemURL(), this.environmentSubstitute(this.outputPath));
                        conf.setInputPaths(finalPaths);
                        conf.setOutputPath(outputPathPath);
                        for (UserDefinedItem item : this.userDefined) {
                            if (item.getName() == null || "".equals(item.getName()) || item.getValue() == null || "".equals(item.getValue())) continue;
                            String nameS = this.environmentSubstitute(item.getName());
                            String valueS = this.environmentSubstitute(item.getValue());
                            conf.set(nameS, valueS);
                        }
                        conf.setJarByClass(shim.getPentahoMapReduceMapRunnerClass());
                        numMapTasksS = this.environmentSubstitute(this.numMapTasks);
                        try {
                            if (Integer.parseInt(numMapTasksS) < 0) {
                                throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.NumMapTasks.Error", (String[])new String[0]));
                            }
                        }
                        catch (NumberFormatException e) {
                            if (!this.log.isDebug()) break block64;
                            this.logError(Const.getStackTracker((Throwable)e));
                        }
                    }
                    numReduceTasksS = this.environmentSubstitute(this.numReduceTasks);
                    try {
                        if (Integer.parseInt(numReduceTasksS) < 0) {
                            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.NumReduceTasks.Error", (String[])new String[0]));
                        }
                    }
                    catch (NumberFormatException e) {
                        if (!this.log.isDebug()) break block65;
                        this.logError(Const.getStackTracker((Throwable)e));
                    }
                }
                conf.setNumMapTasks(Const.toInt((String)numMapTasksS, (int)1));
                conf.setNumReduceTasks(Const.toInt((String)numReduceTasksS, (int)1));
                VariableSpace variableSpace = this.getVariables();
                XStream xStream = new XStream();
                xStream.alias("variableSpace", VariableSpace.class);
                String xmlVariableSpace = xStream.toXML((Object)variableSpace);
                conf.setStrings("variableSpace", new String[]{xmlVariableSpace});
                conf.setStrings("logLevel", new String[]{this.getLogLevel().toString()});
                if (this.isCleanOutputPath()) {
                    if (this.log.isBasic()) {
                        this.logBasic(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.CleaningOutputPath", (String[])new String[]{outputPathPath.toUri().toString()}));
                    }
                    try {
                        if (!this.cleanOutputPath(fs, outputPathPath)) {
                            this.logBasic(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.FailedToCleanOutputPath", (String[])new String[]{outputPathPath.toUri().toString()}));
                        }
                    }
                    catch (IOException ex) {
                        result.setStopped(true);
                        result.setNrErrors(1L);
                        result.setResult(false);
                        this.logError(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.ErrorCleaningOutputPath", (String[])new String[]{outputPathPath.toUri().toString()}), ex);
                        return result;
                    }
                }
                if (this.useDistributedCache(conf, pmrProperties = this.loadPMRProperties())) {
                    String installPath = this.getProperty(conf, pmrProperties, PENTAHO_MAPREDUCE_PROPERTY_KETTLE_HDFS_INSTALL_DIR, null);
                    String installId = this.getProperty(conf, pmrProperties, PENTAHO_MAPREDUCE_PROPERTY_KETTLE_INSTALLATION_ID, BuildVersion.getInstance().getVersion());
                    try {
                        if (Const.isEmpty((String)installPath)) {
                            throw new IllegalArgumentException(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.KettleHdfsInstallDirMissing", (String[])new String[0]));
                        }
                        if (Const.isEmpty((String)installId)) {
                            String pluginVersion = new PluginPropertiesUtil().getVersion();
                            installId = BuildVersion.getInstance().getVersion();
                            if (pluginVersion != null) {
                                installId = installId + "-" + pluginVersion;
                            }
                            installId = installId + "-" + hadoopConfig.getIdentifier();
                        }
                        if (!installPath.endsWith(Const.FILE_SEPARATOR)) {
                            installPath = installPath + Const.FILE_SEPARATOR;
                        }
                        Path kettleEnvInstallDir = fs.asPath(installPath, installId);
                        PluginInterface plugin = this.getPluginInterface();
                        FileObject pmrLibArchive = KettleVFS.getFileObject((String)(plugin.getPluginDirectory().getPath() + Const.FILE_SEPARATOR + this.getProperty(conf, pmrProperties, PENTAHO_MAPREDUCE_PROPERTY_PMR_LIBRARIES_ARCHIVE_FILE, null)));
                        if (shim.getDistributedCacheUtil().isKettleEnvironmentInstalledAt(fs, kettleEnvInstallDir)) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.UsingKettleInstallationFrom", (String[])new String[]{kettleEnvInstallDir.toUri().getPath()}));
                        } else {
                            String additionalPluginNames = this.getProperty(conf, pmrProperties, PENTAHO_MAPREDUCE_PROPERTY_ADDITIONAL_PLUGINS, null);
                            this.installKettleEnvironment(shim, pmrLibArchive, fs, kettleEnvInstallDir, additionalPluginNames);
                        }
                        this.configureWithKettleEnvironment(shim, conf, fs, kettleEnvInstallDir);
                    }
                    catch (Exception ex) {
                        result.setStopped(true);
                        result.setNrErrors(1L);
                        result.setResult(false);
                        this.logError(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.InstallationOfKettleFailed", (String[])new String[0]), ex);
                        return result;
                    }
                }
                RunningJob runningJob = shim.submitJob(conf);
                String loggingIntervalS = this.environmentSubstitute(this.loggingInterval);
                int logIntv = 60;
                try {
                    logIntv = Integer.parseInt(loggingIntervalS);
                }
                catch (NumberFormatException e) {
                    this.logError("Can't parse logging interval '" + loggingIntervalS + "'. Setting " + "logging interval to 60");
                }
                if (!this.blocking) break block66;
                try {
                    int taskCompletionEventIndex = 0;
                    while (!this.parentJob.isStopped() && !runningJob.isComplete()) {
                        if (logIntv >= 1) {
                            this.printJobStatus(runningJob);
                            taskCompletionEventIndex += this.logTaskMessages(runningJob, taskCompletionEventIndex);
                            Thread.sleep(logIntv * 1000);
                            continue;
                        }
                        Thread.sleep(60000L);
                    }
                    if (this.parentJob.isStopped() && !runningJob.isComplete()) {
                        runningJob.killJob();
                        result.setResult(false);
                    }
                    this.printJobStatus(runningJob);
                    this.logTaskMessages(runningJob, taskCompletionEventIndex);
                }
                catch (InterruptedException ie) {
                    this.logError(ie.getMessage(), ie);
                }
                result.setResult(runningJob.isSuccessful());
            }
            catch (Throwable t) {
                t.printStackTrace();
                result.setStopped(true);
                result.setNrErrors(1L);
                result.setResult(false);
                this.logError(Const.NVL((String)t.getMessage(), (String)""), t);
            }
        }
        if (appender != null) {
            LogWriter.getInstance().removeAppender((Appender)appender);
            appender.close();
            ResultFile resultFile = new ResultFile(1, appender.getFile(), this.parentJob.getJobname(), this.getName());
            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
        }
        return result;
    }

    protected HadoopConfiguration getHadoopConfiguration() throws ConfigurationException {
        return HadoopConfigurationBootstrap.getHadoopConfigurationProvider().getActiveConfiguration();
    }

    private int logTaskMessages(RunningJob runningJob, int startIndex) throws IOException {
        TaskCompletionEvent[] tcEvents = runningJob.getTaskCompletionEvents(startIndex);
        block4: for (int i = 0; i < tcEvents.length; ++i) {
            String[] diags = runningJob.getTaskDiagnostics(tcEvents[i].getTaskAttemptId());
            StringBuilder diagsOutput = new StringBuilder();
            if (diags != null && diags.length > 0) {
                diagsOutput.append(Const.CR);
                for (String s : diags) {
                    diagsOutput.append(s);
                    diagsOutput.append(Const.CR);
                }
            }
            TaskCompletionEvent.Status status = tcEvents[i].getTaskStatus();
            switch (status) {
                case KILLED: 
                case FAILED: 
                case TIPFAILED: {
                    this.logError(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.TaskDetails", (Object[])new Object[]{status, tcEvents[i].getTaskAttemptId(), tcEvents[i].getTaskAttemptId(), tcEvents[i].getEventId(), diagsOutput}));
                    continue block4;
                }
                case SUCCEEDED: 
                case OBSOLETE: {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.TaskDetails", (Object[])new Object[]{TaskCompletionEvent.Status.SUCCEEDED, tcEvents[i].getTaskAttemptId(), tcEvents[i].getTaskAttemptId(), tcEvents[i].getEventId(), diagsOutput}));
                    continue block4;
                }
                default: {
                    this.logError(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.TaskDetails", (Object[])new Object[]{"UNKNOWN", tcEvents[i].getTaskAttemptId(), tcEvents[i].getTaskAttemptId(), tcEvents[i].getEventId(), diagsOutput}));
                }
            }
        }
        return tcEvents.length;
    }

    public boolean useDistributedCache(Configuration conf, Properties pmrProperties) {
        return Boolean.parseBoolean(this.getProperty(conf, pmrProperties, PENTAHO_MAPREDUCE_PROPERTY_USE_DISTRIBUTED_CACHE, Boolean.toString(true)));
    }

    public String getProperty(Configuration conf, Properties properties, String propertyName, String defaultValue) {
        String fromConf = conf.get(propertyName);
        return !Const.isEmpty((String)fromConf) ? fromConf : properties.getProperty(propertyName, defaultValue);
    }

    public Properties loadPMRProperties() throws KettleFileException, IOException {
        PluginInterface plugin = this.getPluginInterface();
        return new PluginPropertiesUtil().loadPluginProperties(plugin);
    }

    public PluginInterface getPluginInterface() {
        String pluginId = PluginRegistry.getInstance().getPluginId((Object)this);
        return PluginRegistry.getInstance().findPluginWithId(JobEntryPluginType.class, pluginId);
    }

    public void installKettleEnvironment(HadoopShim shim, FileObject pmrLibArchive, FileSystem fs, Path destination, String additionalPlugins) throws Exception {
        if (pmrLibArchive == null) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.UnableToLocateArchive", (Object[])new Object[]{pmrLibArchive}));
        }
        this.logBasic(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.InstallingKettleAt", (Object[])new Object[]{destination}));
        FileObject bigDataPluginFolder = KettleVFS.getFileObject((String)this.getPluginInterface().getPluginDirectory().getPath());
        shim.getDistributedCacheUtil().installKettleEnvironment(pmrLibArchive, fs, destination, bigDataPluginFolder, additionalPlugins);
        this.logBasic(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.InstallationOfKettleSuccessful", (Object[])new Object[]{destination}));
    }

    private void configureWithKettleEnvironment(HadoopShim shim, Configuration conf, FileSystem fs, Path kettleEnvInstallDir) throws Exception {
        if (!shim.getDistributedCacheUtil().isKettleEnvironmentInstalledAt(fs, kettleEnvInstallDir)) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.KettleInstallationMissingFrom", (String[])new String[]{kettleEnvInstallDir.toUri().getPath()}));
        }
        this.logBasic(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.ConfiguringJobWithKettleAt", (String[])new String[]{kettleEnvInstallDir.toUri().getPath()}));
        shim.getDistributedCacheUtil().configureWithKettleEnvironment(conf, fs, kettleEnvInstallDir);
    }

    public static void verifyTransMeta(TransMeta transMeta, String inputStepName, String outputStepName) throws KettleException {
        if (Const.isEmpty((String)inputStepName)) {
            throw new KettleException("The input step was not specified");
        }
        StepMeta inputStepMeta = transMeta.findStep(inputStepName);
        if (inputStepMeta == null) {
            throw new KettleException("The input step with name '" + inputStepName + "' could not be found");
        }
        RowMetaInterface injectorRowMeta = transMeta.getStepFields(inputStepMeta);
        InKeyValueOrdinals inOrdinals = new InKeyValueOrdinals(injectorRowMeta);
        if (inOrdinals.getKeyOrdinal() < 0 || inOrdinals.getValueOrdinal() < 0) {
            throw new KettleException("key or value is not defined in input step");
        }
        Trans t = new Trans(transMeta);
        t.prepareExecution(null);
        if (t.getStepInterface(inputStepName, 0) == null) {
            throw new KettleException("Input step '" + inputStepName + "' does not seem to be enabled in the " + "transformation.");
        }
        if (Const.isEmpty((String)outputStepName)) {
            throw new KettleException("The output step was not specified");
        }
        StepMeta outputStepMeta = transMeta.findStep(outputStepName);
        if (outputStepMeta == null) {
            throw new KettleException("The output step with name '" + outputStepName + "' could not be found");
        }
        if (outputStepMeta.getStepMetaInterface() instanceof HadoopExitMeta) {
            RowMetaInterface outputRowMeta = transMeta.getPrevStepFields(outputStepMeta);
            HadoopExitMeta exitMeta = (HadoopExitMeta)outputStepMeta.getStepMetaInterface();
            ArrayList<CheckResultInterface> remarks = new ArrayList<CheckResultInterface>();
            exitMeta.check(remarks, transMeta, outputStepMeta, outputRowMeta, null, null, null);
            StringBuilder message = new StringBuilder();
            for (CheckResultInterface remark : remarks) {
                if (remark.getType() != 4) continue;
                message.append(message.toString()).append(Const.CR);
            }
            if (message.length() > 0) {
                throw new KettleException("There was a validation error with the Hadoop Output step:" + Const.CR + message);
            }
        } else {
            RowMetaInterface outputRowMeta = transMeta.getStepFields(outputStepMeta);
            OutKeyValueOrdinals outOrdinals = new OutKeyValueOrdinals(outputRowMeta);
            if (outOrdinals.getKeyOrdinal() < 0 || outOrdinals.getValueOrdinal() < 0) {
                throw new KettleException("outKey or outValue is not defined in output stream");
            }
        }
    }

    private void verifySingleThreadingValidity(TransMeta transMeta) throws KettleException {
        for (StepMeta stepMeta : transMeta.getSteps()) {
            TransMeta.TransformationType[] types = stepMeta.getStepMetaInterface().getSupportedTransformationTypes();
            boolean ok = false;
            for (TransMeta.TransformationType type : types) {
                if (type != TransMeta.TransformationType.SingleThreaded) continue;
                ok = true;
            }
            if (ok) continue;
            throw new KettleException("Step '" + stepMeta.getName() + "' of type '" + stepMeta.getStepID() + "' is not supported in a Single Threaded transformation engine.");
        }
    }

    private boolean cleanOutputPath(FileSystem fs, Path path) throws IOException {
        if (!fs.exists(path)) {
            return true;
        }
        return fs.delete(path, true);
    }

    public void printJobStatus(RunningJob runningJob) throws IOException {
        if (this.log.isBasic()) {
            float setupPercent = runningJob.setupProgress() * 100.0f;
            float mapPercent = runningJob.mapProgress() * 100.0f;
            float reducePercent = runningJob.reduceProgress() * 100.0f;
            this.logBasic(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.RunningPercent", (Object[])new Object[]{Float.valueOf(setupPercent), Float.valueOf(mapPercent), Float.valueOf(reducePercent)}));
        }
    }

    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        super.loadXML(entrynode, databases, slaveServers);
        this.hadoopJobName = XMLHandler.getTagValue((Node)entrynode, (String)"hadoop_job_name");
        this.mapRepositoryDir = XMLHandler.getTagValue((Node)entrynode, (String)"map_trans_repo_dir");
        this.mapRepositoryFile = XMLHandler.getTagValue((Node)entrynode, (String)"map_trans_repo_file");
        String mapTransId = XMLHandler.getTagValue((Node)entrynode, (String)"map_trans_repo_reference");
        this.mapRepositoryReference = Const.isEmpty((String)mapTransId) ? null : new StringObjectId(mapTransId);
        this.mapTrans = XMLHandler.getTagValue((Node)entrynode, (String)"map_trans");
        this.combinerRepositoryDir = XMLHandler.getTagValue((Node)entrynode, (String)"combiner_trans_repo_dir");
        this.combinerRepositoryFile = XMLHandler.getTagValue((Node)entrynode, (String)"combiner_trans_repo_file");
        String combinerTransId = XMLHandler.getTagValue((Node)entrynode, (String)"combiner_trans_repo_reference");
        this.combinerRepositoryReference = Const.isEmpty((String)combinerTransId) ? null : new StringObjectId(combinerTransId);
        this.combinerTrans = XMLHandler.getTagValue((Node)entrynode, (String)"combiner_trans");
        String combinerSingleThreaded = XMLHandler.getTagValue((Node)entrynode, (String)"combiner_single_threaded");
        if (!Const.isEmpty((String)combinerSingleThreaded)) {
            this.setCombiningSingleThreaded("Y".equalsIgnoreCase(combinerSingleThreaded));
        }
        this.reduceRepositoryDir = XMLHandler.getTagValue((Node)entrynode, (String)"reduce_trans_repo_dir");
        this.reduceRepositoryFile = XMLHandler.getTagValue((Node)entrynode, (String)"reduce_trans_repo_file");
        String reduceTransId = XMLHandler.getTagValue((Node)entrynode, (String)"reduce_trans_repo_reference");
        this.reduceRepositoryReference = Const.isEmpty((String)reduceTransId) ? null : new StringObjectId(reduceTransId);
        this.reduceTrans = XMLHandler.getTagValue((Node)entrynode, (String)"reduce_trans");
        String single = XMLHandler.getTagValue((Node)entrynode, (String)"reduce_single_threaded");
        this.reducingSingleThreaded = Const.isEmpty((String)single) ? true : "Y".equalsIgnoreCase(single);
        this.mapInputStepName = XMLHandler.getTagValue((Node)entrynode, (String)"map_input_step_name");
        this.mapOutputStepName = XMLHandler.getTagValue((Node)entrynode, (String)"map_output_step_name");
        this.combinerInputStepName = XMLHandler.getTagValue((Node)entrynode, (String)"combiner_input_step_name");
        this.combinerOutputStepName = XMLHandler.getTagValue((Node)entrynode, (String)"combiner_output_step_name");
        this.reduceInputStepName = XMLHandler.getTagValue((Node)entrynode, (String)"reduce_input_step_name");
        this.reduceOutputStepName = XMLHandler.getTagValue((Node)entrynode, (String)"reduce_output_step_name");
        this.blocking = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"blocking"));
        this.loggingInterval = XMLHandler.getTagValue((Node)entrynode, (String)"logging_interval");
        this.inputPath = XMLHandler.getTagValue((Node)entrynode, (String)"input_path");
        this.inputFormatClass = XMLHandler.getTagValue((Node)entrynode, (String)"input_format_class");
        this.outputPath = XMLHandler.getTagValue((Node)entrynode, (String)"output_path");
        String cleanOutputPath = XMLHandler.getTagValue((Node)entrynode, (String)"clean_output_path");
        if (!Const.isEmpty((String)cleanOutputPath)) {
            this.setCleanOutputPath(cleanOutputPath.equalsIgnoreCase("Y"));
        }
        if (!Const.isEmpty((String)XMLHandler.getTagValue((Node)entrynode, (String)"suppress_output_map_key"))) {
            this.suppressOutputMapKey = XMLHandler.getTagValue((Node)entrynode, (String)"suppress_output_map_key").equalsIgnoreCase("Y");
        }
        if (!Const.isEmpty((String)XMLHandler.getTagValue((Node)entrynode, (String)"suppress_output_map_value"))) {
            this.suppressOutputMapValue = XMLHandler.getTagValue((Node)entrynode, (String)"suppress_output_map_value").equalsIgnoreCase("Y");
        }
        if (!Const.isEmpty((String)XMLHandler.getTagValue((Node)entrynode, (String)"suppress_output_key"))) {
            this.suppressOutputKey = XMLHandler.getTagValue((Node)entrynode, (String)"suppress_output_key").equalsIgnoreCase("Y");
        }
        if (!Const.isEmpty((String)XMLHandler.getTagValue((Node)entrynode, (String)"suppress_output_value"))) {
            this.suppressOutputValue = XMLHandler.getTagValue((Node)entrynode, (String)"suppress_output_value").equalsIgnoreCase("Y");
        }
        this.outputFormatClass = XMLHandler.getTagValue((Node)entrynode, (String)"output_format_class");
        this.loadClusterConfig(null, rep, entrynode);
        this.setRepository(rep);
        this.numMapTasks = XMLHandler.getTagValue((Node)entrynode, (String)"num_map_tasks");
        this.numReduceTasks = XMLHandler.getTagValue((Node)entrynode, (String)"num_reduce_tasks");
        this.userDefined = new ArrayList<UserDefinedItem>();
        Node userDefinedList = XMLHandler.getSubNode((Node)entrynode, (String)"user_defined_list");
        int nrUserDefined = XMLHandler.countNodes((Node)userDefinedList, (String)"user_defined");
        for (int i = 0; i < nrUserDefined; ++i) {
            Node userDefinedNode = XMLHandler.getSubNodeByNr((Node)userDefinedList, (String)"user_defined", (int)i);
            String name = XMLHandler.getTagValue((Node)userDefinedNode, (String)"name");
            String value = XMLHandler.getTagValue((Node)userDefinedNode, (String)"value");
            UserDefinedItem item = new UserDefinedItem();
            item.setName(name);
            item.setValue(value);
            this.userDefined.add(item);
        }
    }

    private void loadClusterConfig(ObjectId id_jobentry, Repository rep, Node entrynode) {
        boolean configLoaded = false;
        try {
            if (entrynode != null) {
                this.setClusterName(XMLHandler.getTagValue((Node)entrynode, (String)"cluster_name"));
            } else if (rep != null) {
                this.setClusterName(rep.getJobEntryAttributeString(id_jobentry, "cluster_name"));
            }
            NamedCluster nc = null;
            if (rep != null && !StringUtils.isEmpty((String)this.getClusterName()) && NamedClusterManager.getInstance().contains(this.getClusterName(), rep.getMetaStore())) {
                nc = NamedClusterManager.getInstance().read(this.getClusterName(), rep.getMetaStore());
            }
            if (nc != null) {
                this.setJobTrackerHostname(nc.getJobTrackerHost());
                this.setJobTrackerPort(nc.getJobTrackerPort());
                this.setHdfsHostname(nc.getHdfsHost());
                this.setHdfsPort(nc.getHdfsPort());
                configLoaded = true;
            }
        }
        catch (Throwable t) {
            this.logDebug(t.getMessage(), new Object[]{t});
        }
        if (!configLoaded) {
            if (entrynode != null) {
                this.setHdfsHostname(XMLHandler.getTagValue((Node)entrynode, (String)"hdfs_hostname"));
                this.setHdfsPort(XMLHandler.getTagValue((Node)entrynode, (String)"hdfs_port"));
                this.setJobTrackerHostname(XMLHandler.getTagValue((Node)entrynode, (String)"job_tracker_hostname"));
                this.setJobTrackerPort(XMLHandler.getTagValue((Node)entrynode, (String)"job_tracker_port"));
            } else if (rep != null) {
                try {
                    this.setHdfsHostname(rep.getJobEntryAttributeString(id_jobentry, "hdfs_hostname"));
                    this.setHdfsPort(rep.getJobEntryAttributeString(id_jobentry, "hdfs_port"));
                    this.setJobTrackerHostname(rep.getJobEntryAttributeString(id_jobentry, "job_tracker_hostname"));
                    this.setJobTrackerPort(rep.getJobEntryAttributeString(id_jobentry, "job_tracker_port"));
                }
                catch (KettleException ke) {
                    this.logError(ke.getMessage(), ke);
                }
            }
        }
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer(1024);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"hadoop_job_name", (String)this.hadoopJobName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"map_trans_repo_dir", (String)this.mapRepositoryDir));
        retval.append("      ").append(XMLHandler.addTagValue((String)"map_trans_repo_file", (String)this.mapRepositoryFile));
        retval.append("      ").append(XMLHandler.addTagValue((String)"map_trans_repo_reference", this.mapRepositoryReference == null ? null : this.mapRepositoryReference.toString()));
        retval.append("      ").append(XMLHandler.addTagValue((String)"map_trans", (String)this.mapTrans));
        retval.append("      ").append(XMLHandler.addTagValue((String)"combiner_trans_repo_dir", (String)this.combinerRepositoryDir));
        retval.append("      ").append(XMLHandler.addTagValue((String)"combiner_trans_repo_file", (String)this.combinerRepositoryFile));
        retval.append("      ").append(XMLHandler.addTagValue((String)"combiner_trans_repo_reference", this.combinerRepositoryReference == null ? null : this.combinerRepositoryReference.toString()));
        retval.append("      ").append(XMLHandler.addTagValue((String)"combiner_trans", (String)this.combinerTrans));
        retval.append("      ").append(XMLHandler.addTagValue((String)"combiner_single_threaded", (boolean)this.combiningSingleThreaded));
        retval.append("      ").append(XMLHandler.addTagValue((String)"reduce_trans_repo_dir", (String)this.reduceRepositoryDir));
        retval.append("      ").append(XMLHandler.addTagValue((String)"reduce_trans_repo_file", (String)this.reduceRepositoryFile));
        retval.append("      ").append(XMLHandler.addTagValue((String)"reduce_trans_repo_reference", this.reduceRepositoryReference == null ? null : this.reduceRepositoryReference.toString()));
        retval.append("      ").append(XMLHandler.addTagValue((String)"reduce_trans", (String)this.reduceTrans));
        retval.append("      ").append(XMLHandler.addTagValue((String)"reduce_single_threaded", (boolean)this.reducingSingleThreaded));
        retval.append("      ").append(XMLHandler.addTagValue((String)"map_input_step_name", (String)this.mapInputStepName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"map_output_step_name", (String)this.mapOutputStepName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"combiner_input_step_name", (String)this.combinerInputStepName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"combiner_output_step_name", (String)this.combinerOutputStepName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"reduce_input_step_name", (String)this.reduceInputStepName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"reduce_output_step_name", (String)this.reduceOutputStepName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"blocking", (boolean)this.blocking));
        retval.append("      ").append(XMLHandler.addTagValue((String)"logging_interval", (String)this.loggingInterval));
        retval.append("      ").append(XMLHandler.addTagValue((String)"input_path", (String)this.inputPath));
        retval.append("      ").append(XMLHandler.addTagValue((String)"input_format_class", (String)this.inputFormatClass));
        retval.append("      ").append(XMLHandler.addTagValue((String)"output_path", (String)this.outputPath));
        retval.append("      ").append(XMLHandler.addTagValue((String)"clean_output_path", (boolean)this.cleanOutputPath));
        retval.append("      ").append(XMLHandler.addTagValue((String)"suppress_output_map_key", (boolean)this.suppressOutputMapKey));
        retval.append("      ").append(XMLHandler.addTagValue((String)"suppress_output_map_value", (boolean)this.suppressOutputMapValue));
        retval.append("      ").append(XMLHandler.addTagValue((String)"suppress_output_key", (boolean)this.suppressOutputKey));
        retval.append("      ").append(XMLHandler.addTagValue((String)"suppress_output_value", (boolean)this.suppressOutputValue));
        retval.append("      ").append(XMLHandler.addTagValue((String)"output_format_class", (String)this.outputFormatClass));
        retval.append("      ").append(XMLHandler.addTagValue((String)"cluster_name", (String)this.clusterName));
        try {
            if (this.rep != null && !StringUtils.isEmpty((String)this.getClusterName()) && NamedClusterManager.getInstance().contains(this.getClusterName(), this.rep.getMetaStore())) {
                NamedCluster nc = NamedClusterManager.getInstance().read(this.getClusterName(), this.rep.getMetaStore());
                this.setJobTrackerHostname(nc.getJobTrackerHost());
                this.setJobTrackerPort(nc.getJobTrackerPort());
                this.setHdfsHostname(nc.getHdfsHost());
                this.setHdfsPort(nc.getHdfsPort());
            }
        }
        catch (MetaStoreException e) {
            this.logDebug(e.getMessage(), new Object[]{e});
        }
        retval.append("      ").append(XMLHandler.addTagValue((String)"hdfs_hostname", (String)this.hdfsHostname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"hdfs_port", (String)this.hdfsPort));
        retval.append("      ").append(XMLHandler.addTagValue((String)"job_tracker_hostname", (String)this.jobTrackerHostname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"job_tracker_port", (String)this.jobTrackerPort));
        retval.append("      ").append(XMLHandler.addTagValue((String)"num_map_tasks", (String)this.numMapTasks));
        retval.append("      ").append(XMLHandler.addTagValue((String)"num_reduce_tasks", (String)this.numReduceTasks));
        retval.append("      <user_defined_list>").append(Const.CR);
        if (this.userDefined != null) {
            for (UserDefinedItem item : this.userDefined) {
                if (item.getName() == null || "".equals(item.getName()) || item.getValue() == null || "".equals(item.getValue())) continue;
                retval.append("        <user_defined>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)"name", (String)item.getName()));
                retval.append("          ").append(XMLHandler.addTagValue((String)"value", (String)item.getValue()));
                retval.append("        </user_defined>").append(Const.CR);
            }
        }
        retval.append("      </user_defined_list>").append(Const.CR);
        return retval.toString();
    }

    public void loadRep(Repository rep, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        if (rep != null) {
            this.setHadoopJobName(rep.getJobEntryAttributeString(id_jobentry, "hadoop_job_name"));
            this.setMapRepositoryDir(rep.getJobEntryAttributeString(id_jobentry, "map_trans_repo_dir"));
            this.setMapRepositoryFile(rep.getJobEntryAttributeString(id_jobentry, "map_trans_repo_file"));
            String mapTransId = rep.getJobEntryAttributeString(id_jobentry, "map_trans_repo_reference");
            this.setMapRepositoryReference((ObjectId)(Const.isEmpty((String)mapTransId) ? null : new StringObjectId(mapTransId)));
            this.setMapTrans(rep.getJobEntryAttributeString(id_jobentry, "map_trans"));
            this.setReduceRepositoryDir(rep.getJobEntryAttributeString(id_jobentry, "reduce_trans_repo_dir"));
            this.setReduceRepositoryFile(rep.getJobEntryAttributeString(id_jobentry, "reduce_trans_repo_file"));
            String reduceTransId = rep.getJobEntryAttributeString(id_jobentry, "reduce_trans_repo_reference");
            this.setReduceRepositoryReference((ObjectId)(Const.isEmpty((String)reduceTransId) ? null : new StringObjectId(reduceTransId)));
            this.setReduceTrans(rep.getJobEntryAttributeString(id_jobentry, "reduce_trans"));
            this.setReducingSingleThreaded(rep.getJobEntryAttributeBoolean(id_jobentry, "reduce_single_threaded", true));
            this.setCombinerRepositoryDir(rep.getJobEntryAttributeString(id_jobentry, "combiner_trans_repo_dir"));
            this.setCombinerRepositoryFile(rep.getJobEntryAttributeString(id_jobentry, "combiner_trans_repo_file"));
            String combinerTransId = rep.getJobEntryAttributeString(id_jobentry, "combiner_trans_repo_reference");
            this.setCombinerRepositoryReference((ObjectId)(Const.isEmpty((String)combinerTransId) ? null : new StringObjectId(combinerTransId)));
            this.setCombinerTrans(rep.getJobEntryAttributeString(id_jobentry, "combiner_trans"));
            this.setCombiningSingleThreaded(rep.getJobEntryAttributeBoolean(id_jobentry, "combiner_single_threaded", true));
            this.setMapInputStepName(rep.getJobEntryAttributeString(id_jobentry, "map_input_step_name"));
            this.setMapOutputStepName(rep.getJobEntryAttributeString(id_jobentry, "map_output_step_name"));
            this.setCombinerInputStepName(rep.getJobEntryAttributeString(id_jobentry, "combiner_input_step_name"));
            this.setCombinerOutputStepName(rep.getJobEntryAttributeString(id_jobentry, "combiner_output_step_name"));
            this.setReduceInputStepName(rep.getJobEntryAttributeString(id_jobentry, "reduce_input_step_name"));
            this.setReduceOutputStepName(rep.getJobEntryAttributeString(id_jobentry, "reduce_output_step_name"));
            this.setBlocking(rep.getJobEntryAttributeBoolean(id_jobentry, "blocking"));
            this.setLoggingInterval(rep.getJobEntryAttributeString(id_jobentry, "logging_interval"));
            this.setInputPath(rep.getJobEntryAttributeString(id_jobentry, "input_path"));
            this.setInputFormatClass(rep.getJobEntryAttributeString(id_jobentry, "input_format_class"));
            this.setOutputPath(rep.getJobEntryAttributeString(id_jobentry, "output_path"));
            this.setCleanOutputPath(rep.getJobEntryAttributeBoolean(id_jobentry, "clean_output_path"));
            this.setSuppressOutputOfMapKey(rep.getJobEntryAttributeBoolean(id_jobentry, "suppress_output_map_key"));
            this.setSuppressOutputOfMapValue(rep.getJobEntryAttributeBoolean(id_jobentry, "suppress_output_map_value"));
            this.setSuppressOutputOfKey(rep.getJobEntryAttributeBoolean(id_jobentry, "suppress_output_key"));
            this.setSuppressOutputOfValue(rep.getJobEntryAttributeBoolean(id_jobentry, "suppress_output_value"));
            this.setOutputFormatClass(rep.getJobEntryAttributeString(id_jobentry, "output_format_class"));
            this.loadClusterConfig(id_jobentry, rep, null);
            this.setRepository(rep);
            this.setNumMapTasks(rep.getJobEntryAttributeString(id_jobentry, "num_map_tasks"));
            this.setNumReduceTasks(rep.getJobEntryAttributeString(id_jobentry, "num_reduce_tasks"));
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "user_defined_name");
            if (argnr > 0) {
                this.userDefined = new ArrayList<UserDefinedItem>();
                UserDefinedItem item = null;
                for (int i = 0; i < argnr; ++i) {
                    item = new UserDefinedItem();
                    item.setName(rep.getJobEntryAttributeString(id_jobentry, i, "user_defined_name"));
                    item.setValue(rep.getJobEntryAttributeString(id_jobentry, i, "user_defined_value"));
                    this.userDefined.add(item);
                }
            }
        } else {
            throw new KettleException("Unable to save to a repository. The repository is null.");
        }
    }

    public void saveRep(Repository rep, ObjectId id_job) throws KettleException {
        if (rep != null) {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "hadoop_job_name", this.hadoopJobName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "map_trans_repo_dir", this.mapRepositoryDir);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "map_trans_repo_file", this.mapRepositoryFile);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "map_trans_repo_reference", this.mapRepositoryReference == null ? null : this.mapRepositoryReference.toString());
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "map_trans", this.mapTrans);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "reduce_trans_repo_dir", this.reduceRepositoryDir);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "reduce_trans_repo_file", this.reduceRepositoryFile);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "reduce_trans_repo_reference", this.reduceRepositoryReference == null ? null : this.reduceRepositoryReference.toString());
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "reduce_trans", this.reduceTrans);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "reduce_single_threaded", this.reducingSingleThreaded);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "combiner_trans_repo_dir", this.combinerRepositoryDir);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "combiner_trans_repo_file", this.combinerRepositoryFile);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "combiner_trans_repo_reference", this.combinerRepositoryReference == null ? null : this.combinerRepositoryReference.toString());
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "combiner_trans", this.combinerTrans);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "combiner_single_threaded", this.combiningSingleThreaded);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "map_input_step_name", this.mapInputStepName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "map_output_step_name", this.mapOutputStepName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "combiner_input_step_name", this.combinerInputStepName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "combiner_output_step_name", this.combinerOutputStepName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "reduce_input_step_name", this.reduceInputStepName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "reduce_output_step_name", this.reduceOutputStepName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "blocking", this.blocking);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "logging_interval", this.loggingInterval);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "input_path", this.inputPath);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "input_format_class", this.inputFormatClass);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "output_path", this.outputPath);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "clean_output_path", this.cleanOutputPath);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "suppress_output_map_key", this.suppressOutputMapKey);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "suppress_output_map_value", this.suppressOutputMapValue);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "suppress_output_key", this.suppressOutputKey);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "suppress_output_value", this.suppressOutputValue);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "output_format_class", this.outputFormatClass);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "cluster_name", this.clusterName);
            try {
                if (!StringUtils.isEmpty((String)this.getClusterName()) && NamedClusterManager.getInstance().contains(this.getClusterName(), rep.getMetaStore())) {
                    NamedCluster nc = NamedClusterManager.getInstance().read(this.getClusterName(), rep.getMetaStore());
                    this.setJobTrackerHostname(nc.getJobTrackerHost());
                    this.setJobTrackerPort(nc.getJobTrackerPort());
                    this.setHdfsHostname(nc.getHdfsHost());
                    this.setHdfsPort(nc.getHdfsPort());
                }
            }
            catch (MetaStoreException e) {
                this.logDebug(e.getMessage(), new Object[]{e});
            }
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "hdfs_hostname", this.hdfsHostname);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "hdfs_port", this.hdfsPort);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "job_tracker_hostname", this.jobTrackerHostname);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "job_tracker_port", this.jobTrackerPort);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "num_map_tasks", this.numMapTasks);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "num_reduce_tasks", this.numReduceTasks);
            if (this.userDefined != null) {
                for (int i = 0; i < this.userDefined.size(); ++i) {
                    UserDefinedItem item = this.userDefined.get(i);
                    if (item.getName() == null || "".equals(item.getName()) || item.getValue() == null || "".equals(item.getValue())) continue;
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "user_defined_name", item.getName());
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "user_defined_value", item.getValue());
                }
            }
        } else {
            throw new KettleException("Unable to save to a repository. The repository is null.");
        }
    }

    public boolean evaluates() {
        return true;
    }

    public boolean isUnconditional() {
        return true;
    }

    public boolean isReducingSingleThreaded() {
        return this.reducingSingleThreaded;
    }

    public void setReducingSingleThreaded(boolean reducingSingleThreaded) {
        this.reducingSingleThreaded = reducingSingleThreaded;
    }

    public boolean isCombiningSingleThreaded() {
        return this.combiningSingleThreaded;
    }

    public void setCombiningSingleThreaded(boolean combiningSingleThreaded) {
        this.combiningSingleThreaded = combiningSingleThreaded;
    }

    private boolean hasMapperDefinition() {
        return !Const.isEmpty((String)this.mapTrans) || this.mapRepositoryReference != null || !Const.isEmpty((String)this.mapRepositoryDir) && !Const.isEmpty((String)this.mapRepositoryFile);
    }

    private boolean hasReducerDefinition() {
        return !Const.isEmpty((String)this.reduceTrans) || this.reduceRepositoryReference != null || !Const.isEmpty((String)this.reduceRepositoryDir) && !Const.isEmpty((String)this.reduceRepositoryFile);
    }

    private boolean hasCombinerDefinition() {
        return !Const.isEmpty((String)this.combinerTrans) || this.combinerRepositoryReference != null || !Const.isEmpty((String)this.combinerRepositoryDir) && !Const.isEmpty((String)this.combinerRepositoryFile);
    }

    public String[] getReferencedObjectDescriptions() {
        return new String[]{BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.ReferencedObject.Mapper", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.ReferencedObject.Combiner", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.ReferencedObject.Reducer", (String[])new String[0])};
    }

    public boolean[] isReferencedObjectEnabled() {
        return new boolean[]{this.hasMapperDefinition(), this.hasCombinerDefinition(), this.hasReducerDefinition()};
    }

    public Object loadReferencedObject(int index, Repository rep, VariableSpace space) throws KettleException {
        switch (index) {
            case 0: {
                return JobEntryHadoopTransJobExecutor.loadTransMeta(space, rep, this.mapTrans, this.mapRepositoryReference, this.mapRepositoryDir, this.mapRepositoryFile);
            }
            case 1: {
                return JobEntryHadoopTransJobExecutor.loadTransMeta(space, rep, this.combinerTrans, this.combinerRepositoryReference, this.combinerRepositoryDir, this.combinerRepositoryFile);
            }
            case 2: {
                return JobEntryHadoopTransJobExecutor.loadTransMeta(space, rep, this.reduceTrans, this.reduceRepositoryReference, this.reduceRepositoryDir, this.reduceRepositoryFile);
            }
        }
        return null;
    }

    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface namingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        this.mapTrans = this.loadAndExport(space, definitions, namingInterface, repository, metaStore, this.mapTrans, this.mapRepositoryReference, this.mapRepositoryDir, this.mapRepositoryFile);
        this.combinerTrans = this.loadAndExport(space, definitions, namingInterface, repository, metaStore, this.combinerTrans, this.combinerRepositoryReference, this.combinerRepositoryDir, this.combinerRepositoryFile);
        this.reduceTrans = this.loadAndExport(space, definitions, namingInterface, repository, metaStore, this.reduceTrans, this.reduceRepositoryReference, this.reduceRepositoryDir, this.reduceRepositoryFile);
        return null;
    }

    private String loadAndExport(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface namingInterface, Repository repository, IMetaStore metaStore, String trans, ObjectId repositoryReference, String repositoryDir, String repositoryFile) throws KettleException {
        TransMeta transMeta = JobEntryHadoopTransJobExecutor.loadTransMeta(space, repository, trans, repositoryReference, repositoryDir, repositoryFile);
        if (transMeta != null) {
            return "${Internal.Job.Filename.Directory}/" + transMeta.exportResources((VariableSpace)transMeta, definitions, namingInterface, repository, metaStore);
        }
        return trans;
    }
}

