/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.hbaseinput;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.hadoop.HadoopConfigurationBootstrap;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.steps.hbaseinput.HBaseInputMeta;
import org.pentaho.hadoop.shim.HadoopConfiguration;
import org.pentaho.hbase.HBaseRowToKettleTuple;
import org.pentaho.hbase.shim.api.ColumnFilter;
import org.pentaho.hbase.shim.api.HBaseValueMeta;
import org.pentaho.hbase.shim.api.Mapping;
import org.pentaho.hbase.shim.spi.HBaseBytesUtilShim;
import org.pentaho.hbase.shim.spi.HBaseConnection;
import org.pentaho.hbase.shim.spi.HBaseShim;

public class HBaseInputData
extends BaseStepData
implements StepDataInterface {
    protected RowMetaInterface m_outputRowMeta;

    public RowMetaInterface getOutputRowMeta() {
        return this.m_outputRowMeta;
    }

    public void setOutputRowMeta(RowMetaInterface rmi) {
        this.m_outputRowMeta = rmi;
    }

    public static HBaseConnection getHBaseConnection(String zookeeperHosts, String zookeeperPort, String siteConfig, String defaultConfig, List<String> logging) throws Exception {
        Properties connProps = new Properties();
        if (!Const.isEmpty((String)zookeeperHosts)) {
            connProps.setProperty("hbase.zookeeper.quorum", zookeeperHosts);
        }
        if (!Const.isEmpty((String)zookeeperPort)) {
            connProps.setProperty("hbase.zookeeper.property.clientPort", zookeeperPort);
        }
        if (!Const.isEmpty((String)siteConfig)) {
            connProps.setProperty("hbase.site", siteConfig);
        }
        if (!Const.isEmpty((String)defaultConfig)) {
            connProps.setProperty("hbase.default", defaultConfig);
        }
        HadoopConfiguration active = HadoopConfigurationBootstrap.getHadoopConfigurationProvider().getActiveConfiguration();
        HBaseShim hbaseShim = active.getHBaseShim();
        HBaseConnection conn = hbaseShim.getHBaseConnection();
        conn.configureConnection(connProps, logging);
        return conn;
    }

    public static URL stringToURL(String pathOrURL) throws MalformedURLException {
        URL result = null;
        if (!Const.isEmpty((String)pathOrURL)) {
            if (pathOrURL.toLowerCase().startsWith("http://") || pathOrURL.toLowerCase().startsWith("file://")) {
                result = new URL(pathOrURL);
            } else {
                String c = "file://" + pathOrURL;
                result = new URL(c);
            }
        }
        return result;
    }

    public static void initializeScan(HBaseConnection hbAdmin, HBaseBytesUtilShim bytesUtil, Mapping tableMapping, String dateOrNumberConversionMaskForKey, String keyStartS, String keyStopS, String scannerCacheSize, LogChannelInterface log, VariableSpace vars) throws KettleException {
        byte[] keyLowerBound = null;
        byte[] keyUpperBound = null;
        if (!Const.isEmpty((String)keyStartS)) {
            Number num;
            DecimalFormat df;
            Date d;
            SimpleDateFormat sdf;
            String[] parts;
            keyStartS = vars.environmentSubstitute(keyStartS);
            String convM = dateOrNumberConversionMaskForKey;
            if (tableMapping.getKeyType() == Mapping.KeyType.BINARY) {
                keyLowerBound = HBaseValueMeta.encodeKeyValue((String)keyStartS, (Mapping.KeyType)tableMapping.getKeyType(), (HBaseBytesUtilShim)bytesUtil);
            } else if (tableMapping.getKeyType() != Mapping.KeyType.STRING) {
                parts = keyStartS.split("@");
                if (parts.length == 2) {
                    keyStartS = parts[0];
                    convM = parts[1];
                }
                if (!Const.isEmpty((String)convM) && convM.length() > 0) {
                    if (tableMapping.getKeyType() == Mapping.KeyType.DATE || tableMapping.getKeyType() == Mapping.KeyType.UNSIGNED_DATE) {
                        sdf = new SimpleDateFormat();
                        sdf.applyPattern(convM);
                        try {
                            d = sdf.parse(keyStartS);
                            keyLowerBound = HBaseValueMeta.encodeKeyValue((Object)d, (Mapping.KeyType)tableMapping.getKeyType(), (HBaseBytesUtilShim)bytesUtil);
                        }
                        catch (ParseException e) {
                            throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.UnableToParseLowerBoundKeyValue", (String[])new String[]{keyStartS}), (Throwable)e);
                        }
                    } else {
                        df = new DecimalFormat();
                        df.applyPattern(convM);
                        num = null;
                        try {
                            num = df.parse(keyStartS);
                            keyLowerBound = HBaseValueMeta.encodeKeyValue((Object)num, (Mapping.KeyType)tableMapping.getKeyType(), (HBaseBytesUtilShim)bytesUtil);
                        }
                        catch (ParseException e) {
                            throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.UnableToParseLowerBoundKeyValue", (String[])new String[]{keyStartS}), (Throwable)e);
                        }
                    }
                } else {
                    keyLowerBound = HBaseValueMeta.encodeKeyValue((String)keyStartS, (Mapping.KeyType)tableMapping.getKeyType(), (HBaseBytesUtilShim)bytesUtil);
                }
            } else {
                keyLowerBound = HBaseValueMeta.encodeKeyValue((String)keyStartS, (Mapping.KeyType)tableMapping.getKeyType(), (HBaseBytesUtilShim)bytesUtil);
            }
            if (!Const.isEmpty((String)keyStopS)) {
                keyStopS = vars.environmentSubstitute(keyStopS);
                convM = dateOrNumberConversionMaskForKey;
                if (tableMapping.getKeyType() == Mapping.KeyType.BINARY) {
                    keyUpperBound = HBaseValueMeta.encodeKeyValue((String)keyStopS, (Mapping.KeyType)tableMapping.getKeyType(), (HBaseBytesUtilShim)bytesUtil);
                } else if (tableMapping.getKeyType() != Mapping.KeyType.STRING) {
                    parts = keyStopS.split("@");
                    if (parts.length == 2) {
                        keyStopS = parts[0];
                        convM = parts[1];
                    }
                    if (!Const.isEmpty((String)convM) && convM.length() > 0) {
                        if (tableMapping.getKeyType() == Mapping.KeyType.DATE || tableMapping.getKeyType() == Mapping.KeyType.UNSIGNED_DATE) {
                            sdf = new SimpleDateFormat();
                            sdf.applyPattern(convM);
                            try {
                                d = sdf.parse(keyStopS);
                                keyUpperBound = HBaseValueMeta.encodeKeyValue((Object)d, (Mapping.KeyType)tableMapping.getKeyType(), (HBaseBytesUtilShim)bytesUtil);
                            }
                            catch (ParseException e) {
                                throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.UnableToParseUpperBoundKeyValue", (String[])new String[]{keyStopS}), (Throwable)e);
                            }
                        } else {
                            df = new DecimalFormat();
                            df.applyPattern(convM);
                            num = null;
                            try {
                                num = df.parse(keyStopS);
                                keyUpperBound = HBaseValueMeta.encodeKeyValue((Object)num, (Mapping.KeyType)tableMapping.getKeyType(), (HBaseBytesUtilShim)bytesUtil);
                            }
                            catch (ParseException e) {
                                throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.UnableToParseUpperBoundKeyValue", (String[])new String[]{keyStopS}), (Throwable)e);
                            }
                        }
                    } else {
                        keyUpperBound = HBaseValueMeta.encodeKeyValue((String)keyStopS, (Mapping.KeyType)tableMapping.getKeyType(), (HBaseBytesUtilShim)bytesUtil);
                    }
                } else {
                    keyUpperBound = HBaseValueMeta.encodeKeyValue((String)keyStopS, (Mapping.KeyType)tableMapping.getKeyType(), (HBaseBytesUtilShim)bytesUtil);
                }
            }
        }
        int cacheSize = 0;
        if (!Const.isEmpty((String)scannerCacheSize)) {
            String temp = vars.environmentSubstitute(scannerCacheSize);
            cacheSize = Integer.parseInt(temp);
            if (log != null) {
                log.logBasic(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Message.SettingScannerCaching", (Object[])new Object[]{cacheSize}));
            }
        }
        try {
            hbAdmin.newSourceTableScan(keyLowerBound, keyUpperBound, cacheSize);
        }
        catch (Exception ex) {
            throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.UnableToConfigureSourceTableScan", (String[])new String[0]), (Throwable)ex);
        }
    }

    public static void setScanColumns(HBaseConnection hbAdmin, List<HBaseValueMeta> limitCols, Mapping tableMapping) throws KettleException {
        for (HBaseValueMeta currentCol : limitCols) {
            if (currentCol.isKey()) continue;
            String colFamilyName = currentCol.getColumnFamily();
            String qualifier = currentCol.getColumnName();
            boolean binaryColName = false;
            if (qualifier.startsWith("@@@binary@@@")) {
                qualifier = qualifier.replace("@@@binary@@@", "");
                binaryColName = true;
            }
            try {
                hbAdmin.addColumnToScan(colFamilyName, qualifier, binaryColName);
            }
            catch (Exception ex) {
                throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.UnableToAddColumnToScan", (String[])new String[0]), (Throwable)ex);
            }
        }
    }

    public static void setScanFilters(HBaseConnection hbAdmin, Collection<ColumnFilter> columnFilters, boolean matchAnyFilter, Map<String, HBaseValueMeta> columnsMappedByAlias, VariableSpace vars) throws KettleException {
        for (ColumnFilter cf : columnFilters) {
            String fieldAliasS = vars.environmentSubstitute(cf.getFieldAlias());
            HBaseValueMeta mappedCol = columnsMappedByAlias.get(fieldAliasS);
            if (mappedCol == null) {
                throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.ColumnFilterIsNotInTheMapping", (String[])new String[]{fieldAliasS}));
            }
            String fieldTypeS = vars.environmentSubstitute(cf.getFieldType());
            if (!Const.isEmpty((String)fieldTypeS) && !mappedCol.getHBaseTypeDesc().equalsIgnoreCase(fieldTypeS)) {
                throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.FieldTypeMismatch", (String[])new String[]{fieldTypeS, fieldAliasS, mappedCol.getHBaseTypeDesc()}));
            }
            try {
                hbAdmin.addColumnFilterToScan(cf, mappedCol, vars, matchAnyFilter);
            }
            catch (Exception ex) {
                throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.UnableToAddColumnFilterToScan", (String[])new String[0]), (Throwable)ex);
            }
        }
    }

    public static List<Object[]> getTupleOutputRows(HBaseConnection hbAdmin, List<HBaseValueMeta> userOutputColumns, Map<String, HBaseValueMeta> columnsMappedByAlias, Mapping tableMapping, HBaseRowToKettleTuple tupleHandler, RowMetaInterface outputRowMeta, HBaseBytesUtilShim bytesUtil) throws KettleException {
        if (userOutputColumns != null && userOutputColumns.size() > 0) {
            return tupleHandler.hbaseRowToKettleTupleMode(null, hbAdmin, tableMapping, userOutputColumns, outputRowMeta);
        }
        return tupleHandler.hbaseRowToKettleTupleMode(null, hbAdmin, tableMapping, columnsMappedByAlias, outputRowMeta);
    }

    public static Object[] getOutputRow(HBaseConnection hbAdmin, List<HBaseValueMeta> userOutputColumns, Map<String, HBaseValueMeta> columnsMappedByAlias, Mapping tableMapping, RowMetaInterface outputRowMeta, HBaseBytesUtilShim bytesUtil) throws KettleException {
        int size = userOutputColumns != null && userOutputColumns.size() > 0 ? userOutputColumns.size() : tableMapping.getMappedColumns().keySet().size() + 1;
        Object[] outputRowData = RowDataUtil.allocateRowData((int)size);
        if (userOutputColumns != null && userOutputColumns.size() > 0) {
            for (HBaseValueMeta currentCol : userOutputColumns) {
                Object decodedVal;
                if (currentCol.isKey()) {
                    byte[] rawKey = null;
                    try {
                        rawKey = hbAdmin.getResultSetCurrentRowKey();
                    }
                    catch (Exception e) {
                        throw new KettleException((Throwable)e);
                    }
                    Object decodedKey = HBaseValueMeta.decodeKeyValue((byte[])rawKey, (Mapping)tableMapping, (HBaseBytesUtilShim)bytesUtil);
                    int keyIndex = outputRowMeta.indexOfValue(currentCol.getAlias());
                    outputRowData[keyIndex] = decodedKey;
                    continue;
                }
                String colFamilyName = currentCol.getColumnFamily();
                String qualifier = currentCol.getColumnName();
                boolean binaryColName = false;
                if (qualifier.startsWith("@@@binary@@@")) {
                    qualifier = qualifier.replace("@@@binary@@@", "");
                    binaryColName = true;
                }
                byte[] kv = null;
                try {
                    kv = hbAdmin.getResultSetCurrentRowColumnLatest(colFamilyName, qualifier, binaryColName);
                }
                catch (Exception e) {
                    throw new KettleException((Throwable)e);
                }
                int outputIndex = outputRowMeta.indexOfValue(currentCol.getAlias());
                if (outputIndex < 0) {
                    throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.ColumnNotDefinedInOutput", (String[])new String[]{currentCol.getAlias()}));
                }
                outputRowData[outputIndex] = decodedVal = HBaseValueMeta.decodeColumnValue((byte[])(kv == null ? null : kv), (HBaseValueMeta)currentCol, (HBaseBytesUtilShim)bytesUtil);
            }
        } else {
            byte[] rawKey = null;
            try {
                rawKey = hbAdmin.getResultSetCurrentRowKey();
            }
            catch (Exception e) {
                throw new KettleException((Throwable)e);
            }
            Object decodedKey = HBaseValueMeta.decodeKeyValue((byte[])rawKey, (Mapping)tableMapping, (HBaseBytesUtilShim)bytesUtil);
            int keyIndex = outputRowMeta.indexOfValue(tableMapping.getKeyName());
            outputRowData[keyIndex] = decodedKey;
            Set<String> aliasSet = columnsMappedByAlias.keySet();
            for (String name : aliasSet) {
                Object decodedVal;
                HBaseValueMeta currentCol = columnsMappedByAlias.get(name);
                String colFamilyName = currentCol.getColumnFamily();
                String qualifier = currentCol.getColumnName();
                boolean binaryColName = false;
                if (qualifier.startsWith("@@@binary@@@")) {
                    qualifier = qualifier.replace("@@@binary@@@", "");
                    binaryColName = true;
                }
                byte[] kv = null;
                try {
                    kv = hbAdmin.getResultSetCurrentRowColumnLatest(colFamilyName, qualifier, binaryColName);
                }
                catch (Exception e) {
                    throw new KettleException((Throwable)e);
                }
                int outputIndex = outputRowMeta.indexOfValue(name);
                if (outputIndex < 0) {
                    throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.ColumnNotDefinedInOutput", (String[])new String[]{name}));
                }
                outputRowData[outputIndex] = decodedVal = HBaseValueMeta.decodeColumnValue((byte[])(kv == null ? null : kv), (HBaseValueMeta)currentCol, (HBaseBytesUtilShim)bytesUtil);
            }
        }
        return outputRowData;
    }
}

