/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.vfs.hadoopvfsfilechooserdialog;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.provider.GenericFileName;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Props;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.hadoop.HadoopConfigurationBootstrap;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.hadoop.shim.ConfigurationException;
import org.pentaho.hadoop.shim.HadoopConfiguration;
import org.pentaho.hadoop.shim.api.Configuration;
import org.pentaho.hadoop.shim.spi.HadoopConfigurationProvider;
import org.pentaho.hadoop.shim.spi.HadoopShim;
import org.pentaho.vfs.ui.CustomVfsUiPanel;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public class HadoopVfsFileChooserDialog
extends CustomVfsUiPanel {
    private static final Class<?> PKG = HadoopVfsFileChooserDialog.class;
    private static final String HDFS_HA_CLUSTER_NAMENODES_PROP = "dfs.ha.namenodes.hacluster";
    private static final String NAMENODE_LIST_DELIMITER = ",";
    private static final String HDFS_HA_CLUSTER_NAMENODE_RESOLVE_PREFIX = "dfs.namenode.rpc-address.hacluster.";
    private static final String NAMENODE_HOSTNAME_PORT_DELIMITER = ":";
    private LogChannel log = new LogChannel((Object)this);
    private Label wlUrl;
    private Text wUrl;
    private GridData fdlUrl;
    private GridData fdUrl;
    private Label wlPort;
    private Text wPort;
    private GridData fdlPort;
    private GridData fdPort;
    private Label wlUserID;
    private Text wUserID;
    private GridData fdlUserID;
    private GridData fdUserID;
    private Label wlPassword;
    private Text wPassword;
    private GridData fdlPassword;
    private GridData fdPassword;
    private Label wPlaceHolderLabel;
    private GridData fdlPlaceHolderLabel;
    private Button wConnectionButton;
    private GridData fdConnectionButton;
    FileObject defaultInitialFile = null;
    FileObject hadoopRootFile = null;
    String hadoopOpenFromFolder = null;
    FileObject rootFile = null;
    FileObject initialFile = null;
    VfsFileChooserDialog vfsFileChooserDialog = null;
    String connectedHostname = null;
    String connectedPortString = null;
    boolean isHighAvailabilityCluster = false;
    String schemeName = "hdfs";

    public HadoopVfsFileChooserDialog(String schemeName, String displayName, VfsFileChooserDialog vfsFileChooserDialog, FileObject rootFile, FileObject initialFile) {
        super(schemeName, displayName, vfsFileChooserDialog, 0);
        this.schemeName = schemeName;
        this.rootFile = rootFile;
        this.initialFile = initialFile;
        this.vfsFileChooserDialog = vfsFileChooserDialog;
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this.setLayoutData(gridData);
        this.setLayout((Layout)new GridLayout(1, false));
        this.createConnectionPanel();
        this.initializeConnectionPanel();
    }

    private void createConnectionPanel() {
        Group connectionGroup = new Group((Composite)this, 16);
        connectionGroup.setText(BaseMessages.getString(PKG, (String)"HadoopVfsFileChooserDialog.ConnectionGroup.Label", (String[])new String[0]));
        GridLayout connectionGroupLayout = new GridLayout();
        connectionGroupLayout.marginWidth = 5;
        connectionGroupLayout.marginHeight = 5;
        connectionGroupLayout.verticalSpacing = 5;
        connectionGroupLayout.horizontalSpacing = 5;
        GridData gData = new GridData(4, 4, true, false);
        connectionGroup.setLayoutData((Object)gData);
        connectionGroup.setLayout((Layout)connectionGroupLayout);
        Composite textFieldPanel = new Composite((Composite)connectionGroup, 0);
        GridData gridData = new GridData(4, 4, true, false);
        textFieldPanel.setLayoutData((Object)gridData);
        textFieldPanel.setLayout((Layout)new GridLayout(5, false));
        this.wlUrl = new Label(textFieldPanel, 131072);
        this.wlUrl.setText(BaseMessages.getString(PKG, (String)"HadoopVfsFileChooserDialog.URL.Label", (String[])new String[0]));
        this.fdlUrl = new GridData();
        this.fdlUrl.widthHint = 75;
        this.wlUrl.setLayoutData((Object)this.fdlUrl);
        this.wUrl = new Text(textFieldPanel, 18436);
        this.fdUrl = new GridData();
        this.fdUrl.widthHint = 150;
        this.wUrl.setLayoutData((Object)this.fdUrl);
        this.wUrl.setText(Props.getInstance().getCustomParameter("HadoopVfsFileChooserDialog.host", "localhost"));
        this.wUrl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                HadoopVfsFileChooserDialog.this.handleConnectionButton();
            }
        });
        this.wlUserID = new Label(textFieldPanel, 131072);
        this.wlUserID.setText(BaseMessages.getString(PKG, (String)"HadoopVfsFileChooserDialog.UserID.Label", (String[])new String[0]));
        this.fdlUserID = new GridData();
        this.fdlUserID.widthHint = 75;
        this.wlUserID.setLayoutData((Object)this.fdlUserID);
        this.wUserID = new Text(textFieldPanel, 18436);
        this.fdUserID = new GridData();
        this.fdUserID.widthHint = 150;
        this.wUserID.setLayoutData((Object)this.fdUserID);
        this.wUserID.setText(Props.getInstance().getCustomParameter("HadoopVfsFileChooserDialog.user", ""));
        this.wPlaceHolderLabel = new Label(textFieldPanel, 131072);
        this.wPlaceHolderLabel.setText("");
        this.fdlPlaceHolderLabel = new GridData();
        this.fdlPlaceHolderLabel.widthHint = 75;
        this.wlUserID.setLayoutData((Object)this.fdlPlaceHolderLabel);
        this.wlPort = new Label(textFieldPanel, 131072);
        this.wlPort.setText(BaseMessages.getString(PKG, (String)"HadoopVfsFileChooserDialog.Port.Label", (String[])new String[0]));
        this.fdlPort = new GridData();
        this.fdlPort.widthHint = 75;
        this.wlPort.setLayoutData((Object)this.fdlPort);
        this.wPort = new Text(textFieldPanel, 18436);
        this.fdPort = new GridData();
        this.fdPort.widthHint = 150;
        this.wPort.setLayoutData((Object)this.fdPort);
        this.wPort.setText(Props.getInstance().getCustomParameter("HadoopVfsFileChooserDialog.port", "9000"));
        this.wPort.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                HadoopVfsFileChooserDialog.this.handleConnectionButton();
            }
        });
        this.wlPassword = new Label(textFieldPanel, 131072);
        this.wlPassword.setText(BaseMessages.getString(PKG, (String)"HadoopVfsFileChooserDialog.Password.Label", (String[])new String[0]));
        this.fdlPassword = new GridData();
        this.fdlPassword.widthHint = 75;
        this.wlPassword.setLayoutData((Object)this.fdlPassword);
        this.wPassword = new Text(textFieldPanel, 18436);
        this.wPassword.setEchoChar('*');
        this.fdPassword = new GridData();
        this.fdPassword.widthHint = 150;
        this.wPassword.setLayoutData((Object)this.fdPassword);
        this.wPassword.setText(Props.getInstance().getCustomParameter("HadoopVfsFileChooserDialog.password", ""));
        this.wConnectionButton = new Button(textFieldPanel, 0x1000000);
        this.fdConnectionButton = new GridData();
        this.fdConnectionButton.widthHint = 75;
        this.wConnectionButton.setLayoutData((Object)this.fdConnectionButton);
        this.wConnectionButton.setText(BaseMessages.getString(PKG, (String)"HadoopVfsFileChooserDialog.ConnectionButton.Label", (String[])new String[0]));
        this.wConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                block22: {
                    HadoopVfsFileChooserDialog.this.connectedHostname = HadoopVfsFileChooserDialog.this.wUrl.getText();
                    HadoopVfsFileChooserDialog.this.connectedPortString = HadoopVfsFileChooserDialog.this.wPort.getText();
                    try {
                        ArrayList<InetSocketAddress> addressList = new ArrayList<InetSocketAddress>();
                        HadoopConfiguration hadoopConfig = HadoopVfsFileChooserDialog.this.getHadoopConfig();
                        if (hadoopConfig != null) {
                            HadoopShim shim = hadoopConfig.getHadoopShim();
                            Configuration conf = shim.createConfiguration();
                            String haNameNodes = conf.get(HadoopVfsFileChooserDialog.HDFS_HA_CLUSTER_NAMENODES_PROP);
                            if (!Const.isEmpty((String)haNameNodes)) {
                                String[] haNameNode = haNameNodes.split(HadoopVfsFileChooserDialog.NAMENODE_LIST_DELIMITER);
                                if (!Const.isEmpty((String[])haNameNode)) {
                                    for (String nameNode : haNameNode) {
                                        String nameNodeResolveProperty = HadoopVfsFileChooserDialog.HDFS_HA_CLUSTER_NAMENODE_RESOLVE_PREFIX + nameNode;
                                        String nameNodeHostAndPort = conf.get(nameNodeResolveProperty);
                                        if (Const.isEmpty((String)nameNodeHostAndPort)) continue;
                                        String[] nameNodeParams = nameNodeHostAndPort.split(HadoopVfsFileChooserDialog.NAMENODE_HOSTNAME_PORT_DELIMITER);
                                        String hostname = nameNodeParams[0];
                                        int port = 0;
                                        if (nameNodeParams.length > 1) {
                                            try {
                                                port = Integer.parseInt(nameNodeParams[1]);
                                            }
                                            catch (NumberFormatException nfe) {
                                                // empty catch block
                                            }
                                        }
                                        addressList.add(new InetSocketAddress(hostname, port));
                                        HadoopVfsFileChooserDialog.this.isHighAvailabilityCluster = true;
                                    }
                                }
                            } else {
                                String hostname = HadoopVfsFileChooserDialog.this.wUrl.getText();
                                int port = 0;
                                try {
                                    port = Integer.parseInt(HadoopVfsFileChooserDialog.this.wPort.getText());
                                }
                                catch (NumberFormatException nfe) {
                                    // empty catch block
                                }
                                addressList.add(new InetSocketAddress(hostname, port));
                                HadoopVfsFileChooserDialog.this.isHighAvailabilityCluster = false;
                            }
                            boolean success = false;
                            StringBuffer connectMessage = new StringBuffer();
                            for (int i = 0; !success && i < addressList.size(); ++i) {
                                InetSocketAddress address = (InetSocketAddress)addressList.get(i);
                                connectMessage.append("Connect ");
                                connectMessage.append(address.getHostName());
                                connectMessage.append(HadoopVfsFileChooserDialog.NAMENODE_HOSTNAME_PORT_DELIMITER);
                                connectMessage.append(address.getPort());
                                Socket testHdfsSocket = new Socket(address.getHostName(), address.getPort());
                                try {
                                    testHdfsSocket.getOutputStream();
                                    testHdfsSocket.close();
                                    success = true;
                                    HadoopVfsFileChooserDialog.this.connectedHostname = address.getHostName();
                                    HadoopVfsFileChooserDialog.this.connectedPortString = Integer.toString(address.getPort());
                                    connectMessage.append("=success!");
                                    continue;
                                }
                                catch (IOException ioe) {
                                    connectMessage.append("=failed, ");
                                    connectMessage.append(ioe.getMessage());
                                    connectMessage.append(System.getProperty("line.separator"));
                                }
                            }
                            if (!success) {
                                throw new IOException(connectMessage.toString());
                            }
                            break block22;
                        }
                        throw new Exception("No active Hadoop Configuration specified!");
                    }
                    catch (Throwable t) {
                        HadoopVfsFileChooserDialog.this.showMessageAndLog(BaseMessages.getString((Class)PKG, (String)"HadoopVfsFileChooserDialog.error", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"HadoopVfsFileChooserDialog.Connection.error", (String[])new String[0]), t.getMessage());
                        return;
                    }
                }
                Props.getInstance().setCustomParameter("HadoopVfsFileChooserDialog.host", HadoopVfsFileChooserDialog.this.wUrl.getText());
                Props.getInstance().setCustomParameter("HadoopVfsFileChooserDialog.port", HadoopVfsFileChooserDialog.this.connectedPortString);
                Props.getInstance().setCustomParameter("HadoopVfsFileChooserDialog.user", HadoopVfsFileChooserDialog.this.wUserID.getText());
                Props.getInstance().setCustomParameter("HadoopVfsFileChooserDialog.password", HadoopVfsFileChooserDialog.this.wPassword.getText());
                FileObject root = HadoopVfsFileChooserDialog.this.rootFile;
                try {
                    root = KettleVFS.getFileObject((String)HadoopVfsFileChooserDialog.this.buildHadoopFileSystemUrlString());
                }
                catch (KettleFileException e1) {
                    String unsupportedSchemeMessage = BaseMessages.getString(HadoopConfiguration.class, (String)"Error.UnsupportedSchemeForConfiguration", (String[])new String[]{"@!@", "!@!"});
                    String unsupportedSchemeMessagePrefix = unsupportedSchemeMessage.split("@!@")[0];
                    String message = e1.getMessage();
                    if (message.contains(unsupportedSchemeMessagePrefix)) {
                        try {
                            HadoopConfiguration hadoopConfig = HadoopVfsFileChooserDialog.this.getHadoopConfig();
                            String hadoopConfigName = hadoopConfig == null ? "Unknown" : hadoopConfig.getName();
                            HadoopVfsFileChooserDialog.this.showMessageAndLog(BaseMessages.getString((Class)PKG, (String)"HadoopVfsFileChooserDialog.error", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"HadoopVfsFileChooserDialog.Connection.schemeError", (String[])new String[]{hadoopConfigName}), message);
                        }
                        catch (ConfigurationException ce) {
                            HadoopVfsFileChooserDialog.this.showMessageAndLog(BaseMessages.getString((Class)PKG, (String)"HadoopVfsFileChooserDialog.error", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"HadoopVfsFileChooserDialog.Connection.error", (String[])new String[0]), ce.getMessage());
                        }
                    } else {
                        HadoopVfsFileChooserDialog.this.showMessageAndLog(BaseMessages.getString((Class)PKG, (String)"HadoopVfsFileChooserDialog.error", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"HadoopVfsFileChooserDialog.Connection.error", (String[])new String[0]), e1.getMessage());
                    }
                    return;
                }
                HadoopVfsFileChooserDialog.this.vfsFileChooserDialog.setSelectedFile(root);
                HadoopVfsFileChooserDialog.this.vfsFileChooserDialog.setRootFile(root);
                HadoopVfsFileChooserDialog.this.rootFile = root;
            }
        });
        textFieldPanel.setTabList(new Control[]{this.wUrl, this.wPort, this.wUserID, this.wPassword, this.wConnectionButton});
    }

    public String buildHadoopFileSystemUrlString() {
        StringBuffer urlString = new StringBuffer(this.schemeName);
        urlString.append("://");
        if (this.wUserID.getText() != null && !"".equals(this.wUserID.getText())) {
            urlString.append(this.wUserID.getText());
            urlString.append(NAMENODE_HOSTNAME_PORT_DELIMITER);
            urlString.append(this.wPassword.getText());
            urlString.append("@");
        }
        urlString.append(this.wUrl.getText());
        if (!Const.isEmpty((String)this.wPort.getText())) {
            urlString.append(NAMENODE_HOSTNAME_PORT_DELIMITER);
            urlString.append(this.wPort.getText());
        }
        return urlString.toString();
    }

    private void initializeConnectionPanel() {
        if (this.initialFile != null && this.initialFile.getName().getScheme().equals("hdfs")) {
            try {
                GenericFileName genericFileName = (GenericFileName)this.initialFile.getFileSystem().getRoot().getName();
                this.wUrl.setText(genericFileName.getHostName());
                this.wPort.setText(String.valueOf(genericFileName.getPort()));
                this.wUserID.setText(genericFileName.getUserName() == null ? "" : genericFileName.getUserName());
                this.wPassword.setText(genericFileName.getPassword() == null ? "" : genericFileName.getPassword());
            }
            catch (FileSystemException fse) {
                this.showMessageAndLog(BaseMessages.getString(PKG, (String)"HadoopVfsFileChooserDialog.error", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HadoopVfsFileChooserDialog.FileSystem.error", (String[])new String[0]), fse.getMessage());
            }
        }
        this.handleConnectionButton();
    }

    private void showMessageAndLog(String title, String message, String messageToLog) {
        MessageBox box = new MessageBox(this.getShell());
        box.setText(title);
        box.setMessage(message);
        this.log.logError(messageToLog);
        box.open();
    }

    private void handleConnectionButton() {
        if (!Const.isEmpty((String)this.wUrl.getText())) {
            this.wConnectionButton.setEnabled(true);
        } else {
            this.wConnectionButton.setEnabled(false);
        }
    }

    private HadoopConfiguration getHadoopConfig() throws ConfigurationException {
        HadoopConfiguration hadoopConfig = null;
        HadoopConfigurationProvider provider = HadoopConfigurationBootstrap.getHadoopConfigurationProvider();
        if (provider != null) {
            hadoopConfig = provider.getActiveConfiguration();
        }
        return hadoopConfig;
    }
}

