/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurenative;

import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurenative.RollingWindowAverage;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;

@Metrics(about="Metrics for WASB", context="azureFileSystem")
final class AzureFileSystemInstrumentation
implements MetricsSource {
    static final String WASB_WEB_RESPONSES = "wasb_web_responses";
    static final String WASB_BYTES_WRITTEN = "wasb_bytes_written_last_second";
    static final String WASB_BYTES_READ = "wasb_bytes_read_last_second";
    static final String WASB_RAW_BYTES_UPLOADED = "wasb_raw_bytes_uploaded";
    static final String WASB_RAW_BYTES_DOWNLOADED = "wasb_raw_bytes_downloaded";
    static final String WASB_FILES_CREATED = "wasb_files_created";
    static final String WASB_FILES_DELETED = "wasb_files_deleted";
    static final String WASB_DIRECTORIES_CREATED = "wasb_directories_created";
    static final String WASB_DIRECTORIES_DELETED = "wasb_directories_deleted";
    static final String WASB_UPLOAD_RATE = "wasb_maximum_upload_bytes_per_second";
    static final String WASB_DOWNLOAD_RATE = "wasb_maximum_download_bytes_per_second";
    static final String WASB_UPLOAD_LATENCY = "wasb_average_block_upload_latency_ms";
    static final String WASB_DOWNLOAD_LATENCY = "wasb_average_block_download_latency_ms";
    static final String WASB_CLIENT_ERRORS = "wasb_client_errors";
    static final String WASB_SERVER_ERRORS = "wasb_server_errors";
    private static final String KEY_ROLLING_WINDOW_SIZE = "fs.azure.metrics.rolling.window.size";
    private final MetricsRegistry registry = new MetricsRegistry("azureFileSystem").setContext("azureFileSystem");
    @Metric(value={"wasb_web_responses", "Total number of web responses obtained from Azure Storage"})
    MutableCounterLong numberOfWebResponses;
    @Metric(value={"wasb_files_created", "Total number of files created through the WASB file system."})
    MutableCounterLong numberOfFilesCreated;
    @Metric(value={"wasb_files_deleted", "Total number of files deleted through the WASB file system."})
    MutableCounterLong numberOfFilesDeleted;
    @Metric(value={"wasb_directories_created", "Total number of directories created through the WASB file system."})
    MutableCounterLong numberOfDirectoriesCreated;
    @Metric(value={"wasb_directories_deleted", "Total number of directories deleted through the WASB file system."})
    MutableCounterLong numberOfDirectoriesDeleted;
    @Metric(value={"wasb_bytes_written_last_second", "Total number of bytes written to Azure Storage during the last second."})
    MutableGaugeLong bytesWrittenInLastSecond;
    @Metric(value={"wasb_bytes_read_last_second", "Total number of bytes read from Azure Storage during the last second."})
    MutableGaugeLong bytesReadInLastSecond;
    @Metric(value={"wasb_maximum_upload_bytes_per_second", "The maximum upload rate encountered to Azure Storage in bytes/second."})
    MutableGaugeLong maximumUploadBytesPerSecond;
    @Metric(value={"wasb_maximum_download_bytes_per_second", "The maximum download rate encountered to Azure Storage in bytes/second."})
    MutableGaugeLong maximumDownloadBytesPerSecond;
    @Metric(value={"wasb_raw_bytes_uploaded", "Total number of raw bytes (including overhead) uploaded to Azure Storage."})
    MutableCounterLong rawBytesUploaded;
    @Metric(value={"wasb_raw_bytes_downloaded", "Total number of raw bytes (including overhead) downloaded from Azure Storage."})
    MutableCounterLong rawBytesDownloaded;
    @Metric(value={"wasb_client_errors", "Total number of client-side errors by WASB (excluding 404)."})
    MutableCounterLong clientErrors;
    @Metric(value={"wasb_server_errors", "Total number of server-caused errors by WASB."})
    MutableCounterLong serverErrors;
    @Metric(value={"wasb_average_block_upload_latency_ms", "The average latency in milliseconds of uploading a single block. The average latency is calculated over a rolling window."})
    MutableGaugeLong averageBlockUploadLatencyMs;
    @Metric(value={"wasb_average_block_download_latency_ms", "The average latency in milliseconds of downloading a single block. The average latency is calculated over a rolling window."})
    MutableGaugeLong averageBlockDownloadLatencyMs;
    private long currentMaximumUploadBytesPerSecond;
    private long currentMaximumDownloadBytesPerSecond;
    private static final int DEFAULT_LATENCY_ROLLING_AVERAGE_WINDOW = 5;
    private final RollingWindowAverage currentBlockUploadLatency;
    private final RollingWindowAverage currentBlockDownloadLatency;
    private UUID fileSystemInstanceId = UUID.randomUUID();

    public AzureFileSystemInstrumentation(Configuration conf) {
        this.registry.tag("wasbFileSystemId", "A unique identifier for the file ", this.fileSystemInstanceId.toString());
        int rollingWindowSizeInSeconds = conf.getInt(KEY_ROLLING_WINDOW_SIZE, 5);
        this.currentBlockUploadLatency = new RollingWindowAverage(rollingWindowSizeInSeconds * 1000);
        this.currentBlockDownloadLatency = new RollingWindowAverage(rollingWindowSizeInSeconds * 1000);
    }

    public UUID getFileSystemInstanceId() {
        return this.fileSystemInstanceId;
    }

    public void setAccountName(String accountName) {
        this.registry.tag("accountName", "Name of the Azure Storage account that these metrics are going against", accountName);
    }

    public void setContainerName(String containerName) {
        this.registry.tag("containerName", "Name of the Azure Storage container that these metrics are going against", containerName);
    }

    public void webResponse() {
        this.numberOfWebResponses.incr();
    }

    public void fileCreated() {
        this.numberOfFilesCreated.incr();
    }

    public void fileDeleted() {
        this.numberOfFilesDeleted.incr();
    }

    public void directoryCreated() {
        this.numberOfDirectoriesCreated.incr();
    }

    public void directoryDeleted() {
        this.numberOfDirectoriesDeleted.incr();
    }

    public void updateBytesWrittenInLastSecond(long currentBytesWritten) {
        this.bytesWrittenInLastSecond.set(currentBytesWritten);
    }

    public void updateBytesReadInLastSecond(long currentBytesRead) {
        this.bytesReadInLastSecond.set(currentBytesRead);
    }

    public synchronized void currentUploadBytesPerSecond(long bytesPerSecond) {
        if (bytesPerSecond > this.currentMaximumUploadBytesPerSecond) {
            this.currentMaximumUploadBytesPerSecond = bytesPerSecond;
            this.maximumUploadBytesPerSecond.set(bytesPerSecond);
        }
    }

    public synchronized void currentDownloadBytesPerSecond(long bytesPerSecond) {
        if (bytesPerSecond > this.currentMaximumDownloadBytesPerSecond) {
            this.currentMaximumDownloadBytesPerSecond = bytesPerSecond;
            this.maximumDownloadBytesPerSecond.set(bytesPerSecond);
        }
    }

    public void rawBytesUploaded(long numberOfBytes) {
        this.rawBytesUploaded.incr(numberOfBytes);
    }

    public void rawBytesDownloaded(long numberOfBytes) {
        this.rawBytesDownloaded.incr(numberOfBytes);
    }

    public void blockUploaded(long latency) {
        this.currentBlockUploadLatency.addPoint(latency);
    }

    public void blockDownloaded(long latency) {
        this.currentBlockDownloadLatency.addPoint(latency);
    }

    public void clientErrorEncountered() {
        this.clientErrors.incr();
    }

    public void serverErrorEncountered() {
        this.serverErrors.incr();
    }

    public long getBlockUploadLatency() {
        return this.currentBlockUploadLatency.getCurrentAverage();
    }

    public long getBlockDownloadLatency() {
        return this.currentBlockDownloadLatency.getCurrentAverage();
    }

    public long getCurrentMaximumUploadBandwidth() {
        return this.currentMaximumUploadBytesPerSecond;
    }

    public long getCurrentMaximumDownloadBandwidth() {
        return this.currentMaximumDownloadBytesPerSecond;
    }

    @Override
    public void getMetrics(MetricsCollector collector, boolean all) {
        this.averageBlockDownloadLatencyMs.set(this.currentBlockDownloadLatency.getCurrentAverage());
        this.averageBlockUploadLatencyMs.set(this.currentBlockUploadLatency.getCurrentAverage());
        this.registry.snapshot(collector.addRecord(this.registry.info()), all);
    }
}

