/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurenative;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azure.KeyProviderException;
import org.apache.hadoop.fs.azurenative.SimpleKeyProvider;
import org.apache.hadoop.util.Shell;

public class ShellDecryptionKeyProvider
extends SimpleKeyProvider {
    static final String KEY_ACCOUNT_SHELLKEYPROVIDER_SCRIPT = "fs.azure.shellkeyprovider.script";

    @Override
    public String getStorageAccountKey(String accountName, Configuration conf) throws KeyProviderException {
        String envelope = super.getStorageAccountKey(accountName, conf);
        String command = conf.get(KEY_ACCOUNT_SHELLKEYPROVIDER_SCRIPT);
        if (command == null) {
            throw new KeyProviderException("Script path is not specified via fs.azure.shellkeyprovider.script");
        }
        String[] cmd = command.split(" ");
        String[] cmdWithEnvelope = Arrays.copyOf(cmd, cmd.length + 1);
        cmdWithEnvelope[cmdWithEnvelope.length - 1] = envelope;
        String decryptedKey = null;
        try {
            decryptedKey = Shell.execCommand(cmdWithEnvelope);
        }
        catch (IOException ex) {
            throw new KeyProviderException(ex);
        }
        return decryptedKey.trim();
    }
}

