/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.clipboard;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.pentaho.di.core.clipboard.PrependWinBMPHeaderFilterInputStream;
import org.pentaho.di.core.clipboard.RemoveWinBMPHeaderFilterOutputStream;
import org.pentaho.di.core.clipboard.UncompressDibFilterInputStream;

public class ImageDataTransfer
extends ByteArrayTransfer {
    public static final int COM_CF_DIB = 8;
    private static final ImageDataTransfer INSTANCE = new ImageDataTransfer();
    private static final String CF_DIB = "CF_DIB";
    private static final int CF_DIBID = 8;

    private ImageDataTransfer() {
    }

    public static ImageDataTransfer getInstance() {
        return INSTANCE;
    }

    protected final int[] getTypeIds() {
        return new int[]{8};
    }

    protected final String[] getTypeNames() {
        return new String[]{CF_DIB};
    }

    protected Object nativeToJava(TransferData transferData) {
        Object o = super.nativeToJava(transferData);
        byte[] bytes = (byte[])o;
        try {
            PrependWinBMPHeaderFilterInputStream bis = new PrependWinBMPHeaderFilterInputStream(new UncompressDibFilterInputStream(new ByteArrayInputStream(bytes)));
            ImageData[] data = new ImageLoader().load((InputStream)bis);
            if (data.length < 1) {
                return null;
            }
            return data[0];
        }
        catch (IOException e) {
            return null;
        }
    }

    protected void javaToNative(Object object, TransferData transferData) {
        ImageData imgData = (ImageData)object;
        ImageLoader loader = new ImageLoader();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        loader.data = new ImageData[]{imgData};
        loader.save((OutputStream)new RemoveWinBMPHeaderFilterOutputStream(bos), 0);
        byte[] bytes = bos.toByteArray();
        super.javaToNative((Object)bytes, transferData);
    }
}

