/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.database.dialog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.DBCache;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.DatabaseMetaInformation;
import org.pentaho.di.core.database.Schema;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LoggingObject;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransProfileFactory;
import org.pentaho.di.ui.core.database.dialog.DatabaseExplorerNode;
import org.pentaho.di.ui.core.database.dialog.GetDatabaseInfoProgressDialog;
import org.pentaho.di.ui.core.database.dialog.GetPreviewTableProgressDialog;
import org.pentaho.di.ui.core.database.dialog.GetQueryFieldsProgressDialog;
import org.pentaho.di.ui.core.database.dialog.GetTableSizeProgressDialog;
import org.pentaho.di.ui.core.database.dialog.IUiActionStatus;
import org.pentaho.di.ui.core.database.dialog.SQLEditor;
import org.pentaho.di.ui.core.database.dialog.UiPostActionStatus;
import org.pentaho.di.ui.core.database.dialog.XulDatabaseExplorerModel;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.dialog.StepFieldsDialog;
import org.pentaho.di.ui.trans.dialog.TransPreviewProgressDialog;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.binding.DefaultBindingFactory;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.components.XulPromptBox;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.swt.tags.SwtButton;
import org.pentaho.ui.xul.swt.tags.SwtDialog;
import org.pentaho.ui.xul.util.XulDialogCallback;

public class XulDatabaseExplorerController
extends AbstractXulEventHandler
implements IUiActionStatus {
    private static final Class<?> PKG = XulDatabaseExplorerController.class;
    private XulDatabaseExplorerModel model;
    private Binding databaseTreeBinding;
    private Binding selectedTableBinding;
    private XulTree databaseTree;
    private XulButton expandCollapseButton;
    private BindingFactory bf;
    protected Shell shell;
    private SwtDialog dbExplorerDialog;
    private DBCache dbcache;
    private List<DatabaseMeta> databases;
    private boolean isExpanded;
    private boolean isJustLook;
    private UiPostActionStatus status = UiPostActionStatus.NONE;
    private static final String DATABASE_IMAGE = "ui/images/folder_connection.png";
    private static final String FOLDER_IMAGE = "ui/images/BOL.png";
    private static final String SCHEMA_IMAGE = "ui/images/schema.png";
    private static final String TABLE_IMAGE = "ui/images/table.png";
    private static final String EXPAND_ALL_IMAGE = "ui/images/ExpandAll.png";
    private static final String COLLAPSE_ALL_IMAGE = "ui/images/CollapseAll.png";
    private static final String STRING_SCHEMAS = BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Schemas.Label", (String[])new String[0]);
    private static final String STRING_TABLES = BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Tables.Label", (String[])new String[0]);
    private static final String STRING_VIEWS = BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Views.Label", (String[])new String[0]);
    private static final String STRING_SYNONYMS = BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Synonyms.Label", (String[])new String[0]);

    public XulDatabaseExplorerController(Shell shell, DatabaseMeta databaseMeta, List<DatabaseMeta> databases, boolean aLook) {
        this.model = new XulDatabaseExplorerModel(databaseMeta);
        this.shell = shell;
        this.bf = new DefaultBindingFactory();
        this.databases = databases;
        this.dbcache = DBCache.getInstance();
        this.isJustLook = aLook;
    }

    public void init() {
        SwtButton theAcceptButton = (SwtButton)this.document.getElementById("databaseExplorerDialog_accept");
        SwtButton theCancelButton = (SwtButton)this.document.getElementById("databaseExplorerDialog_cancel");
        if (this.isJustLook) {
            theAcceptButton.setVisible(false);
            theCancelButton.setLabel(BaseMessages.getString(this.getClass(), (String)"DatabaseExplorer.Button.Ok", (String[])new String[0]));
            theAcceptButton.setDisabled(false);
        } else {
            theAcceptButton.setLabel(BaseMessages.getString(this.getClass(), (String)"DatabaseExplorer.Button.Ok", (String[])new String[0]));
            theCancelButton.setLabel(BaseMessages.getString(this.getClass(), (String)"DatabaseExplorer.Button.Cancel", (String[])new String[0]));
            theAcceptButton.setDisabled(true);
        }
        this.dbExplorerDialog = (SwtDialog)this.document.getElementById("databaseExplorerDialog");
        this.createDatabaseNodes();
        if (this.status != UiPostActionStatus.OK) {
            return;
        }
        this.bf.setDocument(this.document);
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.expandCollapseButton = (XulButton)this.document.getElementById("expandCollapseButton");
        this.databaseTree = (XulTree)this.document.getElementById("databaseTree");
        this.databaseTreeBinding = this.bf.createBinding((Object)this.model, "database", (Object)this.databaseTree, "elements", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.model, "selectedNode", (Object)theAcceptButton, "disabled", new BindingConvertor[]{new BindingConvertor<DatabaseExplorerNode, Boolean>(){

            public Boolean sourceToTarget(DatabaseExplorerNode arg0) {
                return !XulDatabaseExplorerController.this.isJustLook && (arg0 == null || !arg0.isTable());
            }

            public DatabaseExplorerNode targetToSource(Boolean arg0) {
                return null;
            }
        }});
        this.bf.setBindingType(Binding.Type.BI_DIRECTIONAL);
        this.bf.createBinding((Object)this.databaseTree, "selectedItems", (Object)this.model, "selectedNode", new BindingConvertor[]{new BindingConvertor<List<DatabaseExplorerNode>, DatabaseExplorerNode>(){

            public DatabaseExplorerNode sourceToTarget(List<DatabaseExplorerNode> arg0) {
                if (arg0 == null || arg0.size() == 0) {
                    return null;
                }
                return arg0.get(0);
            }

            public List<DatabaseExplorerNode> targetToSource(DatabaseExplorerNode arg0) {
                return Collections.singletonList(arg0);
            }
        }});
        BindingConvertor<DatabaseExplorerNode, Boolean> isDisabledConvertor = new BindingConvertor<DatabaseExplorerNode, Boolean>(){

            public Boolean sourceToTarget(DatabaseExplorerNode value) {
                return value == null || !value.isTable();
            }

            public DatabaseExplorerNode targetToSource(Boolean value) {
                return null;
            }
        };
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.bf.createBinding((Object)this.databaseTree, "selectedItem", "buttonMenuPopUp", "disabled", new BindingConvertor[]{isDisabledConvertor});
        this.bf.createBinding((Object)this.databaseTree, "selectedItem", "buttonMenuPopUpImg", "disabled", new BindingConvertor[]{isDisabledConvertor});
        this.bf.createBinding((Object)this.databaseTree, "selectedItem", "action_popup", "disabled", new BindingConvertor[]{isDisabledConvertor});
        this.fireBindings();
    }

    public void setSelectedSchemaAndTable(String aSchema, String aTable) throws KettleDatabaseException {
        this.model.setSelectedNode(this.model.findBy(aSchema, aTable));
    }

    public String getSelectedTable() {
        return this.model.getTable();
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.model.getDatabaseMeta();
    }

    public String getSelectedSchema() {
        return this.model.getSchema();
    }

    public void accept() {
        if (this.model.getTable() != null) {
            this.dbExplorerDialog.setVisible(false);
        }
    }

    public void cancel() {
        this.model.setSelectedNode(null);
        this.dbExplorerDialog.setVisible(false);
    }

    public void truncate() {
        if (this.model.getTable() == null) {
            return;
        }
        DatabaseMeta dm = this.model.getDatabaseMeta();
        String message = dm.getTruncateTableStatement(this.model.getSchema(), this.model.getTable());
        if (message == null) {
            message = "Truncating tables is not supported by " + dm.getDatabaseInterface().getPluginName();
        }
        SQLEditor theSqlEditor = new SQLEditor((VariableSpace)this.getDatabaseMeta(), this.dbExplorerDialog.getShell(), 0, dm, this.dbcache, "-- " + message);
        theSqlEditor.open();
    }

    public void viewSql() {
        if (this.model.getTable() == null) {
            return;
        }
        SQLEditor theSqlEditor = new SQLEditor((VariableSpace)this.getDatabaseMeta(), this.dbExplorerDialog.getShell(), 0, this.model.getDatabaseMeta(), this.dbcache, "SELECT * FROM " + this.getSchemaAndTable(this.model));
        theSqlEditor.open();
    }

    public void showLayout() {
        DatabaseMeta databaseMeta = this.model.getDatabaseMeta();
        String schemaTable = databaseMeta.getQuotedSchemaTableCombination(this.model.getSchema(), this.model.getTable());
        String theSql = databaseMeta.getSQLQueryFields(schemaTable);
        GetQueryFieldsProgressDialog theProgressDialog = new GetQueryFieldsProgressDialog(this.shell, databaseMeta, theSql);
        RowMetaInterface fields = theProgressDialog.open();
        StepFieldsDialog stepFieldsDialog = new StepFieldsDialog(this.shell, (VariableSpace)databaseMeta, 0, schemaTable, fields);
        stepFieldsDialog.setShellText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.TableLayout.ShellText", (String[])new String[0]));
        stepFieldsDialog.setOriginText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.TableLayout.OriginText", (String[])new String[0]));
        stepFieldsDialog.setShowEditButton(false);
        stepFieldsDialog.open();
    }

    public void displayRowCount() {
        if (this.model.getTable() == null) {
            return;
        }
        try {
            GetTableSizeProgressDialog pd = new GetTableSizeProgressDialog(this.dbExplorerDialog.getShell(), this.model.getDatabaseMeta(), this.model.getTable(), this.model.getSchema());
            Long theCount = pd.open();
            if (theCount != null) {
                XulMessageBox theMessageBox = (XulMessageBox)this.document.createElement("messagebox");
                theMessageBox.setModalParent((Object)this.dbExplorerDialog.getShell());
                theMessageBox.setTitle(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.TableSize.Title", (String[])new String[0]));
                theMessageBox.setMessage(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.TableSize.Message", (String[])new String[]{this.model.getTable(), theCount.toString()}));
                theMessageBox.open();
            }
        }
        catch (XulException e) {
            LogChannel.GENERAL.logError("Error displaying row count", (Throwable)e);
        }
    }

    private void fireBindings() {
        try {
            this.databaseTreeBinding.fireSourceChanged();
            if (this.getSelectedTable() != null) {
                this.selectedTableBinding.fireSourceChanged();
            }
        }
        catch (Exception e) {
            LogChannel.GENERAL.logError("Error firing bindings in database explorer", (Throwable)e);
        }
    }

    public String getName() {
        return "dbexplorer";
    }

    public void preview(boolean askLimit) {
        if (this.model.getTable() == null) {
            return;
        }
        try {
            GetPreviewTableProgressDialog pd;
            List<Object[]> rows;
            PromptCallback theCallback = new PromptCallback();
            boolean execute = true;
            int limit = 100;
            if (askLimit) {
                XulPromptBox thePromptBox = (XulPromptBox)this.document.createElement("promptbox");
                thePromptBox.setModalParent((Object)this.dbExplorerDialog.getShell());
                thePromptBox.setTitle("Enter Max Rows");
                thePromptBox.setMessage("Max Rows:");
                thePromptBox.addDialogCallback((XulDialogCallback)theCallback);
                thePromptBox.open();
                execute = theCallback.getLimit() != -1;
                limit = theCallback.getLimit();
            }
            if ((rows = (pd = new GetPreviewTableProgressDialog(this.dbExplorerDialog.getShell(), this.model.getDatabaseMeta(), this.model.getSchema(), this.model.getTable(), limit)).open()) != null) {
                if (rows.size() > 0) {
                    PreviewRowsDialog prd = new PreviewRowsDialog(this.dbExplorerDialog.getShell(), (VariableSpace)this.model.getDatabaseMeta(), 0, this.model.getTable(), pd.getRowMeta(), rows);
                    prd.open();
                } else {
                    MessageBox mb = new MessageBox(this.dbExplorerDialog.getShell(), 34);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.NoRows.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.NoRows.Title", (String[])new String[0]));
                    mb.open();
                }
            }
        }
        catch (Exception e) {
            LogChannel.GENERAL.logError("Error previewing rows", (Throwable)e);
        }
    }

    public void refresh() {
        this.collapse();
        this.model.getDatabase().clear();
        this.createDatabaseNodes();
        if (this.status != UiPostActionStatus.OK) {
            return;
        }
        this.fireBindings();
    }

    void createDatabaseNodes() {
        this.status = UiPostActionStatus.NONE;
        Database theDatabase = new Database(null, this.model.getDatabaseMeta());
        try {
            Map synonymMap;
            theDatabase.connect();
            GetDatabaseInfoProgressDialog gdipd = new GetDatabaseInfoProgressDialog((Shell)this.dbExplorerDialog.getRootObject(), this.model.getDatabaseMeta());
            DatabaseMetaInformation dmi = gdipd.open();
            DatabaseExplorerNode theDatabaseNode = new DatabaseExplorerNode();
            theDatabaseNode.setName(this.model.getDatabaseMeta().getName());
            theDatabaseNode.setImage(DATABASE_IMAGE);
            this.model.getDatabase().add((Object)theDatabaseNode);
            DatabaseExplorerNode theSchemasNode = new DatabaseExplorerNode();
            theSchemasNode.setName(STRING_SCHEMAS);
            theSchemasNode.setImage(FOLDER_IMAGE);
            theDatabaseNode.add((Object)theSchemasNode);
            DatabaseExplorerNode theTablesNode = new DatabaseExplorerNode();
            theTablesNode.setName(STRING_TABLES);
            theTablesNode.setImage(FOLDER_IMAGE);
            theDatabaseNode.add((Object)theTablesNode);
            DatabaseExplorerNode theViewsNode = new DatabaseExplorerNode();
            theViewsNode.setName(STRING_VIEWS);
            theViewsNode.setImage(FOLDER_IMAGE);
            theDatabaseNode.add((Object)theViewsNode);
            DatabaseExplorerNode theSynonymsNode = new DatabaseExplorerNode();
            theSynonymsNode.setName(STRING_SYNONYMS);
            theSynonymsNode.setImage(FOLDER_IMAGE);
            theDatabaseNode.add((Object)theSynonymsNode);
            Schema[] schemas = dmi.getSchemas();
            if (schemas != null) {
                DatabaseExplorerNode theSchemaNode = null;
                for (int i = 0; i < schemas.length; ++i) {
                    theSchemaNode = new DatabaseExplorerNode();
                    theSchemaNode.setName(schemas[i].getSchemaName());
                    theSchemaNode.setImage(SCHEMA_IMAGE);
                    theSchemaNode.setIsSchema(true);
                    theSchemasNode.add((Object)theSchemaNode);
                    String[] theTableNames = schemas[i].getItems();
                    if (theTableNames == null) continue;
                    for (int i2 = 0; i2 < theTableNames.length; ++i2) {
                        DatabaseExplorerNode theTableNode = new DatabaseExplorerNode();
                        theTableNode.setIsTable(true);
                        theTableNode.setSchema(schemas[i].getSchemaName());
                        theTableNode.setName(theTableNames[i2]);
                        theTableNode.setImage(TABLE_IMAGE);
                        theSchemaNode.add((Object)theTableNode);
                        theTableNode.setParent(theSchemaNode);
                    }
                }
            }
            Map tableMap = dmi.getTableMap();
            ArrayList tableKeys = new ArrayList(tableMap.keySet());
            Collections.sort(tableKeys);
            for (String schema : tableKeys) {
                ArrayList tables = new ArrayList((Collection)tableMap.get(schema));
                Collections.sort(tables);
                for (String table : tables) {
                    DatabaseExplorerNode theTableNode = new DatabaseExplorerNode();
                    theTableNode.setIsTable(true);
                    theTableNode.setName(table);
                    theTableNode.setImage(TABLE_IMAGE);
                    theTablesNode.add((Object)theTableNode);
                }
            }
            Map viewMap = dmi.getViewMap();
            if (viewMap != null) {
                ArrayList viewKeys = new ArrayList(viewMap.keySet());
                Collections.sort(viewKeys);
                for (String schema : viewKeys) {
                    ArrayList views = new ArrayList((Collection)viewMap.get(schema));
                    Collections.sort(views);
                    for (String view : views) {
                        DatabaseExplorerNode theViewNode = new DatabaseExplorerNode();
                        theViewNode.setIsTable(true);
                        theViewNode.setName(view);
                        theViewNode.setImage(TABLE_IMAGE);
                        theViewsNode.add((Object)theViewNode);
                    }
                }
            }
            if ((synonymMap = dmi.getSynonymMap()) != null) {
                ArrayList synonymKeys = new ArrayList(synonymMap.keySet());
                Collections.sort(synonymKeys);
                for (String schema : synonymKeys) {
                    ArrayList synonyms = new ArrayList((Collection)synonymMap.get(schema));
                    Collections.sort(synonyms);
                    for (String synonym : synonyms) {
                        DatabaseExplorerNode theSynonymNode = new DatabaseExplorerNode();
                        theSynonymNode.setIsTable(true);
                        theSynonymNode.setName(synonym);
                        theSynonymNode.setImage(TABLE_IMAGE);
                        theSynonymsNode.add((Object)theSynonymNode);
                    }
                }
            }
        }
        catch (Exception e) {
            this.status = UiPostActionStatus.ERROR;
            theDatabase.disconnect();
            new ErrorDialog(this.shell, "Error", "Unexpected explorer error:", e);
            this.status = UiPostActionStatus.ERROR_DIALOG_SHOWN;
            return;
        }
        this.status = UiPostActionStatus.OK;
    }

    public void close() {
        this.dbExplorerDialog.setVisible(false);
    }

    public void expandCollapse() {
        if (this.isExpanded) {
            this.collapse();
        } else {
            this.expand();
        }
    }

    private void expand() {
        this.databaseTree.expandAll();
        this.isExpanded = true;
        this.expandCollapseButton.setImage(COLLAPSE_ALL_IMAGE);
    }

    private void collapse() {
        this.databaseTree.collapseAll();
        this.isExpanded = false;
        this.expandCollapseButton.setImage(EXPAND_ALL_IMAGE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDDL() {
        if (this.model.getTable() == null) {
            return;
        }
        Database db = new Database(null, this.model.getDatabaseMeta());
        try {
            db.connect();
            String tableName = this.getSchemaAndTable(this.model);
            RowMetaInterface r = db.getTableFields(tableName);
            String sql = db.getCreateTableStatement(tableName, r, null, false, null, true);
            SQLEditor se = new SQLEditor((VariableSpace)this.getDatabaseMeta(), this.dbExplorerDialog.getShell(), 0, this.model.getDatabaseMeta(), this.dbcache, sql);
            se.open();
        }
        catch (KettleDatabaseException dbe) {
            new ErrorDialog(this.dbExplorerDialog.getShell(), BaseMessages.getString(PKG, (String)"Dialog.Error.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Error.RetrieveLayout", (String[])new String[0]), (Exception)((Object)dbe));
        }
        finally {
            db.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDDLForOther() {
        block9: {
            if (this.databases != null) {
                try {
                    ArrayList<DatabaseMeta> dbs = new ArrayList<DatabaseMeta>();
                    for (int i = 0; i < this.databases.size(); ++i) {
                        if (!this.databases.get(i).getDatabaseInterface().isExplorable()) continue;
                        dbs.add(this.databases.get(i));
                    }
                    String[] conn = new String[dbs.size()];
                    for (int i = 0; i < conn.length; ++i) {
                        conn[i] = ((DatabaseMeta)dbs.get(i)).getName();
                    }
                    EnterSelectionDialog esd = new EnterSelectionDialog(this.dbExplorerDialog.getShell(), conn, BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.TargetDatabase.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.TargetDatabase.Message", (String[])new String[0]));
                    String target = esd.open();
                    if (target == null) break block9;
                    DatabaseMeta targetdbi = DatabaseMeta.findDatabase(dbs, (String)target);
                    Database targetdb = new Database(null, targetdbi);
                    try {
                        targetdb.connect();
                        String tableName = this.getSchemaAndTable(this.model);
                        RowMetaInterface r = targetdb.getTableFields(tableName);
                        String sql = targetdb.getCreateTableStatement(tableName, r, null, false, null, true);
                        SQLEditor se = new SQLEditor((VariableSpace)this.getDatabaseMeta(), this.dbExplorerDialog.getShell(), 0, this.model.getDatabaseMeta(), this.dbcache, sql);
                        se.open();
                    }
                    finally {
                        targetdb.disconnect();
                    }
                }
                catch (KettleDatabaseException dbe) {
                    new ErrorDialog(this.dbExplorerDialog.getShell(), BaseMessages.getString(PKG, (String)"Dialog.Error.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.Error.GenDDL", (String[])new String[0]), (Exception)((Object)dbe));
                }
            } else {
                MessageBox mb = new MessageBox(this.dbExplorerDialog.getShell(), 2);
                mb.setMessage(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.NoConnectionsKnown.Message", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.NoConnectionsKnown.Title", (String[])new String[0]));
                mb.open();
            }
        }
    }

    public void dataProfile() {
        if (this.model.getTable() == null) {
            return;
        }
        Shell dbShell = (Shell)this.dbExplorerDialog.getRootObject();
        try {
            TransProfileFactory profileFactory = new TransProfileFactory(this.model.getDatabaseMeta(), this.getSchemaAndTable(this.model));
            TransMeta transMeta = profileFactory.generateTransformation((LoggingObjectInterface)new LoggingObject((Object)this.model.getTable()));
            TransPreviewProgressDialog progressDialog = new TransPreviewProgressDialog(dbShell, transMeta, new String[]{"calc stats"}, new int[]{25000});
            progressDialog.open();
            if (!progressDialog.isCancelled()) {
                Trans trans = progressDialog.getTrans();
                String loggingText = progressDialog.getLoggingText();
                if (trans.getResult() != null && trans.getResult().getNrErrors() > 0L) {
                    EnterTextDialog etd = new EnterTextDialog(dbShell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                    etd.setReadOnly();
                    etd.open();
                }
                PreviewRowsDialog prd = new PreviewRowsDialog(dbShell, (VariableSpace)transMeta, 0, "calc stats", progressDialog.getPreviewRowsMeta("calc stats"), progressDialog.getPreviewRows("calc stats"), loggingText);
                prd.open();
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.dbExplorerDialog.getShell(), BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.UnexpectedProfilingError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DatabaseExplorerDialog.UnexpectedProfilingError.Message", (String[])new String[0]), e);
        }
    }

    private String getSchemaAndTable(XulDatabaseExplorerModel model) {
        return this.getSchemaAndTable(model, model.getDatabaseMeta());
    }

    private String getSchemaAndTable(XulDatabaseExplorerModel model, DatabaseMeta meta) {
        if (model.getSchema() != null) {
            return meta.getQuotedSchemaTableCombination(model.getSchema(), model.getTable());
        }
        return meta.getQuotedSchemaTableCombination(null, model.getTable());
    }

    @Override
    public UiPostActionStatus getActionStatus() {
        return this.status;
    }

    class PromptCallback
    implements XulDialogCallback<Object> {
        private int limit = -1;

        PromptCallback() {
        }

        public void onClose(XulComponent aSender, XulDialogCallback.Status aReturnCode, Object aRetVal) {
            if (aReturnCode == XulDialogCallback.Status.ACCEPT) {
                try {
                    this.limit = Integer.parseInt(aRetVal.toString());
                }
                catch (NumberFormatException e) {
                    LogChannel.GENERAL.logError("Error parsing string '" + aRetVal.toString() + "'", (Throwable)e);
                }
            }
        }

        public void onError(XulComponent aSenter, Throwable aThrowable) {
        }

        public int getLimit() {
            return this.limit;
        }
    }
}

