/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.dialog;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class ShowMessageDialog
extends Dialog {
    private static Class<?> PKG = ShowMessageDialog.class;
    private String title;
    private String message;
    private Shell shell;
    private PropsUI props;
    private int flags;
    private int returnValue;
    private Shell parent;
    private boolean scroll;
    private int timeOut;
    private List<Button> buttons;
    private List<SelectionAdapter> adapters;

    public ShowMessageDialog(Shell parent, int flags, String title, String message) {
        this(parent, flags, title, message, false);
    }

    public ShowMessageDialog(Shell parent, int flags, String title, String message, boolean scroll) {
        super(parent, 0);
        this.parent = parent;
        this.flags = flags;
        this.title = title;
        this.message = message;
        this.scroll = scroll;
        this.props = PropsUI.getInstance();
    }

    public int open() {
        SelectionAdapter selectionAdapter;
        Button button;
        Text wlDesc;
        Display display = this.parent.getDisplay();
        this.shell = new Shell(this.parent, 2160);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageSpoon());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(this.title);
        int margin = 4;
        boolean hasIcon = (this.flags & 8) != 0 || (this.flags & 2) != 0 || (this.flags & 4) != 0 || (this.flags & 1) != 0 || (this.flags & 0x10) != 0;
        Image image = null;
        if ((this.flags & 8) != 0) {
            image = display.getSystemImage(8);
        }
        if ((this.flags & 2) != 0) {
            image = display.getSystemImage(2);
        }
        if ((this.flags & 4) != 0) {
            image = display.getSystemImage(4);
        }
        if ((this.flags & 1) != 0) {
            image = display.getSystemImage(1);
        }
        if ((this.flags & 0x10) != 0) {
            image = display.getSystemImage(16);
        }
        hasIcon = hasIcon && image != null;
        Label wIcon = null;
        if (hasIcon && image != null) {
            wIcon = new Label((Composite)this.shell, 0);
            this.props.setLook((Control)wIcon);
            wIcon.setImage(image);
            FormData fdIcon = new FormData();
            fdIcon.left = new FormAttachment(0, 0);
            fdIcon.top = new FormAttachment(0, 0);
            fdIcon.right = new FormAttachment(0, image.getBounds().width);
            fdIcon.bottom = new FormAttachment(0, image.getBounds().height);
            wIcon.setLayoutData((Object)fdIcon);
        }
        FormData fdlDesc = new FormData();
        if (this.scroll) {
            wlDesc = new Text((Composite)this.shell, 778);
            this.shell.setSize(550, 350);
            fdlDesc.bottom = new FormAttachment(100, -50);
            fdlDesc.right = new FormAttachment(100, 0);
        } else {
            wlDesc = new Text((Composite)this.shell, 10);
            fdlDesc.right = new FormAttachment(100, 0);
        }
        wlDesc.setText(this.message);
        this.props.setLook((Control)wlDesc);
        if (hasIcon) {
            fdlDesc.left = new FormAttachment((Control)wIcon, margin * 2);
            fdlDesc.top = new FormAttachment(0, margin);
        } else {
            fdlDesc.left = new FormAttachment(0, 0);
            fdlDesc.top = new FormAttachment(0, margin);
        }
        wlDesc.setLayoutData((Object)fdlDesc);
        this.buttons = new ArrayList<Button>();
        this.adapters = new ArrayList<SelectionAdapter>();
        if ((this.flags & 0x20) != 0) {
            button = new Button((Composite)this.shell, 8);
            String ok = BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]);
            button.setText(ok);
            SelectionAdapter selectionAdapter2 = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ShowMessageDialog.this.quit(32);
                }
            };
            button.addSelectionListener((SelectionListener)selectionAdapter2);
            this.adapters.add(selectionAdapter2);
            this.buttons.add(button);
        }
        if ((this.flags & 0x100) != 0) {
            button = new Button((Composite)this.shell, 8);
            button.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
            selectionAdapter = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ShowMessageDialog.this.quit(256);
                }
            };
            button.addSelectionListener((SelectionListener)selectionAdapter);
            this.adapters.add(selectionAdapter);
            this.buttons.add(button);
        }
        if ((this.flags & 0x40) != 0) {
            button = new Button((Composite)this.shell, 8);
            button.setText(BaseMessages.getString(PKG, (String)"System.Button.Yes", (String[])new String[0]));
            selectionAdapter = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ShowMessageDialog.this.quit(64);
                }
            };
            button.addSelectionListener((SelectionListener)selectionAdapter);
            this.adapters.add(selectionAdapter);
            this.buttons.add(button);
        }
        if ((this.flags & 0x80) != 0) {
            button = new Button((Composite)this.shell, 8);
            button.setText(BaseMessages.getString(PKG, (String)"System.Button.No", (String[])new String[0]));
            selectionAdapter = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ShowMessageDialog.this.quit(128);
                }
            };
            button.addSelectionListener((SelectionListener)selectionAdapter);
            this.adapters.add(selectionAdapter);
            this.buttons.add(button);
        }
        BaseStepDialog.positionBottomButtons((Composite)this.shell, this.buttons.toArray(new Button[this.buttons.size()]), margin, (Control)wlDesc);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                ShowMessageDialog.this.cancel();
            }
        });
        this.shell.layout();
        if (!this.scroll) {
            this.shell.pack(true);
        }
        button = this.buttons.get(0);
        selectionAdapter = this.adapters.get(0);
        String ok = button.getText();
        long startTime = new Date().getTime();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
            if (this.timeOut <= 0) continue;
            long time = new Date().getTime();
            long diff = (time - startTime) / 1000L;
            button.setText(ok + " (" + ((long)this.timeOut - diff) + ")");
            if (diff < (long)this.timeOut) continue;
            selectionAdapter.widgetSelected(null);
        }
        return this.returnValue;
    }

    public void dispose() {
        this.shell.dispose();
    }

    private void cancel() {
        if ((this.flags & 0x80) > 0) {
            this.quit(128);
        } else {
            this.quit(256);
        }
    }

    private void quit(int returnValue) {
        this.returnValue = returnValue;
        this.dispose();
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(int timeOut) {
        this.timeOut = timeOut;
    }
}

