/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.namedcluster.dialog;

import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.namedcluster.model.NamedCluster;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.widget.TextVar;

public class NamedClusterComposite
extends Composite {
    private static Class<?> PKG = NamedClusterComposite.class;
    private PropsUI props;
    private GridData gridData;
    private GridData numberGridData;
    private GridData labelGridData;
    private GridData urlGridData;
    private static final int TEXT_FLAGS = 18436;
    private static final int PASSWORD_FLAGS = 0x404804;

    public NamedClusterComposite(Composite parent, NamedCluster namedCluster, PropsUI props) {
        super(parent, 0);
        props.setLook((Control)this);
        this.props = props;
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.setLayout((Layout)formLayout);
        this.gridData = new GridData();
        this.gridData.widthHint = 300;
        this.numberGridData = new GridData();
        this.numberGridData.widthHint = 160;
        this.labelGridData = new GridData();
        this.labelGridData.widthHint = 300;
        this.urlGridData = new GridData();
        this.urlGridData.widthHint = 400;
        this.processNamedCluster(this, namedCluster);
    }

    private void processNamedCluster(Composite c, NamedCluster cluster) {
        Composite confUI = this.createConfigurationUI(c, cluster);
        Label topSeparator = new Label(c, 258);
        FormData fd = new FormData(455, 1);
        fd.top = new FormAttachment((Control)confUI);
        topSeparator.setLayoutData((Object)fd);
        ScrolledComposite sc1 = new ScrolledComposite(c, 512);
        this.props.setLook((Control)sc1);
        fd = new FormData(445, 360);
        fd.top = new FormAttachment((Control)topSeparator, 15);
        sc1.setLayoutData((Object)fd);
        Composite c1 = new Composite((Composite)sc1, 0);
        this.props.setLook((Control)c1);
        sc1.setContent((Control)c1);
        c1.setLayout((Layout)new GridLayout(1, false));
        this.createHdfsGroup(c1, cluster);
        this.createJobTrackerGroup(c1, cluster);
        this.createZooKeeperGroup(c1, cluster);
        this.createOozieGroup(c1, cluster);
        c1.setSize(c1.computeSize(-1, -1));
        Label bottomSeparator = new Label(c, 258);
        fd = new FormData(455, 1);
        fd.top = new FormAttachment((Control)sc1, 20);
        bottomSeparator.setLayoutData((Object)fd);
    }

    private Composite createConfigurationUI(Composite c, final NamedCluster namedCluster) {
        Composite mainParent = new Composite(c, 0);
        this.props.setLook((Control)mainParent);
        mainParent.setLayout((Layout)new GridLayout(1, false));
        FormData fd = new FormData(440, 70);
        mainParent.setLayoutData((Object)fd);
        GridData textGridData = new GridData();
        textGridData.widthHint = 250;
        this.createLabel(mainParent, BaseMessages.getString(PKG, (String)"NamedClusterDialog.NamedCluster.Name", (String[])new String[0]), 0);
        final Text nameValue = new Text(mainParent, 18436);
        nameValue.setText("" + namedCluster.getName());
        nameValue.setLayoutData((Object)textGridData);
        this.props.setLook((Control)nameValue);
        nameValue.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent event) {
                namedCluster.setName(nameValue.getText());
            }

            public void keyPressed(KeyEvent event) {
            }
        });
        return mainParent;
    }

    private Label createLabel(Composite parent, String text, int swtFlags) {
        Label label = new Label(parent, 0);
        label.setText(text);
        label.setLayoutData((Object)this.labelGridData);
        this.props.setLook((Control)label);
        return label;
    }

    private TextVar createTextVar(final NamedCluster c, Composite parent, String val, GridData gd, int flags, final Callback cb) {
        final TextVar textVar = new TextVar((VariableSpace)c, parent, flags);
        textVar.setText(StringUtils.isEmpty((String)val) ? "" : val);
        textVar.setLayoutData(gd);
        this.props.setLook((Control)textVar);
        textVar.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent event) {
                cb.invoke(c, textVar, textVar.getText());
            }

            public void keyPressed(KeyEvent event) {
            }
        });
        return textVar;
    }

    private Composite createGroup(Composite parent, String groupLabel) {
        Group group = new Group(parent, 0);
        group.setText(groupLabel);
        group.setLayout((Layout)new RowLayout(512));
        this.props.setLook((Control)group);
        GridData groupGridData = new GridData();
        groupGridData.widthHint = 430;
        group.setLayoutData((Object)groupGridData);
        Composite pp = new Composite((Composite)group, 0);
        this.props.setLook((Control)pp);
        pp.setLayout((Layout)new GridLayout(1, false));
        return pp;
    }

    private void createHdfsGroup(Composite parentComposite, NamedCluster c) {
        Composite pp = this.createGroup(parentComposite, BaseMessages.getString(PKG, (String)"NamedClusterDialog.HDFS", (String[])new String[0]));
        this.createLabel(pp, BaseMessages.getString(PKG, (String)"NamedClusterDialog.Hostname", (String[])new String[0]), 0);
        Callback hdfsHostCB = new Callback(){

            @Override
            public void invoke(NamedCluster nc, TextVar textVar, String value) {
                nc.setHdfsHost(value);
            }
        };
        this.createTextVar(c, pp, c.getHdfsHost(), this.gridData, 18436, hdfsHostCB);
        this.createLabel(pp, BaseMessages.getString(PKG, (String)"NamedClusterDialog.Port", (String[])new String[0]), 0);
        Callback hdfsPortCB = new Callback(){

            @Override
            public void invoke(NamedCluster nc, TextVar textVar, String value) {
                nc.setHdfsPort(value);
            }
        };
        this.createTextVar(c, pp, c.getHdfsPort(), this.numberGridData, 18436, hdfsPortCB);
        this.createLabel(pp, BaseMessages.getString(PKG, (String)"NamedClusterDialog.Username", (String[])new String[0]), 0);
        Callback hdfsUsernameCB = new Callback(){

            @Override
            public void invoke(NamedCluster nc, TextVar textVar, String value) {
                nc.setHdfsUsername(value);
            }
        };
        this.createTextVar(c, pp, c.getHdfsUsername(), this.gridData, 18436, hdfsUsernameCB);
        this.createLabel(pp, BaseMessages.getString(PKG, (String)"NamedClusterDialog.Password", (String[])new String[0]), 0);
        Callback hdfsPasswordCB = new Callback(){

            @Override
            public void invoke(NamedCluster nc, TextVar textVar, String value) {
                nc.setHdfsPassword(value);
            }
        };
        this.createTextVar(c, pp, c.getHdfsPassword(), this.gridData, 0x404804, hdfsPasswordCB);
    }

    private void createJobTrackerGroup(Composite parentComposite, NamedCluster c) {
        Composite pp = this.createGroup(parentComposite, BaseMessages.getString(PKG, (String)"NamedClusterDialog.JobTracker", (String[])new String[0]));
        this.createLabel(pp, BaseMessages.getString(PKG, (String)"NamedClusterDialog.Hostname", (String[])new String[0]), 0);
        Callback hostCB = new Callback(){

            @Override
            public void invoke(NamedCluster nc, TextVar textVar, String value) {
                nc.setJobTrackerHost(value);
            }
        };
        this.createTextVar(c, pp, c.getJobTrackerHost(), this.gridData, 18436, hostCB);
        this.createLabel(pp, BaseMessages.getString(PKG, (String)"NamedClusterDialog.Port", (String[])new String[0]), 0);
        Callback portCB = new Callback(){

            @Override
            public void invoke(NamedCluster nc, TextVar textVar, String value) {
                nc.setJobTrackerPort(value);
            }
        };
        this.createTextVar(c, pp, c.getJobTrackerPort(), this.numberGridData, 18436, portCB);
    }

    private void createZooKeeperGroup(Composite parentComposite, NamedCluster c) {
        Composite pp = this.createGroup(parentComposite, BaseMessages.getString(PKG, (String)"NamedClusterDialog.ZooKeeper", (String[])new String[0]));
        this.createLabel(pp, BaseMessages.getString(PKG, (String)"NamedClusterDialog.Hostname", (String[])new String[0]), 0);
        Callback hostCB = new Callback(){

            @Override
            public void invoke(NamedCluster nc, TextVar textVar, String value) {
                nc.setZooKeeperHost(value);
            }
        };
        this.createTextVar(c, pp, c.getZooKeeperHost(), this.gridData, 18436, hostCB);
        this.createLabel(pp, BaseMessages.getString(PKG, (String)"NamedClusterDialog.Port", (String[])new String[0]), 0);
        Callback portCB = new Callback(){

            @Override
            public void invoke(NamedCluster nc, TextVar textVar, String value) {
                nc.setZooKeeperPort(value);
            }
        };
        this.createTextVar(c, pp, c.getZooKeeperPort(), this.numberGridData, 18436, portCB);
    }

    private void createOozieGroup(Composite parentComposite, NamedCluster c) {
        Composite pp = this.createGroup(parentComposite, BaseMessages.getString(PKG, (String)"NamedClusterDialog.Oozie", (String[])new String[0]));
        this.createLabel(pp, BaseMessages.getString(PKG, (String)"NamedClusterDialog.URL", (String[])new String[0]), 0);
        Callback hostCB = new Callback(){

            @Override
            public void invoke(NamedCluster nc, TextVar textVar, String value) {
                nc.setOozieUrl(value);
            }
        };
        this.createTextVar(c, pp, c.getOozieUrl(), this.urlGridData, 18436, hostCB);
    }

    private static interface Callback {
        public void invoke(NamedCluster var1, TextVar var2, String var3);
    }
}

