/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.widget;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.gui.GUIResource;

public class StyledTextCompFind
extends Dialog {
    private static Class<?> PKG = StyledTextCompFind.class;
    private Shell sShell = null;
    private Text searchText;
    private StyledText text;
    private String strHeader;
    private Button btnNext;
    private Button btnCancel;
    private Button btnIgnoreCase;
    private Button btnWrapSearch;
    private Button optForward;

    public StyledTextCompFind(Shell parent, StyledText text, String strHeader) {
        super(parent);
        this.text = text;
        this.strHeader = strHeader;
    }

    public void open() {
        String tt;
        Shell parent = this.getParent();
        this.sShell = new Shell(parent, 1116256);
        this.sShell.setImage(GUIResource.getInstance().getImageSpoon());
        this.sShell.setText(this.strHeader);
        this.sShell.setSize(new Point(360, 126));
        FormLayout formLayout = new FormLayout();
        this.sShell.setLayout((Layout)formLayout);
        this.searchText = new Text((Composite)this.sShell, 2052);
        FormData frmData = new FormData();
        frmData.left = new FormAttachment(0, 70);
        frmData.top = new FormAttachment(12, 0);
        frmData.width = 178;
        this.searchText.setLayoutData((Object)frmData);
        Label lblFind = new Label((Composite)this.sShell, 16384);
        lblFind.setText(BaseMessages.getString(PKG, (String)"Widget.Styled.Comp.Find.Title", (String[])new String[0]));
        frmData = new FormData();
        frmData.right = new FormAttachment((Control)this.searchText, -8);
        frmData.top = new FormAttachment(12, 0);
        lblFind.setLayoutData((Object)frmData);
        this.btnNext = new Button((Composite)this.sShell, 8);
        this.btnNext.setText(BaseMessages.getString(PKG, (String)"Widget.Styled.Comp.FindNext", (String[])new String[0]));
        this.btnNext.setEnabled(false);
        frmData = new FormData();
        frmData.left = new FormAttachment((Control)this.searchText, 7);
        frmData.width = 81;
        frmData.height = 23;
        frmData.top = new FormAttachment(9, 0);
        this.btnNext.setLayoutData((Object)frmData);
        this.btnCancel = new Button((Composite)this.sShell, 8);
        this.btnCancel.setText(BaseMessages.getString(PKG, (String)"Widget.Styled.Comp.Close", (String[])new String[0]));
        frmData = new FormData();
        frmData.left = new FormAttachment((Control)this.searchText, 7);
        frmData.width = 81;
        frmData.height = 23;
        frmData.top = new FormAttachment((Control)this.btnNext, 6);
        this.btnCancel.setLayoutData((Object)frmData);
        this.btnIgnoreCase = new Button((Composite)this.sShell, 32);
        this.btnIgnoreCase.setText(BaseMessages.getString(PKG, (String)"Widget.Styled.Comp.CaseSensitive", (String[])new String[0]));
        frmData = new FormData();
        frmData.left = new FormAttachment(5, 0);
        frmData.top = new FormAttachment(54, 0);
        this.btnIgnoreCase.setLayoutData((Object)frmData);
        this.btnWrapSearch = new Button((Composite)this.sShell, 32);
        this.btnWrapSearch.setText(BaseMessages.getString(PKG, (String)"Widget.Styled.Comp.WrapSearch", (String[])new String[0]));
        frmData = new FormData();
        frmData.left = new FormAttachment(5, 0);
        frmData.top = new FormAttachment(70, 0);
        this.btnWrapSearch.setLayoutData((Object)frmData);
        Group grpDir = new Group((Composite)this.sShell, 4);
        grpDir.setText(BaseMessages.getString(PKG, (String)"Widget.Styled.Comp.Direction", (String[])new String[0]));
        this.optForward = new Button((Composite)grpDir, 16);
        this.optForward.setText(BaseMessages.getString(PKG, (String)"Widget.Styled.Comp.Forward", (String[])new String[0]));
        this.optForward.setBounds(5, 15, 75, 15);
        Button optBackward = new Button((Composite)grpDir, 16);
        optBackward.setBounds(5, 33, 75, 15);
        this.optForward.setSelection(true);
        optBackward.setText(BaseMessages.getString(PKG, (String)"Widget.Styled.Comp.Backward", (String[])new String[0]));
        frmData = new FormData();
        frmData.top = new FormAttachment((Control)this.searchText, 8);
        frmData.right = new FormAttachment((Control)this.btnNext, -7);
        frmData.bottom = new FormAttachment(100, -10);
        grpDir.setLayoutData((Object)frmData);
        this.btnNext.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (!StyledTextCompFind.this.findText()) {
                    MessageBox messageBox = new MessageBox(StyledTextCompFind.this.sShell, 34);
                    messageBox.setText(BaseMessages.getString((Class)PKG, (String)"Widget.Styled.Comp.FindItem", (String[])new String[0]));
                    messageBox.setMessage(BaseMessages.getString((Class)PKG, (String)"Widget.Styled.CompReplace.ItemNotFound", (String[])new String[]{StyledTextCompFind.this.searchText.getText()}));
                    messageBox.open();
                }
            }
        });
        this.btnCancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                StyledTextCompFind.this.sShell.dispose();
            }
        });
        this.searchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (StyledTextCompFind.this.searchText.getText() != null && StyledTextCompFind.this.searchText.getText().length() > 0) {
                    StyledTextCompFind.this.btnNext.setEnabled(true);
                } else {
                    StyledTextCompFind.this.btnNext.setEnabled(false);
                }
            }
        });
        if (this.text.getSelectionText() != null && (tt = this.text.getSelectionText()).indexOf(10) < 0) {
            this.searchText.setText(this.text.getSelectionText());
        }
        this.setSearchText();
        this.sShell.open();
        Display display = parent.getDisplay();
        while (!(parent.isDisposed() || this.sShell.isDisposed() || this.text.isDisposed())) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.sShell.dispose();
    }

    private void setSearchText() {
        if (this.text != null && !Const.isEmpty((String)this.text.getSelectionText())) {
            this.searchText.setText(this.text.getSelectionText());
        }
        this.searchText.setFocus();
    }

    private boolean findText() {
        String searchString = this.searchText.getText();
        String textString = this.text.getText();
        int offset = this.text.getCaretOffset();
        int start = -1;
        if (!this.btnIgnoreCase.getSelection()) {
            searchString = searchString.toLowerCase();
            textString = textString.toLowerCase();
        }
        if (this.optForward.getSelection()) {
            start = textString.indexOf(searchString, offset);
            if (start < 0 && this.btnWrapSearch.getSelection()) {
                start = textString.indexOf(searchString, 0);
            }
        } else if (this.text.getSelectionRange().y > searchString.length()) {
            start = textString.lastIndexOf(searchString, offset - 1);
            if (start < 0 && this.btnWrapSearch.getSelection()) {
                start = textString.lastIndexOf(searchString);
            }
        } else {
            start = textString.lastIndexOf(searchString, offset - this.text.getSelectionRange().y - 1);
            if (start < 0 && this.btnWrapSearch.getSelection()) {
                start = textString.lastIndexOf(searchString);
            }
        }
        if (start > -1) {
            this.text.setSelection(start, start + searchString.length());
            return true;
        }
        return false;
    }
}

