/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.dialog;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.ProgressMonitorAdapter;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.KettleRepositoryLostException;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.ui.core.dialog.ErrorDialog;

public class JobLoadProgressDialog {
    private Shell shell;
    private Repository rep;
    private String jobname;
    private RepositoryDirectoryInterface repdir;
    private JobMeta jobInfo;
    private String versionLabel;
    private ObjectId objectId;

    public JobLoadProgressDialog(Shell shell, Repository rep, String jobname, RepositoryDirectoryInterface repdir, String versionLabel) {
        this.shell = shell;
        this.rep = rep;
        this.jobname = jobname;
        this.repdir = repdir;
        this.versionLabel = versionLabel;
        this.jobInfo = null;
    }

    public JobLoadProgressDialog(Shell shell, Repository rep, ObjectId objectId, String versionLabel) {
        this.shell = shell;
        this.rep = rep;
        this.objectId = objectId;
        this.versionLabel = versionLabel;
        this.jobInfo = null;
    }

    public JobMeta open() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    if (JobLoadProgressDialog.this.objectId != null) {
                        JobLoadProgressDialog.this.jobInfo = JobLoadProgressDialog.this.rep.loadJob(JobLoadProgressDialog.this.objectId, JobLoadProgressDialog.this.versionLabel);
                    } else {
                        JobLoadProgressDialog.this.jobInfo = JobLoadProgressDialog.this.rep.loadJob(JobLoadProgressDialog.this.jobname, JobLoadProgressDialog.this.repdir, (ProgressMonitorListener)new ProgressMonitorAdapter(monitor), JobLoadProgressDialog.this.versionLabel);
                    }
                }
                catch (KettleException e) {
                    throw new InvocationTargetException(e, "Error loading job");
                }
            }
        };
        try {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.shell);
            pmd.run(false, false, op);
        }
        catch (InvocationTargetException e) {
            KettleRepositoryLostException krle = KettleRepositoryLostException.lookupStackStrace((Throwable)e);
            if (krle != null) {
                throw krle;
            }
            new ErrorDialog(this.shell, "Error loading job", "An error occured loading the job!", e);
            this.jobInfo = null;
        }
        catch (InterruptedException e) {
            new ErrorDialog(this.shell, "Error loading job", "An error occured loading the job!", e);
            this.jobInfo = null;
        }
        return this.jobInfo;
    }
}

