/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.dialog;

import java.util.regex.Pattern;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryElementMetaInterface;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.ui.core.ConstUI;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.repository.RepositoryDirectoryUI;
import org.pentaho.di.ui.repository.dialog.RepositoryDialogInterface;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class SelectObjectDialog
extends Dialog {
    private static Class<?> PKG = RepositoryDialogInterface.class;
    private Label wlTree;
    private Tree wTree;
    private FormData fdlTree;
    private FormData fdTree;
    private FormData fdexpandAll;
    private Button wOK;
    private Button wCancel;
    private Listener lsOK;
    private Listener lsCancel;
    private Shell shell;
    private SelectionAdapter lsDef;
    private String shellText;
    private String lineText;
    private PropsUI props = PropsUI.getInstance();
    private Color dircolor;
    private Repository rep;
    private String objectName;
    private RepositoryDirectoryInterface objectDirectory;
    private TreeColumn nameColumn;
    private TreeColumn userColumn;
    private TreeColumn changedColumn;
    private int sortColumn;
    private boolean ascending;
    private TreeColumn typeColumn;
    private RepositoryObjectType objectType;
    private boolean showTrans;
    private boolean showJobs;
    private TreeColumn descriptionColumn;
    private ToolItem expandAll;
    private ToolItem collapseAll;
    private ToolItem goSearch;
    private ToolItem wfilter;
    private String filterString = null;
    private Text searchText = null;
    private Pattern pattern = null;
    private RepositoryDirectoryInterface directoryTree;
    private boolean includeDeleted;
    private ToolItem wbRegex;
    private RepositoryElementMetaInterface repositoryObject;
    private ObjectId objectId;

    public SelectObjectDialog(Shell parent, Repository rep) {
        this(parent, rep, true, true);
    }

    public SelectObjectDialog(Shell parent, Repository rep, boolean showTransformations, boolean showJobs) {
        super(parent, 0);
        this.rep = rep;
        this.showTrans = showTransformations;
        this.showJobs = showJobs;
        this.includeDeleted = false;
        this.shellText = BaseMessages.getString(PKG, (String)"SelectObjectDialog.Dialog.Main.Title", (String[])new String[0]);
        this.lineText = BaseMessages.getString(PKG, (String)"SelectObjectDialog.Dialog.Object.Title", (String[])new String[0]);
        this.objectName = null;
        this.objectDirectory = null;
        this.sortColumn = 0;
        this.ascending = false;
    }

    public String open() {
        Shell parent = this.getParent();
        this.dircolor = GUIResource.getInstance().getColorDirectory();
        this.shell = new Shell(parent, 268504304);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageFolderConnections());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(this.shellText);
        int margin = 4;
        ToolBar treeTb = new ToolBar((Composite)this.shell, 0x800100);
        this.wfilter = new ToolItem(treeTb, 2);
        this.searchText = new Text((Composite)treeTb, 384);
        this.searchText.setToolTipText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Search.FilterString.ToolTip", (String[])new String[0]));
        this.wfilter.setControl((Control)this.searchText);
        this.wfilter.setWidth(100);
        this.wbRegex = new ToolItem(treeTb, 32);
        this.wbRegex.setImage(GUIResource.getInstance().getImageRegexSmall());
        this.wbRegex.setToolTipText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Search.UseRegex", (String[])new String[0]));
        this.goSearch = new ToolItem(treeTb, 8);
        this.goSearch.setImage(GUIResource.getInstance().getImageSearchSmall());
        this.goSearch.setToolTipText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Search.Run", (String[])new String[0]));
        this.expandAll = new ToolItem(treeTb, 8);
        this.expandAll.setImage(GUIResource.getInstance().getImageExpandAll());
        this.collapseAll = new ToolItem(treeTb, 8);
        this.collapseAll.setImage(GUIResource.getInstance().getImageCollapseAll());
        this.fdexpandAll = new FormData();
        this.fdexpandAll.right = new FormAttachment(100, -margin);
        this.fdexpandAll.top = new FormAttachment(0, margin);
        treeTb.setLayoutData((Object)this.fdexpandAll);
        this.wlTree = new Label((Composite)this.shell, 0);
        this.wlTree.setText(this.lineText);
        this.props.setLook((Control)this.wlTree);
        this.fdlTree = new FormData();
        this.fdlTree.left = new FormAttachment(0, 0);
        this.fdlTree.top = new FormAttachment(0, margin);
        this.wlTree.setLayoutData((Object)this.fdlTree);
        this.wTree = new Tree((Composite)this.shell, 19204);
        this.wTree.setHeaderVisible(true);
        this.props.setLook((Control)this.wTree);
        this.nameColumn = new TreeColumn(this.wTree, 16384);
        this.nameColumn.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Column.Name", (String[])new String[0]));
        this.nameColumn.setWidth(350);
        this.nameColumn.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SelectObjectDialog.this.setSort(0);
            }
        });
        this.typeColumn = new TreeColumn(this.wTree, 16384);
        this.typeColumn.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Column.Type", (String[])new String[0]));
        this.typeColumn.setWidth(100);
        this.typeColumn.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SelectObjectDialog.this.setSort(1);
            }
        });
        this.userColumn = new TreeColumn(this.wTree, 16384);
        this.userColumn.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Column.User", (String[])new String[0]));
        this.userColumn.setWidth(100);
        this.userColumn.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SelectObjectDialog.this.setSort(2);
            }
        });
        this.changedColumn = new TreeColumn(this.wTree, 16384);
        this.changedColumn.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Column.Changed", (String[])new String[0]));
        this.changedColumn.setWidth(120);
        this.changedColumn.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SelectObjectDialog.this.setSort(3);
            }
        });
        this.descriptionColumn = new TreeColumn(this.wTree, 16384);
        this.descriptionColumn.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Column.Description", (String[])new String[0]));
        this.descriptionColumn.setWidth(120);
        this.descriptionColumn.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SelectObjectDialog.this.setSort(4);
            }
        });
        this.props.setLook((Control)this.wTree);
        this.fdTree = new FormData();
        this.fdTree.left = new FormAttachment(0, 0);
        this.fdTree.right = new FormAttachment(100, 0);
        this.fdTree.top = new FormAttachment((Control)treeTb, margin);
        this.fdTree.bottom = new FormAttachment(100, -30);
        this.wTree.setLayoutData((Object)this.fdTree);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                SelectObjectDialog.this.ok();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wOK.setEnabled(false);
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                SelectObjectDialog.this.cancel();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK, this.wCancel}, margin, null);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SelectObjectDialog.this.ok();
            }
        };
        this.wTree.addSelectionListener((SelectionListener)this.lsDef);
        this.wTree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    SelectObjectDialog.this.ok();
                }
            }
        });
        this.wTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectObjectDialog.this.wOK.setEnabled(!SelectObjectDialog.this.wTree.getSelection()[0].getForeground().equals((Object)SelectObjectDialog.this.dircolor));
            }
        });
        this.expandAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectObjectDialog.this.expandAllItems(SelectObjectDialog.this.wTree.getItems(), true);
            }
        });
        this.collapseAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectObjectDialog.this.expandAllItems(SelectObjectDialog.this.wTree.getItems(), false);
            }
        });
        this.goSearch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectObjectDialog.this.updateFilter();
            }
        });
        this.searchText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SelectObjectDialog.this.updateFilter();
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                SelectObjectDialog.this.cancel();
            }
        });
        try {
            this.directoryTree = this.rep.loadRepositoryDirectoryTree();
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SelectObjectDialog.Dialog.ErrorRefreshingDirectoryTree.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SelectObjectDialog.Dialog.ErrorRefreshingDirectoryTree.Message", (String[])new String[0]), (Exception)((Object)e));
        }
        this.getData();
        this.wTree.setFocus();
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.objectName;
    }

    private void expandAllItems(TreeItem[] treeitems, boolean expand) {
        for (TreeItem item : treeitems) {
            item.setExpanded(expand);
            if (item.getItemCount() <= 0) continue;
            this.expandAllItems(item.getItems(), expand);
        }
    }

    protected void updateFilter() {
        this.pattern = null;
        this.filterString = null;
        if (this.searchText != null && !this.searchText.isDisposed() && !Const.isEmpty((String)this.searchText.getText())) {
            if (this.wbRegex.getSelection()) {
                this.pattern = Pattern.compile(this.searchText.getText());
            } else {
                this.filterString = this.searchText.getText().toUpperCase();
            }
        }
        this.refreshTree();
        if (this.wbRegex.getSelection() && this.pattern != null || !this.wbRegex.getSelection() && this.filterString != null) {
            while (this.getNrEmptyFolders(this.wTree.getItems()) > 0) {
                this.removeEmptyFolders(this.wTree.getItems());
                try {
                    Thread.sleep(0L, 1);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.expandAllItems(this.wTree.getItems(), true);
        }
    }

    private void removeEmptyFolders(TreeItem[] treeitems) {
        for (TreeItem item : treeitems) {
            if (item.getImage().equals((Object)GUIResource.getInstance().getImageArrow()) && item.getItemCount() == 0) {
                item.dispose();
                continue;
            }
            this.removeEmptyFolders(item.getItems());
        }
    }

    private int getNrEmptyFolders(TreeItem[] treeitems) {
        int retval = 0;
        for (TreeItem item : treeitems) {
            if (item.getImage().equals((Object)GUIResource.getInstance().getImageArrow()) && item.getItemCount() == 0) {
                ++retval;
                continue;
            }
            retval += this.getNrEmptyFolders(item.getItems());
        }
        return retval;
    }

    protected void setSort(int i) {
        if (this.sortColumn == i) {
            this.ascending = !this.ascending;
        } else {
            this.sortColumn = i;
            this.ascending = true;
        }
        if (this.sortColumn >= 0 && this.sortColumn < 5) {
            TreeColumn column = this.wTree.getColumn(this.sortColumn);
            this.wTree.setSortColumn(column);
            this.wTree.setSortDirection(this.ascending ? 128 : 1024);
        }
        this.refreshTree();
    }

    private void refreshTree() {
        try {
            this.wTree.removeAll();
            TreeItem ti = null;
            if (this.directoryTree.isRoot() && this.directoryTree.isVisible()) {
                ti = new TreeItem(this.wTree, 0);
                ti.setImage(GUIResource.getInstance().getImageFolderConnections());
                ti.setExpanded(true);
                RepositoryDirectoryUI.getTreeWithNames(ti, this.rep, this.dircolor, this.sortColumn, this.includeDeleted, this.ascending, this.showTrans, this.showJobs, this.directoryTree, this.filterString, this.pattern);
            } else {
                for (int i = 0; i < this.directoryTree.getNrSubdirectories(); ++i) {
                    RepositoryDirectory subdir = this.directoryTree.getSubdirectory(i);
                    ti = new TreeItem(this.wTree, 0);
                    ti.setImage(GUIResource.getInstance().getImageArrow());
                    RepositoryDirectoryUI.getTreeWithNames(ti, this.rep, this.dircolor, this.sortColumn, this.includeDeleted, this.ascending, this.showTrans, this.showJobs, (RepositoryDirectoryInterface)subdir, this.filterString, this.pattern);
                }
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SelectObjectDialog.Dialog.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SelectObjectDialog.Dialog.UnexpectedError.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        this.setSort(0);
    }

    private void cancel() {
        this.objectName = null;
        this.dispose();
    }

    private void ok() {
        int level;
        TreeItem ti;
        if (this.wTree.getSelectionCount() > 0 && !(ti = this.wTree.getSelection()[0]).getForeground().equals((Object)this.dircolor) && (level = ConstUI.getTreeLevel(ti)) > 0) {
            this.repositoryObject = (RepositoryElementMetaInterface)ti.getData();
            if (this.repositoryObject != null) {
                this.objectName = this.repositoryObject.getName();
                this.objectDirectory = this.repositoryObject.getRepositoryDirectory();
                this.objectId = this.repositoryObject.getObjectId();
                this.objectType = this.repositoryObject.getObjectType();
            } else {
                String[] path = ConstUI.getTreeStrings(ti.getParentItem());
                this.objectName = ti.getText(0);
                this.objectType = null;
                for (RepositoryObjectType type : RepositoryObjectType.values()) {
                    if (!type.getTypeDescription().equalsIgnoreCase(ti.getText(1))) continue;
                    this.objectType = type;
                    break;
                }
                this.objectDirectory = this.directoryTree.findDirectory(path);
            }
            if (this.objectDirectory != null) {
                this.dispose();
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"SelectObjectDialog.Dialog.DirectoryNotFound.Message", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"SelectObjectDialog.Dialog.DirectoryNotFound.Title", (String[])new String[0]));
                mb.open();
            }
        }
    }

    public RepositoryDirectoryInterface getDirectory() {
        return this.objectDirectory;
    }

    public RepositoryObjectType getObjectType() {
        return this.objectType;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public RepositoryElementMetaInterface getRepositoryObject() {
        return this.repositoryObject;
    }

    public void setRepositoryObject(RepositoryElementMetaInterface repositoryObject) {
        this.repositoryObject = repositoryObject;
    }

    public ObjectId getObjectId() {
        return this.objectId;
    }

    public void setObjectId(ObjectId objectId) {
        this.objectId = objectId;
    }
}

