/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.filterrows;

import java.util.List;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Condition;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.filterrows.FilterRowsMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ConditionEditor;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class FilterRowsDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = FilterRowsMeta.class;
    private Label wlTrueTo;
    private CCombo wTrueTo;
    private FormData fdlTrueTo;
    private FormData fdTrueTo;
    private Label wlFalseTo;
    private CCombo wFalseTo;
    private FormData fdlFalseTo;
    private FormData fdFalseFrom;
    private Label wlCondition;
    private ConditionEditor wCondition;
    private FormData fdlCondition;
    private FormData fdCondition;
    private FilterRowsMeta input;
    private Condition condition;
    private Condition backupCondition;

    public FilterRowsDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.input = (FilterRowsMeta)in;
        this.condition = (Condition)this.input.getCondition().clone();
    }

    public String open() {
        StepMeta stepMeta;
        int i;
        List nextSteps;
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilterRowsDialog.this.input.setChanged();
            }
        };
        this.backupChanged = this.input.hasChanged();
        this.backupCondition = (Condition)this.condition.clone();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"FilterRowsDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"FilterRowsDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wlTrueTo = new Label((Composite)this.shell, 131072);
        this.wlTrueTo.setText(BaseMessages.getString(PKG, (String)"FilterRowsDialog.SendTrueTo.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTrueTo);
        this.fdlTrueTo = new FormData();
        this.fdlTrueTo.left = new FormAttachment(0, 0);
        this.fdlTrueTo.right = new FormAttachment(middle, -margin);
        this.fdlTrueTo.top = new FormAttachment((Control)this.wStepname, margin);
        this.wlTrueTo.setLayoutData((Object)this.fdlTrueTo);
        this.wTrueTo = new CCombo((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTrueTo);
        StepMeta stepinfo = this.transMeta.findStep(this.stepname);
        if (stepinfo != null) {
            nextSteps = this.transMeta.findNextSteps(stepinfo);
            for (i = 0; i < nextSteps.size(); ++i) {
                stepMeta = (StepMeta)nextSteps.get(i);
                this.wTrueTo.add(stepMeta.getName());
            }
        }
        this.wTrueTo.addModifyListener(lsMod);
        this.fdTrueTo = new FormData();
        this.fdTrueTo.left = new FormAttachment(middle, 0);
        this.fdTrueTo.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdTrueTo.right = new FormAttachment(100, 0);
        this.wTrueTo.setLayoutData((Object)this.fdTrueTo);
        this.wlFalseTo = new Label((Composite)this.shell, 131072);
        this.wlFalseTo.setText(BaseMessages.getString(PKG, (String)"FilterRowsDialog.SendFalseTo.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFalseTo);
        this.fdlFalseTo = new FormData();
        this.fdlFalseTo.left = new FormAttachment(0, 0);
        this.fdlFalseTo.right = new FormAttachment(middle, -margin);
        this.fdlFalseTo.top = new FormAttachment((Control)this.wTrueTo, margin);
        this.wlFalseTo.setLayoutData((Object)this.fdlFalseTo);
        this.wFalseTo = new CCombo((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wFalseTo);
        stepinfo = this.transMeta.findStep(this.stepname);
        if (stepinfo != null) {
            nextSteps = this.transMeta.findNextSteps(stepinfo);
            for (i = 0; i < nextSteps.size(); ++i) {
                stepMeta = (StepMeta)nextSteps.get(i);
                this.wFalseTo.add(stepMeta.getName());
            }
        }
        this.wFalseTo.addModifyListener(lsMod);
        this.fdFalseFrom = new FormData();
        this.fdFalseFrom.left = new FormAttachment(middle, 0);
        this.fdFalseFrom.top = new FormAttachment((Control)this.wTrueTo, margin);
        this.fdFalseFrom.right = new FormAttachment(100, 0);
        this.wFalseTo.setLayoutData((Object)this.fdFalseFrom);
        this.wlCondition = new Label((Composite)this.shell, 0);
        this.wlCondition.setText(BaseMessages.getString(PKG, (String)"FilterRowsDialog.Condition.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCondition);
        this.fdlCondition = new FormData();
        this.fdlCondition.left = new FormAttachment(0, 0);
        this.fdlCondition.top = new FormAttachment((Control)this.wFalseTo, margin);
        this.wlCondition.setLayoutData((Object)this.fdlCondition);
        RowMetaInterface inputfields = null;
        try {
            inputfields = this.transMeta.getPrevStepFields(this.stepname);
        }
        catch (KettleException ke) {
            inputfields = new RowMeta();
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"FilterRowsDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FilterRowsDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, null);
        this.wCondition = new ConditionEditor((Composite)this.shell, 2048, this.condition, inputfields);
        this.fdCondition = new FormData();
        this.fdCondition.left = new FormAttachment(0, 0);
        this.fdCondition.top = new FormAttachment((Control)this.wlCondition, margin);
        this.fdCondition.right = new FormAttachment(100, 0);
        this.fdCondition.bottom = new FormAttachment((Control)this.wOK, -2 * margin);
        this.wCondition.setLayoutData(this.fdCondition);
        this.wCondition.addModifyListener(lsMod);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                FilterRowsDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                FilterRowsDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                FilterRowsDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                FilterRowsDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.input.setChanged(this.backupChanged);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void getData() {
        List targetStreams = this.input.getStepIOMeta().getTargetStreams();
        this.wTrueTo.setText(Const.NVL((String)((StreamInterface)targetStreams.get(0)).getStepname(), (String)""));
        this.wFalseTo.setText(Const.NVL((String)((StreamInterface)targetStreams.get(1)).getStepname(), (String)""));
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.backupChanged);
        this.input.setCondition(this.backupCondition);
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        if (this.wCondition.getLevel() > 0) {
            this.wCondition.goUp();
        } else {
            String falseStepname;
            String trueStepname = this.wTrueTo.getText();
            if (trueStepname.length() == 0) {
                trueStepname = null;
            }
            if ((falseStepname = this.wFalseTo.getText()).length() == 0) {
                falseStepname = null;
            }
            List targetStreams = this.input.getStepIOMeta().getTargetStreams();
            ((StreamInterface)targetStreams.get(0)).setStepMeta(this.transMeta.findStep(trueStepname));
            ((StreamInterface)targetStreams.get(1)).setStepMeta(this.transMeta.findStep(falseStepname));
            this.stepname = this.wStepname.getText();
            this.input.setCondition(this.condition);
            this.dispose();
        }
    }
}

