/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.http;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.http.HTTPMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class HTTPDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = HTTPMeta.class;
    private Label wlUrl;
    private TextVar wUrl;
    private FormData fdlUrl;
    private FormData fdUrl;
    private Label wlResult;
    private TextVar wResult;
    private FormData fdlResult;
    private FormData fdResult;
    private Label wlFields;
    private TableView wFields;
    private FormData fdlFields;
    private FormData fdFields;
    private Label wlHeaders;
    private TableView wHeaders;
    private FormData fdlHeaders;
    private FormData fdHeaders;
    private Label wlUrlInField;
    private Button wUrlInField;
    private FormData fdlUrlInField;
    private FormData fdUrlInField;
    private Label wlUrlField;
    private ComboVar wUrlField;
    private FormData fdlUrlField;
    private FormData fdUrlField;
    private ComboVar wEncoding;
    private Button wGet;
    private Button wGetHeaders;
    private Listener lsGet;
    private Listener lsGetHeaders;
    private Label wlHttpLogin;
    private TextVar wHttpLogin;
    private Label wlHttpPassword;
    private TextVar wHttpPassword;
    private Label wlProxyHost;
    private TextVar wProxyHost;
    private Label wlProxyPort;
    private TextVar wProxyPort;
    private CTabFolder wTabFolder;
    private CTabItem wGeneralTab;
    private CTabItem wAdditionalTab;
    private FormData fdTabFolder;
    private Composite wGeneralComp;
    private Composite wAdditionalComp;
    private FormData fdGeneralComp;
    private FormData fdAdditionalComp;
    private Label wlResultCode;
    private TextVar wResultCode;
    private FormData fdlResultCode;
    private FormData fdResultCode;
    private Label wlResponseTime;
    private TextVar wResponseTime;
    private FormData fdlResponseTime;
    private FormData fdResponseTime;
    private HTTPMeta input;
    private ColumnInfo[] colinf;
    private ColumnInfo[] colinfHeaders;
    private Map<String, Integer> inputFields;
    private boolean gotEncodings = false;
    private Label wlConnectionTimeOut;
    private TextVar wConnectionTimeOut;
    private Label wlSocketTimeOut;
    private TextVar wSocketTimeOut;
    private Label wlCloseIdleConnectionsTime;
    private TextVar wCloseIdleConnectionsTime;

    public HTTPDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (HTTPMeta)in;
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HTTPDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        Object lastControl = this.wStepname;
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wGeneralTab = new CTabItem(this.wTabFolder, 0);
        this.wGeneralTab.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.GeneralTab.Title", (String[])new String[0]));
        this.wGeneralComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wGeneralComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        this.wGeneralComp.setLayout((Layout)fileLayout);
        Group gSettings = new Group(this.wGeneralComp, 16);
        gSettings.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.SettingsGroup.Label", (String[])new String[0]));
        FormLayout SettingsLayout = new FormLayout();
        SettingsLayout.marginWidth = 3;
        SettingsLayout.marginHeight = 3;
        gSettings.setLayout((Layout)SettingsLayout);
        this.props.setLook((Control)gSettings);
        this.wlUrl = new Label((Composite)gSettings, 131072);
        this.wlUrl.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.URL.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlUrl);
        this.fdlUrl = new FormData();
        this.fdlUrl.left = new FormAttachment(0, 0);
        this.fdlUrl.right = new FormAttachment(middle, -margin);
        this.fdlUrl.top = new FormAttachment((Control)lastControl, margin);
        this.wlUrl.setLayoutData((Object)this.fdlUrl);
        this.wUrl = new TextVar((VariableSpace)this.transMeta, (Composite)gSettings, 18436);
        this.props.setLook((Control)this.wUrl);
        this.wUrl.addModifyListener(lsMod);
        this.fdUrl = new FormData();
        this.fdUrl.left = new FormAttachment(middle, 0);
        this.fdUrl.top = new FormAttachment((Control)lastControl, margin);
        this.fdUrl.right = new FormAttachment(100, 0);
        this.wUrl.setLayoutData(this.fdUrl);
        lastControl = this.wUrl;
        this.wlUrlInField = new Label((Composite)gSettings, 131072);
        this.wlUrlInField.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.UrlInField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlUrlInField);
        this.fdlUrlInField = new FormData();
        this.fdlUrlInField.left = new FormAttachment(0, 0);
        this.fdlUrlInField.top = new FormAttachment((Control)lastControl, margin);
        this.fdlUrlInField.right = new FormAttachment(middle, -margin);
        this.wlUrlInField.setLayoutData((Object)this.fdlUrlInField);
        this.wUrlInField = new Button((Composite)gSettings, 32);
        this.props.setLook((Control)this.wUrlInField);
        this.fdUrlInField = new FormData();
        this.fdUrlInField.left = new FormAttachment(middle, 0);
        this.fdUrlInField.top = new FormAttachment((Control)lastControl, margin);
        this.fdUrlInField.right = new FormAttachment(100, 0);
        this.wUrlInField.setLayoutData((Object)this.fdUrlInField);
        this.wUrlInField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HTTPDialog.this.input.setChanged();
                HTTPDialog.this.activeUrlInfield();
            }
        });
        lastControl = this.wUrlInField;
        this.wlUrlField = new Label((Composite)gSettings, 131072);
        this.wlUrlField.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.UrlField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlUrlField);
        this.fdlUrlField = new FormData();
        this.fdlUrlField.left = new FormAttachment(0, 0);
        this.fdlUrlField.right = new FormAttachment(middle, -margin);
        this.fdlUrlField.top = new FormAttachment((Control)lastControl, margin);
        this.wlUrlField.setLayoutData((Object)this.fdlUrlField);
        this.wUrlField = new ComboVar((VariableSpace)this.transMeta, (Composite)gSettings, 18436);
        this.wUrlField.setToolTipText(BaseMessages.getString(PKG, (String)"HTTPDialog.UrlField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wUrlField);
        this.wUrlField.addModifyListener(lsMod);
        this.fdUrlField = new FormData();
        this.fdUrlField.left = new FormAttachment(middle, 0);
        this.fdUrlField.top = new FormAttachment((Control)lastControl, margin);
        this.fdUrlField.right = new FormAttachment(100, 0);
        this.wUrlField.setLayoutData(this.fdUrlField);
        this.wUrlField.setEnabled(false);
        this.wUrlField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)HTTPDialog.this.shell.getDisplay(), 1);
                HTTPDialog.this.shell.setCursor(busy);
                BaseStepDialog.getFieldsFromPrevious(HTTPDialog.this.wUrlField, HTTPDialog.this.transMeta, HTTPDialog.this.stepMeta);
                HTTPDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        lastControl = this.wUrlField;
        Label wlEncoding = new Label((Composite)gSettings, 131072);
        wlEncoding.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.Encoding.Label", (String[])new String[0]));
        this.props.setLook((Control)wlEncoding);
        FormData fdlEncoding = new FormData();
        fdlEncoding.top = new FormAttachment((Control)lastControl, margin);
        fdlEncoding.left = new FormAttachment(0, 0);
        fdlEncoding.right = new FormAttachment(middle, -margin);
        wlEncoding.setLayoutData((Object)fdlEncoding);
        this.wEncoding = new ComboVar((VariableSpace)this.transMeta, (Composite)gSettings, 18436);
        this.props.setLook((Control)this.wEncoding);
        this.wEncoding.addModifyListener(lsMod);
        FormData fdEncoding = new FormData();
        fdEncoding.top = new FormAttachment((Control)lastControl, margin);
        fdEncoding.left = new FormAttachment(middle, 0);
        fdEncoding.right = new FormAttachment(100, 0);
        this.wEncoding.setLayoutData(fdEncoding);
        lastControl = this.wEncoding;
        this.wEncoding.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)HTTPDialog.this.shell.getDisplay(), 1);
                HTTPDialog.this.shell.setCursor(busy);
                HTTPDialog.this.setEncodings();
                HTTPDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.wlConnectionTimeOut = new Label((Composite)gSettings, 131072);
        this.wlConnectionTimeOut.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.ConnectionTimeOut.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlConnectionTimeOut);
        FormData fdlConnectionTimeOut = new FormData();
        fdlConnectionTimeOut.top = new FormAttachment((Control)this.wEncoding, margin);
        fdlConnectionTimeOut.left = new FormAttachment(0, 0);
        fdlConnectionTimeOut.right = new FormAttachment(middle, -margin);
        this.wlConnectionTimeOut.setLayoutData((Object)fdlConnectionTimeOut);
        this.wConnectionTimeOut = new TextVar((VariableSpace)this.transMeta, (Composite)gSettings, 18436);
        this.wConnectionTimeOut.addModifyListener(lsMod);
        this.wConnectionTimeOut.setToolTipText(BaseMessages.getString(PKG, (String)"HTTPDialog.ConnectionTimeOut.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wConnectionTimeOut);
        FormData fdConnectionTimeOut = new FormData();
        fdConnectionTimeOut.top = new FormAttachment((Control)this.wEncoding, margin);
        fdConnectionTimeOut.left = new FormAttachment(middle, 0);
        fdConnectionTimeOut.right = new FormAttachment(100, 0);
        this.wConnectionTimeOut.setLayoutData(fdConnectionTimeOut);
        this.wlSocketTimeOut = new Label((Composite)gSettings, 131072);
        this.wlSocketTimeOut.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.SocketTimeOut.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSocketTimeOut);
        FormData fdlSocketTimeOut = new FormData();
        fdlSocketTimeOut.top = new FormAttachment((Control)this.wConnectionTimeOut, margin);
        fdlSocketTimeOut.left = new FormAttachment(0, 0);
        fdlSocketTimeOut.right = new FormAttachment(middle, -margin);
        this.wlSocketTimeOut.setLayoutData((Object)fdlSocketTimeOut);
        this.wSocketTimeOut = new TextVar((VariableSpace)this.transMeta, (Composite)gSettings, 18436);
        this.wSocketTimeOut.addModifyListener(lsMod);
        this.wSocketTimeOut.setToolTipText(BaseMessages.getString(PKG, (String)"HTTPDialog.SocketTimeOut.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wSocketTimeOut);
        FormData fdSocketTimeOut = new FormData();
        fdSocketTimeOut.top = new FormAttachment((Control)this.wConnectionTimeOut, margin);
        fdSocketTimeOut.left = new FormAttachment(middle, 0);
        fdSocketTimeOut.right = new FormAttachment(100, 0);
        this.wSocketTimeOut.setLayoutData(fdSocketTimeOut);
        this.wlCloseIdleConnectionsTime = new Label((Composite)gSettings, 131072);
        this.wlCloseIdleConnectionsTime.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.CloseIdleConnectionsTime.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCloseIdleConnectionsTime);
        FormData fdlCloseIdleConnectionsTime = new FormData();
        fdlCloseIdleConnectionsTime.top = new FormAttachment((Control)this.wSocketTimeOut, margin);
        fdlCloseIdleConnectionsTime.left = new FormAttachment(0, 0);
        fdlCloseIdleConnectionsTime.right = new FormAttachment(middle, -margin);
        this.wlCloseIdleConnectionsTime.setLayoutData((Object)fdlCloseIdleConnectionsTime);
        this.wCloseIdleConnectionsTime = new TextVar((VariableSpace)this.transMeta, (Composite)gSettings, 18436);
        this.wCloseIdleConnectionsTime.addModifyListener(lsMod);
        this.wCloseIdleConnectionsTime.setToolTipText(BaseMessages.getString(PKG, (String)"HTTPDialog.CloseIdleConnectionsTime.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wCloseIdleConnectionsTime);
        FormData fdCloseIdleConnectionsTime = new FormData();
        fdCloseIdleConnectionsTime.top = new FormAttachment((Control)this.wSocketTimeOut, margin);
        fdCloseIdleConnectionsTime.left = new FormAttachment(middle, 0);
        fdCloseIdleConnectionsTime.right = new FormAttachment(100, 0);
        this.wCloseIdleConnectionsTime.setLayoutData(fdCloseIdleConnectionsTime);
        FormData fdSettings = new FormData();
        fdSettings.left = new FormAttachment(0, 0);
        fdSettings.right = new FormAttachment(100, 0);
        fdSettings.top = new FormAttachment((Control)lastControl, margin);
        gSettings.setLayoutData((Object)fdSettings);
        lastControl = gSettings;
        Group gOutputFields = new Group(this.wGeneralComp, 16);
        gOutputFields.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.OutputFieldsGroup.Label", (String[])new String[0]));
        FormLayout OutputFieldsLayout = new FormLayout();
        OutputFieldsLayout.marginWidth = 3;
        OutputFieldsLayout.marginHeight = 3;
        gOutputFields.setLayout((Layout)OutputFieldsLayout);
        this.props.setLook((Control)gOutputFields);
        this.wlResult = new Label((Composite)gOutputFields, 131072);
        this.wlResult.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.Result.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlResult);
        this.fdlResult = new FormData();
        this.fdlResult.left = new FormAttachment(0, 0);
        this.fdlResult.right = new FormAttachment(middle, -margin);
        this.fdlResult.top = new FormAttachment((Control)lastControl, margin);
        this.wlResult.setLayoutData((Object)this.fdlResult);
        this.wResult = new TextVar((VariableSpace)this.transMeta, (Composite)gOutputFields, 18436);
        this.props.setLook((Control)this.wResult);
        this.wResult.addModifyListener(lsMod);
        this.fdResult = new FormData();
        this.fdResult.left = new FormAttachment(middle, 0);
        this.fdResult.top = new FormAttachment((Control)lastControl, margin);
        this.fdResult.right = new FormAttachment(100, 0);
        this.wResult.setLayoutData(this.fdResult);
        this.wlResultCode = new Label((Composite)gOutputFields, 131072);
        this.wlResultCode.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.ResultCode.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlResultCode);
        this.fdlResultCode = new FormData();
        this.fdlResultCode.left = new FormAttachment(0, 0);
        this.fdlResultCode.right = new FormAttachment(middle, -margin);
        this.fdlResultCode.top = new FormAttachment((Control)this.wResult, margin);
        this.wlResultCode.setLayoutData((Object)this.fdlResultCode);
        this.wResultCode = new TextVar((VariableSpace)this.transMeta, (Composite)gOutputFields, 18436);
        this.props.setLook((Control)this.wResultCode);
        this.wResultCode.addModifyListener(lsMod);
        this.fdResultCode = new FormData();
        this.fdResultCode.left = new FormAttachment(middle, 0);
        this.fdResultCode.top = new FormAttachment((Control)this.wResult, margin);
        this.fdResultCode.right = new FormAttachment(100, 0);
        this.wResultCode.setLayoutData(this.fdResultCode);
        this.wlResponseTime = new Label((Composite)gOutputFields, 131072);
        this.wlResponseTime.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.ResponseTime.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlResponseTime);
        this.fdlResponseTime = new FormData();
        this.fdlResponseTime.left = new FormAttachment(0, 0);
        this.fdlResponseTime.right = new FormAttachment(middle, -margin);
        this.fdlResponseTime.top = new FormAttachment((Control)this.wResultCode, margin);
        this.wlResponseTime.setLayoutData((Object)this.fdlResponseTime);
        this.wResponseTime = new TextVar((VariableSpace)this.transMeta, (Composite)gOutputFields, 18436);
        this.props.setLook((Control)this.wResponseTime);
        this.wResponseTime.addModifyListener(lsMod);
        this.fdResponseTime = new FormData();
        this.fdResponseTime.left = new FormAttachment(middle, 0);
        this.fdResponseTime.top = new FormAttachment((Control)this.wResultCode, margin);
        this.fdResponseTime.right = new FormAttachment(100, 0);
        this.wResponseTime.setLayoutData(this.fdResponseTime);
        FormData fdOutputFields = new FormData();
        fdOutputFields.left = new FormAttachment(0, 0);
        fdOutputFields.right = new FormAttachment(100, 0);
        fdOutputFields.top = new FormAttachment((Control)lastControl, margin);
        gOutputFields.setLayoutData((Object)fdOutputFields);
        lastControl = gOutputFields;
        Group gHttpAuth = new Group(this.wGeneralComp, 16);
        gHttpAuth.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.HttpAuthGroup.Label", (String[])new String[0]));
        FormLayout httpAuthLayout = new FormLayout();
        httpAuthLayout.marginWidth = 3;
        httpAuthLayout.marginHeight = 3;
        gHttpAuth.setLayout((Layout)httpAuthLayout);
        this.props.setLook((Control)gHttpAuth);
        this.wlHttpLogin = new Label((Composite)gHttpAuth, 131072);
        this.wlHttpLogin.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.HttpLogin.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlHttpLogin);
        FormData fdlHttpLogin = new FormData();
        fdlHttpLogin.top = new FormAttachment(0, margin);
        fdlHttpLogin.left = new FormAttachment(0, 0);
        fdlHttpLogin.right = new FormAttachment(middle, -margin);
        this.wlHttpLogin.setLayoutData((Object)fdlHttpLogin);
        this.wHttpLogin = new TextVar((VariableSpace)this.transMeta, (Composite)gHttpAuth, 18436);
        this.wHttpLogin.addModifyListener(lsMod);
        this.wHttpLogin.setToolTipText(BaseMessages.getString(PKG, (String)"HTTPDialog.HttpLogin.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wHttpLogin);
        FormData fdHttpLogin = new FormData();
        fdHttpLogin.top = new FormAttachment(0, margin);
        fdHttpLogin.left = new FormAttachment(middle, 0);
        fdHttpLogin.right = new FormAttachment(100, 0);
        this.wHttpLogin.setLayoutData(fdHttpLogin);
        this.wlHttpPassword = new Label((Composite)gHttpAuth, 131072);
        this.wlHttpPassword.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.HttpPassword.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlHttpPassword);
        FormData fdlHttpPassword = new FormData();
        fdlHttpPassword.top = new FormAttachment((Control)this.wHttpLogin, margin);
        fdlHttpPassword.left = new FormAttachment(0, 0);
        fdlHttpPassword.right = new FormAttachment(middle, -margin);
        this.wlHttpPassword.setLayoutData((Object)fdlHttpPassword);
        this.wHttpPassword = new TextVar((VariableSpace)this.transMeta, (Composite)gHttpAuth, 18436);
        this.wHttpPassword.addModifyListener(lsMod);
        this.wHttpPassword.setToolTipText(BaseMessages.getString(PKG, (String)"HTTPDialog.HttpPassword.Tooltip", (String[])new String[0]));
        this.wHttpPassword.setEchoChar('*');
        this.props.setLook((Control)this.wHttpPassword);
        FormData fdHttpPassword = new FormData();
        fdHttpPassword.top = new FormAttachment((Control)this.wHttpLogin, margin);
        fdHttpPassword.left = new FormAttachment(middle, 0);
        fdHttpPassword.right = new FormAttachment(100, 0);
        this.wHttpPassword.setLayoutData(fdHttpPassword);
        FormData fdHttpAuth = new FormData();
        fdHttpAuth.left = new FormAttachment(0, 0);
        fdHttpAuth.right = new FormAttachment(100, 0);
        fdHttpAuth.top = new FormAttachment((Control)lastControl, margin);
        gHttpAuth.setLayoutData((Object)fdHttpAuth);
        lastControl = gHttpAuth;
        Group gProxy = new Group(this.wGeneralComp, 16);
        gProxy.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.ProxyGroup.Label", (String[])new String[0]));
        FormLayout proxyLayout = new FormLayout();
        proxyLayout.marginWidth = 3;
        proxyLayout.marginHeight = 3;
        gProxy.setLayout((Layout)proxyLayout);
        this.props.setLook((Control)gProxy);
        this.wlProxyHost = new Label((Composite)gProxy, 131072);
        this.wlProxyHost.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.ProxyHost.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlProxyHost);
        FormData fdlProxyHost = new FormData();
        fdlProxyHost.top = new FormAttachment(0, margin);
        fdlProxyHost.left = new FormAttachment(0, 0);
        fdlProxyHost.right = new FormAttachment(middle, -margin);
        this.wlProxyHost.setLayoutData((Object)fdlProxyHost);
        this.wProxyHost = new TextVar((VariableSpace)this.transMeta, (Composite)gProxy, 18436);
        this.wProxyHost.addModifyListener(lsMod);
        this.wProxyHost.setToolTipText(BaseMessages.getString(PKG, (String)"HTTPDialog.ProxyHost.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wProxyHost);
        FormData fdProxyHost = new FormData();
        fdProxyHost.top = new FormAttachment(0, margin);
        fdProxyHost.left = new FormAttachment(middle, 0);
        fdProxyHost.right = new FormAttachment(100, 0);
        this.wProxyHost.setLayoutData(fdProxyHost);
        this.wlProxyPort = new Label((Composite)gProxy, 131072);
        this.wlProxyPort.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.ProxyPort.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlProxyPort);
        FormData fdlProxyPort = new FormData();
        fdlProxyPort.top = new FormAttachment((Control)this.wProxyHost, margin);
        fdlProxyPort.left = new FormAttachment(0, 0);
        fdlProxyPort.right = new FormAttachment(middle, -margin);
        this.wlProxyPort.setLayoutData((Object)fdlProxyPort);
        this.wProxyPort = new TextVar((VariableSpace)this.transMeta, (Composite)gProxy, 18436);
        this.wProxyPort.addModifyListener(lsMod);
        this.wProxyPort.setToolTipText(BaseMessages.getString(PKG, (String)"HTTPDialog.ProxyPort.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wProxyPort);
        FormData fdProxyPort = new FormData();
        fdProxyPort.top = new FormAttachment((Control)this.wProxyHost, margin);
        fdProxyPort.left = new FormAttachment(middle, 0);
        fdProxyPort.right = new FormAttachment(100, 0);
        this.wProxyPort.setLayoutData(fdProxyPort);
        FormData fdProxy = new FormData();
        fdProxy.left = new FormAttachment(0, 0);
        fdProxy.right = new FormAttachment(100, 0);
        fdProxy.top = new FormAttachment((Control)lastControl, margin);
        gProxy.setLayoutData((Object)fdProxy);
        lastControl = gProxy;
        this.fdGeneralComp = new FormData();
        this.fdGeneralComp.left = new FormAttachment(0, 0);
        this.fdGeneralComp.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdGeneralComp.right = new FormAttachment(100, 0);
        this.fdGeneralComp.bottom = new FormAttachment(100, 0);
        this.wGeneralComp.setLayoutData((Object)this.fdGeneralComp);
        this.wGeneralComp.layout();
        this.wGeneralTab.setControl((Control)this.wGeneralComp);
        this.wAdditionalTab = new CTabItem(this.wTabFolder, 0);
        this.wAdditionalTab.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.FieldsTab.Title", (String[])new String[0]));
        FormLayout addLayout = new FormLayout();
        addLayout.marginWidth = 5;
        addLayout.marginHeight = 5;
        this.wAdditionalComp = new Composite((Composite)this.wTabFolder, 0);
        this.wAdditionalComp.setLayout((Layout)addLayout);
        this.props.setLook((Control)this.wAdditionalComp);
        this.wlFields = new Label(this.wAdditionalComp, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.Parameters.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFields);
        this.fdlFields = new FormData();
        this.fdlFields.left = new FormAttachment(0, 0);
        this.fdlFields.top = new FormAttachment((Control)lastControl, margin);
        this.wlFields.setLayoutData((Object)this.fdlFields);
        lastControl = this.wlFields;
        this.wGet = new Button(this.wAdditionalComp, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.GetFields.Button", (String[])new String[0]));
        FormData fdGet = new FormData();
        fdGet.top = new FormAttachment((Control)this.wlFields, margin);
        fdGet.right = new FormAttachment(100, 0);
        this.wGet.setLayoutData((Object)fdGet);
        int FieldsRows = this.input.getArgumentField().length;
        this.colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"HTTPDialog.ColumnInfo.Name", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"HTTPDialog.ColumnInfo.Parameter", (String[])new String[0]), 1, false)};
        this.wFields = new TableView((VariableSpace)this.transMeta, this.wAdditionalComp, 67586, this.colinf, FieldsRows, lsMod, this.props);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        this.fdFields.right = new FormAttachment((Control)this.wGet, -margin);
        this.fdFields.bottom = new FormAttachment((Control)this.wlFields, 200);
        this.wFields.setLayoutData(this.fdFields);
        this.wlHeaders = new Label(this.wAdditionalComp, 0);
        this.wlHeaders.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.Headers.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlHeaders);
        this.fdlHeaders = new FormData();
        this.fdlHeaders.left = new FormAttachment(0, 0);
        this.fdlHeaders.top = new FormAttachment((Control)this.wFields, margin);
        this.wlHeaders.setLayoutData((Object)this.fdlHeaders);
        int HeadersRows = this.input.getHeaderParameter().length;
        this.colinfHeaders = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"HTTPDialog.ColumnInfo.Field", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"HTTPDialog.ColumnInfo.Header", (String[])new String[0]), 1, false)};
        this.colinfHeaders[1].setUsingVariables(true);
        this.wHeaders = new TableView((VariableSpace)this.transMeta, this.wAdditionalComp, 67586, this.colinfHeaders, HeadersRows, lsMod, this.props);
        this.wGetHeaders = new Button(this.wAdditionalComp, 8);
        this.wGetHeaders.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.GetHeaders.Button", (String[])new String[0]));
        FormData fdGetHeaders = new FormData();
        fdGetHeaders.top = new FormAttachment((Control)this.wlHeaders, margin);
        fdGetHeaders.right = new FormAttachment(100, 0);
        this.wGetHeaders.setLayoutData((Object)fdGetHeaders);
        this.fdHeaders = new FormData();
        this.fdHeaders.left = new FormAttachment(0, 0);
        this.fdHeaders.top = new FormAttachment((Control)this.wlHeaders, margin);
        this.fdHeaders.right = new FormAttachment((Control)this.wGetHeaders, -margin);
        this.fdHeaders.bottom = new FormAttachment(100, -margin);
        this.wHeaders.setLayoutData(this.fdHeaders);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StepMeta stepMeta = HTTPDialog.this.transMeta.findStep(HTTPDialog.this.stepname);
                if (stepMeta != null) {
                    try {
                        RowMetaInterface row = HTTPDialog.this.transMeta.getPrevStepFields(stepMeta);
                        for (int i = 0; i < row.size(); ++i) {
                            HTTPDialog.this.inputFields.put(row.getValueMeta(i).getName(), i);
                        }
                        HTTPDialog.this.setComboBoxes();
                    }
                    catch (KettleException e) {
                        HTTPDialog.this.logError(BaseMessages.getString((Class)PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                    }
                }
            }
        };
        new Thread(runnable).start();
        this.fdAdditionalComp = new FormData();
        this.fdAdditionalComp.left = new FormAttachment(0, 0);
        this.fdAdditionalComp.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdAdditionalComp.right = new FormAttachment(100, 0);
        this.fdAdditionalComp.bottom = new FormAttachment(100, 0);
        this.wAdditionalComp.setLayoutData((Object)this.fdAdditionalComp);
        this.wAdditionalComp.layout();
        this.wAdditionalTab.setControl((Control)this.wAdditionalComp);
        this.fdTabFolder = new FormData();
        this.fdTabFolder.left = new FormAttachment(0, 0);
        this.fdTabFolder.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdTabFolder.right = new FormAttachment(100, 0);
        this.fdTabFolder.bottom = new FormAttachment(100, -50);
        this.wTabFolder.setLayoutData((Object)this.fdTabFolder);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, (Control)this.wTabFolder);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                HTTPDialog.this.ok();
            }
        };
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                HTTPDialog.this.get();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                HTTPDialog.this.cancel();
            }
        };
        this.lsGetHeaders = new Listener(){

            public void handleEvent(Event e) {
                HTTPDialog.this.getHeadersFields();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wGet.addListener(13, this.lsGet);
        this.wCancel.addListener(13, this.lsCancel);
        this.wGetHeaders.addListener(13, this.lsGetHeaders);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                HTTPDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wUrl.addSelectionListener(this.lsDef);
        this.wResult.addSelectionListener(this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                HTTPDialog.this.cancel();
            }
        });
        this.lsResize = new Listener(){

            public void handleEvent(Event event) {
                Point size = HTTPDialog.this.shell.getSize();
                HTTPDialog.this.wFields.setSize(size.x - 10, size.y - 50);
                ((HTTPDialog)HTTPDialog.this).wFields.table.setSize(size.x - 10, size.y - 50);
                HTTPDialog.this.wFields.redraw();
            }
        };
        this.shell.addListener(11, this.lsResize);
        this.setSize();
        this.getData();
        this.wTabFolder.setSelection(0);
        this.activeUrlInfield();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void setEncodings() {
        if (!this.gotEncodings) {
            this.gotEncodings = true;
            this.wEncoding.removeAll();
            ArrayList<Charset> values = new ArrayList<Charset>(Charset.availableCharsets().values());
            for (int i = 0; i < values.size(); ++i) {
                Charset charSet = (Charset)values.get(i);
                this.wEncoding.add(charSet.displayName());
            }
            String defEncoding = Const.getEnvironmentVariable((String)"file.encoding", (String)"UTF-8");
            int idx = Const.indexOfString((String)defEncoding, (String[])this.wEncoding.getItems());
            if (idx >= 0) {
                this.wEncoding.select(idx);
            }
        }
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.colinf[0].setComboValues(fieldNames);
        this.colinfHeaders[0].setComboValues(fieldNames);
    }

    private void activeUrlInfield() {
        this.wlUrlField.setEnabled(this.wUrlInField.getSelection());
        this.wUrlField.setEnabled(this.wUrlInField.getSelection());
        this.wlUrl.setEnabled(!this.wUrlInField.getSelection());
        this.wUrl.setEnabled(!this.wUrlInField.getSelection());
    }

    public void getData() {
        TableItem item;
        int i;
        if (this.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"HTTPDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        if (this.input.getArgumentField() != null) {
            for (i = 0; i < this.input.getArgumentField().length; ++i) {
                item = this.wFields.table.getItem(i);
                item.setText(1, Const.NVL((String)this.input.getArgumentField()[i], (String)""));
                item.setText(2, Const.NVL((String)this.input.getArgumentParameter()[i], (String)""));
            }
        }
        if (this.input.getHeaderField() != null) {
            for (i = 0; i < this.input.getHeaderField().length; ++i) {
                item = this.wHeaders.table.getItem(i);
                if (this.input.getHeaderField()[i] != null) {
                    item.setText(1, this.input.getHeaderField()[i]);
                }
                if (this.input.getHeaderParameter()[i] == null) continue;
                item.setText(2, this.input.getHeaderParameter()[i]);
            }
        }
        this.wSocketTimeOut.setText(Const.NVL((String)this.input.getSocketTimeout(), (String)""));
        this.wConnectionTimeOut.setText(Const.NVL((String)this.input.getConnectionTimeout(), (String)""));
        this.wCloseIdleConnectionsTime.setText(Const.NVL((String)this.input.getCloseIdleConnectionsTime(), (String)""));
        this.wUrl.setText(Const.NVL((String)this.input.getUrl(), (String)""));
        this.wUrlInField.setSelection(this.input.isUrlInField());
        this.wUrlField.setText(Const.NVL((String)this.input.getUrlField(), (String)""));
        this.wEncoding.setText(Const.NVL((String)this.input.getEncoding(), (String)""));
        this.wResult.setText(Const.NVL((String)this.input.getFieldName(), (String)""));
        if (this.input.getHttpLogin() != null) {
            this.wHttpLogin.setText(this.input.getHttpLogin());
        }
        if (this.input.getHttpPassword() != null) {
            this.wHttpPassword.setText(this.input.getHttpPassword());
        }
        if (this.input.getProxyHost() != null) {
            this.wProxyHost.setText(this.input.getProxyHost());
        }
        if (this.input.getProxyPort() != null) {
            this.wProxyPort.setText(this.input.getProxyPort());
        }
        if (this.input.getResultCodeFieldName() != null) {
            this.wResultCode.setText(this.input.getResultCodeFieldName());
        }
        if (this.input.getResponseTimeFieldName() != null) {
            this.wResponseTime.setText(this.input.getResponseTimeFieldName());
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wHeaders.setRowNums();
        this.wHeaders.optWidth(true);
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        TableItem item;
        int i;
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        int nrargs = this.wFields.nrNonEmpty();
        int nrheaders = this.wHeaders.nrNonEmpty();
        this.input.allocate(nrargs, nrheaders);
        if (this.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"HTTPDialog.Log.FoundArguments", (String[])new String[]{String.valueOf(nrargs)}));
        }
        for (i = 0; i < nrargs; ++i) {
            item = this.wFields.getNonEmpty(i);
            this.input.getArgumentField()[i] = item.getText(1);
            this.input.getArgumentParameter()[i] = item.getText(2);
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"HTTPDialog.Log.FoundHeaders", (String[])new String[]{String.valueOf(nrheaders)}));
        }
        for (i = 0; i < nrheaders; ++i) {
            item = this.wHeaders.getNonEmpty(i);
            this.input.getHeaderField()[i] = item.getText(1);
            this.input.getHeaderParameter()[i] = item.getText(2);
        }
        this.input.setUrl(this.wUrl.getText());
        this.input.setUrlField(this.wUrlField.getText());
        this.input.setUrlInField(this.wUrlInField.getSelection());
        this.input.setFieldName(this.wResult.getText());
        this.input.setEncoding(this.wEncoding.getText());
        this.input.setHttpLogin(this.wHttpLogin.getText());
        this.input.setHttpPassword(this.wHttpPassword.getText());
        this.input.setProxyHost(this.wProxyHost.getText());
        this.input.setProxyPort(this.wProxyPort.getText());
        this.input.setResultCodeFieldName(this.wResultCode.getText());
        this.input.setResponseTimeFieldName(this.wResponseTime.getText());
        this.input.setSocketTimeout(this.wSocketTimeOut.getText());
        this.input.setConnectionTimeout(this.wConnectionTimeOut.getText());
        this.input.setCloseIdleConnectionsTime(this.wCloseIdleConnectionsTime.getText());
        this.stepname = this.wStepname.getText();
        this.dispose();
    }

    private void get() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null && !r.isEmpty()) {
                BaseStepDialog.getFieldsFromPrevious(r, this.wFields, 1, new int[]{1, 2}, new int[]{3}, -1, -1, null);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"HTTPDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HTTPDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void getHeadersFields() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null && !r.isEmpty()) {
                BaseStepDialog.getFieldsFromPrevious(r, this.wHeaders, 1, new int[]{1, 2}, new int[]{3}, -1, -1, null);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"HTTPDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HTTPDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

