/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.xmlinputsax;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.compatibility.Value;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPreviewFactory;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.xmlinputsax.XMLInputSaxField;
import org.pentaho.di.trans.steps.xmlinputsax.XMLInputSaxFieldPosition;
import org.pentaho.di.trans.steps.xmlinputsax.XMLInputSaxFieldRetriever;
import org.pentaho.di.trans.steps.xmlinputsax.XMLInputSaxMeta;
import org.pentaho.di.ui.core.dialog.EnterNumberDialog;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.dialog.TransPreviewProgressDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class XMLInputSaxDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = XMLInputSaxMeta.class;
    private CTabFolder wTabFolder;
    private FormData fdTabFolder;
    private CTabItem wFileTab;
    private CTabItem wContentTab;
    private CTabItem wFieldsTab;
    private Composite wFileComp;
    private Composite wContentComp;
    private Composite wFieldsComp;
    private FormData fdFileComp;
    private FormData fdContentComp;
    private FormData fdFieldsComp;
    private Label wlFilename;
    private Button wbbFilename;
    private Button wbdFilename;
    private Button wbeFilename;
    private Button wbaFilename;
    private TextVar wFilename;
    private FormData fdlFilename;
    private FormData fdbFilename;
    private FormData fdbdFilename;
    private FormData fdbeFilename;
    private FormData fdbaFilename;
    private FormData fdFilename;
    private Label wlFilenameList;
    private TableView wFilenameList;
    private FormData fdlFilenameList;
    private FormData fdFilenameList;
    private Label wlFilemask;
    private Text wFilemask;
    private FormData fdlFilemask;
    private FormData fdFilemask;
    private Button wbShowFiles;
    private FormData fdbShowFiles;
    private Label wlInclFilename;
    private Button wInclFilename;
    private FormData fdlInclFilename;
    private FormData fdInclFilename;
    private Label wlInclFilenameField;
    private Text wInclFilenameField;
    private FormData fdlInclFilenameField;
    private FormData fdInclFilenameField;
    private Label wlInclRownum;
    private Button wInclRownum;
    private FormData fdlInclRownum;
    private FormData fdRownum;
    private Label wlInclRownumField;
    private Text wInclRownumField;
    private FormData fdlInclRownumField;
    private FormData fdInclRownumField;
    private Label wlLimit;
    private Text wLimit;
    private FormData fdlLimit;
    private FormData fdLimit;
    private Label wlPosition;
    private TableView wPosition;
    private FormData fdlPosition;
    private FormData fdPosition;
    private TableView wFields;
    private FormData fdFields;
    private TableView wAttributes;
    private FormData fdAttributes;
    private XMLInputSaxMeta input;
    private static final String STRING_PREVIEW_ROWS = BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Button.PreviewRows.Label", (String[])new String[0]);
    public static final int[] dateLengths = new int[]{23, 19, 14, 10, 10, 10, 10, 8, 8, 8, 8, 6, 6};

    public XMLInputSaxDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (XMLInputSaxMeta)in;
    }

    public String open() {
        int x;
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XMLInputSaxDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Shell.Text", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.StepName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wFileTab = new CTabItem(this.wTabFolder, 0);
        this.wFileTab.setText(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.File.Label", (String[])new String[0]));
        this.wFileComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wFileComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        this.wFileComp.setLayout((Layout)fileLayout);
        this.wlFilename = new Label(this.wFileComp, 131072);
        this.wlFilename.setText(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.FileOrDirectory.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFilename);
        this.fdlFilename = new FormData();
        this.fdlFilename.left = new FormAttachment(0, 0);
        this.fdlFilename.top = new FormAttachment(0, 0);
        this.fdlFilename.right = new FormAttachment(middle, -margin);
        this.wlFilename.setLayoutData((Object)this.fdlFilename);
        this.wbbFilename = new Button(this.wFileComp, 0x1000008);
        this.props.setLook((Control)this.wbbFilename);
        this.wbbFilename.setText(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.System.Button.Browse", (String[])new String[0]));
        this.wbbFilename.setToolTipText(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Button.Brows.ToolTip", (String[])new String[0]));
        this.fdbFilename = new FormData();
        this.fdbFilename.right = new FormAttachment(100, 0);
        this.fdbFilename.top = new FormAttachment(0, 0);
        this.wbbFilename.setLayoutData((Object)this.fdbFilename);
        this.wbaFilename = new Button(this.wFileComp, 0x1000008);
        this.props.setLook((Control)this.wbaFilename);
        this.wbaFilename.setText(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Button.AddFile.Label", (String[])new String[0]));
        this.wbaFilename.setToolTipText(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Button.AddFile.ToolTip", (String[])new String[0]));
        this.fdbaFilename = new FormData();
        this.fdbaFilename.right = new FormAttachment((Control)this.wbbFilename, -margin);
        this.fdbaFilename.top = new FormAttachment(0, 0);
        this.wbaFilename.setLayoutData((Object)this.fdbaFilename);
        this.wFilename = new TextVar((VariableSpace)this.transMeta, this.wFileComp, 18436);
        this.props.setLook((Control)this.wFilename);
        this.wFilename.addModifyListener(lsMod);
        this.fdFilename = new FormData();
        this.fdFilename.left = new FormAttachment(middle, 0);
        this.fdFilename.right = new FormAttachment((Control)this.wbaFilename, -margin);
        this.fdFilename.top = new FormAttachment(0, 0);
        this.wFilename.setLayoutData(this.fdFilename);
        this.wlFilemask = new Label(this.wFileComp, 131072);
        this.wlFilemask.setText(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.FileMaskRegExp.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFilemask);
        this.fdlFilemask = new FormData();
        this.fdlFilemask.left = new FormAttachment(0, 0);
        this.fdlFilemask.top = new FormAttachment((Control)this.wFilename, margin);
        this.fdlFilemask.right = new FormAttachment(middle, -margin);
        this.wlFilemask.setLayoutData((Object)this.fdlFilemask);
        this.wFilemask = new Text(this.wFileComp, 18436);
        this.props.setLook((Control)this.wFilemask);
        this.wFilemask.addModifyListener(lsMod);
        this.fdFilemask = new FormData();
        this.fdFilemask.left = new FormAttachment(middle, 0);
        this.fdFilemask.top = new FormAttachment((Control)this.wFilename, margin);
        this.fdFilemask.right = new FormAttachment(100, 0);
        this.wFilemask.setLayoutData((Object)this.fdFilemask);
        this.wlFilenameList = new Label(this.wFileComp, 131072);
        this.wlFilenameList.setText(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.SelectedFiles.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFilenameList);
        this.fdlFilenameList = new FormData();
        this.fdlFilenameList.left = new FormAttachment(0, 0);
        this.fdlFilenameList.top = new FormAttachment((Control)this.wFilemask, margin);
        this.fdlFilenameList.right = new FormAttachment(middle, -margin);
        this.wlFilenameList.setLayoutData((Object)this.fdlFilenameList);
        this.wbdFilename = new Button(this.wFileComp, 0x1000008);
        this.props.setLook((Control)this.wbdFilename);
        this.wbdFilename.setText(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Button.DeleteEntry.Label", (String[])new String[0]));
        this.wbdFilename.setToolTipText(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Button.DeleteEntry.ToolTip", (String[])new String[0]));
        this.fdbdFilename = new FormData();
        this.fdbdFilename.right = new FormAttachment(100, 0);
        this.fdbdFilename.top = new FormAttachment((Control)this.wFilemask, 40);
        this.wbdFilename.setLayoutData((Object)this.fdbdFilename);
        this.wbeFilename = new Button(this.wFileComp, 0x1000008);
        this.props.setLook((Control)this.wbeFilename);
        this.wbeFilename.setText(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Button.EditEntry.Label", (String[])new String[0]));
        this.wbeFilename.setToolTipText(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Button.EditEntry.ToolTip", (String[])new String[0]));
        this.fdbeFilename = new FormData();
        this.fdbeFilename.right = new FormAttachment(100, 0);
        this.fdbeFilename.top = new FormAttachment((Control)this.wbdFilename, margin);
        this.wbeFilename.setLayoutData((Object)this.fdbeFilename);
        this.wbShowFiles = new Button(this.wFileComp, 0x1000008);
        this.props.setLook((Control)this.wbShowFiles);
        this.wbShowFiles.setText(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Button.ShowFilenames.Label", (String[])new String[0]));
        this.fdbShowFiles = new FormData();
        this.fdbShowFiles.left = new FormAttachment(middle, 0);
        this.fdbShowFiles.bottom = new FormAttachment(100, 0);
        this.wbShowFiles.setLayoutData((Object)this.fdbShowFiles);
        ColumnInfo[] colinfo = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Column.FileDirectory.Label", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Column.Wildcard.Label", (String[])new String[0]), 1, false)};
        colinfo[0].setUsingVariables(true);
        colinfo[1].setToolTip(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Column.FileDirectory.ToolTip", (String[])new String[0]));
        this.wFilenameList = new TableView((VariableSpace)this.transMeta, this.wFileComp, 67588, colinfo, 2, lsMod, this.props);
        this.props.setLook((Control)this.wFilenameList);
        this.fdFilenameList = new FormData();
        this.fdFilenameList.left = new FormAttachment(middle, 0);
        this.fdFilenameList.right = new FormAttachment((Control)this.wbdFilename, -margin);
        this.fdFilenameList.top = new FormAttachment((Control)this.wFilemask, margin);
        this.fdFilenameList.bottom = new FormAttachment((Control)this.wbShowFiles, -margin);
        this.wFilenameList.setLayoutData(this.fdFilenameList);
        this.fdFileComp = new FormData();
        this.fdFileComp.left = new FormAttachment(0, 0);
        this.fdFileComp.top = new FormAttachment(0, 0);
        this.fdFileComp.right = new FormAttachment(100, 0);
        this.fdFileComp.bottom = new FormAttachment(100, 0);
        this.wFileComp.setLayoutData((Object)this.fdFileComp);
        this.wFileComp.layout();
        this.wFileTab.setControl((Control)this.wFileComp);
        this.wContentTab = new CTabItem(this.wTabFolder, 0);
        this.wContentTab.setText(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Tab.Content.Label", (String[])new String[0]));
        FormLayout contentLayout = new FormLayout();
        contentLayout.marginWidth = 3;
        contentLayout.marginHeight = 3;
        this.wContentComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wContentComp);
        this.wContentComp.setLayout((Layout)contentLayout);
        this.wlInclFilename = new Label(this.wContentComp, 131072);
        this.wlInclFilename.setText(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.IncludeFilename.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlInclFilename);
        this.fdlInclFilename = new FormData();
        this.fdlInclFilename.left = new FormAttachment(0, 0);
        this.fdlInclFilename.top = new FormAttachment(0, 0);
        this.fdlInclFilename.right = new FormAttachment(middle, -margin);
        this.wlInclFilename.setLayoutData((Object)this.fdlInclFilename);
        this.wInclFilename = new Button(this.wContentComp, 32);
        this.props.setLook((Control)this.wInclFilename);
        this.wInclFilename.setToolTipText(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.IncludeFilename.ToolTip", (String[])new String[0]));
        this.fdInclFilename = new FormData();
        this.fdInclFilename.left = new FormAttachment(middle, 0);
        this.fdInclFilename.top = new FormAttachment(0, 0);
        this.wInclFilename.setLayoutData((Object)this.fdInclFilename);
        this.wlInclFilenameField = new Label(this.wContentComp, 16384);
        this.wlInclFilenameField.setText(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.FilenameFieldname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlInclFilenameField);
        this.fdlInclFilenameField = new FormData();
        this.fdlInclFilenameField.left = new FormAttachment((Control)this.wInclFilename, margin);
        this.fdlInclFilenameField.top = new FormAttachment(0, 0);
        this.wlInclFilenameField.setLayoutData((Object)this.fdlInclFilenameField);
        this.wInclFilenameField = new Text(this.wContentComp, 18436);
        this.props.setLook((Control)this.wInclFilenameField);
        this.wInclFilenameField.addModifyListener(lsMod);
        this.fdInclFilenameField = new FormData();
        this.fdInclFilenameField.left = new FormAttachment((Control)this.wlInclFilenameField, margin);
        this.fdInclFilenameField.top = new FormAttachment(0, 0);
        this.fdInclFilenameField.right = new FormAttachment(100, 0);
        this.wInclFilenameField.setLayoutData((Object)this.fdInclFilenameField);
        this.wlInclRownum = new Label(this.wContentComp, 131072);
        this.wlInclRownum.setText(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.RowNumInOutput.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlInclRownum);
        this.fdlInclRownum = new FormData();
        this.fdlInclRownum.left = new FormAttachment(0, 0);
        this.fdlInclRownum.top = new FormAttachment((Control)this.wInclFilenameField, margin);
        this.fdlInclRownum.right = new FormAttachment(middle, -margin);
        this.wlInclRownum.setLayoutData((Object)this.fdlInclRownum);
        this.wInclRownum = new Button(this.wContentComp, 32);
        this.props.setLook((Control)this.wInclRownum);
        this.wInclRownum.setToolTipText(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.RowNumInOutput.ToolTip", (String[])new String[0]));
        this.fdRownum = new FormData();
        this.fdRownum.left = new FormAttachment(middle, 0);
        this.fdRownum.top = new FormAttachment((Control)this.wInclFilenameField, margin);
        this.wInclRownum.setLayoutData((Object)this.fdRownum);
        this.wlInclRownumField = new Label(this.wContentComp, 131072);
        this.wlInclRownumField.setText(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.RowNumInOutputField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlInclRownumField);
        this.fdlInclRownumField = new FormData();
        this.fdlInclRownumField.left = new FormAttachment((Control)this.wInclRownum, margin);
        this.fdlInclRownumField.top = new FormAttachment((Control)this.wInclFilenameField, margin);
        this.wlInclRownumField.setLayoutData((Object)this.fdlInclRownumField);
        this.wInclRownumField = new Text(this.wContentComp, 18436);
        this.props.setLook((Control)this.wInclRownumField);
        this.wInclRownumField.addModifyListener(lsMod);
        this.fdInclRownumField = new FormData();
        this.fdInclRownumField.left = new FormAttachment((Control)this.wlInclRownumField, margin);
        this.fdInclRownumField.top = new FormAttachment((Control)this.wInclFilenameField, margin);
        this.fdInclRownumField.right = new FormAttachment(100, 0);
        this.wInclRownumField.setLayoutData((Object)this.fdInclRownumField);
        this.wlLimit = new Label(this.wContentComp, 131072);
        this.wlLimit.setText(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Limit.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlLimit);
        this.fdlLimit = new FormData();
        this.fdlLimit.left = new FormAttachment(0, 0);
        this.fdlLimit.top = new FormAttachment((Control)this.wInclRownumField, margin);
        this.fdlLimit.right = new FormAttachment(middle, -margin);
        this.wlLimit.setLayoutData((Object)this.fdlLimit);
        this.wLimit = new Text(this.wContentComp, 18436);
        this.props.setLook((Control)this.wLimit);
        this.wLimit.addModifyListener(lsMod);
        this.fdLimit = new FormData();
        this.fdLimit.left = new FormAttachment(middle, 0);
        this.fdLimit.top = new FormAttachment((Control)this.wInclRownumField, margin);
        this.fdLimit.right = new FormAttachment(100, 0);
        this.wLimit.setLayoutData((Object)this.fdLimit);
        String positionHelp = BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Location.ToolTip", (String[])new String[0]);
        this.wlPosition = new Label(this.wContentComp, 131072);
        this.wlPosition.setText(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Location.Label", (String[])new String[0]));
        this.wlPosition.setToolTipText(positionHelp);
        this.props.setLook((Control)this.wlPosition);
        this.fdlPosition = new FormData();
        this.fdlPosition.left = new FormAttachment(0, 0);
        this.fdlPosition.top = new FormAttachment((Control)this.wLimit, margin);
        this.fdlPosition.right = new FormAttachment(middle, -margin);
        this.wlPosition.setLayoutData((Object)this.fdlPosition);
        ColumnInfo[] locationColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Column.Elements.Label", (String[])new String[0]), 1, false)};
        locationColumns[0].setToolTip(positionHelp);
        int nrElements = this.input.getInputPosition() != null ? this.input.getInputPosition().length : 0;
        this.wPosition = new TableView((VariableSpace)this.transMeta, this.wContentComp, 65538, locationColumns, nrElements, lsMod, this.props);
        this.wPosition.addModifyListener(lsMod);
        this.fdPosition = new FormData();
        this.fdPosition.left = new FormAttachment(middle, 0);
        this.fdPosition.top = new FormAttachment((Control)this.wLimit, margin);
        this.fdPosition.bottom = new FormAttachment(100, -50);
        this.fdPosition.right = new FormAttachment(100, 0);
        this.wPosition.setLayoutData(this.fdPosition);
        this.wPosition.setToolTipText(positionHelp);
        this.fdContentComp = new FormData();
        this.fdContentComp.left = new FormAttachment(0, 0);
        this.fdContentComp.top = new FormAttachment(0, 0);
        this.fdContentComp.right = new FormAttachment(100, 0);
        this.fdContentComp.bottom = new FormAttachment(100, 0);
        this.wContentComp.setLayoutData((Object)this.fdContentComp);
        this.wContentComp.layout();
        this.wContentTab.setControl((Control)this.wContentComp);
        this.wFieldsTab = new CTabItem(this.wTabFolder, 0);
        this.wFieldsTab.setText(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Tab.Fields.Label", (String[])new String[0]));
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = 5;
        fieldsLayout.marginHeight = 5;
        this.wFieldsComp = new Composite((Composite)this.wTabFolder, 0);
        this.wFieldsComp.setLayout((Layout)fieldsLayout);
        this.props.setLook((Control)this.wFieldsComp);
        this.wGet = new Button(this.wFieldsComp, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Button.GetFields.Label", (String[])new String[0]));
        this.fdGet = new FormData();
        this.fdGet.left = new FormAttachment(50, 0);
        this.fdGet.bottom = new FormAttachment(100, 0);
        this.wGet.setLayoutData((Object)this.fdGet);
        int FieldsRows = this.input.getInputFields().length;
        String[] dats = Const.getDateFormats();
        String[] nums = Const.getNumberFormats();
        int totsize = dats.length + nums.length;
        String[] formats = new String[totsize];
        for (x = 0; x < dats.length; ++x) {
            formats[x] = dats[x];
        }
        for (x = 0; x < nums.length; ++x) {
            formats[dats.length + x] = nums[x];
        }
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Column.Name.Label", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Column.Type.Label", (String[])new String[0]), 2, Value.getTypes(), true), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Column.Format.Label", (String[])new String[0]), 2, formats), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Column.Length.Label", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Column.Precision.Label", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Column.Currency.Label", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Column.Decimal.Label", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Column.Group.Label", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Column.TrimType.Label", (String[])new String[0]), 2, XMLInputSaxField.trimTypeDesc, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Column.Repeat.Label", (String[])new String[0]), 2, new String[]{"Y", "N"}, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Column.Position.Label", (String[])new String[0]), 1, false)};
        this.wFields = new TableView((VariableSpace)this.transMeta, this.wFieldsComp, 65538, colinf, FieldsRows, lsMod, this.props);
        int AttributesRows = this.input.getDefinitionLength();
        ColumnInfo[] colinfatt = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Column.Element.Label", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Column.DefiningAttribute.Label", (String[])new String[0]), 1, false)};
        this.wAttributes = new TableView((VariableSpace)this.transMeta, this.wFieldsComp, 65538, colinfatt, AttributesRows, lsMod, this.props);
        this.fdAttributes = new FormData();
        this.fdAttributes.left = new FormAttachment(0, 0);
        this.fdAttributes.top = new FormAttachment(0, 0);
        this.fdAttributes.right = new FormAttachment(100, 0);
        this.fdAttributes.bottom = new FormAttachment(15, 0);
        this.wAttributes.setLayoutData(this.fdAttributes);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment((Control)this.wAttributes, margin * 3);
        this.fdFields.right = new FormAttachment(100, 0);
        this.fdFields.bottom = new FormAttachment((Control)this.wGet, -margin);
        this.wFields.setLayoutData(this.fdFields);
        this.fdFieldsComp = new FormData();
        this.fdFieldsComp.left = new FormAttachment(0, 0);
        this.fdFieldsComp.top = new FormAttachment(0, 0);
        this.fdFieldsComp.right = new FormAttachment(100, 0);
        this.fdFieldsComp.bottom = new FormAttachment(110, 0);
        this.wFieldsComp.setLayoutData((Object)this.fdFieldsComp);
        this.wFieldsComp.layout();
        this.wFieldsTab.setControl((Control)this.wFieldsComp);
        this.fdTabFolder = new FormData();
        this.fdTabFolder.left = new FormAttachment(0, 0);
        this.fdTabFolder.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdTabFolder.right = new FormAttachment(100, 0);
        this.fdTabFolder.bottom = new FormAttachment(100, -50);
        this.wTabFolder.setLayoutData((Object)this.fdTabFolder);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(STRING_PREVIEW_ROWS);
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wPreview, this.wCancel}, margin, (Control)this.wTabFolder);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                XMLInputSaxDialog.this.ok();
            }
        };
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                XMLInputSaxDialog.this.get();
            }
        };
        this.lsPreview = new Listener(){

            public void handleEvent(Event e) {
                XMLInputSaxDialog.this.preview();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                XMLInputSaxDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wGet.addListener(13, this.lsGet);
        this.wPreview.addListener(13, this.lsPreview);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                XMLInputSaxDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wLimit.addSelectionListener((SelectionListener)this.lsDef);
        this.wInclRownumField.addSelectionListener((SelectionListener)this.lsDef);
        this.wInclFilenameField.addSelectionListener((SelectionListener)this.lsDef);
        SelectionAdapter selA = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                XMLInputSaxDialog.this.wFilenameList.add(XMLInputSaxDialog.this.wFilename.getText(), XMLInputSaxDialog.this.wFilemask.getText());
                XMLInputSaxDialog.this.wFilename.setText("");
                XMLInputSaxDialog.this.wFilemask.setText("");
                XMLInputSaxDialog.this.wFilenameList.removeEmptyRows();
                XMLInputSaxDialog.this.wFilenameList.setRowNums();
                XMLInputSaxDialog.this.wFilenameList.optWidth(true);
            }
        };
        this.wbaFilename.addSelectionListener((SelectionListener)selA);
        this.wFilename.addSelectionListener(selA);
        this.wbdFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int[] idx = XMLInputSaxDialog.this.wFilenameList.getSelectionIndices();
                XMLInputSaxDialog.this.wFilenameList.remove(idx);
                XMLInputSaxDialog.this.wFilenameList.removeEmptyRows();
                XMLInputSaxDialog.this.wFilenameList.setRowNums();
            }
        });
        this.wbeFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int idx = XMLInputSaxDialog.this.wFilenameList.getSelectionIndex();
                if (idx >= 0) {
                    String[] string = XMLInputSaxDialog.this.wFilenameList.getItem(idx);
                    XMLInputSaxDialog.this.wFilename.setText(string[0]);
                    XMLInputSaxDialog.this.wFilemask.setText(string[1]);
                    XMLInputSaxDialog.this.wFilenameList.remove(idx);
                }
                XMLInputSaxDialog.this.wFilenameList.removeEmptyRows();
                XMLInputSaxDialog.this.wFilenameList.setRowNums();
            }
        });
        this.wbShowFiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    XMLInputSaxMeta tfii = new XMLInputSaxMeta();
                    XMLInputSaxDialog.this.getInfo(tfii);
                    String[] files = tfii.getFilePaths((VariableSpace)XMLInputSaxDialog.this.transMeta);
                    if (files != null && files.length > 0) {
                        EnterSelectionDialog esd = new EnterSelectionDialog(XMLInputSaxDialog.this.shell, files, BaseMessages.getString((Class)PKG, (String)"XMLInputSaxDialog.Dialog.FilesRead.Title", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"XMLInputSaxDialog.Dialog.FilesRead.Message", (String[])new String[0]));
                        esd.setViewOnly();
                        esd.open();
                    } else {
                        MessageBox mb = new MessageBox(XMLInputSaxDialog.this.shell, 33);
                        mb.setMessage(BaseMessages.getString((Class)PKG, (String)"XMLInputSaxDialog.Dialog.NoFilesFound.Message", (String[])new String[0]));
                        mb.setText(BaseMessages.getString((Class)PKG, (String)"XMLInputSaxDialog.Dialog.NoFilesFound.Title", (String[])new String[0]));
                        mb.open();
                    }
                }
                catch (KettleException ex) {
                    new ErrorDialog(XMLInputSaxDialog.this.shell, BaseMessages.getString((Class)PKG, (String)"XMLInputSaxDialog.Dialog.ErrorParsingInputData.Title", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"XMLInputSaxDialog.Dialog.ErrorParsingInputData.Message", (String[])new String[0]), (Exception)((Object)ex));
                }
            }
        });
        this.wInclFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLInputSaxDialog.this.setIncludeFilename();
            }
        });
        this.wInclRownum.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLInputSaxDialog.this.setIncludeRownum();
            }
        });
        this.wFilename.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XMLInputSaxDialog.this.wFilename.setToolTipText(XMLInputSaxDialog.this.transMeta.environmentSubstitute(XMLInputSaxDialog.this.wFilename.getText()));
            }
        });
        this.wbbFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (XMLInputSaxDialog.this.wFilemask.getText() != null && XMLInputSaxDialog.this.wFilemask.getText().length() > 0) {
                    DirectoryDialog dialog = new DirectoryDialog(XMLInputSaxDialog.this.shell, 4096);
                    if (XMLInputSaxDialog.this.wFilename.getText() != null) {
                        String fpath = XMLInputSaxDialog.this.transMeta.environmentSubstitute(XMLInputSaxDialog.this.wFilename.getText());
                        dialog.setFilterPath(fpath);
                    }
                    if (dialog.open() != null) {
                        String str = dialog.getFilterPath();
                        XMLInputSaxDialog.this.wFilename.setText(str);
                    }
                } else {
                    FileDialog dialog = new FileDialog(XMLInputSaxDialog.this.shell, 4096);
                    dialog.setFilterExtensions(new String[]{"*.xml;*.XML", "*"});
                    if (XMLInputSaxDialog.this.wFilename.getText() != null) {
                        String fname = XMLInputSaxDialog.this.transMeta.environmentSubstitute(XMLInputSaxDialog.this.wFilename.getText());
                        dialog.setFileName(fname);
                    }
                    dialog.setFilterNames(new String[]{BaseMessages.getString((Class)PKG, (String)"XMLInputSaxDialog.60", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"XMLInputSaxDialog.68", (String[])new String[0])});
                    if (dialog.open() != null) {
                        String str = dialog.getFilterPath() + System.getProperty("file.separator") + dialog.getFileName();
                        XMLInputSaxDialog.this.wFilename.setText(str);
                    }
                }
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                XMLInputSaxDialog.this.cancel();
            }
        });
        this.wTabFolder.setSelection(0);
        this.setSize();
        this.getData(this.input);
        this.input.setChanged(this.changed);
        this.wFields.optWidth(true);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void setMultiple() {
    }

    public void setIncludeFilename() {
        this.wlInclFilenameField.setEnabled(this.wInclFilename.getSelection());
        this.wInclFilenameField.setEnabled(this.wInclFilename.getSelection());
    }

    public void setIncludeRownum() {
        this.wlInclRownumField.setEnabled(this.wInclRownum.getSelection());
        this.wInclRownumField.setEnabled(this.wInclRownum.getSelection());
    }

    public void getData(XMLInputSaxMeta in) {
        TableItem item;
        int i;
        if (in.getFileName() != null) {
            this.wFilenameList.removeAll();
            for (i = 0; i < in.getFileName().length; ++i) {
                this.wFilenameList.add(in.getFileName()[i], in.getFileMask()[i]);
            }
            this.wFilenameList.removeEmptyRows();
            this.wFilenameList.setRowNums();
            this.wFilenameList.optWidth(true);
        }
        this.wInclFilename.setSelection(in.includeFilename());
        this.wInclRownum.setSelection(in.includeRowNumber());
        if (in.getFilenameField() != null) {
            this.wInclFilenameField.setText(in.getFilenameField());
        }
        if (in.getRowNumberField() != null) {
            this.wInclRownumField.setText(in.getRowNumberField());
        }
        this.wLimit.setText("" + in.getRowLimit());
        this.logDebug("getting fields info...");
        for (i = 0; i < in.getInputFields().length; ++i) {
            String rep;
            XMLInputSaxField field = in.getInputFields()[i];
            if (field == null) continue;
            TableItem item2 = this.wFields.table.getItem(i);
            String name = field.getName();
            String type = field.getTypeDesc();
            String format = field.getFormat();
            String length = "" + field.getLength();
            String prec = "" + field.getPrecision();
            String curr = field.getCurrencySymbol();
            String group = field.getGroupSymbol();
            String decim = field.getDecimalSymbol();
            String trim = field.getTrimTypeDesc();
            String string = rep = field.isRepeated() ? "Y" : "N";
            if (name != null) {
                item2.setText(1, name);
            }
            if (type != null) {
                item2.setText(2, type);
            }
            if (format != null) {
                item2.setText(3, format);
            }
            if (length != null && !"-1".equals(length)) {
                item2.setText(4, length);
            }
            if (prec != null && !"-1".equals(prec)) {
                item2.setText(5, prec);
            }
            if (curr != null) {
                item2.setText(6, curr);
            }
            if (decim != null) {
                item2.setText(7, decim);
            }
            if (group != null) {
                item2.setText(8, group);
            }
            if (trim != null) {
                item2.setText(9, trim);
            }
            if (rep != null) {
                item2.setText(10, rep);
            }
            item2.setText(11, field.getFieldPositionsCode());
        }
        for (i = 0; i < this.input.getDefinitionLength(); ++i) {
            item = this.wAttributes.table.getItem(i);
            item.setText(1, this.input.getDefiningElement(i));
            item.setText(2, this.input.getDefiningAttribute(i));
        }
        for (i = 0; i < this.input.getInputPosition().length; ++i) {
            item = this.wPosition.table.getItem(i);
            if (this.input.getInputPosition()[i] == null) continue;
            item.setText(1, this.input.getInputPosition()[i].toString());
        }
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wPosition.removeEmptyRows();
        this.wPosition.setRowNums();
        this.wPosition.optWidth(true);
        this.setMultiple();
        this.setIncludeFilename();
        this.setIncludeRownum();
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        try {
            this.getInfo(this.input);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Dialog.ErrorParsingInputData.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Dialog.ErrorParsingInputData.Message", (String[])new String[0]), (Exception)((Object)e));
        }
        this.dispose();
    }

    private void getInfo(XMLInputSaxMeta in) throws KettleException {
        TableItem item;
        int i;
        this.stepname = this.wStepname.getText();
        in.setRowLimit(Const.toLong((String)this.wLimit.getText(), (long)0L));
        in.setFilenameField(this.wInclFilenameField.getText());
        in.setRowNumberField(this.wInclRownumField.getText());
        in.setIncludeFilename(this.wInclFilename.getSelection());
        in.setIncludeRowNumber(this.wInclRownum.getSelection());
        int nrFiles = this.wFilenameList.getItemCount();
        int nrAttributes = this.wAttributes.nrNonEmpty();
        int nrFields = this.wFields.nrNonEmpty();
        int nrPositions = this.wPosition.nrNonEmpty();
        in.allocate(nrFiles, nrFields, nrPositions);
        in.setFileName(this.wFilenameList.getItems(0));
        in.setFileMask(this.wFilenameList.getItems(1));
        in.clearDefinition();
        for (i = 0; i < nrAttributes; ++i) {
            item = this.wAttributes.getNonEmpty(i);
            in.setDefiningAttribute(item.getText(1), item.getText(2));
        }
        for (i = 0; i < nrFields; ++i) {
            XMLInputSaxField field = new XMLInputSaxField();
            TableItem item2 = this.wFields.getNonEmpty(i);
            field.setName(item2.getText(1));
            field.setType(Value.getType((String)item2.getText(2)));
            field.setFormat(item2.getText(3));
            field.setLength(Const.toInt((String)item2.getText(4), (int)-1));
            field.setPrecision(Const.toInt((String)item2.getText(5), (int)-1));
            field.setCurrencySymbol(item2.getText(6));
            field.setDecimalSymbol(item2.getText(7));
            field.setGroupSymbol(item2.getText(8));
            field.setTrimType(XMLInputSaxField.getTrimType((String)item2.getText(9)));
            field.setRepeated("Y".equalsIgnoreCase(item2.getText(10)));
            field.setFieldPosition(item2.getText(11));
            in.getInputFields()[i] = field;
        }
        for (i = 0; i < nrPositions; ++i) {
            item = this.wPosition.getNonEmpty(i);
            String encode = item.getText(1);
            in.getInputPosition()[i] = new XMLInputSaxFieldPosition(encode);
        }
    }

    private void get() {
        try {
            XMLInputSaxMeta meta = new XMLInputSaxMeta();
            this.getInfo(meta);
            List fields = new ArrayList();
            String[] filePaths = meta.getFilePaths((VariableSpace)this.transMeta);
            if (meta.getInputPosition().length == 0) {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Dialog.NoElements.Message", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Dialog.NoElements.Title", (String[])new String[0]));
                mb.open();
                return;
            }
            for (int f = 0; f < filePaths.length; ++f) {
                XMLInputSaxFieldRetriever fieldRetreiver = new XMLInputSaxFieldRetriever((LogChannelInterface)this.log, filePaths[f], meta);
                fields = fieldRetreiver.getFields();
                for (int i = 0; i < fields.size(); ++i) {
                    XMLInputSaxField iF = (XMLInputSaxField)fields.get(i);
                    TableItem item = new TableItem(this.wFields.table, 0);
                    item.setText(1, iF.getName());
                    item.setText(2, iF.getTypeDesc());
                    item.setText(11, iF.getFieldPositionsCode(meta.getInputPosition().length));
                }
                this.wFields.removeEmptyRows();
                this.wFields.setRowNums();
                this.wFields.optWidth(true);
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Dialog.ErrorParsingInputData.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Dialog.ErrorParsingInputData.Message", (String[])new String[0]), (Exception)((Object)e));
            System.out.println(e.getMessage());
        }
    }

    private void preview() {
        try {
            XMLInputSaxMeta oneMeta = new XMLInputSaxMeta();
            this.getInfo(oneMeta);
            TransMeta previewMeta = TransPreviewFactory.generatePreviewTransformation((VariableSpace)this.transMeta, (StepMetaInterface)oneMeta, (String)this.wStepname.getText());
            EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Dialog.EnterPreviewSize.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Dialog.EnterPreviewSize.Message", (String[])new String[0]));
            int previewSize = numberDialog.open();
            if (previewSize > 0) {
                TransPreviewProgressDialog progressDialog = new TransPreviewProgressDialog(this.shell, previewMeta, new String[]{this.wStepname.getText()}, new int[]{previewSize});
                progressDialog.open();
                if (!progressDialog.isCancelled()) {
                    PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, (VariableSpace)this.transMeta, 0, this.wStepname.getText(), progressDialog.getPreviewRowsMeta(this.wStepname.getText()), progressDialog.getPreviewRows(this.wStepname.getText()));
                    prd.open();
                }
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Dialog.ErrorDisplayingPreviewData.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"XMLInputSaxDialog.Dialog.ErrorDisplayingPreviewData.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }
}

