/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.zipfile;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.zipfile.ZipFileMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class ZipFileDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = ZipFileMeta.class;
    private Label wlSourceFileNameField;
    private CCombo wSourceFileNameField;
    private FormData fdlSourceFileNameField;
    private FormData fdSourceFileNameField;
    private Label wlTargetFileNameField;
    private CCombo wTargetFileNameField;
    private FormData fdlTargetFileNameField;
    private FormData fdTargetFileNameField;
    private Button wAddResult;
    private FormData fdAddResult;
    private FormData fdlAddResult;
    private Label wlAddResult;
    private Button wOverwriteZipEntry;
    private FormData fdOverwriteTarget;
    private FormData fdlOverwriteTarget;
    private Label wlOverwriteTarget;
    private Button wCreateParentFolder;
    private FormData fdCreateParentFolder;
    private FormData fdlCreateParentFolder;
    private Label wlCreateParentFolder;
    private Button wKeepFolders;
    private FormData fdKeepFolders;
    private FormData fdlKeepFolders;
    private Label wlKeepFolders;
    private Group wSettingsGroup;
    private FormData fdSettingsGroup;
    private ZipFileMeta input;
    private Label wlBaseFolderField;
    private CCombo wBaseFolderField;
    private FormData fdlBaseFolderField;
    private FormData fdBaseFolderField;
    private Label wlOperation;
    private CCombo wOperation;
    private FormData fdlOperation;
    private FormData fdOperation;
    private Label wlMoveToFolderField;
    private CCombo wMoveToFolderField;
    private FormData fdlMoveToFolderField;
    private FormData fdMoveToFolderField;
    private boolean gotPreviousFields = false;

    public ZipFileDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (ZipFileMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ZipFileDialog.this.input.setChanged();
            }
        };
        SelectionAdapter lsSel = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ZipFileDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ZipFileDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"ZipFileDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wSettingsGroup = new Group((Composite)this.shell, 32);
        this.props.setLook((Control)this.wSettingsGroup);
        this.wSettingsGroup.setText(BaseMessages.getString(PKG, (String)"ZipFileDialog.wSettingsGroup.Label", (String[])new String[0]));
        FormLayout settingGroupLayout = new FormLayout();
        settingGroupLayout.marginWidth = 10;
        settingGroupLayout.marginHeight = 10;
        this.wSettingsGroup.setLayout((Layout)settingGroupLayout);
        this.wlCreateParentFolder = new Label((Composite)this.wSettingsGroup, 131072);
        this.wlCreateParentFolder.setText(BaseMessages.getString(PKG, (String)"ZipFileDialog.CreateParentFolder.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCreateParentFolder);
        this.fdlCreateParentFolder = new FormData();
        this.fdlCreateParentFolder.left = new FormAttachment(0, 0);
        this.fdlCreateParentFolder.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdlCreateParentFolder.right = new FormAttachment(middle, -margin);
        this.wlCreateParentFolder.setLayoutData((Object)this.fdlCreateParentFolder);
        this.wCreateParentFolder = new Button((Composite)this.wSettingsGroup, 32);
        this.props.setLook((Control)this.wCreateParentFolder);
        this.wCreateParentFolder.setToolTipText(BaseMessages.getString(PKG, (String)"ZipFileDialog.CreateParentFolder.Tooltip", (String[])new String[0]));
        this.fdCreateParentFolder = new FormData();
        this.fdCreateParentFolder.left = new FormAttachment(middle, 0);
        this.fdCreateParentFolder.top = new FormAttachment((Control)this.wStepname, margin);
        this.wCreateParentFolder.setLayoutData((Object)this.fdCreateParentFolder);
        this.wCreateParentFolder.addSelectionListener((SelectionListener)lsSel);
        this.wlOverwriteTarget = new Label((Composite)this.wSettingsGroup, 131072);
        this.wlOverwriteTarget.setText(BaseMessages.getString(PKG, (String)"ZipFileDialog.OverwriteTarget.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlOverwriteTarget);
        this.fdlOverwriteTarget = new FormData();
        this.fdlOverwriteTarget.left = new FormAttachment(0, 0);
        this.fdlOverwriteTarget.top = new FormAttachment((Control)this.wCreateParentFolder, margin);
        this.fdlOverwriteTarget.right = new FormAttachment(middle, -margin);
        this.wlOverwriteTarget.setLayoutData((Object)this.fdlOverwriteTarget);
        this.wOverwriteZipEntry = new Button((Composite)this.wSettingsGroup, 32);
        this.props.setLook((Control)this.wOverwriteZipEntry);
        this.wOverwriteZipEntry.setToolTipText(BaseMessages.getString(PKG, (String)"ZipFileDialog.OverwriteTarget.Tooltip", (String[])new String[0]));
        this.fdOverwriteTarget = new FormData();
        this.fdOverwriteTarget.left = new FormAttachment(middle, 0);
        this.fdOverwriteTarget.top = new FormAttachment((Control)this.wCreateParentFolder, margin);
        this.wOverwriteZipEntry.setLayoutData((Object)this.fdOverwriteTarget);
        this.wOverwriteZipEntry.addSelectionListener((SelectionListener)lsSel);
        this.wlAddResult = new Label((Composite)this.wSettingsGroup, 131072);
        this.wlAddResult.setText(BaseMessages.getString(PKG, (String)"ZipFileDialog.AddResult.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAddResult);
        this.fdlAddResult = new FormData();
        this.fdlAddResult.left = new FormAttachment(0, 0);
        this.fdlAddResult.top = new FormAttachment((Control)this.wOverwriteZipEntry, margin);
        this.fdlAddResult.right = new FormAttachment(middle, -margin);
        this.wlAddResult.setLayoutData((Object)this.fdlAddResult);
        this.wAddResult = new Button((Composite)this.wSettingsGroup, 32);
        this.props.setLook((Control)this.wAddResult);
        this.wAddResult.setToolTipText(BaseMessages.getString(PKG, (String)"ZipFileDialog.AddResult.Tooltip", (String[])new String[0]));
        this.fdAddResult = new FormData();
        this.fdAddResult.left = new FormAttachment(middle, 0);
        this.fdAddResult.top = new FormAttachment((Control)this.wOverwriteZipEntry, margin);
        this.wAddResult.setLayoutData((Object)this.fdAddResult);
        this.wAddResult.addSelectionListener((SelectionListener)lsSel);
        this.fdSettingsGroup = new FormData();
        this.fdSettingsGroup.left = new FormAttachment(0, margin);
        this.fdSettingsGroup.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdSettingsGroup.right = new FormAttachment(100, -margin);
        this.wSettingsGroup.setLayoutData((Object)this.fdSettingsGroup);
        this.wlSourceFileNameField = new Label((Composite)this.shell, 131072);
        this.wlSourceFileNameField.setText(BaseMessages.getString(PKG, (String)"ZipFileDialog.SourceFileNameField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSourceFileNameField);
        this.fdlSourceFileNameField = new FormData();
        this.fdlSourceFileNameField.left = new FormAttachment(0, 0);
        this.fdlSourceFileNameField.right = new FormAttachment(middle, -margin);
        this.fdlSourceFileNameField.top = new FormAttachment((Control)this.wSettingsGroup, 2 * margin);
        this.wlSourceFileNameField.setLayoutData((Object)this.fdlSourceFileNameField);
        this.wSourceFileNameField = new CCombo((Composite)this.shell, 2056);
        this.props.setLook((Control)this.wSourceFileNameField);
        this.wSourceFileNameField.setEditable(true);
        this.wSourceFileNameField.addModifyListener(lsMod);
        this.fdSourceFileNameField = new FormData();
        this.fdSourceFileNameField.left = new FormAttachment(middle, 0);
        this.fdSourceFileNameField.top = new FormAttachment((Control)this.wSettingsGroup, 2 * margin);
        this.fdSourceFileNameField.right = new FormAttachment(100, -margin);
        this.wSourceFileNameField.setLayoutData((Object)this.fdSourceFileNameField);
        this.wSourceFileNameField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                ZipFileDialog.this.get();
            }
        });
        this.wlTargetFileNameField = new Label((Composite)this.shell, 131072);
        this.wlTargetFileNameField.setText(BaseMessages.getString(PKG, (String)"ZipFileDialog.TargetFileNameField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTargetFileNameField);
        this.fdlTargetFileNameField = new FormData();
        this.fdlTargetFileNameField.left = new FormAttachment(0, 0);
        this.fdlTargetFileNameField.right = new FormAttachment(middle, -margin);
        this.fdlTargetFileNameField.top = new FormAttachment((Control)this.wSourceFileNameField, margin);
        this.wlTargetFileNameField.setLayoutData((Object)this.fdlTargetFileNameField);
        this.wTargetFileNameField = new CCombo((Composite)this.shell, 2056);
        this.wTargetFileNameField.setEditable(true);
        this.props.setLook((Control)this.wTargetFileNameField);
        this.wTargetFileNameField.addModifyListener(lsMod);
        this.fdTargetFileNameField = new FormData();
        this.fdTargetFileNameField.left = new FormAttachment(middle, 0);
        this.fdTargetFileNameField.top = new FormAttachment((Control)this.wSourceFileNameField, margin);
        this.fdTargetFileNameField.right = new FormAttachment(100, -margin);
        this.wTargetFileNameField.setLayoutData((Object)this.fdTargetFileNameField);
        this.wTargetFileNameField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                ZipFileDialog.this.get();
            }
        });
        this.wlKeepFolders = new Label((Composite)this.shell, 131072);
        this.wlKeepFolders.setText(BaseMessages.getString(PKG, (String)"ZipFileDialog.KeepFolders.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlKeepFolders);
        this.fdlKeepFolders = new FormData();
        this.fdlKeepFolders.left = new FormAttachment(0, 0);
        this.fdlKeepFolders.top = new FormAttachment((Control)this.wTargetFileNameField, margin);
        this.fdlKeepFolders.right = new FormAttachment(middle, -margin);
        this.wlKeepFolders.setLayoutData((Object)this.fdlKeepFolders);
        this.wKeepFolders = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wKeepFolders);
        this.wKeepFolders.setToolTipText(BaseMessages.getString(PKG, (String)"ZipFileDialog.KeepFolders.Tooltip", (String[])new String[0]));
        this.fdKeepFolders = new FormData();
        this.fdKeepFolders.left = new FormAttachment(middle, 0);
        this.fdKeepFolders.top = new FormAttachment((Control)this.wTargetFileNameField, margin);
        this.wKeepFolders.setLayoutData((Object)this.fdKeepFolders);
        this.wKeepFolders.addSelectionListener((SelectionListener)lsSel);
        this.wKeepFolders.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ZipFileDialog.this.keepFolder();
            }
        });
        this.wlBaseFolderField = new Label((Composite)this.shell, 131072);
        this.wlBaseFolderField.setText(BaseMessages.getString(PKG, (String)"ZipFileDialog.BaseFolderField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlBaseFolderField);
        this.fdlBaseFolderField = new FormData();
        this.fdlBaseFolderField.left = new FormAttachment(0, 0);
        this.fdlBaseFolderField.right = new FormAttachment(middle, -margin);
        this.fdlBaseFolderField.top = new FormAttachment((Control)this.wKeepFolders, margin);
        this.wlBaseFolderField.setLayoutData((Object)this.fdlBaseFolderField);
        this.wBaseFolderField = new CCombo((Composite)this.shell, 2056);
        this.wBaseFolderField.setEditable(true);
        this.props.setLook((Control)this.wBaseFolderField);
        this.wBaseFolderField.addModifyListener(lsMod);
        this.fdBaseFolderField = new FormData();
        this.fdBaseFolderField.left = new FormAttachment(middle, 0);
        this.fdBaseFolderField.top = new FormAttachment((Control)this.wKeepFolders, margin);
        this.fdBaseFolderField.right = new FormAttachment(100, -margin);
        this.wBaseFolderField.setLayoutData((Object)this.fdBaseFolderField);
        this.wBaseFolderField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                ZipFileDialog.this.get();
            }
        });
        this.wlOperation = new Label((Composite)this.shell, 131072);
        this.wlOperation.setText(BaseMessages.getString(PKG, (String)"ZipFileDialog.Operation.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlOperation);
        this.fdlOperation = new FormData();
        this.fdlOperation.left = new FormAttachment(0, 0);
        this.fdlOperation.right = new FormAttachment(middle, -margin);
        this.fdlOperation.top = new FormAttachment((Control)this.wBaseFolderField, margin);
        this.wlOperation.setLayoutData((Object)this.fdlOperation);
        this.wOperation = new CCombo((Composite)this.shell, 2056);
        this.props.setLook((Control)this.wOperation);
        this.wOperation.addModifyListener(lsMod);
        this.fdOperation = new FormData();
        this.fdOperation.left = new FormAttachment(middle, 0);
        this.fdOperation.top = new FormAttachment((Control)this.wBaseFolderField, margin);
        this.fdOperation.right = new FormAttachment(100, -margin);
        this.wOperation.setLayoutData((Object)this.fdOperation);
        this.wOperation.setItems(ZipFileMeta.operationTypeDesc);
        this.wOperation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZipFileDialog.this.updateOperation();
            }
        });
        this.wlMoveToFolderField = new Label((Composite)this.shell, 131072);
        this.wlMoveToFolderField.setText(BaseMessages.getString(PKG, (String)"ZipFileDialog.MoveToFolderField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlMoveToFolderField);
        this.fdlMoveToFolderField = new FormData();
        this.fdlMoveToFolderField.left = new FormAttachment(0, 0);
        this.fdlMoveToFolderField.right = new FormAttachment(middle, -margin);
        this.fdlMoveToFolderField.top = new FormAttachment((Control)this.wOperation, margin);
        this.wlMoveToFolderField.setLayoutData((Object)this.fdlMoveToFolderField);
        this.wMoveToFolderField = new CCombo((Composite)this.shell, 2056);
        this.wMoveToFolderField.setEditable(true);
        this.props.setLook((Control)this.wMoveToFolderField);
        this.wMoveToFolderField.addModifyListener(lsMod);
        this.fdMoveToFolderField = new FormData();
        this.fdMoveToFolderField.left = new FormAttachment(middle, 0);
        this.fdMoveToFolderField.top = new FormAttachment((Control)this.wOperation, margin);
        this.fdMoveToFolderField.right = new FormAttachment(100, -margin);
        this.wMoveToFolderField.setLayoutData((Object)this.fdMoveToFolderField);
        this.wMoveToFolderField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                ZipFileDialog.this.get();
            }
        });
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, (Control)this.wMoveToFolderField);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                ZipFileDialog.this.ok();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                ZipFileDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ZipFileDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                ZipFileDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.keepFolder();
        this.updateOperation();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void getData() {
        if (this.log.isDebug()) {
            this.log.logDebug(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"ZipFileDialog.Log.GettingKeyInfo", (String[])new String[0])});
        }
        if (this.input.getBaseFolderField() != null) {
            this.wBaseFolderField.setText(this.input.getBaseFolderField());
        }
        if (this.input.getDynamicSourceFileNameField() != null) {
            this.wSourceFileNameField.setText(this.input.getDynamicSourceFileNameField());
        }
        if (this.input.getDynamicTargetFileNameField() != null) {
            this.wTargetFileNameField.setText(this.input.getDynamicTargetFileNameField());
        }
        this.wOperation.setText(ZipFileMeta.getOperationTypeDesc((int)this.input.getOperationType()));
        if (this.input.getMoveToFolderField() != null) {
            this.wMoveToFolderField.setText(this.input.getMoveToFolderField());
        }
        this.wAddResult.setSelection(this.input.isaddTargetFileNametoResult());
        this.wOverwriteZipEntry.setSelection(this.input.isOverwriteZipEntry());
        this.wCreateParentFolder.setSelection(this.input.isCreateParentFolder());
        this.wKeepFolders.setSelection(this.input.isKeepSouceFolder());
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.Error.StepNameMissing.Message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"System.Error.StepNameMissing.Title", (String[])new String[0]));
            mb.open();
            return;
        }
        this.input.setBaseFolderField(this.wBaseFolderField.getText());
        this.input.setDynamicSourceFileNameField(this.wSourceFileNameField.getText());
        this.input.setDynamicTargetFileNameField(this.wTargetFileNameField.getText());
        this.input.setaddTargetFileNametoResult(this.wAddResult.getSelection());
        this.input.setOverwriteZipEntry(this.wOverwriteZipEntry.getSelection());
        this.input.setCreateParentFolder(this.wCreateParentFolder.getSelection());
        this.input.setKeepSouceFolder(this.wKeepFolders.getSelection());
        this.input.setOperationType(ZipFileMeta.getOperationTypeByDesc((String)this.wOperation.getText()));
        this.input.setMoveToFolderField(this.wMoveToFolderField.getText());
        this.stepname = this.wStepname.getText();
        this.dispose();
    }

    private void keepFolder() {
        this.wlBaseFolderField.setEnabled(this.wKeepFolders.getSelection());
        this.wBaseFolderField.setEnabled(this.wKeepFolders.getSelection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void get() {
        if (!this.gotPreviousFields) {
            this.gotPreviousFields = true;
            String source = this.wSourceFileNameField.getText();
            String target = this.wTargetFileNameField.getText();
            String base = this.wBaseFolderField.getText();
            try {
                this.wSourceFileNameField.removeAll();
                this.wTargetFileNameField.removeAll();
                this.wBaseFolderField.removeAll();
                RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
                if (r != null) {
                    String[] fields = r.getFieldNames();
                    this.wSourceFileNameField.setItems(fields);
                    this.wTargetFileNameField.setItems(fields);
                    this.wBaseFolderField.setItems(fields);
                }
            }
            catch (KettleException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"ZipFileDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ZipFileDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
            finally {
                if (source != null) {
                    this.wSourceFileNameField.setText(source);
                }
                if (target != null) {
                    this.wTargetFileNameField.setText(target);
                }
                if (base != null) {
                    this.wBaseFolderField.setText(base);
                }
            }
        }
    }

    private void updateOperation() {
        this.wlMoveToFolderField.setEnabled(ZipFileMeta.getOperationTypeByDesc((String)this.wOperation.getText()) == 1);
        this.wMoveToFolderField.setEnabled(ZipFileMeta.getOperationTypeByDesc((String)this.wOperation.getText()) == 1);
    }
}

