/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricPredicate;
import com.yammer.metrics.core.MetricProcessor;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.reporting.ConsoleReporter;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.util.BloomFilter;
import org.apache.hadoop.hbase.util.BloomFilterFactory;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HFilePrettyPrinter {
    private static final Log LOG = LogFactory.getLog(HFilePrettyPrinter.class);
    private Options options = new Options();
    private boolean verbose;
    private boolean printValue;
    private boolean printKey;
    private boolean shouldPrintMeta;
    private boolean printBlocks;
    private boolean printStats;
    private boolean checkRow;
    private boolean checkFamily;
    private boolean isSeekToRow = false;
    private byte[] row = null;
    private Configuration conf;
    private List<Path> files = new ArrayList<Path>();
    private int count;
    private static final String FOUR_SPACES = "    ";

    public HFilePrettyPrinter() {
        this.options.addOption("v", "verbose", false, "Verbose output; emits file and meta data delimiters");
        this.options.addOption("p", "printkv", false, "Print key/value pairs");
        this.options.addOption("e", "printkey", false, "Print keys");
        this.options.addOption("m", "printmeta", false, "Print meta data of file");
        this.options.addOption("b", "printblocks", false, "Print block index meta data");
        this.options.addOption("k", "checkrow", false, "Enable row order check; looks for out-of-order keys");
        this.options.addOption("a", "checkfamily", false, "Enable family check");
        this.options.addOption("f", "file", true, "File to scan. Pass full-path; e.g. hdfs://a:9000/hbase/hbase:meta/12/34");
        this.options.addOption("w", "seekToRow", true, "Seek to this row and print all the kvs for this row only");
        this.options.addOption("r", "region", true, "Region to scan. Pass region name; e.g. 'hbase:meta,,1'");
        this.options.addOption("s", "stats", false, "Print statistics");
    }

    public boolean parseOptions(String[] args) throws ParseException, IOException {
        if (args.length == 0) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("HFile", this.options, true);
            return false;
        }
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(this.options, args);
        this.verbose = cmd.hasOption("v");
        this.printValue = cmd.hasOption("p");
        this.printKey = cmd.hasOption("e") || this.printValue;
        this.shouldPrintMeta = cmd.hasOption("m");
        this.printBlocks = cmd.hasOption("b");
        this.printStats = cmd.hasOption("s");
        this.checkRow = cmd.hasOption("k");
        this.checkFamily = cmd.hasOption("a");
        if (cmd.hasOption("f")) {
            this.files.add(new Path(cmd.getOptionValue("f")));
        }
        if (cmd.hasOption("w")) {
            String key = cmd.getOptionValue("w");
            if (key != null && key.length() != 0) {
                this.row = key.getBytes();
                this.isSeekToRow = true;
            } else {
                System.err.println("Invalid row is specified.");
                System.exit(-1);
            }
        }
        if (cmd.hasOption("r")) {
            String regionName = cmd.getOptionValue("r");
            byte[] rn = Bytes.toBytes((String)regionName);
            byte[][] hri = HRegionInfo.parseRegionName((byte[])rn);
            Path rootDir = FSUtils.getRootDir(this.conf);
            Path tableDir = FSUtils.getTableDir(rootDir, TableName.valueOf((byte[])hri[0]));
            String enc = HRegionInfo.encodeRegionName((byte[])rn);
            Path regionDir = new Path(tableDir, enc);
            if (this.verbose) {
                System.out.println("region dir -> " + regionDir);
            }
            List<Path> regionFiles = HFile.getStoreFiles(FileSystem.get((Configuration)this.conf), regionDir);
            if (this.verbose) {
                System.out.println("Number of region files found -> " + regionFiles.size());
            }
            if (this.verbose) {
                int i = 1;
                for (Path p : regionFiles) {
                    if (!this.verbose) continue;
                    System.out.println("Found file[" + i++ + "] -> " + p);
                }
            }
            this.files.addAll(regionFiles);
        }
        return true;
    }

    public int run(String[] args) {
        this.conf = HBaseConfiguration.create();
        try {
            FSUtils.setFsDefault(this.conf, FSUtils.getRootDir(this.conf));
            if (!this.parseOptions(args)) {
                return 1;
            }
        }
        catch (IOException ex) {
            LOG.error((Object)"Error parsing command-line options", (Throwable)ex);
            return 1;
        }
        catch (ParseException ex) {
            LOG.error((Object)"Error parsing command-line options", (Throwable)ex);
            return 1;
        }
        for (Path fileName : this.files) {
            try {
                this.processFile(fileName);
            }
            catch (IOException ex) {
                LOG.error((Object)("Error reading " + fileName), (Throwable)ex);
            }
        }
        if (this.verbose || this.printKey) {
            System.out.println("Scanned kv count -> " + this.count);
        }
        return 0;
    }

    private void processFile(Path file) throws IOException {
        FileSystem fs;
        if (this.verbose) {
            System.out.println("Scanning -> " + file);
        }
        if (!(fs = file.getFileSystem(this.conf)).exists(file)) {
            System.err.println("ERROR, file doesnt exist: " + file);
        }
        HFile.Reader reader = HFile.createReader(fs, file, new CacheConfig(this.conf), this.conf);
        Map<byte[], byte[]> fileInfo = reader.loadFileInfo();
        KeyValueStatsCollector fileStats = null;
        if (this.verbose || this.printKey || this.checkRow || this.checkFamily || this.printStats) {
            HFileScanner scanner = reader.getScanner(false, false, false);
            fileStats = new KeyValueStatsCollector();
            boolean shouldScanKeysValues = false;
            shouldScanKeysValues = this.isSeekToRow ? scanner.seekTo(KeyValue.createFirstOnRow((byte[])this.row).getKey()) != -1 : scanner.seekTo();
            if (shouldScanKeysValues) {
                this.scanKeysValues(file, fileStats, scanner, this.row);
            }
        }
        if (this.shouldPrintMeta) {
            this.printMeta(reader, fileInfo);
        }
        if (this.printBlocks) {
            System.out.println("Block Index:");
            System.out.println(reader.getDataBlockIndexReader());
        }
        if (this.printStats) {
            fileStats.finish();
            System.out.println("Stats:\n" + fileStats);
        }
        reader.close();
    }

    private void scanKeysValues(Path file, KeyValueStatsCollector fileStats, HFileScanner scanner, byte[] row) throws IOException {
        KeyValue pkv = null;
        do {
            KeyValue kv = scanner.getKeyValue();
            if (row != null && row.length != 0) {
                int result = Bytes.compareTo((byte[])kv.getRow(), (byte[])row);
                if (result > 0) break;
                if (result < 0) continue;
            }
            if (this.printStats) {
                fileStats.collect(kv);
            }
            if (this.printKey) {
                System.out.print("K: " + kv);
                if (this.printValue) {
                    System.out.print(" V: " + Bytes.toStringBinary((byte[])kv.getValue()));
                    int i = 0;
                    List tags = kv.getTags();
                    for (Tag tag : tags) {
                        System.out.print(String.format(" T[%d]: %s", i++, Bytes.toStringBinary((byte[])tag.getValue())));
                    }
                }
                System.out.println();
            }
            if (this.checkRow && pkv != null && Bytes.compareTo((byte[])pkv.getRow(), (byte[])kv.getRow()) > 0) {
                System.err.println("WARNING, previous row is greater then current row\n\tfilename -> " + file + "\n\tprevious -> " + Bytes.toStringBinary((byte[])pkv.getKey()) + "\n\tcurrent  -> " + Bytes.toStringBinary((byte[])kv.getKey()));
            }
            if (this.checkFamily) {
                String fam = Bytes.toString((byte[])kv.getFamily());
                if (!file.toString().contains(fam)) {
                    System.err.println("WARNING, filename does not match kv family,\n\tfilename -> " + file + "\n\tkeyvalue -> " + Bytes.toStringBinary((byte[])kv.getKey()));
                }
                if (pkv != null && !Bytes.equals((byte[])pkv.getFamily(), (byte[])kv.getFamily())) {
                    System.err.println("WARNING, previous kv has different family compared to current key\n\tfilename -> " + file + "\n\tprevious -> " + Bytes.toStringBinary((byte[])pkv.getKey()) + "\n\tcurrent  -> " + Bytes.toStringBinary((byte[])kv.getKey()));
                }
            }
            pkv = kv;
            ++this.count;
        } while (scanner.next());
    }

    private static String asSeparateLines(String keyValueStr) {
        return keyValueStr.replaceAll(", ([a-zA-Z]+=)", ",\n    $1");
    }

    private void printMeta(HFile.Reader reader, Map<byte[], byte[]> fileInfo) throws IOException {
        System.out.println("Block index size as per heapsize: " + reader.indexSize());
        System.out.println(HFilePrettyPrinter.asSeparateLines(reader.toString()));
        System.out.println("Trailer:\n    " + HFilePrettyPrinter.asSeparateLines(reader.getTrailer().toString()));
        System.out.println("Fileinfo:");
        for (Map.Entry<byte[], byte[]> e : fileInfo.entrySet()) {
            System.out.print(FOUR_SPACES + Bytes.toString((byte[])e.getKey()) + " = ");
            if (Bytes.compareTo((byte[])e.getKey(), (byte[])Bytes.toBytes((String)"MAX_SEQ_ID_KEY")) == 0) {
                long seqid = Bytes.toLong((byte[])e.getValue());
                System.out.println(seqid);
                continue;
            }
            if (Bytes.compareTo((byte[])e.getKey(), (byte[])Bytes.toBytes((String)"TIMERANGE")) == 0) {
                TimeRangeTracker timeRangeTracker = new TimeRangeTracker();
                Writables.copyWritable((byte[])e.getValue(), (Writable)timeRangeTracker);
                System.out.println(timeRangeTracker.getMinimumTimestamp() + "...." + timeRangeTracker.getMaximumTimestamp());
                continue;
            }
            if (Bytes.compareTo((byte[])e.getKey(), (byte[])HFile.FileInfo.AVG_KEY_LEN) == 0 || Bytes.compareTo((byte[])e.getKey(), (byte[])HFile.FileInfo.AVG_VALUE_LEN) == 0) {
                System.out.println(Bytes.toInt((byte[])e.getValue()));
                continue;
            }
            System.out.println(Bytes.toStringBinary((byte[])e.getValue()));
        }
        try {
            System.out.println("Mid-key: " + Bytes.toStringBinary((byte[])reader.midkey()));
        }
        catch (Exception e) {
            System.out.println("Unable to retrieve the midkey");
        }
        DataInput bloomMeta = reader.getGeneralBloomFilterMetadata();
        BloomFilter bloomFilter = null;
        if (bloomMeta != null) {
            bloomFilter = BloomFilterFactory.createFromMeta(bloomMeta, reader);
        }
        System.out.println("Bloom filter:");
        if (bloomFilter != null) {
            System.out.println(FOUR_SPACES + bloomFilter.toString().replaceAll("; ", "\n    "));
        } else {
            System.out.println("    Not present");
        }
        bloomMeta = reader.getDeleteBloomFilterMetadata();
        bloomFilter = null;
        if (bloomMeta != null) {
            bloomFilter = BloomFilterFactory.createFromMeta(bloomMeta, reader);
        }
        System.out.println("Delete Family Bloom filter:");
        if (bloomFilter != null) {
            System.out.println(FOUR_SPACES + bloomFilter.toString().replaceAll("; ", "\n    "));
        } else {
            System.out.println("    Not present");
        }
    }

    private static class SimpleReporter
    extends ConsoleReporter {
        private final PrintStream out;

        public SimpleReporter(MetricsRegistry metricsRegistry, PrintStream out) {
            super(metricsRegistry, out, MetricPredicate.ALL);
            this.out = out;
        }

        public void run() {
            for (Map.Entry entry : this.getMetricsRegistry().groupedMetrics(MetricPredicate.ALL).entrySet()) {
                try {
                    for (Map.Entry subEntry : ((SortedMap)entry.getValue()).entrySet()) {
                        this.out.print("   " + ((MetricName)subEntry.getKey()).getName());
                        this.out.println(':');
                        ((Metric)subEntry.getValue()).processWith((MetricProcessor)this, (MetricName)subEntry.getKey(), (Object)this.out);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(this.out);
                }
            }
        }

        public void processHistogram(MetricName name, Histogram histogram, PrintStream stream) {
            super.processHistogram(name, histogram, stream);
            stream.printf(Locale.getDefault(), "             count = %d\n", histogram.count());
        }
    }

    private static class KeyValueStatsCollector {
        private final MetricsRegistry metricsRegistry = new MetricsRegistry();
        private final ByteArrayOutputStream metricsOutput = new ByteArrayOutputStream();
        private final SimpleReporter simpleReporter = new SimpleReporter(this.metricsRegistry, new PrintStream(this.metricsOutput));
        Histogram keyLen = this.metricsRegistry.newHistogram(HFilePrettyPrinter.class, "Key length");
        Histogram valLen = this.metricsRegistry.newHistogram(HFilePrettyPrinter.class, "Val length");
        Histogram rowSizeBytes = this.metricsRegistry.newHistogram(HFilePrettyPrinter.class, "Row size (bytes)");
        Histogram rowSizeCols = this.metricsRegistry.newHistogram(HFilePrettyPrinter.class, "Row size (columns)");
        long curRowBytes = 0L;
        long curRowCols = 0L;
        byte[] biggestRow = null;
        private KeyValue prevKV = null;
        private long maxRowBytes = 0L;
        private long curRowKeyLength;

        private KeyValueStatsCollector() {
        }

        public void collect(KeyValue kv) {
            this.valLen.update(kv.getValueLength());
            if (this.prevKV != null && KeyValue.COMPARATOR.compareRows(this.prevKV, kv) != 0) {
                this.collectRow();
            }
            this.curRowBytes += (long)kv.getLength();
            this.curRowKeyLength = kv.getKeyLength();
            ++this.curRowCols;
            this.prevKV = kv;
        }

        private void collectRow() {
            this.rowSizeBytes.update(this.curRowBytes);
            this.rowSizeCols.update(this.curRowCols);
            this.keyLen.update(this.curRowKeyLength);
            if (this.curRowBytes > this.maxRowBytes && this.prevKV != null) {
                this.biggestRow = this.prevKV.getRow();
                this.maxRowBytes = this.curRowBytes;
            }
            this.curRowBytes = 0L;
            this.curRowCols = 0L;
        }

        public void finish() {
            if (this.curRowCols > 0L) {
                this.collectRow();
            }
        }

        public String toString() {
            if (this.prevKV == null) {
                return "no data available for statistics";
            }
            this.simpleReporter.shutdown();
            this.simpleReporter.run();
            this.metricsRegistry.shutdown();
            return this.metricsOutput.toString() + "Key of biggest row: " + Bytes.toStringBinary((byte[])this.biggestRow);
        }
    }
}

