/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Chore;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.RegionTransition;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.master.AssignCallable;
import org.apache.hadoop.hbase.master.GeneralBulkAssigner;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MetricsAssignmentManager;
import org.apache.hadoop.hbase.master.MetricsMaster;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.SnapshotOfRegionAssignmentFromMeta;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.master.UnAssignCallable;
import org.apache.hadoop.hbase.master.balancer.FavoredNodeAssignmentHelper;
import org.apache.hadoop.hbase.master.balancer.FavoredNodeLoadBalancer;
import org.apache.hadoop.hbase.master.handler.ClosedRegionHandler;
import org.apache.hadoop.hbase.master.handler.DisableTableHandler;
import org.apache.hadoop.hbase.master.handler.EnableTableHandler;
import org.apache.hadoop.hbase.master.handler.OpenedRegionHandler;
import org.apache.hadoop.hbase.regionserver.RegionAlreadyInTransitionException;
import org.apache.hadoop.hbase.regionserver.RegionMergeTransaction;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.regionserver.SplitTransaction;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.KeyLocker;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.MetaRegionTracker;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKTable;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

@InterfaceAudience.Private
public class AssignmentManager
extends ZooKeeperListener {
    private static final Log LOG = LogFactory.getLog(AssignmentManager.class);
    public static final ServerName HBCK_CODE_SERVERNAME = ServerName.valueOf((String)"HBCKServerName", (int)-1, (long)-1L);
    public static final String ASSIGNMENT_TIMEOUT = "hbase.master.assignment.timeoutmonitor.timeout";
    public static final int DEFAULT_ASSIGNMENT_TIMEOUT_DEFAULT = 600000;
    public static final String ASSIGNMENT_TIMEOUT_MANAGEMENT = "hbase.assignment.timeout.management";
    public static final boolean DEFAULT_ASSIGNMENT_TIMEOUT_MANAGEMENT = false;
    public static final String ALREADY_IN_TRANSITION_WAITTIME = "hbase.assignment.already.intransition.waittime";
    public static final int DEFAULT_ALREADY_IN_TRANSITION_WAITTIME = 60000;
    protected final Server server;
    private ServerManager serverManager;
    private boolean shouldAssignRegionsWithFavoredNodes;
    private CatalogTracker catalogTracker;
    protected final TimeoutMonitor timeoutMonitor;
    private final TimerUpdater timerUpdater;
    private LoadBalancer balancer;
    private final MetricsAssignmentManager metricsAssignmentManager;
    private final TableLockManager tableLockManager;
    private AtomicInteger numRegionsOpened = new AtomicInteger(0);
    private final KeyLocker<String> locker = new KeyLocker();
    private final Map<String, HRegionInfo> regionsToReopen;
    private final int maximumAttempts;
    private final Map<String, PairOfSameType<HRegionInfo>> mergingRegions = new HashMap<String, PairOfSameType<HRegionInfo>>();
    private final long sleepTimeBeforeRetryingMetaAssignment;
    final NavigableMap<String, RegionPlan> regionPlans = new TreeMap<String, RegionPlan>();
    private final ZKTable zkTable;
    private final ConcurrentSkipListSet<ServerName> serversInUpdatingTimer;
    private final org.apache.hadoop.hbase.executor.ExecutorService executorService;
    private Map<HRegionInfo, AtomicBoolean> closedRegionHandlerCalled = null;
    private Map<HRegionInfo, AtomicBoolean> openedRegionHandlerCalled = null;
    private ExecutorService threadPoolExecutorService;
    private final ExecutorService zkEventWorkers;
    private List<EventType> ignoreStatesRSOffline = Arrays.asList(EventType.RS_ZK_REGION_FAILED_OPEN, EventType.RS_ZK_REGION_CLOSED);
    private final RegionStates regionStates;
    private final int bulkAssignThresholdRegions;
    private final int bulkAssignThresholdServers;
    private final boolean bulkAssignWaitTillAllAssigned;
    protected final AtomicBoolean failoverCleanupDone = new AtomicBoolean(false);
    private final boolean tomActivated;
    private final ConcurrentHashMap<String, AtomicInteger> failedOpenTracker = new ConcurrentHashMap();
    @SuppressWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static boolean TEST_SKIP_SPLIT_HANDLING = false;
    private final Set<String> regionsInProgress = new HashSet<String>();
    private final LinkedHashMultimap<String, RegionRunnable> zkEventWorkerWaitingList = LinkedHashMultimap.create();

    public AssignmentManager(Server server, ServerManager serverManager, CatalogTracker catalogTracker, LoadBalancer balancer, org.apache.hadoop.hbase.executor.ExecutorService service, MetricsMaster metricsMaster, TableLockManager tableLockManager) throws KeeperException, IOException {
        super(server.getZooKeeper());
        this.server = server;
        this.serverManager = serverManager;
        this.catalogTracker = catalogTracker;
        this.executorService = service;
        this.regionsToReopen = Collections.synchronizedMap(new HashMap());
        Configuration conf = server.getConfiguration();
        this.shouldAssignRegionsWithFavoredNodes = conf.getClass("hbase.master.loadbalancer.class", Object.class).equals(FavoredNodeLoadBalancer.class);
        this.tomActivated = conf.getBoolean(ASSIGNMENT_TIMEOUT_MANAGEMENT, false);
        if (this.tomActivated) {
            this.serversInUpdatingTimer = new ConcurrentSkipListSet();
            this.timeoutMonitor = new TimeoutMonitor(conf.getInt("hbase.master.assignment.timeoutmonitor.period", 30000), (Stoppable)server, serverManager, conf.getInt(ASSIGNMENT_TIMEOUT, 600000));
            this.timerUpdater = new TimerUpdater(conf.getInt("hbase.master.assignment.timerupdater.period", 10000), (Stoppable)server);
            Threads.setDaemonThreadRunning((Thread)this.timerUpdater.getThread(), (String)(server.getServerName() + ".timerUpdater"));
        } else {
            this.serversInUpdatingTimer = null;
            this.timeoutMonitor = null;
            this.timerUpdater = null;
        }
        try {
            this.zkTable = new ZKTable(this.watcher);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        this.maximumAttempts = Math.max(1, this.server.getConfiguration().getInt("hbase.assignment.maximum.attempts", 10));
        this.sleepTimeBeforeRetryingMetaAssignment = this.server.getConfiguration().getLong("hbase.meta.assignment.retry.sleeptime", 1000L);
        this.balancer = balancer;
        int maxThreads = conf.getInt("hbase.assignment.threads.max", 30);
        this.threadPoolExecutorService = Threads.getBoundedCachedThreadPool((int)maxThreads, (long)60L, (TimeUnit)TimeUnit.SECONDS, (ThreadFactory)Threads.newDaemonThreadFactory((String)"AM."));
        this.regionStates = new RegionStates(server, serverManager);
        this.bulkAssignWaitTillAllAssigned = conf.getBoolean("hbase.bulk.assignment.waittillallassigned", false);
        this.bulkAssignThresholdRegions = conf.getInt("hbase.bulk.assignment.threshold.regions", 7);
        this.bulkAssignThresholdServers = conf.getInt("hbase.bulk.assignment.threshold.servers", 3);
        int workers = conf.getInt("hbase.assignment.zkevent.workers", 20);
        ThreadFactory threadFactory = Threads.newDaemonThreadFactory((String)"AM.ZK.Worker");
        this.zkEventWorkers = Threads.getBoundedCachedThreadPool((int)workers, (long)60L, (TimeUnit)TimeUnit.SECONDS, (ThreadFactory)threadFactory);
        this.tableLockManager = tableLockManager;
        this.metricsAssignmentManager = new MetricsAssignmentManager();
    }

    void startTimeOutMonitor() {
        if (this.tomActivated) {
            Threads.setDaemonThreadRunning((Thread)this.timeoutMonitor.getThread(), (String)(this.server.getServerName() + ".timeoutMonitor"));
        }
    }

    public ZKTable getZKTable() {
        return this.zkTable;
    }

    public RegionStates getRegionStates() {
        return this.regionStates;
    }

    public RegionPlan getRegionReopenPlan(HRegionInfo hri) {
        return new RegionPlan(hri, null, this.regionStates.getRegionServerOfRegion(hri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlan(String encodedName, RegionPlan plan) {
        NavigableMap<String, RegionPlan> navigableMap = this.regionPlans;
        synchronized (navigableMap) {
            this.regionPlans.put(encodedName, plan);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlans(Map<String, RegionPlan> plans) {
        NavigableMap<String, RegionPlan> navigableMap = this.regionPlans;
        synchronized (navigableMap) {
            this.regionPlans.putAll(plans);
        }
    }

    public void setRegionsToReopen(List<HRegionInfo> regions) {
        for (HRegionInfo hri : regions) {
            this.regionsToReopen.put(hri.getEncodedName(), hri);
        }
    }

    public Pair<Integer, Integer> getReopenStatus(TableName tableName) throws IOException {
        List hris = MetaReader.getTableRegions((CatalogTracker)this.server.getCatalogTracker(), (TableName)tableName, (boolean)true);
        Integer pending = 0;
        for (HRegionInfo hri : hris) {
            String name = hri.getEncodedName();
            if (!this.regionsToReopen.containsKey(name) && !this.regionStates.isRegionInTransition(name)) continue;
            Integer n = pending;
            Integer n2 = pending = Integer.valueOf(pending + 1);
        }
        return new Pair((Object)pending, (Object)hris.size());
    }

    public boolean isFailoverCleanupDone() {
        return this.failoverCleanupDone.get();
    }

    public Lock acquireRegionLock(String encodedName) {
        return this.locker.acquireLock((Comparable)((Object)encodedName));
    }

    void failoverCleanupDone() {
        this.failoverCleanupDone.set(true);
        this.serverManager.processQueuedDeadServers();
    }

    void joinCluster() throws IOException, KeeperException, InterruptedException {
        Map<ServerName, List<HRegionInfo>> deadServers = this.rebuildUserRegions();
        this.processDeadServersAndRegionsInTransition(deadServers);
        this.recoverTableInDisablingState();
        this.recoverTableInEnablingState();
    }

    void processDeadServersAndRegionsInTransition(Map<ServerName, List<HRegionInfo>> deadServers) throws KeeperException, IOException, InterruptedException {
        boolean failover;
        List nodes = ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)this.watcher, (String)this.watcher.assignmentZNode);
        if (nodes == null) {
            String errorMessage = "Failed to get the children from ZK";
            this.server.abort(errorMessage, (Throwable)new IOException(errorMessage));
            return;
        }
        boolean bl = failover = !this.serverManager.getDeadServers().isEmpty() || !this.serverManager.getRequeuedDeadServers().isEmpty();
        if (!failover) {
            Map<HRegionInfo, ServerName> regions = this.regionStates.getRegionAssignments();
            for (HRegionInfo hri : regions.keySet()) {
                if (hri.isMetaTable()) continue;
                LOG.debug((Object)("Found " + hri + " out on cluster"));
                failover = true;
                break;
            }
            if (!failover) {
                for (String encodedName : nodes) {
                    RegionState state = this.regionStates.getRegionState(encodedName);
                    if (state == null || state.getRegion().isMetaRegion()) continue;
                    LOG.debug((Object)("Found " + state.getRegion().getRegionNameAsString() + " in RITs"));
                    failover = true;
                    break;
                }
            }
        }
        if (failover) {
            LOG.info((Object)"Found regions out on cluster or in RIT; presuming failover");
            this.processDeadServersAndRecoverLostRegions(deadServers);
        } else {
            LOG.info((Object)"Clean cluster startup. Assigning userregions");
            this.assignAllUserRegions();
        }
    }

    boolean processRegionInTransitionAndBlockUntilAssigned(HRegionInfo hri) throws InterruptedException, KeeperException, IOException {
        RegionState state;
        String encodedRegionName = hri.getEncodedName();
        if (!this.processRegionInTransition(encodedRegionName, hri)) {
            return false;
        }
        LOG.debug((Object)("Waiting on " + HRegionInfo.prettyPrint((String)encodedRegionName)));
        while (!this.server.isStopped() && this.regionStates.isRegionInTransition(encodedRegionName) && (state = this.regionStates.getRegionTransitionState(encodedRegionName)) != null && this.serverManager.isServerOnline(state.getServerName())) {
            this.regionStates.waitForUpdate(100L);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processRegionInTransition(String encodedRegionName, HRegionInfo regionInfo) throws KeeperException, IOException {
        ReentrantLock lock = this.locker.acquireLock((Comparable)((Object)encodedRegionName));
        try {
            RegionTransition rt;
            Stat stat = new Stat();
            byte[] data = ZKAssign.getDataAndWatch((ZooKeeperWatcher)this.watcher, (String)encodedRegionName, (Stat)stat);
            if (data == null) {
                boolean bl = false;
                return bl;
            }
            try {
                rt = RegionTransition.parseFrom((byte[])data);
            }
            catch (DeserializationException e) {
                LOG.warn((Object)"Failed parse znode data", (Throwable)e);
                boolean bl = false;
                lock.unlock();
                return bl;
            }
            HRegionInfo hri = regionInfo;
            if (hri == null) {
                hri = this.regionStates.getRegionInfo(rt.getRegionName());
                EventType et = rt.getEventType();
                if (hri == null && et != EventType.RS_ZK_REGION_MERGING && et != EventType.RS_ZK_REQUEST_REGION_MERGE) {
                    LOG.warn((Object)("Couldn't find the region in recovering " + rt));
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = this.processRegionsInTransition(rt, hri, stat.getVersion());
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    boolean processRegionsInTransition(RegionTransition rt, final HRegionInfo regionInfo, final int expectedVersion) throws KeeperException {
        EventType et = rt.getEventType();
        final ServerName sn = rt.getServerName();
        byte[] regionName = rt.getRegionName();
        final String encodedName = HRegionInfo.encodeRegionName((byte[])regionName);
        String prettyPrintedRegionName = HRegionInfo.prettyPrint((String)encodedName);
        LOG.info((Object)("Processing " + prettyPrintedRegionName + " in state: " + et));
        if (this.regionStates.isRegionInTransition(encodedName)) {
            LOG.info((Object)("Processed region " + prettyPrintedRegionName + " in state: " + et + ", does nothing since the region is already in transition " + this.regionStates.getRegionTransitionState(encodedName)));
            return true;
        }
        if (!this.serverManager.isServerOnline(sn)) {
            LOG.debug((Object)("RIT " + encodedName + " in state=" + rt.getEventType() + " was on deadserver; forcing offline"));
            if (this.regionStates.isRegionOnline(regionInfo)) {
                this.regionStates.regionOffline(regionInfo);
            }
            this.regionStates.updateRegionState(regionInfo, RegionState.State.OFFLINE, sn);
            if (regionInfo.isMetaRegion()) {
                MetaRegionTracker.setMetaLocation((ZooKeeperWatcher)this.watcher, (ServerName)sn);
            } else {
                this.regionStates.setLastRegionServerOfRegion(sn, encodedName);
                if (!this.serverManager.isServerDead(sn)) {
                    this.serverManager.expireServer(sn);
                }
            }
            return false;
        }
        switch (et) {
            case M_ZK_REGION_CLOSING: {
                final RegionState rsClosing = this.regionStates.updateRegionState(rt, RegionState.State.CLOSING);
                this.executorService.submit(new EventHandler(this.server, EventType.M_MASTER_RECOVERY){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void process() throws IOException {
                        ReentrantLock lock = AssignmentManager.this.locker.acquireLock((Comparable)((Object)regionInfo.getEncodedName()));
                        try {
                            AssignmentManager.this.unassign(regionInfo, rsClosing, expectedVersion, null, true, null);
                            if (AssignmentManager.this.regionStates.isRegionOffline(regionInfo)) {
                                AssignmentManager.this.assign(regionInfo, true);
                            }
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                });
                break;
            }
            case RS_ZK_REGION_CLOSED: 
            case RS_ZK_REGION_FAILED_OPEN: {
                this.regionStates.updateRegionState(regionInfo, RegionState.State.CLOSED, sn);
                this.invokeAssign(regionInfo);
                break;
            }
            case M_ZK_REGION_OFFLINE: {
                this.regionStates.updateRegionState(rt, RegionState.State.PENDING_OPEN);
                final RegionState rsOffline = this.regionStates.getRegionState(regionInfo);
                this.executorService.submit(new EventHandler(this.server, EventType.M_MASTER_RECOVERY){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void process() throws IOException {
                        ReentrantLock lock = AssignmentManager.this.locker.acquireLock((Comparable)((Object)regionInfo.getEncodedName()));
                        try {
                            RegionPlan plan = new RegionPlan(regionInfo, null, sn);
                            AssignmentManager.this.addPlan(encodedName, plan);
                            AssignmentManager.this.assign(rsOffline, false, false);
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                });
                break;
            }
            case RS_ZK_REGION_OPENING: {
                this.regionStates.updateRegionState(rt, RegionState.State.OPENING);
                break;
            }
            case RS_ZK_REGION_OPENED: {
                this.regionStates.updateRegionState(rt, RegionState.State.OPEN);
                new OpenedRegionHandler(this.server, this, regionInfo, sn, expectedVersion).process();
                break;
            }
            case RS_ZK_REQUEST_REGION_SPLIT: 
            case RS_ZK_REGION_SPLITTING: 
            case RS_ZK_REGION_SPLIT: {
                this.regionStates.regionOnline(regionInfo, sn);
                this.regionStates.updateRegionState(rt, RegionState.State.SPLITTING);
                if (this.handleRegionSplitting(rt, encodedName, prettyPrintedRegionName, sn)) break;
                this.deleteSplittingNode(encodedName, sn);
                break;
            }
            case RS_ZK_REQUEST_REGION_MERGE: 
            case RS_ZK_REGION_MERGING: 
            case RS_ZK_REGION_MERGED: {
                if (this.handleRegionMerging(rt, encodedName, prettyPrintedRegionName, sn)) break;
                this.deleteMergingNode(encodedName, sn);
                break;
            }
            default: {
                throw new IllegalStateException("Received region in state:" + et + " is not valid.");
            }
        }
        LOG.info((Object)("Processed region " + prettyPrintedRegionName + " in state " + et + ", on " + (this.serverManager.isServerOnline(sn) ? "" : "dead ") + "server: " + sn));
        return true;
    }

    public void removeClosedRegion(HRegionInfo hri) {
        if (this.regionsToReopen.remove(hri.getEncodedName()) != null) {
            LOG.debug((Object)"Removed region from reopening regions because it was closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void handleRegion(RegionTransition rt, int expectedVersion) {
        if (rt == null) {
            LOG.warn((Object)"Unexpected NULL input for RegionTransition rt");
            return;
        }
        ServerName sn = rt.getServerName();
        if (sn.equals((Object)HBCK_CODE_SERVERNAME)) {
            this.handleHBCK(rt);
            return;
        }
        long createTime = rt.getCreateTime();
        byte[] regionName = rt.getRegionName();
        String encodedName = HRegionInfo.encodeRegionName((byte[])regionName);
        String prettyPrintedRegionName = HRegionInfo.prettyPrint((String)encodedName);
        if (!this.serverManager.isServerOnline(sn) && !this.ignoreStatesRSOffline.contains(rt.getEventType())) {
            LOG.warn((Object)("Attempted to handle region transition for server but it is not online: " + prettyPrintedRegionName + ", " + rt));
            return;
        }
        RegionState regionState = this.regionStates.getRegionState(encodedName);
        long startTime = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            boolean lateEvent = createTime < startTime - 15000L;
            LOG.debug((Object)("Handling " + rt.getEventType() + ", server=" + sn + ", region=" + (prettyPrintedRegionName == null ? "null" : prettyPrintedRegionName) + (lateEvent ? ", which is more than 15 seconds late" : "") + ", current_state=" + regionState));
        }
        if (rt.getEventType() == EventType.M_ZK_REGION_OFFLINE) {
            return;
        }
        ReentrantLock lock = this.locker.acquireLock((Comparable)((Object)encodedName));
        try {
            long waitedTime;
            RegionState latestState = this.regionStates.getRegionState(encodedName);
            if (regionState == null && latestState != null || regionState != null && latestState == null || regionState != null && latestState != null && latestState.getState() != regionState.getState()) {
                LOG.warn((Object)("Region state changed from " + regionState + " to " + latestState + ", while acquiring lock"));
            }
            if ((waitedTime = System.currentTimeMillis() - startTime) > 5000L) {
                LOG.warn((Object)("Took " + waitedTime + "ms to acquire the lock"));
            }
            regionState = latestState;
            switch (rt.getEventType()) {
                case RS_ZK_REQUEST_REGION_SPLIT: 
                case RS_ZK_REGION_SPLITTING: 
                case RS_ZK_REGION_SPLIT: {
                    if (this.handleRegionSplitting(rt, encodedName, prettyPrintedRegionName, sn)) return;
                    this.deleteSplittingNode(encodedName, sn);
                    return;
                }
                case RS_ZK_REQUEST_REGION_MERGE: 
                case RS_ZK_REGION_MERGING: 
                case RS_ZK_REGION_MERGED: {
                    if (this.handleRegionMerging(rt, encodedName, prettyPrintedRegionName, sn)) return;
                    this.deleteMergingNode(encodedName, sn);
                    return;
                }
                case M_ZK_REGION_CLOSING: {
                    if (regionState == null || !regionState.isPendingCloseOrClosingOnServer(sn)) {
                        LOG.warn((Object)("Received CLOSING for " + prettyPrintedRegionName + " from " + sn + " but the region isn't PENDING_CLOSE/CLOSING here: " + this.regionStates.getRegionState(encodedName)));
                        return;
                    }
                    this.regionStates.updateRegionState(rt, RegionState.State.CLOSING);
                    return;
                }
                case RS_ZK_REGION_CLOSED: {
                    if (regionState == null || !regionState.isPendingCloseOrClosingOnServer(sn)) {
                        LOG.warn((Object)("Received CLOSED for " + prettyPrintedRegionName + " from " + sn + " but the region isn't PENDING_CLOSE/CLOSING here: " + this.regionStates.getRegionState(encodedName)));
                        return;
                    }
                    new ClosedRegionHandler(this.server, this, regionState.getRegion()).process();
                    this.updateClosedRegionHandlerTracker(regionState.getRegion());
                    return;
                }
                case RS_ZK_REGION_FAILED_OPEN: {
                    if (regionState == null || !regionState.isPendingOpenOrOpeningOnServer(sn)) {
                        LOG.warn((Object)("Received FAILED_OPEN for " + prettyPrintedRegionName + " from " + sn + " but the region isn't PENDING_OPEN/OPENING here: " + this.regionStates.getRegionState(encodedName)));
                        return;
                    }
                    AtomicInteger failedOpenCount = this.failedOpenTracker.get(encodedName);
                    if (failedOpenCount == null) {
                        failedOpenCount = new AtomicInteger();
                        this.failedOpenTracker.put(encodedName, failedOpenCount);
                    }
                    if (failedOpenCount.incrementAndGet() >= this.maximumAttempts) {
                        this.regionStates.updateRegionState(rt, RegionState.State.FAILED_OPEN);
                        this.failedOpenTracker.remove(encodedName);
                        return;
                    } else {
                        regionState = this.regionStates.updateRegionState(rt, RegionState.State.CLOSED);
                        if (regionState == null) return;
                        try {
                            this.getRegionPlan(regionState.getRegion(), sn, true);
                            new ClosedRegionHandler(this.server, this, regionState.getRegion()).process();
                            return;
                        }
                        catch (HBaseIOException e) {
                            LOG.warn((Object)"Failed to get region plan", (Throwable)e);
                            return;
                        }
                    }
                }
                case RS_ZK_REGION_OPENING: {
                    if (regionState == null || !regionState.isPendingOpenOrOpeningOnServer(sn)) {
                        LOG.warn((Object)("Received OPENING for " + prettyPrintedRegionName + " from " + sn + " but the region isn't PENDING_OPEN/OPENING here: " + this.regionStates.getRegionState(encodedName)));
                        return;
                    }
                    this.regionStates.updateRegionState(rt, RegionState.State.OPENING);
                    return;
                }
                case RS_ZK_REGION_OPENED: {
                    if (regionState == null || !regionState.isPendingOpenOrOpeningOnServer(sn)) {
                        LOG.warn((Object)("Received OPENED for " + prettyPrintedRegionName + " from " + sn + " but the region isn't PENDING_OPEN/OPENING here: " + this.regionStates.getRegionState(encodedName)));
                        if (regionState == null) return;
                        this.unassign(regionState.getRegion(), null, -1, null, false, sn);
                        return;
                    }
                    regionState = this.regionStates.updateRegionState(rt, RegionState.State.OPEN);
                    if (regionState == null) return;
                    this.failedOpenTracker.remove(encodedName);
                    new OpenedRegionHandler(this.server, this, regionState.getRegion(), sn, expectedVersion).process();
                    this.updateOpenedRegionHandlerTracker(regionState.getRegion());
                    return;
                }
                default: {
                    throw new IllegalStateException("Received event is not valid.");
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    boolean wasClosedHandlerCalled(HRegionInfo hri) {
        AtomicBoolean b = this.closedRegionHandlerCalled.get(hri);
        return b == null ? false : b.compareAndSet(true, false);
    }

    boolean wasOpenedHandlerCalled(HRegionInfo hri) {
        AtomicBoolean b = this.openedRegionHandlerCalled.get(hri);
        return b == null ? false : b.compareAndSet(true, false);
    }

    void initializeHandlerTrackers() {
        this.closedRegionHandlerCalled = new HashMap<HRegionInfo, AtomicBoolean>();
        this.openedRegionHandlerCalled = new HashMap<HRegionInfo, AtomicBoolean>();
    }

    void updateClosedRegionHandlerTracker(HRegionInfo hri) {
        if (this.closedRegionHandlerCalled != null) {
            this.closedRegionHandlerCalled.put(hri, new AtomicBoolean(true));
        }
    }

    void updateOpenedRegionHandlerTracker(HRegionInfo hri) {
        if (this.openedRegionHandlerCalled != null) {
            this.openedRegionHandlerCalled.put(hri, new AtomicBoolean(true));
        }
    }

    void processFavoredNodes(List<HRegionInfo> regions) throws IOException {
        if (!this.shouldAssignRegionsWithFavoredNodes) {
            return;
        }
        HashMap<HRegionInfo, List<ServerName>> regionToFavoredNodes = new HashMap<HRegionInfo, List<ServerName>>();
        for (HRegionInfo region : regions) {
            regionToFavoredNodes.put(region, ((FavoredNodeLoadBalancer)this.balancer).getFavoredNodes(region));
        }
        FavoredNodeAssignmentHelper.updateMetaWithFavoredNodesInfo(regionToFavoredNodes, this.catalogTracker);
    }

    private void handleHBCK(RegionTransition rt) {
        String encodedName = HRegionInfo.encodeRegionName((byte[])rt.getRegionName());
        LOG.info((Object)("Handling HBCK triggered transition=" + rt.getEventType() + ", server=" + rt.getServerName() + ", region=" + HRegionInfo.prettyPrint((String)encodedName)));
        RegionState regionState = this.regionStates.getRegionTransitionState(encodedName);
        switch (rt.getEventType()) {
            case M_ZK_REGION_OFFLINE: {
                HRegionInfo regionInfo;
                if (regionState != null) {
                    regionInfo = regionState.getRegion();
                } else {
                    try {
                        byte[] name = rt.getRegionName();
                        Pair p = MetaReader.getRegion((CatalogTracker)this.catalogTracker, (byte[])name);
                        regionInfo = (HRegionInfo)p.getFirst();
                    }
                    catch (IOException e) {
                        LOG.info((Object)"Exception reading hbase:meta doing HBCK repair operation", (Throwable)e);
                        return;
                    }
                }
                LOG.info((Object)("HBCK repair is triggering assignment of region=" + regionInfo.getRegionNameAsString()));
                this.assign(regionInfo, false);
                break;
            }
            default: {
                LOG.warn((Object)("Received unexpected region state from HBCK: " + rt.toString()));
            }
        }
    }

    public void nodeCreated(String path) {
        this.handleAssignmentEvent(path);
    }

    public void nodeDataChanged(String path) {
        this.handleAssignmentEvent(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zkEventWorkersSubmit(final RegionRunnable regRunnable) {
        Set<String> set = this.regionsInProgress;
        synchronized (set) {
            if (this.regionsInProgress.contains(regRunnable.getRegionName())) {
                LinkedHashMultimap<String, RegionRunnable> linkedHashMultimap = this.zkEventWorkerWaitingList;
                synchronized (linkedHashMultimap) {
                    this.zkEventWorkerWaitingList.put((Object)regRunnable.getRegionName(), (Object)regRunnable);
                }
                return;
            }
            this.regionsInProgress.add(regRunnable.getRegionName());
            this.zkEventWorkers.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        regRunnable.run();
                    }
                    finally {
                        Set set = AssignmentManager.this.regionsInProgress;
                        synchronized (set) {
                            AssignmentManager.this.regionsInProgress.remove(regRunnable.getRegionName());
                            LinkedHashMultimap linkedHashMultimap = AssignmentManager.this.zkEventWorkerWaitingList;
                            synchronized (linkedHashMultimap) {
                                Set waiting = AssignmentManager.this.zkEventWorkerWaitingList.get((Object)regRunnable.getRegionName());
                                if (!waiting.isEmpty()) {
                                    RegionRunnable toSubmit = (RegionRunnable)waiting.iterator().next();
                                    AssignmentManager.this.zkEventWorkerWaitingList.remove((Object)toSubmit.getRegionName(), (Object)toSubmit);
                                    AssignmentManager.this.zkEventWorkersSubmit(toSubmit);
                                }
                            }
                        }
                    }
                }
            });
        }
    }

    public void nodeDeleted(String path) {
        if (path.startsWith(this.watcher.assignmentZNode)) {
            final String regionName = ZKAssign.getRegionName((ZooKeeperWatcher)this.watcher, (String)path);
            this.zkEventWorkersSubmit(new RegionRunnable(){

                @Override
                public String getRegionName() {
                    return regionName;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block11: {
                        ReentrantLock lock = AssignmentManager.this.locker.acquireLock((Comparable)((Object)regionName));
                        try {
                            RegionState rs = AssignmentManager.this.regionStates.getRegionTransitionState(regionName);
                            if (!(rs != null || (rs = AssignmentManager.this.regionStates.getRegionState(regionName)) != null && rs.isMergingNew())) {
                                return;
                            }
                            HRegionInfo regionInfo = rs.getRegion();
                            String regionNameStr = regionInfo.getRegionNameAsString();
                            LOG.debug((Object)("Znode " + regionNameStr + " deleted, state: " + rs));
                            boolean disabled = AssignmentManager.this.getZKTable().isDisablingOrDisabledTable(regionInfo.getTable());
                            ServerName serverName = rs.getServerName();
                            if (!AssignmentManager.this.serverManager.isServerOnline(serverName)) break block11;
                            if (rs.isOnServer(serverName) && (rs.isOpened() || rs.isSplitting())) {
                                AssignmentManager.this.regionOnline(regionInfo, serverName);
                                if (disabled) {
                                    LOG.info((Object)("Opened " + regionNameStr + "but this table is disabled, triggering close of region"));
                                    AssignmentManager.this.unassign(regionInfo);
                                }
                                break block11;
                            }
                            if (!rs.isMergingNew()) break block11;
                            RegionStates regionStates = AssignmentManager.this.regionStates;
                            synchronized (regionStates) {
                                String p = regionInfo.getEncodedName();
                                PairOfSameType regions = (PairOfSameType)AssignmentManager.this.mergingRegions.get(p);
                                if (regions != null) {
                                    this.onlineMergingRegion(disabled, (HRegionInfo)regions.getFirst(), serverName);
                                    this.onlineMergingRegion(disabled, (HRegionInfo)regions.getSecond(), serverName);
                                }
                            }
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                }

                private void onlineMergingRegion(boolean disabled, HRegionInfo hri, ServerName serverName) {
                    RegionState regionState = AssignmentManager.this.regionStates.getRegionState(hri);
                    if (regionState != null && regionState.isMerging() && regionState.isOnServer(serverName)) {
                        AssignmentManager.this.regionOnline(regionState.getRegion(), serverName);
                        if (disabled) {
                            AssignmentManager.this.unassign(hri);
                        }
                    }
                }
            });
        }
    }

    public void nodeChildrenChanged(String path) {
        if (path.equals(this.watcher.assignmentZNode)) {
            this.zkEventWorkers.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        List children = ZKUtil.listChildrenAndWatchForNewChildren((ZooKeeperWatcher)AssignmentManager.this.watcher, (String)((AssignmentManager)AssignmentManager.this).watcher.assignmentZNode);
                        if (children != null) {
                            Stat stat = new Stat();
                            for (String child : children) {
                                if (AssignmentManager.this.regionStates.isRegionInTransition(child)) continue;
                                ZKAssign.getDataAndWatch((ZooKeeperWatcher)AssignmentManager.this.watcher, (String)child, (Stat)stat);
                            }
                        }
                    }
                    catch (KeeperException e) {
                        AssignmentManager.this.server.abort("Unexpected ZK exception reading unassigned children", (Throwable)e);
                    }
                }
            });
        }
    }

    void regionOnline(HRegionInfo regionInfo, ServerName sn) {
        this.numRegionsOpened.incrementAndGet();
        this.regionStates.regionOnline(regionInfo, sn);
        this.clearRegionPlan(regionInfo);
        this.addToServersInUpdatingTimer(sn);
    }

    private void handleAssignmentEvent(final String path) {
        if (path.startsWith(this.watcher.assignmentZNode)) {
            final String regionName = ZKAssign.getRegionName((ZooKeeperWatcher)this.watcher, (String)path);
            this.zkEventWorkersSubmit(new RegionRunnable(){

                @Override
                public String getRegionName() {
                    return regionName;
                }

                @Override
                public void run() {
                    try {
                        Stat stat = new Stat();
                        byte[] data = ZKAssign.getDataAndWatch((ZooKeeperWatcher)AssignmentManager.this.watcher, (String)path, (Stat)stat);
                        if (data == null) {
                            return;
                        }
                        RegionTransition rt = RegionTransition.parseFrom((byte[])data);
                        AssignmentManager.this.handleRegion(rt, stat.getVersion());
                    }
                    catch (KeeperException e) {
                        AssignmentManager.this.server.abort("Unexpected ZK exception reading unassigned node data", (Throwable)e);
                    }
                    catch (DeserializationException e) {
                        AssignmentManager.this.server.abort("Unexpected exception deserializing node data", (Throwable)e);
                    }
                }
            });
        }
    }

    private void addToServersInUpdatingTimer(ServerName sn) {
        if (this.tomActivated) {
            this.serversInUpdatingTimer.add(sn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTimers(ServerName sn) {
        ArrayList rps;
        Preconditions.checkState((boolean)this.tomActivated);
        if (sn == null) {
            return;
        }
        NavigableMap<String, RegionPlan> navigableMap = this.regionPlans;
        synchronized (navigableMap) {
            rps = new ArrayList(this.regionPlans.entrySet());
        }
        for (Map.Entry entry : rps) {
            RegionState regionState;
            if (entry.getValue() == null || entry.getKey() == null || !sn.equals((Object)((RegionPlan)entry.getValue()).getDestination()) || (regionState = this.regionStates.getRegionTransitionState((String)entry.getKey())) == null) continue;
            regionState.updateTimestampToNow();
        }
    }

    public void regionOffline(HRegionInfo regionInfo) {
        this.regionOffline(regionInfo, null);
    }

    public void offlineDisabledRegion(HRegionInfo regionInfo) {
        LOG.debug((Object)("Table being disabled so deleting ZK node and removing from regions in transition, skipping assignment of region " + regionInfo.getRegionNameAsString()));
        String encodedName = regionInfo.getEncodedName();
        this.deleteNodeInStates(encodedName, "closed", null, EventType.RS_ZK_REGION_CLOSED, EventType.M_ZK_REGION_OFFLINE);
        this.regionOffline(regionInfo);
    }

    public void assign(HRegionInfo region, boolean setOfflineInZK) {
        this.assign(region, setOfflineInZK, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assign(HRegionInfo region, boolean setOfflineInZK, boolean forceNewPlan) {
        if (this.isDisabledorDisablingRegionInRIT(region)) {
            return;
        }
        if (this.serverManager.isClusterShutdown()) {
            LOG.info((Object)("Cluster shutdown is set; skipping assign of " + region.getRegionNameAsString()));
            return;
        }
        String encodedName = region.getEncodedName();
        ReentrantLock lock = this.locker.acquireLock((Comparable)((Object)encodedName));
        try {
            RegionState state = this.forceRegionStateToOffline(region, forceNewPlan);
            if (state != null) {
                if (this.regionStates.wasRegionOnDeadServer(encodedName)) {
                    LOG.info((Object)("Skip assigning " + region.getRegionNameAsString() + ", it's host " + this.regionStates.getLastRegionServerOfRegion(encodedName) + " is dead but not processed yet"));
                    return;
                }
                this.assign(state, setOfflineInZK, forceNewPlan);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    boolean assign(ServerName destination, List<HRegionInfo> regions) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 26[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void unassign(HRegionInfo region, RegionState state, int versionOfClosingNode, ServerName dest, boolean transitionInZK, ServerName src) {
        ServerName server = src;
        if (state != null) {
            server = state.getServerName();
        }
        long maxWaitTime = -1L;
        for (int i = 1; i <= this.maximumAttempts; ++i) {
            if (this.server.isStopped() || this.server.isAborted()) {
                LOG.debug((Object)("Server stopped/aborted; skipping unassign of " + region));
                return;
            }
            if (!this.serverManager.isServerOnline(server)) {
                LOG.debug((Object)("Offline " + region.getRegionNameAsString() + ", no need to unassign since it's on a dead server: " + server));
                if (transitionInZK) {
                    this.deleteClosingOrClosedNode(region, server);
                }
                if (state != null) {
                    this.regionOffline(region);
                }
                return;
            }
            try {
                if (this.serverManager.sendRegionClose(server, region, versionOfClosingNode, dest, transitionInZK)) {
                    LOG.debug((Object)("Sent CLOSE to " + server + " for region " + region.getRegionNameAsString()));
                    if (!transitionInZK && state != null) {
                        this.unassign(region, state, versionOfClosingNode, dest, transitionInZK, src);
                    }
                    return;
                }
                LOG.warn((Object)("Server " + server + " region CLOSE RPC returned false for " + region.getRegionNameAsString()));
                continue;
            }
            catch (Throwable t2) {
                IOException t2;
                if (t2 instanceof RemoteException) {
                    t2 = ((RemoteException)t2).unwrapRemoteException();
                }
                boolean logRetries = true;
                if (t2 instanceof NotServingRegionException || t2 instanceof RegionServerStoppedException) {
                    LOG.debug((Object)("Offline " + region.getRegionNameAsString() + ", it's not any more on " + server), (Throwable)t2);
                    if (transitionInZK) {
                        this.deleteClosingOrClosedNode(region, server);
                    }
                    if (state != null) {
                        this.regionOffline(region);
                    }
                    return;
                }
                if (t2 instanceof RpcClient.FailedServerException || state != null && t2 instanceof RegionAlreadyInTransitionException) {
                    long sleepTime = 0L;
                    Configuration conf = this.server.getConfiguration();
                    if (t2 instanceof RpcClient.FailedServerException) {
                        sleepTime = 1 + conf.getInt("hbase.ipc.client.failed.servers.expiry", 2000);
                    } else {
                        long now;
                        LOG.debug((Object)("update " + state + " the timestamp."));
                        state.updateTimestampToNow();
                        if (maxWaitTime < 0L) {
                            maxWaitTime = EnvironmentEdgeManager.currentTimeMillis() + conf.getLong(ALREADY_IN_TRANSITION_WAITTIME, 60000L);
                        }
                        if ((now = EnvironmentEdgeManager.currentTimeMillis()) < maxWaitTime) {
                            LOG.debug((Object)("Region is already in transition; waiting up to " + (maxWaitTime - now) + "ms"), (Throwable)t2);
                            sleepTime = 100L;
                            --i;
                            logRetries = false;
                        }
                    }
                    try {
                        if (sleepTime > 0L) {
                            Thread.sleep(sleepTime);
                        }
                    }
                    catch (InterruptedException ie) {
                        LOG.warn((Object)("Failed to unassign " + region.getRegionNameAsString() + " since interrupted"), (Throwable)ie);
                        Thread.currentThread().interrupt();
                        if (!this.tomActivated && state != null) {
                            this.regionStates.updateRegionState(region, RegionState.State.FAILED_CLOSE);
                        }
                        return;
                    }
                }
                if (!logRetries) continue;
                LOG.info((Object)("Server " + server + " returned " + t2 + " for " + region.getRegionNameAsString() + ", try=" + i + " of " + this.maximumAttempts), (Throwable)t2);
            }
        }
        if (!this.tomActivated && state != null) {
            this.regionStates.updateRegionState(region, RegionState.State.FAILED_CLOSE);
        }
    }

    private RegionState forceRegionStateToOffline(HRegionInfo region, boolean forceNewPlan) {
        RegionState state = this.regionStates.getRegionState(region);
        if (state == null) {
            LOG.warn((Object)("Assigning a region not in region states: " + region));
            state = this.regionStates.createRegionState(region);
        }
        ServerName sn = state.getServerName();
        if (forceNewPlan && LOG.isDebugEnabled()) {
            LOG.debug((Object)("Force region state offline " + state));
        }
        switch (state.getState()) {
            case OPEN: 
            case OPENING: 
            case PENDING_OPEN: 
            case CLOSING: 
            case PENDING_CLOSE: {
                if (!forceNewPlan) {
                    LOG.debug((Object)("Skip assigning " + region + ", it is already " + state));
                    return null;
                }
            }
            case FAILED_CLOSE: 
            case FAILED_OPEN: {
                this.unassign(region, state, -1, null, false, null);
                state = this.regionStates.getRegionState(region);
                if (state.isFailedClose()) {
                    LOG.info((Object)("Skip assigning " + region + ", we couldn't close it: " + state));
                    return null;
                }
            }
            case OFFLINE: {
                if (this.regionStates.isServerDeadAndNotProcessed(sn) && this.wasRegionOnDeadServerByMeta(region, sn)) {
                    LOG.info((Object)("Skip assigning " + region.getRegionNameAsString() + ", it is on a dead but not processed yet server"));
                    return null;
                }
            }
            case CLOSED: {
                break;
            }
            default: {
                LOG.error((Object)("Trying to assign region " + region + ", which is " + state));
                return null;
            }
        }
        return state;
    }

    private boolean wasRegionOnDeadServerByMeta(HRegionInfo region, ServerName sn) {
        try {
            if (region.isMetaRegion()) {
                ServerName server = this.catalogTracker.getMetaLocation();
                return this.regionStates.isServerDeadAndNotProcessed(server);
            }
            while (!this.server.isStopped()) {
                try {
                    this.catalogTracker.waitForMeta();
                    Pair r = MetaReader.getRegion((CatalogTracker)this.catalogTracker, (byte[])region.getRegionName());
                    ServerName server = r == null ? null : (ServerName)r.getSecond();
                    return this.regionStates.isServerDeadAndNotProcessed(server);
                }
                catch (IOException ioe) {
                    LOG.info((Object)("Received exception accessing hbase:meta during force assign " + region.getRegionNameAsString() + ", retrying"), (Throwable)ioe);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.info((Object)"Interrupted accessing hbase:meta", (Throwable)e);
        }
        return this.regionStates.isServerDeadAndNotProcessed(sn);
    }

    /*
     * Exception decompiling
     */
    private void assign(RegionState state, boolean setOfflineInZK, boolean forceNewPlan) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void processAlreadyOpenedRegion(HRegionInfo region, ServerName sn) {
        LOG.debug((Object)("ALREADY_OPENED " + region.getRegionNameAsString() + " to " + sn));
        String encodedName = region.getEncodedName();
        this.deleteNodeInStates(encodedName, "offline", sn, EventType.M_ZK_REGION_OFFLINE);
        this.regionStates.regionOnline(region, sn);
    }

    private boolean isDisabledorDisablingRegionInRIT(HRegionInfo region) {
        TableName tableName = region.getTable();
        boolean disabled = this.zkTable.isDisabledTable(tableName);
        if (disabled || this.zkTable.isDisablingTable(tableName)) {
            LOG.info((Object)("Table " + tableName + (disabled ? " disabled;" : " disabling;") + " skipping assign of " + region.getRegionNameAsString()));
            this.offlineDisabledRegion(region);
            return true;
        }
        return false;
    }

    private int setOfflineInZooKeeper(RegionState state, ServerName destination) {
        int versionOfOfflineNode;
        if (!state.isClosed() && !state.isOffline()) {
            String msg = "Unexpected state : " + state + " .. Cannot transit it to OFFLINE.";
            this.server.abort(msg, (Throwable)new IllegalStateException(msg));
            return -1;
        }
        this.regionStates.updateRegionState(state.getRegion(), RegionState.State.OFFLINE);
        try {
            versionOfOfflineNode = ZKAssign.createOrForceNodeOffline((ZooKeeperWatcher)this.watcher, (HRegionInfo)state.getRegion(), (ServerName)destination);
            if (versionOfOfflineNode == -1) {
                LOG.warn((Object)("Attempted to create/force node into OFFLINE state before completing assignment but failed to do so for " + state));
                return -1;
            }
        }
        catch (KeeperException e) {
            this.server.abort("Unexpected ZK exception creating/setting node OFFLINE", (Throwable)e);
            return -1;
        }
        return versionOfOfflineNode;
    }

    private RegionPlan getRegionPlan(HRegionInfo region, boolean forceNewPlan) throws HBaseIOException {
        return this.getRegionPlan(region, null, forceNewPlan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegionPlan getRegionPlan(HRegionInfo region, ServerName serverToExclude, boolean forceNewPlan) throws HBaseIOException {
        RegionPlan existingPlan;
        String encodedName = region.getEncodedName();
        List<ServerName> destServers = this.serverManager.createDestinationServersList(serverToExclude);
        if (destServers.isEmpty()) {
            LOG.warn((Object)("Can't move " + encodedName + ", there is no destination server available."));
            return null;
        }
        RegionPlan randomPlan = null;
        boolean newPlan = false;
        NavigableMap<String, RegionPlan> navigableMap = this.regionPlans;
        synchronized (navigableMap) {
            existingPlan = (RegionPlan)this.regionPlans.get(encodedName);
            if (existingPlan != null && existingPlan.getDestination() != null) {
                LOG.debug((Object)("Found an existing plan for " + region.getRegionNameAsString() + " destination server is " + existingPlan.getDestination() + " accepted as a dest server = " + destServers.contains(existingPlan.getDestination())));
            }
            if (forceNewPlan || existingPlan == null || existingPlan.getDestination() == null || !destServers.contains(existingPlan.getDestination())) {
                newPlan = true;
                randomPlan = new RegionPlan(region, null, this.balancer.randomAssignment(region, destServers));
                if (!region.isMetaTable() && this.shouldAssignRegionsWithFavoredNodes) {
                    ArrayList<HRegionInfo> regions = new ArrayList<HRegionInfo>(1);
                    regions.add(region);
                    try {
                        this.processFavoredNodes(regions);
                    }
                    catch (IOException ie) {
                        LOG.warn((Object)("Ignoring exception in processFavoredNodes " + ie));
                    }
                }
                this.regionPlans.put(encodedName, randomPlan);
            }
        }
        if (newPlan) {
            if (randomPlan.getDestination() == null) {
                LOG.warn((Object)("Can't find a destination for " + encodedName));
                return null;
            }
            LOG.debug((Object)("No previous transition plan found (or ignoring an existing plan) for " + region.getRegionNameAsString() + "; generated random plan=" + randomPlan + "; " + this.serverManager.countOfRegionServers() + " (online=" + this.serverManager.getOnlineServers().size() + ", available=" + destServers.size() + ") available servers" + ", forceNewPlan=" + forceNewPlan));
            return randomPlan;
        }
        LOG.debug((Object)("Using pre-existing plan for " + region.getRegionNameAsString() + "; plan=" + existingPlan));
        return existingPlan;
    }

    public void unassign(HRegionInfo region) {
        this.unassign(region, false);
    }

    /*
     * Exception decompiling
     */
    public void unassign(HRegionInfo region, boolean force, ServerName dest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void unassign(HRegionInfo region, boolean force) {
        this.unassign(region, force, null);
    }

    public void deleteClosingOrClosedNode(HRegionInfo region, ServerName sn) {
        String encodedName = region.getEncodedName();
        this.deleteNodeInStates(encodedName, "closing", sn, EventType.M_ZK_REGION_CLOSING, EventType.RS_ZK_REGION_CLOSED);
    }

    private boolean isSplitOrSplittingOrMergedOrMerging(String path) throws KeeperException, DeserializationException {
        boolean result = false;
        byte[] data = ZKAssign.getData((ZooKeeperWatcher)this.watcher, (String)path);
        if (data == null) {
            LOG.info((Object)("Node " + path + " is gone"));
            return false;
        }
        RegionTransition rt = RegionTransition.parseFrom((byte[])data);
        switch (rt.getEventType()) {
            case RS_ZK_REQUEST_REGION_SPLIT: 
            case RS_ZK_REGION_SPLITTING: 
            case RS_ZK_REGION_SPLIT: 
            case RS_ZK_REQUEST_REGION_MERGE: 
            case RS_ZK_REGION_MERGING: 
            case RS_ZK_REGION_MERGED: {
                result = true;
                break;
            }
            default: {
                LOG.info((Object)("Node " + path + " is in " + rt.getEventType()));
            }
        }
        return result;
    }

    public int getNumRegionsOpened() {
        return this.numRegionsOpened.get();
    }

    public boolean waitForAssignment(HRegionInfo regionInfo) throws InterruptedException {
        while (!this.regionStates.isRegionOnline(regionInfo)) {
            if (this.regionStates.isRegionInState(regionInfo, RegionState.State.FAILED_OPEN) || this.server.isStopped()) {
                return false;
            }
            this.regionStates.waitForUpdate(100L);
        }
        return true;
    }

    public void assignMeta() throws KeeperException {
        MetaRegionTracker.deleteMetaLocation((ZooKeeperWatcher)this.watcher);
        this.assign(HRegionInfo.FIRST_META_REGIONINFO, true);
    }

    public void assign(Map<HRegionInfo, ServerName> regions) throws IOException, InterruptedException {
        if (regions == null || regions.isEmpty()) {
            return;
        }
        List<ServerName> servers = this.serverManager.createDestinationServersList();
        if (servers == null || servers.isEmpty()) {
            throw new IOException("Found no destination server to assign region(s)");
        }
        Map<ServerName, List<HRegionInfo>> bulkPlan = this.balancer.retainAssignment(regions, servers);
        this.assign(regions.size(), servers.size(), "retainAssignment=true", bulkPlan);
    }

    public void assign(List<HRegionInfo> regions) throws IOException, InterruptedException {
        if (regions == null || regions.isEmpty()) {
            return;
        }
        List<ServerName> servers = this.serverManager.createDestinationServersList();
        if (servers == null || servers.isEmpty()) {
            throw new IOException("Found no destination server to assign region(s)");
        }
        Map<ServerName, List<HRegionInfo>> bulkPlan = this.balancer.roundRobinAssignment(regions, servers);
        this.processFavoredNodes(regions);
        this.assign(regions.size(), servers.size(), "round-robin=true", bulkPlan);
    }

    private void assign(int regions, int totalServers, String message, Map<ServerName, List<HRegionInfo>> bulkPlan) throws InterruptedException, IOException {
        int servers = bulkPlan.size();
        if (servers == 1 || regions < this.bulkAssignThresholdRegions && servers < this.bulkAssignThresholdServers) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Not using bulk assignment since we are assigning only " + regions + " region(s) to " + servers + " server(s)"));
            }
            for (Map.Entry<ServerName, List<HRegionInfo>> plan : bulkPlan.entrySet()) {
                if (this.assign(plan.getKey(), plan.getValue())) continue;
                for (HRegionInfo region : plan.getValue()) {
                    if (this.regionStates.isRegionOnline(region)) continue;
                    this.invokeAssign(region);
                }
            }
        } else {
            LOG.info((Object)("Bulk assigning " + regions + " region(s) across " + totalServers + " server(s), " + message));
            GeneralBulkAssigner ba = new GeneralBulkAssigner(this.server, bulkPlan, this, this.bulkAssignWaitTillAllAssigned);
            ba.bulkAssign();
            LOG.info((Object)"Bulk assigning done");
        }
    }

    private void assignAllUserRegions() throws IOException, InterruptedException, KeeperException {
        ZKAssign.deleteAllNodes((ZooKeeperWatcher)this.watcher);
        ZKUtil.listChildrenAndWatchForNewChildren((ZooKeeperWatcher)this.watcher, (String)this.watcher.assignmentZNode);
        this.failoverCleanupDone();
        Set disabledOrDisablingOrEnabling = ZKTable.getDisabledOrDisablingTables((ZooKeeperWatcher)this.watcher);
        disabledOrDisablingOrEnabling.addAll(ZKTable.getEnablingTables((ZooKeeperWatcher)this.watcher));
        SnapshotOfRegionAssignmentFromMeta snapshotOfRegionAssignment = new SnapshotOfRegionAssignmentFromMeta(this.catalogTracker, disabledOrDisablingOrEnabling, true);
        snapshotOfRegionAssignment.initialize();
        Map<HRegionInfo, ServerName> allRegions = snapshotOfRegionAssignment.getRegionToRegionServerMap();
        if (allRegions == null || allRegions.isEmpty()) {
            return;
        }
        boolean retainAssignment = this.server.getConfiguration().getBoolean("hbase.master.startup.retainassign", true);
        Set<HRegionInfo> regionsFromMetaScan = allRegions.keySet();
        if (retainAssignment) {
            this.assign(allRegions);
        } else {
            ArrayList<HRegionInfo> regions = new ArrayList<HRegionInfo>(regionsFromMetaScan);
            this.assign(regions);
        }
        for (HRegionInfo hri : regionsFromMetaScan) {
            TableName tableName = hri.getTable();
            if (this.zkTable.isEnabledTable(tableName)) continue;
            this.setEnabledTable(tableName);
        }
        this.assign(AssignmentManager.replicaRegionsNotRecordedInMeta(regionsFromMetaScan, (MasterServices)this.server));
    }

    public static List<HRegionInfo> replicaRegionsNotRecordedInMeta(Set<HRegionInfo> regionsRecordedInMeta, MasterServices master) throws IOException {
        ArrayList<HRegionInfo> regionsNotRecordedInMeta = new ArrayList<HRegionInfo>();
        for (HRegionInfo hri : regionsRecordedInMeta) {
            TableName table = hri.getTable();
            HTableDescriptor htd = master.getTableDescriptors().get(table);
            int desiredRegionReplication = htd.getRegionReplication();
            for (int i = 0; i < desiredRegionReplication; ++i) {
                HRegionInfo replica = RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)hri, (int)i);
                if (regionsRecordedInMeta.contains(replica)) continue;
                regionsNotRecordedInMeta.add(replica);
            }
        }
        return regionsNotRecordedInMeta;
    }

    boolean waitUntilNoRegionsInTransition(long timeout) throws InterruptedException {
        long endTime = System.currentTimeMillis() + timeout;
        while (!this.server.isStopped() && this.regionStates.isRegionsInTransition() && endTime > System.currentTimeMillis()) {
            this.regionStates.waitForUpdate(100L);
        }
        return !this.regionStates.isRegionsInTransition();
    }

    Map<ServerName, List<HRegionInfo>> rebuildUserRegions() throws IOException, KeeperException {
        Set enablingTables = ZKTable.getEnablingTables((ZooKeeperWatcher)this.watcher);
        Set disabledOrEnablingTables = ZKTable.getDisabledTables((ZooKeeperWatcher)this.watcher);
        disabledOrEnablingTables.addAll(enablingTables);
        Set disabledOrDisablingOrEnabling = ZKTable.getDisablingTables((ZooKeeperWatcher)this.watcher);
        disabledOrDisablingOrEnabling.addAll(disabledOrEnablingTables);
        List results = MetaReader.fullScan((CatalogTracker)this.catalogTracker);
        Set<ServerName> onlineServers = this.serverManager.getOnlineServers().keySet();
        TreeMap<ServerName, List<HRegionInfo>> offlineServers = new TreeMap<ServerName, List<HRegionInfo>>();
        for (Result result : results) {
            HRegionLocation[] locations;
            if (result == null && LOG.isDebugEnabled()) {
                LOG.debug((Object)"null result from meta - ignoring but this is strange.");
                continue;
            }
            RegionLocations rl = MetaReader.getRegionLocations((Result)result);
            if (rl == null || (locations = rl.getRegionLocations()) == null) continue;
            for (HRegionLocation hrl : locations) {
                if (hrl == null) continue;
                ServerName regionLocation = hrl.getServerName();
                HRegionInfo regionInfo = hrl.getRegionInfo();
                this.regionStates.createRegionState(regionInfo);
                if (this.regionStates.isRegionInState(regionInfo, RegionState.State.SPLIT)) {
                    LOG.debug((Object)("Region " + regionInfo.getRegionNameAsString() + " split is completed. Hence need not add to regions list"));
                    continue;
                }
                TableName tableName = regionInfo.getTable();
                if (regionLocation == null) {
                    if (enablingTables.contains(tableName)) continue;
                    LOG.warn((Object)("Region " + regionInfo.getEncodedName() + " has null regionLocation." + " But its table " + tableName + " isn't in ENABLING state."));
                    continue;
                }
                if (!onlineServers.contains(regionLocation)) {
                    ArrayList<HRegionInfo> offlineRegions = (ArrayList<HRegionInfo>)offlineServers.get(regionLocation);
                    if (offlineRegions == null) {
                        offlineRegions = new ArrayList<HRegionInfo>(1);
                        offlineServers.put(regionLocation, offlineRegions);
                    }
                    offlineRegions.add(regionInfo);
                    if (disabledOrDisablingOrEnabling.contains(tableName) || this.getZKTable().isEnabledTable(tableName)) continue;
                    this.setEnabledTable(tableName);
                    continue;
                }
                if (!disabledOrEnablingTables.contains(tableName)) {
                    this.regionStates.updateRegionState(regionInfo, RegionState.State.OPEN, regionLocation);
                    this.regionStates.regionOnline(regionInfo, regionLocation);
                }
                if (disabledOrDisablingOrEnabling.contains(tableName) || this.getZKTable().isEnabledTable(tableName)) continue;
                this.setEnabledTable(tableName);
            }
        }
        return offlineServers;
    }

    private void recoverTableInDisablingState() throws KeeperException, TableNotFoundException, IOException {
        Set disablingTables = ZKTable.getDisablingTables((ZooKeeperWatcher)this.watcher);
        if (disablingTables.size() != 0) {
            for (TableName tableName : disablingTables) {
                LOG.info((Object)("The table " + tableName + " is in DISABLING state.  Hence recovering by moving the table" + " to DISABLED state."));
                new DisableTableHandler(this.server, tableName, this.catalogTracker, this, this.tableLockManager, true).prepare().process();
            }
        }
    }

    private void recoverTableInEnablingState() throws KeeperException, TableNotFoundException, IOException {
        Set enablingTables = ZKTable.getEnablingTables((ZooKeeperWatcher)this.watcher);
        if (enablingTables.size() != 0) {
            for (TableName tableName : enablingTables) {
                LOG.info((Object)("The table " + tableName + " is in ENABLING state.  Hence recovering by moving the table" + " to ENABLED state."));
                EnableTableHandler eth = new EnableTableHandler(this.server, tableName, this.catalogTracker, this, this.tableLockManager, true);
                try {
                    eth.prepare();
                }
                catch (TableNotFoundException e) {
                    LOG.warn((Object)("Table " + tableName + " not found in hbase:meta to recover."));
                    continue;
                }
                eth.process();
            }
        }
    }

    private void processDeadServersAndRecoverLostRegions(Map<ServerName, List<HRegionInfo>> deadServers) throws IOException, KeeperException {
        List nodes;
        if (deadServers != null) {
            for (Map.Entry<ServerName, List<HRegionInfo>> server : deadServers.entrySet()) {
                ServerName serverName = server.getKey();
                this.regionStates.setLastRegionServerOfRegions(serverName, server.getValue());
                if (this.serverManager.isServerDead(serverName)) continue;
                this.serverManager.expireServer(serverName);
            }
        }
        if (!(nodes = ZKUtil.listChildrenAndWatchForNewChildren((ZooKeeperWatcher)this.watcher, (String)this.watcher.assignmentZNode)).isEmpty()) {
            for (String encodedRegionName : nodes) {
                this.processRegionInTransition(encodedRegionName, null);
            }
        }
        this.failoverCleanupDone();
    }

    public void updateRegionsInTransitionMetrics() {
        long currentTime = System.currentTimeMillis();
        int totalRITs = 0;
        int totalRITsOverThreshold = 0;
        long oldestRITTime = 0L;
        int ritThreshold = this.server.getConfiguration().getInt("hbase.metrics.rit.stuck.warning.threshold", 60000);
        for (RegionState state : this.regionStates.getRegionsInTransition().values()) {
            ++totalRITs;
            long ritTime = currentTime - state.getStamp();
            if (ritTime > (long)ritThreshold) {
                ++totalRITsOverThreshold;
            }
            if (oldestRITTime >= ritTime) continue;
            oldestRITTime = ritTime;
        }
        if (this.metricsAssignmentManager != null) {
            this.metricsAssignmentManager.updateRITOldestAge(oldestRITTime);
            this.metricsAssignmentManager.updateRITCount(totalRITs);
            this.metricsAssignmentManager.updateRITCountOverThreshold(totalRITsOverThreshold);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearRegionPlan(HRegionInfo region) {
        NavigableMap<String, RegionPlan> navigableMap = this.regionPlans;
        synchronized (navigableMap) {
            this.regionPlans.remove(region.getEncodedName());
        }
    }

    public void waitOnRegionToClearRegionsInTransition(HRegionInfo hri) throws IOException, InterruptedException {
        this.waitOnRegionToClearRegionsInTransition(hri, -1L);
    }

    public boolean waitOnRegionToClearRegionsInTransition(HRegionInfo hri, long timeOut) throws InterruptedException {
        if (!this.regionStates.isRegionInTransition(hri)) {
            return true;
        }
        long end = timeOut <= 0L ? Long.MAX_VALUE : EnvironmentEdgeManager.currentTimeMillis() + timeOut;
        LOG.info((Object)("Waiting for " + hri.getEncodedName() + " to leave regions-in-transition, timeOut=" + timeOut + " ms."));
        while (!this.server.isStopped() && this.regionStates.isRegionInTransition(hri)) {
            this.regionStates.waitForUpdate(100L);
            if (EnvironmentEdgeManager.currentTimeMillis() <= end) continue;
            LOG.info((Object)("Timed out on waiting for " + hri.getEncodedName() + " to be assigned."));
            return false;
        }
        if (this.server.isStopped()) {
            LOG.info((Object)"Giving up wait on regions in transition because stoppable.isStopped is set");
            return false;
        }
        return true;
    }

    private void processOpeningState(HRegionInfo regionInfo) {
        LOG.info((Object)("Region has been OPENING for too long, reassigning region=" + regionInfo.getRegionNameAsString()));
        try {
            String node = ZKAssign.getNodeName((ZooKeeperWatcher)this.watcher, (String)regionInfo.getEncodedName());
            Stat stat = new Stat();
            byte[] data = ZKAssign.getDataNoWatch((ZooKeeperWatcher)this.watcher, (String)node, (Stat)stat);
            if (data == null) {
                LOG.warn((Object)("Data is null, node " + node + " no longer exists"));
                return;
            }
            RegionTransition rt = RegionTransition.parseFrom((byte[])data);
            EventType et = rt.getEventType();
            if (et == EventType.RS_ZK_REGION_OPENED) {
                LOG.debug((Object)"Region has transitioned to OPENED, allowing watched event handlers to process");
                return;
            }
            if (et != EventType.RS_ZK_REGION_OPENING && et != EventType.RS_ZK_REGION_FAILED_OPEN) {
                LOG.warn((Object)("While timing out a region, found ZK node in unexpected state: " + et));
                return;
            }
            this.invokeAssign(regionInfo);
        }
        catch (KeeperException ke) {
            LOG.error((Object)"Unexpected ZK exception timing out CLOSING region", (Throwable)ke);
        }
        catch (DeserializationException e) {
            LOG.error((Object)"Unexpected exception parsing CLOSING region", (Throwable)e);
        }
    }

    void invokeAssign(HRegionInfo regionInfo) {
        this.threadPoolExecutorService.submit(new AssignCallable(this, regionInfo));
    }

    private void invokeUnassign(HRegionInfo regionInfo) {
        this.threadPoolExecutorService.submit(new UnAssignCallable(this, regionInfo));
    }

    public boolean isCarryingMeta(ServerName serverName) {
        return this.isCarryingRegion(serverName, HRegionInfo.FIRST_META_REGIONINFO);
    }

    private boolean isCarryingRegion(ServerName serverName, HRegionInfo hri) {
        ServerName addressFromZK;
        RegionTransition rt = null;
        try {
            byte[] data = ZKAssign.getData((ZooKeeperWatcher)this.watcher, (String)hri.getEncodedName());
            rt = data == null ? null : RegionTransition.parseFrom((byte[])data);
        }
        catch (KeeperException e) {
            this.server.abort("Exception reading unassigned node for region=" + hri.getEncodedName(), (Throwable)e);
        }
        catch (DeserializationException e) {
            this.server.abort("Exception parsing unassigned node for region=" + hri.getEncodedName(), (Throwable)e);
        }
        ServerName serverName2 = addressFromZK = rt != null ? rt.getServerName() : null;
        if (addressFromZK != null) {
            boolean matchZK = addressFromZK.equals((Object)serverName);
            LOG.debug((Object)("Checking region=" + hri.getRegionNameAsString() + ", zk server=" + addressFromZK + " current=" + serverName + ", matches=" + matchZK));
            return matchZK;
        }
        ServerName addressFromAM = this.regionStates.getRegionServerOfRegion(hri);
        boolean matchAM = addressFromAM != null && addressFromAM.equals((Object)serverName);
        LOG.debug((Object)("based on AM, current region=" + hri.getRegionNameAsString() + " is on server=" + (addressFromAM != null ? addressFromAM : "null") + " server being checked: " + serverName));
        return matchAM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HRegionInfo> processServerShutdown(ServerName sn) {
        NavigableMap<String, RegionPlan> navigableMap = this.regionPlans;
        synchronized (navigableMap) {
            Iterator i = this.regionPlans.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                ServerName otherSn = ((RegionPlan)e.getValue()).getDestination();
                if (otherSn == null || !otherSn.equals((Object)sn)) continue;
                i.remove();
            }
        }
        List<HRegionInfo> regions = this.regionStates.serverOffline(this.watcher, sn);
        Iterator<HRegionInfo> it = regions.iterator();
        while (it.hasNext()) {
            HRegionInfo hri = it.next();
            String encodedName = hri.getEncodedName();
            ReentrantLock lock = this.locker.acquireLock((Comparable)((Object)encodedName));
            try {
                RegionState regionState = this.regionStates.getRegionTransitionState(encodedName);
                if (regionState == null || regionState.getServerName() != null && !regionState.isOnServer(sn) || !regionState.isFailedClose() && !regionState.isOffline() && !regionState.isPendingOpenOrOpening()) {
                    LOG.info((Object)("Skip " + regionState + " since it is not opening/failed_close" + " on the dead server any more: " + sn));
                    it.remove();
                    continue;
                }
                try {
                    ZKAssign.deleteNodeFailSilent((ZooKeeperWatcher)this.watcher, (HRegionInfo)hri);
                }
                catch (KeeperException ke) {
                    this.server.abort("Unexpected ZK exception deleting node " + hri, (Throwable)ke);
                }
                if (this.zkTable.isDisablingOrDisabledTable(hri.getTable())) {
                    this.regionStates.regionOffline(hri);
                    it.remove();
                    continue;
                }
                this.regionStates.updateRegionState(hri, RegionState.State.OFFLINE);
            }
            finally {
                lock.unlock();
            }
        }
        return regions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void balance(RegionPlan plan) {
        HRegionInfo hri = plan.getRegionInfo();
        TableName tableName = hri.getTable();
        if (this.zkTable.isDisablingOrDisabledTable(tableName)) {
            LOG.info((Object)("Ignored moving region of disabling/disabled table " + tableName));
            return;
        }
        String encodedName = hri.getEncodedName();
        ReentrantLock lock = this.locker.acquireLock((Comparable)((Object)encodedName));
        try {
            if (!this.regionStates.isRegionOnline(hri)) {
                RegionState state = this.regionStates.getRegionState(encodedName);
                LOG.info((Object)("Ignored moving region not assigned: " + hri + ", " + (state == null ? "not in region states" : state)));
                return;
            }
            NavigableMap<String, RegionPlan> navigableMap = this.regionPlans;
            synchronized (navigableMap) {
                this.regionPlans.put(plan.getRegionName(), plan);
            }
            this.unassign(hri, false, plan.getDestination());
        }
        finally {
            lock.unlock();
        }
    }

    public void stop() {
        if (this.tomActivated) {
            this.timeoutMonitor.interrupt();
            this.timerUpdater.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        LinkedHashMultimap<String, RegionRunnable> linkedHashMultimap = this.zkEventWorkerWaitingList;
        synchronized (linkedHashMultimap) {
            this.zkEventWorkerWaitingList.clear();
        }
        this.threadPoolExecutorService.shutdownNow();
        this.zkEventWorkers.shutdownNow();
    }

    protected void setEnabledTable(TableName tableName) {
        try {
            this.zkTable.setEnabledTable(tableName);
        }
        catch (KeeperException e) {
            String errorMsg = "Unable to ensure that the table " + tableName + " will be" + " enabled because of a ZooKeeper issue";
            LOG.error((Object)errorMsg);
            this.server.abort(errorMsg, (Throwable)e);
        }
    }

    private boolean asyncSetOfflineInZooKeeper(RegionState state, AsyncCallback.StringCallback cb, ServerName destination) {
        if (!state.isClosed() && !state.isOffline()) {
            this.server.abort("Unexpected state trying to OFFLINE; " + state, (Throwable)new IllegalStateException());
            return false;
        }
        this.regionStates.updateRegionState(state.getRegion(), RegionState.State.OFFLINE);
        try {
            ZKAssign.asyncCreateNodeOffline((ZooKeeperWatcher)this.watcher, (HRegionInfo)state.getRegion(), (ServerName)destination, (AsyncCallback.StringCallback)cb, (Object)state);
        }
        catch (KeeperException e) {
            if (e instanceof KeeperException.NodeExistsException) {
                LOG.warn((Object)("Node for " + state.getRegion() + " already exists"));
            } else {
                this.server.abort("Unexpected ZK exception creating/setting node OFFLINE", (Throwable)e);
            }
            return false;
        }
        return true;
    }

    private boolean deleteNodeInStates(String encodedName, String desc, ServerName sn, EventType ... types) {
        try {
            for (EventType et : types) {
                if (!ZKAssign.deleteNode((ZooKeeperWatcher)this.watcher, (String)encodedName, (EventType)et, (ServerName)sn)) continue;
                return true;
            }
            LOG.info((Object)("Failed to delete the " + desc + " node for " + encodedName + ". The node type may not match"));
        }
        catch (KeeperException.NoNodeException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The " + desc + " node for " + encodedName + " already deleted"));
            }
        }
        catch (KeeperException ke) {
            this.server.abort("Unexpected ZK exception deleting " + desc + " node for the region " + encodedName, (Throwable)ke);
        }
        return false;
    }

    private void deleteMergingNode(String encodedName, ServerName sn) {
        this.deleteNodeInStates(encodedName, "merging", sn, EventType.RS_ZK_REGION_MERGING, EventType.RS_ZK_REQUEST_REGION_MERGE, EventType.RS_ZK_REGION_MERGED);
    }

    private void deleteSplittingNode(String encodedName, ServerName sn) {
        this.deleteNodeInStates(encodedName, "splitting", sn, EventType.RS_ZK_REGION_SPLITTING, EventType.RS_ZK_REQUEST_REGION_SPLIT, EventType.RS_ZK_REGION_SPLIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleRegionMerging(RegionTransition rt, String encodedName, String prettyPrintedRegionName, ServerName sn) {
        List mergingRegions;
        if (!this.serverManager.isServerOnline(sn)) {
            LOG.warn((Object)("Dropped merging! ServerName=" + sn + " unknown."));
            return false;
        }
        byte[] payloadOfMerging = rt.getPayload();
        try {
            mergingRegions = HRegionInfo.parseDelimitedFrom((byte[])payloadOfMerging, (int)0, (int)payloadOfMerging.length);
        }
        catch (IOException e) {
            LOG.error((Object)("Dropped merging! Failed reading " + rt.getEventType() + " payload for " + prettyPrintedRegionName));
            return false;
        }
        assert (mergingRegions.size() == 3);
        HRegionInfo p = (HRegionInfo)mergingRegions.get(0);
        HRegionInfo hri_a = (HRegionInfo)mergingRegions.get(1);
        HRegionInfo hri_b = (HRegionInfo)mergingRegions.get(2);
        RegionState rs_p = this.regionStates.getRegionState(p);
        RegionState rs_a = this.regionStates.getRegionState(hri_a);
        RegionState rs_b = this.regionStates.getRegionState(hri_b);
        if (rs_a != null && !rs_a.isOpenOrMergingOnServer(sn) || rs_b != null && !rs_b.isOpenOrMergingOnServer(sn) || rs_p != null && !rs_p.isOpenOrMergingNewOnServer(sn)) {
            LOG.warn((Object)("Dropped merging! Not in state good for MERGING; rs_p=" + rs_p + ", rs_a=" + rs_a + ", rs_b=" + rs_b));
            return false;
        }
        EventType et = rt.getEventType();
        if (et == EventType.RS_ZK_REQUEST_REGION_MERGE) {
            try {
                if (RegionMergeTransaction.transitionMergingNode(this.watcher, p, hri_a, hri_b, sn, -1, EventType.RS_ZK_REQUEST_REGION_MERGE, EventType.RS_ZK_REGION_MERGING) == -1) {
                    byte[] data = ZKAssign.getData((ZooKeeperWatcher)this.watcher, (String)encodedName);
                    EventType currentType = null;
                    if (data != null) {
                        RegionTransition newRt = RegionTransition.parseFrom((byte[])data);
                        currentType = newRt.getEventType();
                    }
                    if (currentType == null || currentType != EventType.RS_ZK_REGION_MERGED && currentType != EventType.RS_ZK_REGION_MERGING) {
                        LOG.warn((Object)("Failed to transition pending_merge node " + encodedName + " to merging, it's now " + currentType));
                        return false;
                    }
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("Failed to transition pending_merge node " + encodedName + " to merging"), (Throwable)e);
                return false;
            }
        }
        RegionStates e = this.regionStates;
        synchronized (e) {
            this.regionStates.updateRegionState(hri_a, RegionState.State.MERGING);
            this.regionStates.updateRegionState(hri_b, RegionState.State.MERGING);
            this.regionStates.updateRegionState(p, RegionState.State.MERGING_NEW, sn);
            if (et != EventType.RS_ZK_REGION_MERGED) {
                this.regionStates.regionOffline(p, RegionState.State.MERGING_NEW);
                this.mergingRegions.put(encodedName, (PairOfSameType<HRegionInfo>)new PairOfSameType((Object)hri_a, (Object)hri_b));
            } else {
                this.mergingRegions.remove(encodedName);
                this.regionOffline(hri_a, RegionState.State.MERGED);
                this.regionOffline(hri_b, RegionState.State.MERGED);
                this.regionOnline(p, sn);
            }
        }
        if (et == EventType.RS_ZK_REGION_MERGED) {
            LOG.debug((Object)("Handling MERGED event for " + encodedName + "; deleting node"));
            try {
                boolean successful = false;
                while (!successful) {
                    successful = ZKAssign.deleteNode((ZooKeeperWatcher)this.watcher, (String)encodedName, (EventType)EventType.RS_ZK_REGION_MERGED, (ServerName)sn);
                }
            }
            catch (KeeperException e2) {
                if (e2 instanceof KeeperException.NoNodeException) {
                    String znodePath = ZKUtil.joinZNode((String)this.watcher.splitLogZNode, (String)encodedName);
                    LOG.debug((Object)("The znode " + znodePath + " does not exist.  May be deleted already."));
                }
                this.server.abort("Error deleting MERGED node " + encodedName, (Throwable)e2);
            }
            LOG.info((Object)("Handled MERGED event; merged=" + p.getRegionNameAsString() + ", region_a=" + hri_a.getRegionNameAsString() + ", region_b=" + hri_b.getRegionNameAsString() + ", on " + sn));
            if (this.zkTable.isDisablingOrDisabledTable(p.getTable())) {
                this.unassign(p);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleRegionSplitting(RegionTransition rt, String encodedName, String prettyPrintedRegionName, ServerName sn) {
        List splittingRegions;
        if (!this.serverManager.isServerOnline(sn)) {
            LOG.warn((Object)("Dropped splitting! ServerName=" + sn + " unknown."));
            return false;
        }
        byte[] payloadOfSplitting = rt.getPayload();
        try {
            splittingRegions = HRegionInfo.parseDelimitedFrom((byte[])payloadOfSplitting, (int)0, (int)payloadOfSplitting.length);
        }
        catch (IOException e) {
            LOG.error((Object)("Dropped splitting! Failed reading " + rt.getEventType() + " payload for " + prettyPrintedRegionName));
            return false;
        }
        assert (splittingRegions.size() == 2);
        HRegionInfo hri_a = (HRegionInfo)splittingRegions.get(0);
        HRegionInfo hri_b = (HRegionInfo)splittingRegions.get(1);
        RegionState rs_p = this.regionStates.getRegionState(encodedName);
        RegionState rs_a = this.regionStates.getRegionState(hri_a);
        RegionState rs_b = this.regionStates.getRegionState(hri_b);
        if (rs_p != null && !rs_p.isOpenOrSplittingOnServer(sn) || rs_a != null && !rs_a.isOpenOrSplittingNewOnServer(sn) || rs_b != null && !rs_b.isOpenOrSplittingNewOnServer(sn)) {
            LOG.warn((Object)("Dropped splitting! Not in state good for SPLITTING; rs_p=" + rs_p + ", rs_a=" + rs_a + ", rs_b=" + rs_b));
            return false;
        }
        if (rs_p == null) {
            rs_p = this.regionStates.updateRegionState(rt, RegionState.State.OPEN);
            if (rs_p == null) {
                LOG.warn((Object)("Received splitting for region " + prettyPrintedRegionName + " from server " + sn + " but it doesn't exist anymore," + " probably already processed its split"));
                return false;
            }
            this.regionStates.regionOnline(rs_p.getRegion(), sn);
        }
        HRegionInfo p = rs_p.getRegion();
        EventType et = rt.getEventType();
        if (et == EventType.RS_ZK_REQUEST_REGION_SPLIT) {
            try {
                if (SplitTransaction.transitionSplittingNode(this.watcher, p, hri_a, hri_b, sn, -1, EventType.RS_ZK_REQUEST_REGION_SPLIT, EventType.RS_ZK_REGION_SPLITTING) == -1) {
                    byte[] data = ZKAssign.getData((ZooKeeperWatcher)this.watcher, (String)encodedName);
                    EventType currentType = null;
                    if (data != null) {
                        RegionTransition newRt = RegionTransition.parseFrom((byte[])data);
                        currentType = newRt.getEventType();
                    }
                    if (currentType == null || currentType != EventType.RS_ZK_REGION_SPLIT && currentType != EventType.RS_ZK_REGION_SPLITTING) {
                        LOG.warn((Object)("Failed to transition pending_split node " + encodedName + " to splitting, it's now " + currentType));
                        return false;
                    }
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("Failed to transition pending_split node " + encodedName + " to splitting"), (Throwable)e);
                return false;
            }
        }
        RegionStates e = this.regionStates;
        synchronized (e) {
            this.regionStates.updateRegionState(hri_a, RegionState.State.SPLITTING_NEW, sn);
            this.regionStates.updateRegionState(hri_b, RegionState.State.SPLITTING_NEW, sn);
            this.regionStates.regionOffline(hri_a, RegionState.State.SPLITTING_NEW);
            this.regionStates.regionOffline(hri_b, RegionState.State.SPLITTING_NEW);
            this.regionStates.updateRegionState(rt, RegionState.State.SPLITTING);
            if (TEST_SKIP_SPLIT_HANDLING) {
                LOG.warn((Object)"Skipping split message, TEST_SKIP_SPLIT_HANDLING is set");
                return true;
            }
            if (et == EventType.RS_ZK_REGION_SPLIT) {
                this.regionOffline(p, RegionState.State.SPLIT);
                this.regionOnline(hri_a, sn);
                this.regionOnline(hri_b, sn);
            }
        }
        if (et == EventType.RS_ZK_REGION_SPLIT) {
            LOG.debug((Object)("Handling SPLIT event for " + encodedName + "; deleting node"));
            try {
                boolean successful = false;
                while (!successful) {
                    successful = ZKAssign.deleteNode((ZooKeeperWatcher)this.watcher, (String)encodedName, (EventType)EventType.RS_ZK_REGION_SPLIT, (ServerName)sn);
                }
            }
            catch (KeeperException e2) {
                if (e2 instanceof KeeperException.NoNodeException) {
                    String znodePath = ZKUtil.joinZNode((String)this.watcher.splitLogZNode, (String)encodedName);
                    LOG.debug((Object)("The znode " + znodePath + " does not exist.  May be deleted already."));
                }
                this.server.abort("Error deleting SPLIT node " + encodedName, (Throwable)e2);
            }
            LOG.info((Object)("Handled SPLIT event; parent=" + p.getRegionNameAsString() + ", daughter a=" + hri_a.getRegionNameAsString() + ", daughter b=" + hri_b.getRegionNameAsString() + ", on " + sn));
            if (this.zkTable.isDisablingOrDisabledTable(p.getTable())) {
                this.unassign(hri_a);
                this.unassign(hri_b);
            }
        }
        return true;
    }

    private void regionOffline(HRegionInfo regionInfo, RegionState.State state) {
        this.regionStates.regionOffline(regionInfo, state);
        this.removeClosedRegion(regionInfo);
        this.clearRegionPlan(regionInfo);
    }

    public LoadBalancer getBalancer() {
        return this.balancer;
    }

    public Map<ServerName, List<HRegionInfo>> getSnapShotOfAssignment(Collection<HRegionInfo> infos) {
        return this.getRegionStates().getRegionAssignments(infos);
    }

    public class TimeoutMonitor
    extends Chore {
        private boolean allRegionServersOffline;
        private ServerManager serverManager;
        private final int timeout;

        public TimeoutMonitor(int period, Stoppable stopper, ServerManager serverManager, int timeout) {
            super("AssignmentTimeoutMonitor", period, stopper);
            this.allRegionServersOffline = false;
            this.timeout = timeout;
            this.serverManager = serverManager;
        }

        private synchronized void setAllRegionServersOffline(boolean allRegionServersOffline) {
            this.allRegionServersOffline = allRegionServersOffline;
        }

        protected void chore() {
            Preconditions.checkState((boolean)AssignmentManager.this.tomActivated);
            boolean noRSAvailable = this.serverManager.createDestinationServersList().isEmpty();
            long now = System.currentTimeMillis();
            for (String regionName : AssignmentManager.this.regionStates.getRegionsInTransition().keySet()) {
                RegionPlan existingPlan;
                RegionState regionState = AssignmentManager.this.regionStates.getRegionTransitionState(regionName);
                if (regionState == null) continue;
                if (regionState.getStamp() + (long)this.timeout <= now) {
                    this.actOnTimeOut(regionState);
                    continue;
                }
                if (!this.allRegionServersOffline || noRSAvailable || (existingPlan = (RegionPlan)AssignmentManager.this.regionPlans.get(regionName)) != null && this.serverManager.isServerOnline(existingPlan.getDestination())) continue;
                this.actOnTimeOut(regionState);
            }
            this.setAllRegionServersOffline(noRSAvailable);
        }

        private void actOnTimeOut(RegionState regionState) {
            HRegionInfo regionInfo = regionState.getRegion();
            LOG.info((Object)("Regions in transition timed out:  " + regionState));
            switch (regionState.getState()) {
                case CLOSED: {
                    LOG.info((Object)("Region " + regionInfo.getEncodedName() + " has been CLOSED for too long, waiting on queued " + "ClosedRegionHandler to run or server shutdown"));
                    regionState.updateTimestampToNow();
                    break;
                }
                case OFFLINE: {
                    LOG.info((Object)("Region has been OFFLINE for too long, reassigning " + regionInfo.getRegionNameAsString() + " to a random server"));
                    AssignmentManager.this.invokeAssign(regionInfo);
                    break;
                }
                case PENDING_OPEN: {
                    LOG.info((Object)("Region has been PENDING_OPEN for too long, reassigning region=" + regionInfo.getRegionNameAsString()));
                    AssignmentManager.this.invokeAssign(regionInfo);
                    break;
                }
                case OPENING: {
                    AssignmentManager.this.processOpeningState(regionInfo);
                    break;
                }
                case OPEN: {
                    LOG.error((Object)"Region has been OPEN for too long, we don't know where region was opened so can't do anything");
                    regionState.updateTimestampToNow();
                    break;
                }
                case PENDING_CLOSE: {
                    LOG.info((Object)("Region has been PENDING_CLOSE for too long, running forced unassign again on region=" + regionInfo.getRegionNameAsString()));
                    AssignmentManager.this.invokeUnassign(regionInfo);
                    break;
                }
                case CLOSING: {
                    LOG.info((Object)"Region has been CLOSING for too long, this should eventually complete or the server will expire, send RPC again");
                    AssignmentManager.this.invokeUnassign(regionInfo);
                    break;
                }
                case FAILED_CLOSE: 
                case FAILED_OPEN: 
                case SPLIT: 
                case SPLITTING: 
                case MERGING: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Received event is not valid.");
                }
            }
        }

        static /* synthetic */ void access$1300(TimeoutMonitor x0, boolean x1) {
            x0.setAllRegionServersOffline(x1);
        }
    }

    public class TimerUpdater
    extends Chore {
        public TimerUpdater(int period, Stoppable stopper) {
            super("AssignmentTimerUpdater", period, stopper);
        }

        protected void chore() {
            Preconditions.checkState((boolean)AssignmentManager.this.tomActivated);
            ServerName serverToUpdateTimer = null;
            while (!AssignmentManager.this.serversInUpdatingTimer.isEmpty() && !this.stopper.isStopped() && (serverToUpdateTimer = serverToUpdateTimer == null ? (ServerName)AssignmentManager.this.serversInUpdatingTimer.first() : (ServerName)AssignmentManager.this.serversInUpdatingTimer.higher(serverToUpdateTimer)) != null) {
                AssignmentManager.this.updateTimers(serverToUpdateTimer);
                AssignmentManager.this.serversInUpdatingTimer.remove(serverToUpdateTimer);
            }
        }
    }

    private static interface RegionRunnable
    extends Runnable {
        public String getRegionName();
    }
}

