/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Chore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.util.StringUtils;

public class StorefileRefresherChore
extends Chore {
    private static final Log LOG = LogFactory.getLog(StorefileRefresherChore.class);
    public static final String REGIONSERVER_STOREFILE_REFRESH_PERIOD = "hbase.regionserver.storefile.refresh.period";
    static final int DEFAULT_REGIONSERVER_STOREFILE_REFRESH_PERIOD = 0;
    private HRegionServer regionServer;
    private long hfileTtl;
    private int period;
    private Map<String, Long> lastRefreshTimes;

    public StorefileRefresherChore(int period, HRegionServer regionServer, Stoppable stoppable) {
        super("StorefileRefresherChore", period, stoppable);
        this.period = period;
        this.regionServer = regionServer;
        this.hfileTtl = this.regionServer.getConfiguration().getLong("hbase.master.hfilecleaner.ttl", 300000L);
        if ((long)period > this.hfileTtl / 2L) {
            throw new RuntimeException("hbase.regionserver.storefile.refresh.period should be set smaller than half of hbase.master.hfilecleaner.ttl");
        }
        this.lastRefreshTimes = new HashMap<String, Long>();
    }

    protected void chore() {
        for (HRegion r : this.regionServer.getOnlineRegionsLocalContext()) {
            if (!r.writestate.isReadOnly()) continue;
            String encodedName = r.getRegionInfo().getEncodedName();
            long time = EnvironmentEdgeManager.currentTimeMillis();
            if (!this.lastRefreshTimes.containsKey(encodedName)) {
                this.lastRefreshTimes.put(encodedName, time);
            }
            try {
                for (Store store : r.getStores().values()) {
                    store.refreshStoreFiles();
                }
            }
            catch (IOException ex) {
                LOG.warn((Object)("Exception while trying to refresh store files for region:" + r.getRegionInfo() + ", exception:" + StringUtils.stringifyException((Throwable)ex)));
                if (!this.isRegionStale(encodedName, time)) continue;
                r.setReadsEnabled(false);
                continue;
            }
            this.lastRefreshTimes.put(encodedName, time);
            r.setReadsEnabled(true);
        }
        Iterator<String> lastRefreshTimesIter = this.lastRefreshTimes.keySet().iterator();
        while (lastRefreshTimesIter.hasNext()) {
            String encodedName = lastRefreshTimesIter.next();
            if (this.regionServer.getFromOnlineRegions(encodedName) != null) continue;
            lastRefreshTimesIter.remove();
        }
    }

    protected boolean isRegionStale(String encodedName, long time) {
        long lastRefreshTime = this.lastRefreshTimes.get(encodedName);
        return time - lastRefreshTime > this.hfileTtl - (long)this.period;
    }
}

