/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;

public class HLogUtil {
    static final Log LOG = LogFactory.getLog(HLogUtil.class);
    private static final Pattern pattern = Pattern.compile(".*\\.\\d*(.meta)*");

    public static boolean validateHLogFilename(String filename) {
        return pattern.matcher(filename).matches();
    }

    public static String getHLogDirectoryName(String serverName) {
        StringBuilder dirName = new StringBuilder("WALs");
        dirName.append("/");
        dirName.append(serverName);
        return dirName.toString();
    }

    public static Path getRegionDirRecoveredEditsDir(Path regiondir) {
        return new Path(regiondir, "recovered.edits");
    }

    public static Path moveAsideBadEditsFile(FileSystem fs, Path edits) throws IOException {
        Path moveAsideName = new Path(edits.getParent(), edits.getName() + "." + System.currentTimeMillis());
        if (!fs.rename(edits, moveAsideName)) {
            LOG.warn((Object)("Rename failed from " + edits + " to " + moveAsideName));
        }
        return moveAsideName;
    }

    public static ServerName getServerNameFromHLogDirectoryName(Configuration conf, String path) throws IOException {
        String fullPath;
        if (path == null || path.length() <= "WALs".length()) {
            return null;
        }
        if (conf == null) {
            throw new IllegalArgumentException("parameter conf must be set");
        }
        String rootDir = conf.get("hbase.rootdir");
        if (rootDir == null || rootDir.isEmpty()) {
            throw new IllegalArgumentException("hbase.rootdir key not found in conf.");
        }
        StringBuilder startPathSB = new StringBuilder(rootDir);
        if (!rootDir.endsWith("/")) {
            startPathSB.append('/');
        }
        startPathSB.append("WALs");
        if (!"WALs".endsWith("/")) {
            startPathSB.append('/');
        }
        String startPath = startPathSB.toString();
        try {
            fullPath = FileSystem.get((Configuration)conf).makeQualified(new Path(path)).toString();
        }
        catch (IllegalArgumentException e) {
            LOG.info((Object)("Call to makeQualified failed on " + path + " " + e.getMessage()));
            return null;
        }
        if (!fullPath.startsWith(startPath)) {
            return null;
        }
        String serverNameAndFile = fullPath.substring(startPath.length());
        if (serverNameAndFile.indexOf(47) < "a,0,0".length()) {
            return null;
        }
        Path p = new Path(path);
        return HLogUtil.getServerNameFromHLogDirectoryName(p);
    }

    public static ServerName getServerNameFromHLogDirectoryName(Path logFile) {
        Path logDir = logFile.getParent();
        String logDirName = logDir.getName();
        if (logDirName.equals("WALs")) {
            logDir = logFile;
            logDirName = logDir.getName();
        }
        ServerName serverName = null;
        if (logDirName.endsWith("-splitting")) {
            logDirName = logDirName.substring(0, logDirName.length() - "-splitting".length());
        }
        try {
            serverName = ServerName.parseServerName((String)logDirName);
        }
        catch (IllegalArgumentException ex) {
            serverName = null;
            LOG.warn((Object)("Invalid log file path=" + logFile), (Throwable)ex);
        }
        if (serverName != null && serverName.getStartcode() < 0L) {
            LOG.warn((Object)("Invalid log file path=" + logFile));
            return null;
        }
        return serverName;
    }

    public static NavigableSet<Path> getSplitEditFilesSorted(final FileSystem fs, Path regiondir) throws IOException {
        TreeSet<Path> filesSorted = new TreeSet<Path>();
        Path editsdir = HLogUtil.getRegionDirRecoveredEditsDir(regiondir);
        if (!fs.exists(editsdir)) {
            return filesSorted;
        }
        FileStatus[] files = FSUtils.listStatus(fs, editsdir, new PathFilter(){

            public boolean accept(Path p) {
                boolean result = false;
                try {
                    Matcher m = HLog.EDITFILES_NAME_PATTERN.matcher(p.getName());
                    boolean bl = result = fs.isFile(p) && m.matches();
                    if (p.getName().endsWith(".temp")) {
                        result = false;
                    }
                }
                catch (IOException e) {
                    LOG.warn((Object)("Failed isFile check on " + p));
                }
                return result;
            }
        });
        if (files == null) {
            return filesSorted;
        }
        for (FileStatus status : files) {
            filesSorted.add(status.getPath());
        }
        return filesSorted;
    }

    public static boolean isMetaFile(Path p) {
        return HLogUtil.isMetaFile(p.getName());
    }

    public static boolean isMetaFile(String p) {
        return p != null && p.endsWith(".meta");
    }

    public static void writeCompactionMarker(HLog log, HTableDescriptor htd, HRegionInfo info, WALProtos.CompactionDescriptor c, AtomicLong sequenceId) throws IOException {
        WALEdit e = WALEdit.createCompaction(c);
        long now = EnvironmentEdgeManager.currentTimeMillis();
        TableName tn = TableName.valueOf((byte[])c.getTableName().toByteArray());
        long txid = log.appendNoSync(info, tn, e, new ArrayList<UUID>(), now, htd, sequenceId, false, 0L, 0L);
        log.sync(txid);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Appended compaction marker " + TextFormat.shortDebugString((MessageOrBuilder)c)));
        }
    }
}

