/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.protobuf.ByteString;
import com.google.protobuf.HBaseZeroCopyByteString;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.coprocessor.CoprocessorService;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.util.StreamUtils;
import org.apache.hadoop.hbase.ipc.RequestContext;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.DisabledRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.security.visibility.ExpressionExpander;
import org.apache.hadoop.hbase.security.visibility.ExpressionParser;
import org.apache.hadoop.hbase.security.visibility.InvalidLabelException;
import org.apache.hadoop.hbase.security.visibility.LabelAlreadyExistsException;
import org.apache.hadoop.hbase.security.visibility.ParseException;
import org.apache.hadoop.hbase.security.visibility.ScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelFilter;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelsManager;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelsValidator;
import org.apache.hadoop.hbase.security.visibility.VisibilityUtils;
import org.apache.hadoop.hbase.security.visibility.expression.ExpressionNode;
import org.apache.hadoop.hbase.security.visibility.expression.LeafExpressionNode;
import org.apache.hadoop.hbase.security.visibility.expression.NonLeafExpressionNode;
import org.apache.hadoop.hbase.security.visibility.expression.Operator;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

@InterfaceAudience.Private
public class VisibilityController
extends BaseRegionObserver
implements MasterObserver,
RegionObserver,
VisibilityLabelsProtos.VisibilityLabelsService.Interface,
CoprocessorService {
    private static final Log LOG = LogFactory.getLog(VisibilityController.class);
    private static final byte[] DUMMY_VALUE = new byte[0];
    private static final int SYSTEM_LABEL_ORDINAL = 1;
    private static final Tag[] LABELS_TABLE_TAGS = new Tag[1];
    private final ExpressionParser expressionParser = new ExpressionParser();
    private final ExpressionExpander expressionExpander = new ExpressionExpander();
    private VisibilityLabelsManager visibilityManager;
    private RegionCoprocessorEnvironment regionEnv;
    private ScanLabelGenerator scanLabelGenerator;
    private volatile int ordinalCounter = -1;
    private boolean labelsRegion = false;
    private boolean acOn = false;
    private Configuration conf;
    private volatile boolean initialized = false;
    private Map<InternalScanner, String> scannerOwners = new MapMaker().weakKeys().makeMap();

    @Override
    public void start(CoprocessorEnvironment env) throws IOException {
        this.conf = env.getConfiguration();
        if (HFile.getFormatVersion(this.conf) < 3) {
            throw new RuntimeException("A minimum HFile version of 3 is required to persist visibility labels. Consider setting hfile.format.version accordingly.");
        }
        ZooKeeperWatcher zk = null;
        if (env instanceof MasterCoprocessorEnvironment) {
            MasterCoprocessorEnvironment mEnv = (MasterCoprocessorEnvironment)env;
            zk = mEnv.getMasterServices().getZooKeeper();
        } else if (env instanceof RegionCoprocessorEnvironment) {
            this.regionEnv = (RegionCoprocessorEnvironment)env;
            zk = this.regionEnv.getRegionServerServices().getZooKeeper();
        } else if (env instanceof RegionServerCoprocessorEnvironment) {
            throw new RuntimeException("Visibility controller should not be configured as 'hbase.coprocessor.regionserver.classes'.");
        }
        if (zk == null) {
            throw new RuntimeException("Error obtaining VisibilityLabelsManager, zk found null.");
        }
        try {
            this.visibilityManager = VisibilityLabelsManager.get(zk, this.conf);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error obtaining VisibilityLabelsManager", ioe);
        }
        if (env instanceof RegionCoprocessorEnvironment) {
            this.scanLabelGenerator = VisibilityUtils.getScanLabelGenerator(this.conf);
        }
    }

    @Override
    public void stop(CoprocessorEnvironment env) throws IOException {
    }

    @Override
    public void postStartMaster(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
        MasterServices master = ctx.getEnvironment().getMasterServices();
        if (!MetaReader.tableExists((CatalogTracker)master.getCatalogTracker(), (TableName)VisibilityConstants.LABELS_TABLE_NAME)) {
            HTableDescriptor labelsTable = new HTableDescriptor(VisibilityConstants.LABELS_TABLE_NAME);
            HColumnDescriptor labelsColumn = new HColumnDescriptor(VisibilityConstants.LABELS_TABLE_FAMILY);
            labelsColumn.setBloomFilterType(BloomType.NONE);
            labelsColumn.setBlockCacheEnabled(false);
            labelsTable.addFamily(labelsColumn);
            labelsTable.setValue("SPLIT_POLICY", DisabledRegionSplitPolicy.class.getName());
            labelsTable.setValue(Bytes.toBytes((String)"hbase.regionserver.disallow.writes.when.recovering"), Bytes.toBytes((boolean)true));
            master.createTable(labelsTable, null);
        }
    }

    @Override
    public void preCreateTable(ObserverContext<MasterCoprocessorEnvironment> ctx, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
    }

    @Override
    public void postCreateTable(ObserverContext<MasterCoprocessorEnvironment> ctx, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
    }

    @Override
    public void preCreateTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
    }

    @Override
    public void postCreateTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
    }

    @Override
    public void preDeleteTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
    }

    @Override
    public void postDeleteTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
    }

    @Override
    public void preDeleteTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
    }

    @Override
    public void postDeleteTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
    }

    @Override
    public void preModifyTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HTableDescriptor htd) throws IOException {
        if (VisibilityConstants.LABELS_TABLE_NAME.equals((Object)tableName)) {
            throw new ConstraintException("Cannot alter " + VisibilityConstants.LABELS_TABLE_NAME);
        }
    }

    @Override
    public void postModifyTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HTableDescriptor htd) throws IOException {
    }

    @Override
    public void preModifyTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HTableDescriptor htd) throws IOException {
    }

    @Override
    public void postModifyTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HTableDescriptor htd) throws IOException {
    }

    @Override
    public void preAddColumn(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HColumnDescriptor column) throws IOException {
        if (VisibilityConstants.LABELS_TABLE_NAME.equals((Object)tableName)) {
            throw new ConstraintException("Cannot alter " + VisibilityConstants.LABELS_TABLE_NAME);
        }
    }

    @Override
    public void postAddColumn(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HColumnDescriptor column) throws IOException {
    }

    @Override
    public void preAddColumnHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HColumnDescriptor column) throws IOException {
    }

    @Override
    public void postAddColumnHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HColumnDescriptor column) throws IOException {
    }

    @Override
    public void preModifyColumn(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HColumnDescriptor descriptor) throws IOException {
        if (VisibilityConstants.LABELS_TABLE_NAME.equals((Object)tableName)) {
            throw new ConstraintException("Cannot alter " + VisibilityConstants.LABELS_TABLE_NAME);
        }
    }

    @Override
    public void postModifyColumn(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HColumnDescriptor descriptor) throws IOException {
    }

    @Override
    public void preModifyColumnHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HColumnDescriptor descriptor) throws IOException {
    }

    @Override
    public void postModifyColumnHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HColumnDescriptor descriptor) throws IOException {
    }

    @Override
    public void preDeleteColumn(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, byte[] c) throws IOException {
        if (VisibilityConstants.LABELS_TABLE_NAME.equals((Object)tableName)) {
            throw new ConstraintException("Cannot alter " + VisibilityConstants.LABELS_TABLE_NAME);
        }
    }

    @Override
    public void postDeleteColumn(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, byte[] c) throws IOException {
    }

    @Override
    public void preDeleteColumnHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, byte[] c) throws IOException {
    }

    @Override
    public void postDeleteColumnHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, byte[] c) throws IOException {
    }

    @Override
    public void preEnableTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
    }

    @Override
    public void postEnableTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
    }

    @Override
    public void preEnableTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
    }

    @Override
    public void postEnableTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
    }

    @Override
    public void preDisableTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (VisibilityConstants.LABELS_TABLE_NAME.equals((Object)tableName)) {
            throw new ConstraintException("Cannot disable " + VisibilityConstants.LABELS_TABLE_NAME);
        }
    }

    @Override
    public void postDisableTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
    }

    @Override
    public void preDisableTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
    }

    @Override
    public void postDisableTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
    }

    @Override
    public void preMove(ObserverContext<MasterCoprocessorEnvironment> ctx, HRegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
    }

    @Override
    public void postMove(ObserverContext<MasterCoprocessorEnvironment> ctx, HRegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
    }

    @Override
    public void preAssign(ObserverContext<MasterCoprocessorEnvironment> ctx, HRegionInfo regionInfo) throws IOException {
    }

    @Override
    public void postAssign(ObserverContext<MasterCoprocessorEnvironment> ctx, HRegionInfo regionInfo) throws IOException {
    }

    @Override
    public void preUnassign(ObserverContext<MasterCoprocessorEnvironment> ctx, HRegionInfo regionInfo, boolean force) throws IOException {
    }

    @Override
    public void postUnassign(ObserverContext<MasterCoprocessorEnvironment> ctx, HRegionInfo regionInfo, boolean force) throws IOException {
    }

    @Override
    public void preRegionOffline(ObserverContext<MasterCoprocessorEnvironment> ctx, HRegionInfo regionInfo) throws IOException {
    }

    @Override
    public void postRegionOffline(ObserverContext<MasterCoprocessorEnvironment> ctx, HRegionInfo regionInfo) throws IOException {
    }

    @Override
    public void preBalance(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
    }

    @Override
    public void postBalance(ObserverContext<MasterCoprocessorEnvironment> ctx, List<RegionPlan> plans) throws IOException {
    }

    @Override
    public boolean preBalanceSwitch(ObserverContext<MasterCoprocessorEnvironment> ctx, boolean newValue) throws IOException {
        return false;
    }

    @Override
    public void postBalanceSwitch(ObserverContext<MasterCoprocessorEnvironment> ctx, boolean oldValue, boolean newValue) throws IOException {
    }

    @Override
    public void preShutdown(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
    }

    @Override
    public void preStopMaster(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
    }

    @Override
    public void preSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
    }

    @Override
    public void postSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
    }

    @Override
    public void preCloneSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
    }

    @Override
    public void postCloneSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
    }

    @Override
    public void preRestoreSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
    }

    @Override
    public void postRestoreSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
    }

    @Override
    public void preDeleteSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot) throws IOException {
    }

    @Override
    public void postDeleteSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot) throws IOException {
    }

    @Override
    public void preGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableName> tableNamesList, List<HTableDescriptor> descriptors) throws IOException {
    }

    @Override
    public void postGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<HTableDescriptor> descriptors) throws IOException {
    }

    @Override
    public void preCreateNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
    }

    @Override
    public void postCreateNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
    }

    @Override
    public void preDeleteNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
    }

    @Override
    public void postDeleteNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
    }

    @Override
    public void preModifyNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
    }

    @Override
    public void postModifyNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
    }

    @Override
    public void preMasterInitialization(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
    }

    @Override
    public void postOpen(ObserverContext<RegionCoprocessorEnvironment> e) {
        if (e.getEnvironment().getRegion().getRegionInfo().getTable().equals((Object)VisibilityConstants.LABELS_TABLE_NAME)) {
            this.labelsRegion = true;
            this.acOn = CoprocessorHost.getLoadedCoprocessors().contains(AccessController.class.getName());
            if (!e.getEnvironment().getRegion().isRecovering()) {
                this.initialize(e);
            }
        } else {
            this.initialized = true;
        }
    }

    @Override
    public void postLogReplay(ObserverContext<RegionCoprocessorEnvironment> e) {
        if (this.labelsRegion) {
            this.initialize(e);
        }
    }

    private void initialize(ObserverContext<RegionCoprocessorEnvironment> e) {
        try {
            byte[] serialized;
            Pair<Map<String, Integer>, Map<String, List<Integer>>> labelsAndUserAuths = this.extractLabelsAndAuths(this.getExistingLabelsWithAuths());
            Map labels = (Map)labelsAndUserAuths.getFirst();
            Map userAuths = (Map)labelsAndUserAuths.getSecond();
            this.addSystemLabel(e.getEnvironment().getRegion(), labels, userAuths);
            int ordinal = 1;
            for (Integer i : labels.values()) {
                if (i <= ordinal) continue;
                ordinal = i;
            }
            this.ordinalCounter = ordinal + 1;
            if (labels.size() > 0) {
                serialized = VisibilityUtils.getDataToWriteToZooKeeper(labels);
                this.visibilityManager.writeToZookeeper(serialized, true);
            }
            if (userAuths.size() > 0) {
                serialized = VisibilityUtils.getUserAuthsDataToWriteToZooKeeper(userAuths);
                this.visibilityManager.writeToZookeeper(serialized, false);
            }
            this.initialized = true;
        }
        catch (IOException ioe) {
            LOG.error((Object)"Error while updating the zk with the exisiting labels data", (Throwable)ioe);
        }
    }

    private void addSystemLabel(HRegion region, Map<String, Integer> labels, Map<String, List<Integer>> userAuths) throws IOException {
        if (!labels.containsKey("system")) {
            Put p = new Put(Bytes.toBytes((int)1));
            p.addImmutable(VisibilityConstants.LABELS_TABLE_FAMILY, VisibilityConstants.LABEL_QUALIFIER, Bytes.toBytes((String)"system"));
            List<String> superUsers = this.getSystemAndSuperUsers();
            for (String superUser : superUsers) {
                p.addImmutable(VisibilityConstants.LABELS_TABLE_FAMILY, Bytes.toBytes((String)superUser), DUMMY_VALUE, LABELS_TABLE_TAGS);
            }
            region.put(p);
            labels.put("system", 1);
            for (String superUser : superUsers) {
                List<Integer> auths = userAuths.get(superUser);
                if (auths == null) {
                    auths = new ArrayList<Integer>(1);
                    userAuths.put(superUser, auths);
                }
                auths.add(1);
            }
        }
    }

    @Override
    public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        if (c.getEnvironment().getRegion().getRegionInfo().getTable().isSystemTable()) {
            return;
        }
        HashMap<String, List<Tag>> labelCache = new HashMap<String, List<Tag>>();
        for (int i = 0; i < miniBatchOp.size(); ++i) {
            Mutation m = miniBatchOp.getOperation(i);
            CellVisibility cellVisibility = null;
            try {
                cellVisibility = m.getCellVisibility();
            }
            catch (DeserializationException de) {
                miniBatchOp.setOperationStatus(i, new OperationStatus(HConstants.OperationStatusCode.SANITY_CHECK_FAILURE, de.getMessage()));
                continue;
            }
            if (m instanceof Put) {
                Put p = (Put)m;
                boolean sanityFailure = false;
                CellScanner cellScanner = p.cellScanner();
                while (cellScanner.advance()) {
                    if (this.checkForReservedVisibilityTagPresence(cellScanner.current())) continue;
                    miniBatchOp.setOperationStatus(i, new OperationStatus(HConstants.OperationStatusCode.SANITY_CHECK_FAILURE, "Mutation contains cell with reserved type tag"));
                    sanityFailure = true;
                    break;
                }
                if (sanityFailure || cellVisibility == null) continue;
                String labelsExp = cellVisibility.getExpression();
                List<Tag> visibilityTags = (List<Tag>)labelCache.get(labelsExp);
                if (visibilityTags == null) {
                    try {
                        visibilityTags = this.createVisibilityTags(labelsExp);
                    }
                    catch (ParseException e) {
                        miniBatchOp.setOperationStatus(i, new OperationStatus(HConstants.OperationStatusCode.SANITY_CHECK_FAILURE, e.getMessage()));
                    }
                    catch (InvalidLabelException e) {
                        miniBatchOp.setOperationStatus(i, new OperationStatus(HConstants.OperationStatusCode.SANITY_CHECK_FAILURE, e.getMessage()));
                    }
                }
                if (visibilityTags == null) continue;
                labelCache.put(labelsExp, visibilityTags);
                ArrayList<KeyValue> updatedCells = new ArrayList<KeyValue>();
                CellScanner cellScanner2 = p.cellScanner();
                while (cellScanner2.advance()) {
                    Cell cell = cellScanner2.current();
                    List tags = Tag.asList((byte[])cell.getTagsArray(), (int)cell.getTagsOffset(), (int)cell.getTagsLength());
                    tags.addAll(visibilityTags);
                    KeyValue updatedCell = new KeyValue(cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength(), cell.getFamilyArray(), cell.getFamilyOffset(), (int)cell.getFamilyLength(), cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength(), cell.getTimestamp(), KeyValue.Type.codeToType((byte)cell.getTypeByte()), cell.getValueArray(), cell.getValueOffset(), cell.getValueLength(), tags);
                    updatedCells.add(updatedCell);
                }
                p.getFamilyCellMap().clear();
                for (Cell cell : updatedCells) {
                    p.add(cell);
                }
                continue;
            }
            if (cellVisibility == null) continue;
            miniBatchOp.setOperationStatus(i, new OperationStatus(HConstants.OperationStatusCode.SANITY_CHECK_FAILURE, "CellVisibility cannot be set on Delete mutation"));
        }
    }

    @Override
    public void postBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        if (this.labelsRegion) {
            Pair<Map<String, Integer>, Map<String, List<Integer>>> labelsAndUserAuths = this.extractLabelsAndAuths(this.getExistingLabelsWithAuths());
            Map existingLabels = (Map)labelsAndUserAuths.getFirst();
            Map userAuths = (Map)labelsAndUserAuths.getSecond();
            boolean isNewLabels = false;
            boolean isUserAuthsChange = false;
            for (int i = 0; i < miniBatchOp.size(); ++i) {
                Mutation m = miniBatchOp.getOperation(i);
                if (miniBatchOp.getOperationStatus(i).getOperationStatusCode() != HConstants.OperationStatusCode.SUCCESS) continue;
                for (List cells : m.getFamilyCellMap().values()) {
                    for (Cell cell : cells) {
                        int labelOrdinal = Bytes.toInt((byte[])cell.getRowArray(), (int)cell.getRowOffset());
                        if (Bytes.equals((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength(), (byte[])VisibilityConstants.LABEL_QUALIFIER, (int)0, (int)VisibilityConstants.LABEL_QUALIFIER.length)) {
                            if (!(m instanceof Put)) continue;
                            existingLabels.put(Bytes.toString((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()), labelOrdinal);
                            isNewLabels = true;
                            continue;
                        }
                        String user = Bytes.toString((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength());
                        ArrayList<Integer> auths = (ArrayList<Integer>)userAuths.get(user);
                        if (auths == null) {
                            auths = new ArrayList<Integer>();
                            userAuths.put(user, auths);
                        }
                        if (m instanceof Delete) {
                            auths.remove((Object)labelOrdinal);
                        } else {
                            auths.add(labelOrdinal);
                        }
                        isUserAuthsChange = true;
                    }
                }
            }
            if (isNewLabels) {
                byte[] serialized = VisibilityUtils.getDataToWriteToZooKeeper(existingLabels);
                this.visibilityManager.writeToZookeeper(serialized, true);
            }
            if (isUserAuthsChange) {
                byte[] serialized = VisibilityUtils.getUserAuthsDataToWriteToZooKeeper(userAuths);
                this.visibilityManager.writeToZookeeper(serialized, false);
            }
        }
    }

    private Pair<Map<String, Integer>, Map<String, List<Integer>>> extractLabelsAndAuths(List<List<Cell>> labelDetails) {
        HashMap<String, Integer> labels = new HashMap<String, Integer>();
        HashMap<String, ArrayList<Integer>> userAuths = new HashMap<String, ArrayList<Integer>>();
        for (List<Cell> cells : labelDetails) {
            for (Cell cell : cells) {
                if (Bytes.equals((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength(), (byte[])VisibilityConstants.LABEL_QUALIFIER, (int)0, (int)VisibilityConstants.LABEL_QUALIFIER.length)) {
                    labels.put(Bytes.toString((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()), Bytes.toInt((byte[])cell.getRowArray(), (int)cell.getRowOffset()));
                    continue;
                }
                String user = Bytes.toString((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength());
                ArrayList<Integer> auths = (ArrayList<Integer>)userAuths.get(user);
                if (auths == null) {
                    auths = new ArrayList<Integer>();
                    userAuths.put(user, auths);
                }
                auths.add(Bytes.toInt((byte[])cell.getRowArray(), (int)cell.getRowOffset()));
            }
        }
        return new Pair(labels, userAuths);
    }

    private boolean checkForReservedVisibilityTagPresence(Cell cell) throws IOException {
        if (cell.getTagsLength() > 0) {
            Iterator tagsItr = CellUtil.tagsIterator((byte[])cell.getTagsArray(), (int)cell.getTagsOffset(), (int)cell.getTagsLength());
            while (tagsItr.hasNext()) {
                if (((Tag)tagsItr.next()).getType() != 2) continue;
                return false;
            }
        }
        return true;
    }

    private List<Tag> createVisibilityTags(String visibilityLabelsExp) throws IOException, ParseException, InvalidLabelException {
        ExpressionNode node = null;
        node = this.expressionParser.parse(visibilityLabelsExp);
        node = this.expressionExpander.expand(node);
        ArrayList<Tag> tags = new ArrayList<Tag>();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        if (node.isSingleNode()) {
            this.writeLabelOrdinalsToStream(node, dos);
            tags.add(new Tag(2, baos.toByteArray()));
            baos.reset();
        } else {
            NonLeafExpressionNode nlNode = (NonLeafExpressionNode)node;
            if (nlNode.getOperator() == Operator.OR) {
                for (ExpressionNode child : nlNode.getChildExps()) {
                    this.writeLabelOrdinalsToStream(child, dos);
                    tags.add(new Tag(2, baos.toByteArray()));
                    baos.reset();
                }
            } else {
                this.writeLabelOrdinalsToStream(nlNode, dos);
                tags.add(new Tag(2, baos.toByteArray()));
                baos.reset();
            }
        }
        return tags;
    }

    private void writeLabelOrdinalsToStream(ExpressionNode node, DataOutputStream dos) throws IOException, InvalidLabelException {
        if (node.isSingleNode()) {
            String identifier = null;
            int labelOrdinal = 0;
            if (node instanceof LeafExpressionNode) {
                identifier = ((LeafExpressionNode)node).getIdentifier();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("The identifier is " + identifier));
                }
                labelOrdinal = this.visibilityManager.getLabelOrdinal(identifier);
            } else {
                LeafExpressionNode lNode = (LeafExpressionNode)((NonLeafExpressionNode)node).getChildExps().get(0);
                identifier = lNode.getIdentifier();
                labelOrdinal = this.visibilityManager.getLabelOrdinal(identifier);
                labelOrdinal = -1 * labelOrdinal;
            }
            if (labelOrdinal == 0) {
                throw new InvalidLabelException("Invalid visibility label " + identifier);
            }
            StreamUtils.writeRawVInt32((OutputStream)dos, (int)labelOrdinal);
        } else {
            List<ExpressionNode> childExps = ((NonLeafExpressionNode)node).getChildExps();
            for (ExpressionNode child : childExps) {
                this.writeLabelOrdinalsToStream(child, dos);
            }
        }
    }

    @Override
    public RegionScanner preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> e, Scan scan, RegionScanner s) throws IOException {
        HRegion region = e.getEnvironment().getRegion();
        Authorizations authorizations = null;
        if (this.checkIfScanOrGetFromSuperUser()) {
            return s;
        }
        try {
            authorizations = scan.getAuthorizations();
        }
        catch (DeserializationException de) {
            throw new IOException(de);
        }
        Filter visibilityLabelFilter = this.createVisibilityLabelFilter(region, authorizations);
        if (visibilityLabelFilter != null) {
            Filter filter = scan.getFilter();
            if (filter != null) {
                scan.setFilter((Filter)new FilterList(new Filter[]{filter, visibilityLabelFilter}));
            } else {
                scan.setFilter(visibilityLabelFilter);
            }
        }
        return s;
    }

    private boolean checkIfScanOrGetFromSuperUser() throws IOException {
        User user = this.getActiveUser();
        if (user != null && user.getShortName() != null) {
            List<String> auths = this.visibilityManager.getAuths(user.getShortName());
            return auths.contains("system");
        }
        return false;
    }

    @Override
    public RegionScanner postScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException {
        User user = this.getActiveUser();
        if (user != null && user.getShortName() != null) {
            this.scannerOwners.put(s, user.getShortName());
        }
        return s;
    }

    @Override
    public boolean preScannerNext(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s, List<Result> result, int limit, boolean hasNext) throws IOException {
        this.requireScannerOwner(s);
        return hasNext;
    }

    @Override
    public void preScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
        this.requireScannerOwner(s);
    }

    @Override
    public void postScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
        this.scannerOwners.remove(s);
    }

    private void requireScannerOwner(InternalScanner s) throws AccessDeniedException {
        if (RequestContext.isInRequestContext()) {
            String requestUName = RequestContext.getRequestUserName();
            String owner = this.scannerOwners.get(s);
            if (owner != null && !owner.equals(requestUName)) {
                throw new AccessDeniedException("User '" + requestUName + "' is not the scanner owner!");
            }
        }
    }

    @Override
    public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
        Authorizations authorizations = null;
        if (this.checkIfScanOrGetFromSuperUser()) {
            return;
        }
        try {
            authorizations = get.getAuthorizations();
        }
        catch (DeserializationException de) {
            throw new IOException(de);
        }
        Filter visibilityLabelFilter = this.createVisibilityLabelFilter(e.getEnvironment().getRegion(), authorizations);
        if (visibilityLabelFilter != null) {
            Filter filter = get.getFilter();
            if (filter != null) {
                get.setFilter((Filter)new FilterList(new Filter[]{filter, visibilityLabelFilter}));
            } else {
                get.setFilter(visibilityLabelFilter);
            }
        }
    }

    private Filter createVisibilityLabelFilter(HRegion region, Authorizations authorizations) {
        if (authorizations == null) {
            TableName table = region.getRegionInfo().getTable();
            if (table.isSystemTable() && !table.equals((Object)VisibilityConstants.LABELS_TABLE_NAME)) {
                return null;
            }
            return new VisibilityLabelFilter(new BitSet(0));
        }
        VisibilityLabelFilter visibilityLabelFilter = null;
        if (this.scanLabelGenerator != null) {
            List<String> labels = null;
            try {
                labels = this.scanLabelGenerator.getLabels(this.getActiveUser(), authorizations);
            }
            catch (Throwable t) {
                LOG.error((Object)t);
            }
            int labelsCount = this.visibilityManager.getLabelsCount();
            BitSet bs = new BitSet(labelsCount + 1);
            if (labels != null) {
                for (String label : labels) {
                    int labelOrdinal = this.visibilityManager.getLabelOrdinal(label);
                    if (labelOrdinal == 0) continue;
                    bs.set(labelOrdinal);
                }
            }
            visibilityLabelFilter = new VisibilityLabelFilter(bs);
        }
        return visibilityLabelFilter;
    }

    private User getActiveUser() throws IOException {
        User user = RequestContext.getRequestUser();
        if (!RequestContext.isInRequestContext()) {
            user = User.getCurrent();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Current active user name is " + user.getShortName()));
        }
        return user;
    }

    private List<String> getSystemAndSuperUsers() throws IOException {
        User user = User.getCurrent();
        if (user == null) {
            throw new IOException("Unable to obtain the current user, authorization checks for internal operations will not work correctly!");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Current user name is " + user.getShortName()));
        }
        String currentUser = user.getShortName();
        List superUsers = Lists.asList((Object)currentUser, (Object[])this.conf.getStrings("hbase.superuser", new String[0]));
        return superUsers;
    }

    private boolean isSystemOrSuperUser() throws IOException {
        List<String> superUsers = this.getSystemAndSuperUsers();
        User activeUser = this.getActiveUser();
        return superUsers.contains(activeUser.getShortName());
    }

    @Override
    public Cell postMutationBeforeWAL(ObserverContext<RegionCoprocessorEnvironment> ctx, RegionObserver.MutationType opType, Mutation mutation, Cell oldCell, Cell newCell) throws IOException {
        ArrayList tags = Lists.newArrayList();
        CellVisibility cellVisibility = null;
        try {
            cellVisibility = mutation.getCellVisibility();
        }
        catch (DeserializationException e) {
            throw new IOException(e);
        }
        if (cellVisibility == null) {
            return newCell;
        }
        Iterator tagsItr = CellUtil.tagsIterator((byte[])newCell.getTagsArray(), (int)newCell.getTagsOffset(), (int)newCell.getTagsLength());
        while (tagsItr.hasNext()) {
            Tag tag = (Tag)tagsItr.next();
            if (tag.getType() == 2) continue;
            tags.add(tag);
        }
        try {
            tags.addAll(this.createVisibilityTags(cellVisibility.getExpression()));
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
        KeyValue newKv = KeyValueUtil.ensureKeyValue((Cell)newCell);
        byte[] bytes = newKv.getBuffer();
        KeyValue rewriteKv = new KeyValue(bytes, newKv.getRowOffset(), (int)newKv.getRowLength(), bytes, newKv.getFamilyOffset(), (int)newKv.getFamilyLength(), bytes, newKv.getQualifierOffset(), newKv.getQualifierLength(), newKv.getTimestamp(), KeyValue.Type.codeToType((byte)newKv.getTypeByte()), bytes, newKv.getValueOffset(), newKv.getValueLength(), (List)tags);
        rewriteKv.setMvccVersion(newKv.getMvccVersion());
        return rewriteKv;
    }

    @Override
    public Service getService() {
        return VisibilityLabelsProtos.VisibilityLabelsService.newReflectiveService((VisibilityLabelsProtos.VisibilityLabelsService.Interface)this);
    }

    public synchronized void addLabels(RpcController controller, VisibilityLabelsProtos.VisibilityLabelsRequest request, RpcCallback<VisibilityLabelsProtos.VisibilityLabelsResponse> done) {
        VisibilityLabelsProtos.VisibilityLabelsResponse.Builder response = VisibilityLabelsProtos.VisibilityLabelsResponse.newBuilder();
        List labels = request.getVisLabelList();
        if (!this.initialized) {
            this.setExceptionResults(labels.size(), (IOException)new CoprocessorException("VisibilityController not yet initialized"), response);
        }
        try {
            this.checkCallingUserAuth();
            ArrayList<Put> puts = new ArrayList<Put>(labels.size());
            ClientProtos.RegionActionResult successResult = ClientProtos.RegionActionResult.newBuilder().build();
            for (VisibilityLabelsProtos.VisibilityLabel visLabel : labels) {
                ClientProtos.RegionActionResult.Builder failureResultBuilder;
                byte[] label = visLabel.getLabel().toByteArray();
                String labelStr = Bytes.toString((byte[])label);
                if (VisibilityLabelsValidator.isValidLabel((byte[])label)) {
                    if (this.visibilityManager.getLabelOrdinal(labelStr) > 0) {
                        failureResultBuilder = ClientProtos.RegionActionResult.newBuilder();
                        failureResultBuilder.setException(ResponseConverter.buildException((Throwable)new LabelAlreadyExistsException("Label '" + labelStr + "' already exists")));
                        response.addResult(failureResultBuilder.build());
                        continue;
                    }
                    Put p = new Put(Bytes.toBytes((int)this.ordinalCounter));
                    p.addImmutable(VisibilityConstants.LABELS_TABLE_FAMILY, VisibilityConstants.LABEL_QUALIFIER, label, LABELS_TABLE_TAGS);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Adding the label " + labelStr));
                    }
                    puts.add(p);
                    ++this.ordinalCounter;
                    response.addResult(successResult);
                    continue;
                }
                failureResultBuilder = ClientProtos.RegionActionResult.newBuilder();
                failureResultBuilder.setException(ResponseConverter.buildException((Throwable)new InvalidLabelException("Invalid visibility label '" + labelStr + "'")));
                response.addResult(failureResultBuilder.build());
            }
            OperationStatus[] opStatus = this.regionEnv.getRegion().batchMutate(puts.toArray(new Mutation[puts.size()]));
            int i = 0;
            for (OperationStatus status : opStatus) {
                if (status.getOperationStatusCode() != HConstants.OperationStatusCode.SUCCESS) {
                    while (response.getResult(i) != successResult) {
                        ++i;
                    }
                    ClientProtos.RegionActionResult.Builder failureResultBuilder = ClientProtos.RegionActionResult.newBuilder();
                    failureResultBuilder.setException(ResponseConverter.buildException((Throwable)new DoNotRetryIOException(status.getExceptionMsg())));
                    response.setResult(i, failureResultBuilder.build());
                }
                ++i;
            }
        }
        catch (IOException e) {
            LOG.error((Object)e);
            this.setExceptionResults(labels.size(), e, response);
        }
        done.run((Object)response.build());
    }

    private void setExceptionResults(int size, IOException e, VisibilityLabelsProtos.VisibilityLabelsResponse.Builder response) {
        ClientProtos.RegionActionResult.Builder failureResultBuilder = ClientProtos.RegionActionResult.newBuilder();
        failureResultBuilder.setException(ResponseConverter.buildException((Throwable)e));
        ClientProtos.RegionActionResult failureResult = failureResultBuilder.build();
        for (int i = 0; i < size; ++i) {
            response.addResult(i, failureResult);
        }
    }

    private void performACLCheck() throws IOException {
        if (this.acOn && !this.isSystemOrSuperUser()) {
            User user = this.getActiveUser();
            throw new AccessDeniedException("User '" + (user != null ? user.getShortName() : "null") + " is not authorized to perform this action.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<List<Cell>> getExistingLabelsWithAuths() throws IOException {
        Scan scan = new Scan();
        RegionScanner scanner = this.regionEnv.getRegion().getScanner(scan);
        ArrayList<List<Cell>> existingLabels = new ArrayList<List<Cell>>();
        try {
            while (true) {
                ArrayList<Cell> cells = new ArrayList<Cell>();
                scanner.next(cells);
                if (cells.isEmpty()) {
                    break;
                }
                existingLabels.add(cells);
            }
        }
        finally {
            scanner.close();
        }
        return existingLabels;
    }

    public synchronized void setAuths(RpcController controller, VisibilityLabelsProtos.SetAuthsRequest request, RpcCallback<VisibilityLabelsProtos.VisibilityLabelsResponse> done) {
        VisibilityLabelsProtos.VisibilityLabelsResponse.Builder response = VisibilityLabelsProtos.VisibilityLabelsResponse.newBuilder();
        List auths = request.getAuthList();
        if (!this.initialized) {
            this.setExceptionResults(auths.size(), (IOException)new CoprocessorException("VisibilityController not yet initialized"), response);
        }
        byte[] user = request.getUser().toByteArray();
        try {
            this.checkCallingUserAuth();
            ArrayList<Put> puts = new ArrayList<Put>(auths.size());
            ClientProtos.RegionActionResult successResult = ClientProtos.RegionActionResult.newBuilder().build();
            for (ByteString authBS : auths) {
                byte[] auth = authBS.toByteArray();
                String authStr = Bytes.toString((byte[])auth);
                int labelOrdinal = this.visibilityManager.getLabelOrdinal(authStr);
                if (labelOrdinal == 0) {
                    ClientProtos.RegionActionResult.Builder failureResultBuilder = ClientProtos.RegionActionResult.newBuilder();
                    failureResultBuilder.setException(ResponseConverter.buildException((Throwable)new InvalidLabelException("Label '" + authStr + "' doesn't exist")));
                    response.addResult(failureResultBuilder.build());
                    continue;
                }
                Put p = new Put(Bytes.toBytes((int)labelOrdinal));
                p.addImmutable(VisibilityConstants.LABELS_TABLE_FAMILY, user, DUMMY_VALUE, LABELS_TABLE_TAGS);
                puts.add(p);
                response.addResult(successResult);
            }
            OperationStatus[] opStatus = this.regionEnv.getRegion().batchMutate(puts.toArray(new Mutation[puts.size()]));
            int i = 0;
            for (OperationStatus status : opStatus) {
                if (status.getOperationStatusCode() != HConstants.OperationStatusCode.SUCCESS) {
                    while (response.getResult(i) != successResult) {
                        ++i;
                    }
                    ClientProtos.RegionActionResult.Builder failureResultBuilder = ClientProtos.RegionActionResult.newBuilder();
                    failureResultBuilder.setException(ResponseConverter.buildException((Throwable)new DoNotRetryIOException(status.getExceptionMsg())));
                    response.setResult(i, failureResultBuilder.build());
                }
                ++i;
            }
        }
        catch (IOException e) {
            LOG.error((Object)e);
            this.setExceptionResults(auths.size(), e, response);
        }
        done.run((Object)response.build());
    }

    public synchronized void getAuths(RpcController controller, VisibilityLabelsProtos.GetAuthsRequest request, RpcCallback<VisibilityLabelsProtos.GetAuthsResponse> done) {
        byte[] user = request.getUser().toByteArray();
        VisibilityLabelsProtos.GetAuthsResponse.Builder response = VisibilityLabelsProtos.GetAuthsResponse.newBuilder();
        response.setUser(request.getUser());
        try {
            List<String> labels = this.getUserAuthsFromLabelsTable(user);
            for (String label : labels) {
                response.addAuth(HBaseZeroCopyByteString.wrap((byte[])Bytes.toBytes((String)label)));
            }
        }
        catch (IOException e) {
            ResponseConverter.setControllerException((RpcController)controller, (IOException)e);
        }
        done.run((Object)response.build());
    }

    private List<String> getUserAuthsFromLabelsTable(byte[] user) throws IOException {
        Scan s = new Scan();
        s.addColumn(VisibilityConstants.LABELS_TABLE_FAMILY, user);
        Filter filter = this.createVisibilityLabelFilter(this.regionEnv.getRegion(), new Authorizations(new String[]{"system"}));
        s.setFilter(filter);
        ArrayList<String> auths = new ArrayList<String>();
        this.performACLCheck();
        RegionScanner scanner = this.regionEnv.getRegion().getScanner(s);
        ArrayList<Cell> results = new ArrayList<Cell>(1);
        while (true) {
            scanner.next(results);
            if (results.isEmpty()) break;
            Cell cell = (Cell)results.get(0);
            int ordinal = Bytes.toInt((byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength());
            String label = this.visibilityManager.getLabel(ordinal);
            if (label != null) {
                auths.add(label);
            }
            results.clear();
        }
        return auths;
    }

    public synchronized void clearAuths(RpcController controller, VisibilityLabelsProtos.SetAuthsRequest request, RpcCallback<VisibilityLabelsProtos.VisibilityLabelsResponse> done) {
        VisibilityLabelsProtos.VisibilityLabelsResponse.Builder response = VisibilityLabelsProtos.VisibilityLabelsResponse.newBuilder();
        List auths = request.getAuthList();
        if (!this.initialized) {
            this.setExceptionResults(auths.size(), (IOException)new CoprocessorException("VisibilityController not yet initialized"), response);
        }
        byte[] user = request.getUser().toByteArray();
        try {
            this.checkCallingUserAuth();
            List<String> currentAuths = this.getUserAuthsFromLabelsTable(user);
            ArrayList<Delete> deletes = new ArrayList<Delete>(auths.size());
            ClientProtos.RegionActionResult successResult = ClientProtos.RegionActionResult.newBuilder().build();
            for (ByteString authBS : auths) {
                byte[] auth = authBS.toByteArray();
                String authStr = Bytes.toString((byte[])auth);
                if (currentAuths.contains(authStr)) {
                    int labelOrdinal = this.visibilityManager.getLabelOrdinal(authStr);
                    assert (labelOrdinal > 0);
                    Delete d = new Delete(Bytes.toBytes((int)labelOrdinal));
                    d.deleteColumns(VisibilityConstants.LABELS_TABLE_FAMILY, user);
                    deletes.add(d);
                    response.addResult(successResult);
                    continue;
                }
                ClientProtos.RegionActionResult.Builder failureResultBuilder = ClientProtos.RegionActionResult.newBuilder();
                failureResultBuilder.setException(ResponseConverter.buildException((Throwable)new InvalidLabelException("Label '" + authStr + "' is not set for the user " + Bytes.toString((byte[])user))));
                response.addResult(failureResultBuilder.build());
            }
            OperationStatus[] opStatus = this.regionEnv.getRegion().batchMutate(deletes.toArray(new Mutation[deletes.size()]));
            int i = 0;
            for (OperationStatus status : opStatus) {
                if (status.getOperationStatusCode() != HConstants.OperationStatusCode.SUCCESS) {
                    while (response.getResult(i) != successResult) {
                        ++i;
                    }
                    ClientProtos.RegionActionResult.Builder failureResultBuilder = ClientProtos.RegionActionResult.newBuilder();
                    failureResultBuilder.setException(ResponseConverter.buildException((Throwable)new DoNotRetryIOException(status.getExceptionMsg())));
                    response.setResult(i, failureResultBuilder.build());
                }
                ++i;
            }
        }
        catch (IOException e) {
            LOG.error((Object)e);
            this.setExceptionResults(auths.size(), e, response);
        }
        done.run((Object)response.build());
    }

    private void checkCallingUserAuth() throws IOException {
        if (!this.acOn) {
            User user = this.getActiveUser();
            if (user == null) {
                throw new IOException("Unable to retrieve calling user");
            }
            List<String> auths = this.visibilityManager.getAuths(user.getShortName());
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("The list of auths are " + auths));
            }
            if (!auths.contains("system")) {
                throw new AccessDeniedException("User '" + user.getShortName() + "' is not authorized to perform this action.");
            }
        }
    }

    static {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            StreamUtils.writeRawVInt32((OutputStream)dos, (int)1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        VisibilityController.LABELS_TABLE_TAGS[0] = new Tag(2, baos.toByteArray());
    }
}

