/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.toc;

import java.awt.event.ActionEvent;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.ReportDesignerDocumentContext;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.ReportRenderContext;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.extensions.toc.Messages;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.extensions.toc.TocElement;

public class EditTocAction
extends AbstractElementSelectionAction {
    public EditTocAction() {
        this.putValue("Name", Messages.getInstance().getString("EditTocAction.Text"));
        this.putValue("ShortDescription", Messages.getInstance().getString("EditTocAction.Description"));
        this.putValue("MnemonicKey", Messages.getInstance().getOptionalMnemonic("EditTocAction.Mnemonic"));
        this.putValue("AcceleratorKey", Messages.getInstance().getOptionalKeyStroke("EditTocAction.Accelerator"));
    }

    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
    }

    protected void updateSelection() {
        if (!this.isSingleElementSelection()) {
            this.setEnabled(false);
            return;
        }
        Object selectedElement = this.getSelectionModel().getSelectedElement(0);
        if (selectedElement instanceof TocElement) {
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent e) {
        ReportDesignerContext designerContext = this.getReportDesignerContext();
        if (designerContext == null) {
            return;
        }
        ReportDocumentContext activeReportContext = this.getActiveContext();
        if (activeReportContext == null) {
            return;
        }
        DocumentContextSelectionModel selectionModel1 = this.getSelectionModel();
        if (selectionModel1 == null) {
            return;
        }
        Object leadSelection = selectionModel1.getLeadSelection();
        if (!(leadSelection instanceof Element)) {
            return;
        }
        Element element = (Element)leadSelection;
        if (element instanceof TocElement) {
            int contextCount = designerContext.getReportRenderContextCount();
            for (int i = 0; i < contextCount; ++i) {
                ReportRenderContext rrc = designerContext.getReportRenderContext(i);
                if (rrc.getReportDefinition() != element) continue;
                designerContext.setActiveDocument((ReportDesignerDocumentContext)rrc);
                return;
            }
            TocElement report = (TocElement)element;
            try {
                designerContext.addSubReport(activeReportContext, (SubReport)report);
            }
            catch (ReportDataFactoryException e1) {
                UncaughtExceptionsModel.getInstance().addException((Throwable)e1);
            }
        }
    }
}

