/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.session;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.hooks.HookUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.service.CompositeService;
import org.apache.hive.service.auth.TSetIpAddressProcessor;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.log.LogManager;
import org.apache.hive.service.cli.operation.OperationManager;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.cli.session.HiveSessionHook;
import org.apache.hive.service.cli.session.HiveSessionHookContextImpl;
import org.apache.hive.service.cli.session.HiveSessionImpl;
import org.apache.hive.service.cli.session.HiveSessionImplwithUGI;
import org.apache.hive.service.cli.session.HiveSessionProxy;
import org.apache.hive.service.cli.thrift.TProtocolVersion;
import org.apache.hive.service.server.ThreadFactoryWithGarbageCleanup;

public class SessionManager
extends CompositeService {
    private static final Log LOG = LogFactory.getLog(CompositeService.class);
    public static final String HIVERCFILE = ".hiverc";
    private HiveConf hiveConf;
    private final Map<SessionHandle, HiveSession> handleToSession = new ConcurrentHashMap<SessionHandle, HiveSession>();
    private final OperationManager operationManager = new OperationManager();
    private ThreadPoolExecutor backgroundOperationPool;
    private LogManager logManager = new LogManager();
    private long checkInterval;
    private long sessionTimeout;
    private volatile boolean shutdown;
    private static ThreadLocal<String> threadLocalIpAddress = new ThreadLocal<String>(){

        @Override
        protected synchronized String initialValue() {
            return null;
        }
    };
    private static ThreadLocal<String> threadLocalUserName = new ThreadLocal<String>(){

        @Override
        protected synchronized String initialValue() {
            return null;
        }
    };
    private static ThreadLocal<String> threadLocalProxyUserName = new ThreadLocal<String>(){

        @Override
        protected synchronized String initialValue() {
            return null;
        }
    };

    public SessionManager() {
        super("SessionManager");
    }

    @Override
    public synchronized void init(HiveConf hiveConf) {
        try {
            this.applyAuthorizationConfigPolicy(hiveConf);
        }
        catch (HiveException e) {
            throw new RuntimeException("Error applying authorization policy on hive configuration", e);
        }
        this.hiveConf = hiveConf;
        this.createBackgroundOperationPool();
        this.addService(this.operationManager);
        this.logManager = new LogManager();
        this.logManager.setSessionManager(this);
        this.addService(this.logManager);
        super.init(hiveConf);
    }

    private void createBackgroundOperationPool() {
        int backgroundPoolSize = this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_THREADS);
        LOG.info((Object)("HiveServer2: Background operation thread pool size: " + backgroundPoolSize));
        int backgroundPoolQueueSize = this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_WAIT_QUEUE_SIZE);
        LOG.info((Object)("HiveServer2: Background operation thread wait queue size: " + backgroundPoolQueueSize));
        long keepAliveTime = HiveConf.getTimeVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_KEEPALIVE_TIME, (TimeUnit)TimeUnit.SECONDS);
        LOG.info((Object)("HiveServer2: Background operation thread keepalive time: " + keepAliveTime));
        String threadPoolName = "HiveServer2-Background-Pool";
        this.backgroundOperationPool = new ThreadPoolExecutor(backgroundPoolSize, backgroundPoolSize, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(backgroundPoolQueueSize), new ThreadFactoryWithGarbageCleanup(threadPoolName));
        this.backgroundOperationPool.allowCoreThreadTimeOut(true);
        this.checkInterval = HiveConf.getTimeVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_SESSION_CHECK_INTERVAL, (TimeUnit)TimeUnit.MILLISECONDS);
        this.sessionTimeout = HiveConf.getTimeVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_IDLE_SESSION_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private void applyAuthorizationConfigPolicy(HiveConf newHiveConf) throws HiveException {
        SessionState ss = SessionState.start((HiveConf)newHiveConf);
        ss.applyAuthorizationPolicy();
    }

    @Override
    public synchronized void start() {
        super.start();
        if (this.checkInterval > 0L) {
            this.startTimeoutChecker();
        }
    }

    private void startTimeoutChecker() {
        final long interval = Math.max(this.checkInterval, 3000L);
        Runnable timeoutChecker = new Runnable(){

            @Override
            public void run() {
                this.sleepInterval(interval);
                while (!SessionManager.this.shutdown) {
                    long current = System.currentTimeMillis();
                    for (HiveSession session : new ArrayList(SessionManager.this.handleToSession.values())) {
                        if (SessionManager.this.sessionTimeout > 0L && session.getLastAccessTime() + SessionManager.this.sessionTimeout <= current) {
                            SessionHandle handle = session.getSessionHandle();
                            LOG.warn((Object)("Session " + handle + " is Timed-out (last access : " + new Date(session.getLastAccessTime()) + ") and will be closed"));
                            try {
                                SessionManager.this.closeSession(handle);
                            }
                            catch (HiveSQLException e) {
                                LOG.warn((Object)("Exception is thrown closing session " + handle), (Throwable)e);
                            }
                            continue;
                        }
                        session.closeExpiredOperations();
                    }
                    this.sleepInterval(interval);
                }
            }

            private void sleepInterval(long interval2) {
                try {
                    Thread.sleep(interval2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        this.backgroundOperationPool.execute(timeoutChecker);
    }

    @Override
    public synchronized void stop() {
        super.stop();
        this.shutdown = true;
        if (this.backgroundOperationPool != null) {
            this.backgroundOperationPool.shutdown();
            long timeout = this.hiveConf.getTimeVar(HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_SHUTDOWN_TIMEOUT, TimeUnit.SECONDS);
            try {
                this.backgroundOperationPool.awaitTermination(timeout, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOG.warn((Object)("HIVE_SERVER2_ASYNC_EXEC_SHUTDOWN_TIMEOUT = " + timeout + " seconds has been exceeded. RUNNING background operations will be shut down"), (Throwable)e);
            }
            this.backgroundOperationPool = null;
        }
    }

    public SessionHandle openSession(TProtocolVersion protocol, String username, String password, Map<String, String> sessionConf) throws HiveSQLException {
        return this.openSession(protocol, username, password, sessionConf, false, null);
    }

    public SessionHandle openSession(TProtocolVersion protocol, String username, String password, Map<String, String> sessionConf, boolean withImpersonation, String delegationToken) throws HiveSQLException {
        HiveSession session;
        if (withImpersonation) {
            HiveSessionImplwithUGI hiveSessionUgi = new HiveSessionImplwithUGI(protocol, username, password, this.hiveConf, TSetIpAddressProcessor.getUserIpAddress(), delegationToken);
            session = HiveSessionProxy.getProxy(hiveSessionUgi, hiveSessionUgi.getSessionUgi());
            hiveSessionUgi.setProxySession(session);
        } else {
            session = new HiveSessionImpl(protocol, username, password, this.hiveConf, TSetIpAddressProcessor.getUserIpAddress());
        }
        session.setSessionManager(this);
        session.setOperationManager(this.operationManager);
        session.setLogManager(this.logManager);
        session.initialize(sessionConf);
        session.open();
        this.handleToSession.put(session.getSessionHandle(), session);
        try {
            this.executeSessionHooks(session);
        }
        catch (Exception e) {
            throw new HiveSQLException("Failed to execute session hooks", e);
        }
        return session.getSessionHandle();
    }

    public void closeSession(SessionHandle sessionHandle) throws HiveSQLException {
        HiveSession session = this.handleToSession.remove(sessionHandle);
        if (session == null) {
            throw new HiveSQLException("Session does not exist!");
        }
        session.close();
    }

    public HiveSession getSession(SessionHandle sessionHandle) throws HiveSQLException {
        HiveSession session = this.handleToSession.get(sessionHandle);
        if (session == null) {
            throw new HiveSQLException("Invalid SessionHandle: " + sessionHandle);
        }
        return session;
    }

    public OperationManager getOperationManager() {
        return this.operationManager;
    }

    public LogManager getLogManager() {
        return this.logManager;
    }

    public static void setIpAddress(String ipAddress) {
        threadLocalIpAddress.set(ipAddress);
    }

    public static void clearIpAddress() {
        threadLocalIpAddress.remove();
    }

    public static String getIpAddress() {
        return threadLocalIpAddress.get();
    }

    public static void setUserName(String userName) {
        threadLocalUserName.set(userName);
    }

    public static void clearUserName() {
        threadLocalUserName.remove();
    }

    public static String getUserName() {
        return threadLocalUserName.get();
    }

    public static void setProxyUserName(String userName) {
        LOG.debug((Object)("setting proxy user name based on query param to: " + userName));
        threadLocalProxyUserName.set(userName);
    }

    public static String getProxyUserName() {
        return threadLocalProxyUserName.get();
    }

    public static void clearProxyUserName() {
        threadLocalProxyUserName.remove();
    }

    private void executeSessionHooks(HiveSession session) throws Exception {
        List sessionHooks = HookUtils.getHooks((HiveConf)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_SESSION_HOOK, HiveSessionHook.class);
        for (HiveSessionHook sessionHook : sessionHooks) {
            sessionHook.run(new HiveSessionHookContextImpl(session));
        }
    }

    public Future<?> submitBackgroundOperation(Runnable r) {
        return this.backgroundOperationPool.submit(r);
    }
}

