/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing.propertyeditors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;

public class BooleanPropertyEditor
implements PropertyEditor {
    private Boolean value;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    @Override
    public void setValue(Object value) {
        Boolean oldValue = this.value;
        this.value = value instanceof Boolean ? (Boolean)value : null;
        this.propertyChangeSupport.firePropertyChange((String)null, oldValue, this.value);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public String getJavaInitializationString() {
        if (this.value == null) {
            return "null";
        }
        if (Boolean.TRUE.equals(this.value)) {
            return "Boolean.TRUE";
        }
        return "Boolean.FALSE";
    }

    @Override
    public String getAsText() {
        if (this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (text == null) {
            this.setValue(null);
            return;
        }
        if ("true".equalsIgnoreCase(text)) {
            this.setValue(Boolean.TRUE);
        } else if ("false".equalsIgnoreCase(text)) {
            this.setValue(Boolean.FALSE);
        } else {
            this.setValue(null);
        }
    }

    @Override
    public String[] getTags() {
        return new String[]{null, "True", "False"};
    }

    @Override
    public Component getCustomEditor() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return false;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

