/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.kettle;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryRegistry;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.EmbeddedKettleDataFactoryMetaData;
import org.pentaho.reporting.libraries.base.util.FilesystemFilter;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class TransformationDatasourceMetadata {
    private static final String DATASOURCE_DIRECTORY = "datasources";
    private static final Log logger = LogFactory.getLog(TransformationDatasourceMetadata.class);
    private static final DirectoryFileFilter DIRECTORY_FILTER = new DirectoryFileFilter();
    private static final FilesystemFilter TEMPLATE_FILES_FILTER = new FilesystemFilter(new String[]{".ktr"}, "", false);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void registerDatasources() throws ReportDataFactoryException {
        ResourceManager resourceManager = new ResourceManager();
        URL templateLocation = TransformationDatasourceMetadata.class.getClassLoader().getResource(DATASOURCE_DIRECTORY);
        if (templateLocation != null) {
            try {
                File templateDir = new File(templateLocation.toURI());
                if (!templateDir.exists() || !templateDir.isDirectory()) return;
                TransformationDatasourceMetadata.processDirectory(templateDir, resourceManager);
                return;
            }
            catch (URISyntaxException e) {
                logger.error((Object)"Not able to access location of datasource templates. Some datasources may not be available.", (Throwable)e);
                throw new ReportDataFactoryException("Templated datasource not available.", (Throwable)e);
            }
        } else {
            logger.debug((Object)"No datasource template directory found. No templated datasources will be available.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processDirectory(File dir, ResourceManager resourceManager) {
        try {
            File[] dirs = dir.listFiles(DIRECTORY_FILTER);
            if (dirs == null) {
                return;
            }
            for (File f : dirs) {
                TransformationDatasourceMetadata.processDirectory(f, resourceManager);
            }
            Object[] templatesArray = dir.listFiles((FilenameFilter)TEMPLATE_FILES_FILTER);
            if (templatesArray == null) {
                return;
            }
            Arrays.sort(templatesArray);
            for (Object f : templatesArray) {
                String absolutePath = ((File)f).getAbsolutePath();
                try {
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream((File)f));
                    try {
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        IOUtils.getInstance().copyStreams((InputStream)in, (OutputStream)bout);
                        String possiblePluginId = absolutePath.substring(absolutePath.indexOf(DATASOURCE_DIRECTORY), absolutePath.length());
                        DataFactoryRegistry.getInstance().register((DataFactoryMetaData)new EmbeddedKettleDataFactoryMetaData(possiblePluginId, ((File)f).getName().replace(".ktr", ""), bout.toByteArray()));
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)"Datasource metadata successfully registered: ".concat(absolutePath));
                    }
                    finally {
                        ((InputStream)in).close();
                    }
                }
                catch (IOException ioe) {
                    logger.warn((Object)("Error reading template file: " + absolutePath), (Throwable)ioe);
                }
            }
        }
        catch (Exception se) {
            logger.error((Object)"Cannot access datasource template directory", (Throwable)se);
        }
    }

    private static class DirectoryFileFilter
    implements FileFilter {
        private DirectoryFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.getName().length() > 0 && file.getName().charAt(0) == '.') {
                return false;
            }
            return file.isDirectory();
        }
    }
}

