/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.kettle.writer;

import java.io.IOException;
import java.io.OutputStream;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.EmbeddedKettleTransformationProducer;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleTransformationProducer;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.writer.TransformationProducerWriteHandler;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.writer.TransformationProducerWriteHandlerLib;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.docbundle.BundleUtilities;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class EmdeddedTransformationProducerWriteHandler
implements TransformationProducerWriteHandler {
    @Override
    public void writeKettleRepositoryProducer(WriteableDocumentBundle bundle, String dataSourceFileName, XmlWriter xmlWriter, String queryName, KettleTransformationProducer producer) throws IOException, BundleWriterException {
        if (!(producer instanceof EmbeddedKettleTransformationProducer)) {
            throw new BundleWriterException("Invalid object type registered for handler of " + EmbeddedKettleTransformationProducer.class.getSimpleName());
        }
        EmbeddedKettleTransformationProducer fileProducer = (EmbeddedKettleTransformationProducer)producer;
        String absoluteResourceName = this.writeFile(bundle, dataSourceFileName, queryName, fileProducer);
        AttributeList coreAttrs = new AttributeList();
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "name", queryName);
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "plugin-id", fileProducer.getPluginId());
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "stop-on-error", String.valueOf(fileProducer.isStopOnError()));
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "query-embedded", coreAttrs, false);
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "resource", false);
        String resourceName = IOUtils.getInstance().createRelativePath(absoluteResourceName, dataSourceFileName);
        xmlWriter.writeText(resourceName);
        xmlWriter.writeCloseTag();
        TransformationProducerWriteHandlerLib.writeParameterAndArguments(xmlWriter, fileProducer);
        xmlWriter.writeCloseTag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeFile(WriteableDocumentBundle bundle, String contextFileName, String queryName, EmbeddedKettleTransformationProducer fileProducer) throws IOException {
        String fileName = BundleUtilities.getUniqueName((DocumentBundle)bundle, (String)contextFileName, (String)(queryName + "{0}.ktr"));
        if (fileName == null) {
            throw new IOException("Unable to generate unique name for unified datasource. ");
        }
        OutputStream outputStream = null;
        try {
            outputStream = bundle.createEntry(fileName, "text/xml");
            outputStream.write(fileProducer.getTransformationRaw());
        }
        finally {
            if (outputStream != null) {
                outputStream.flush();
                outputStream.close();
            }
        }
        return fileName;
    }
}

