/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.DBDSPool;
import com.ibm.as400.access.DBData;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.DBSQLRequestDS;
import com.ibm.as400.access.JDCursor;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDRow;
import com.ibm.as400.access.JDRowCache;
import com.ibm.as400.access.JDServerRow;
import com.ibm.as400.access.JDTrace;
import java.sql.SQLException;

class JDServerRowCache
implements JDRowCache {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private int blockingFactor_;
    private AS400JDBCConnection connection_;
    private boolean empty_;
    private boolean emptyChecked_;
    private boolean firstBlock_;
    private JDServerRow row_;
    private int id_;
    private boolean lastBlock_;
    private DBData serverData_;
    private boolean variableFieldCompressionSupported_ = false;
    private int bufferSize_;
    private JDCursor cursor_ = null;
    private int cached_;
    private int index_;
    private static int NOT_KNOWN = -9999;
    private int cursorPositionOfFirstRowInCache_ = NOT_KNOWN;

    JDServerRowCache(JDServerRow jDServerRow, AS400JDBCConnection aS400JDBCConnection, int n, int n2, boolean bl, int n3) throws SQLException {
        this.blockingFactor_ = n2;
        this.connection_ = aS400JDBCConnection;
        this.emptyChecked_ = this.lastBlock_ = bl;
        this.empty_ = this.lastBlock_;
        this.firstBlock_ = true;
        this.id_ = n;
        this.row_ = jDServerRow;
        this.serverData_ = null;
        this.cached_ = 0;
        this.index_ = -1;
        if (this.connection_.getServerFunctionalLevel() >= 14 && this.connection_.getProperties().getBoolean(65) && n3 == 1003) {
            this.variableFieldCompressionSupported_ = true;
        }
        this.bufferSize_ = this.connection_.getProperties().getInt(1);
        this.cursorPositionOfFirstRowInCache_ = 0;
        this.row_.setRowIndex(this.index_);
    }

    JDServerRowCache(JDServerRow jDServerRow, AS400JDBCConnection aS400JDBCConnection, int n, int n2, boolean bl, int n3, JDCursor jDCursor) throws SQLException {
        this(jDServerRow, aS400JDBCConnection, n, n2, bl, n3);
        this.cursor_ = jDCursor;
    }

    JDServerRowCache(JDServerRow jDServerRow, AS400JDBCConnection aS400JDBCConnection, int n, int n2, DBData dBData, boolean bl, int n3) throws SQLException {
        this.blockingFactor_ = n2;
        this.connection_ = aS400JDBCConnection;
        this.firstBlock_ = true;
        this.id_ = n;
        this.lastBlock_ = bl;
        this.row_ = jDServerRow;
        this.serverData_ = dBData;
        if (this.connection_.getServerFunctionalLevel() >= 14 && this.connection_.getProperties().getBoolean(65) && n3 == 1003) {
            this.variableFieldCompressionSupported_ = true;
        }
        this.bufferSize_ = this.connection_.getProperties().getInt(1);
        try {
            this.cached_ = dBData.getRowCount();
        }
        catch (DBDataStreamException dBDataStreamException) {
            JDError.throwSQLException("HY000", dBDataStreamException);
        }
        this.emptyChecked_ = true;
        this.empty_ = this.cached_ == 0;
        this.cursorPositionOfFirstRowInCache_ = this.cached_ > 0 ? 1 : 0;
        this.index_ = -1;
        this.row_.setRowIndex(this.index_);
        this.row_.setServerData(this.serverData_);
    }

    JDServerRowCache(JDServerRow jDServerRow, AS400JDBCConnection aS400JDBCConnection, int n, int n2, DBData dBData, boolean bl, int n3, JDCursor jDCursor) throws SQLException {
        this(jDServerRow, aS400JDBCConnection, n, n2, dBData, bl, n3);
        this.cursor_ = jDCursor;
    }

    private boolean fetch(int n) throws SQLException {
        return this.fetch(n, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetch(int n, int n2) throws SQLException {
        boolean bl = false;
        try {
            DBSQLRequestDS dBSQLRequestDS = null;
            DBReplyRequestedDS dBReplyRequestedDS = null;
            try {
                dBSQLRequestDS = DBDSPool.getDBSQLRequestDS(6155, this.id_, -2080374784, 0);
                dBSQLRequestDS.setFetchScrollOption(n, n2);
                if (n == 0 && this.blockingFactor_ > 0 && this.cursorPositionOfFirstRowInCache_ >= 0) {
                    if (this.variableFieldCompressionSupported_) {
                        dBSQLRequestDS.setVariableFieldCompression(true);
                        dBSQLRequestDS.setBufferSize(this.bufferSize_ * 1024);
                    } else {
                        dBSQLRequestDS.setBlockingFactor(this.blockingFactor_);
                    }
                } else {
                    dBSQLRequestDS.setBlockingFactor(1);
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this.connection_, "Fetching a block of data from the system");
                }
                dBReplyRequestedDS = this.connection_.sendAndReceive(dBSQLRequestDS, this.id_);
                int n3 = dBReplyRequestedDS.getErrorClass();
                int n4 = dBReplyRequestedDS.getReturnCode();
                if (n3 == 1 && n4 == 100 || n3 == 2 && n4 == 701) {
                    bl = true;
                } else if (n3 == 2 && n4 == 700) {
                    bl = true;
                    if (this.cursor_ != null) {
                        this.cursor_.setState(true);
                    }
                } else if (n3 != 0) {
                    if (n4 < 0) {
                        JDError.throwSQLException(this.connection_, this.id_, n3, n4);
                    } else {
                        this.connection_.postWarning(JDError.getSQLWarning(this.connection_, this.id_, n3, n4));
                    }
                }
                this.serverData_ = dBReplyRequestedDS.getResultData();
                if (this.serverData_ == null) {
                    bl = true;
                    this.cached_ = 0;
                } else {
                    this.row_.setServerData(this.serverData_);
                    this.cached_ = this.serverData_.getRowCount();
                }
                if (!this.emptyChecked_) {
                    this.emptyChecked_ = true;
                    this.empty_ = this.cached_ == 0;
                }
                Object var9_9 = null;
                if (dBSQLRequestDS != null) {
                    dBSQLRequestDS.inUse_ = false;
                }
                if (dBReplyRequestedDS != null) {
                    dBReplyRequestedDS.inUse_ = false;
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (dBSQLRequestDS != null) {
                    dBSQLRequestDS.inUse_ = false;
                }
                if (dBReplyRequestedDS != null) {
                    dBReplyRequestedDS.inUse_ = false;
                }
                throw throwable;
            }
        }
        catch (DBDataStreamException dBDataStreamException) {
            JDError.throwSQLException("HY000", dBDataStreamException);
        }
        return bl;
    }

    public void setFetchSize(int n) throws SQLException {
        if (this.connection_.getProperties().getInt(1) == 0) {
            this.blockingFactor_ = n;
        }
    }

    public void open() throws SQLException {
    }

    public void close() throws SQLException {
    }

    public void flush() throws SQLException {
        this.cached_ = 0;
        this.emptyChecked_ = false;
    }

    public void refreshRow() throws SQLException {
        this.fetch(6);
        this.index_ = 0;
        this.row_.setRowIndex(this.index_);
    }

    public JDRow getRow() {
        return this.row_;
    }

    public boolean isEmpty() throws SQLException {
        if (!this.emptyChecked_) {
            this.firstBlock_ = false;
            this.first(true);
            this.beforeFirst();
        }
        return this.empty_;
    }

    public boolean isValid() {
        return this.serverData_ != null && this.index_ >= 0 && this.index_ < this.cached_;
    }

    public void absolute(int n) throws SQLException {
        if (n > 0) {
            if (this.cursor_.isClosed()) {
                this.first(false);
            } else {
                this.first(true);
            }
            this.relative(n - 1);
        } else {
            this.last(true);
            this.relative(n + 1);
        }
    }

    public void afterLast() throws SQLException {
        if (this.lastBlock_) {
            this.index_ = this.cached_;
        } else {
            this.fetch(5);
            this.firstBlock_ = false;
            this.lastBlock_ = true;
            this.index_ = 0;
            this.cursorPositionOfFirstRowInCache_ = NOT_KNOWN;
        }
        this.row_.setRowIndex(this.index_);
    }

    public void beforeFirst() throws SQLException {
        if (this.firstBlock_) {
            this.index_ = -1;
        } else {
            this.fetch(4);
            this.firstBlock_ = true;
            this.lastBlock_ = false;
            this.index_ = -1;
            this.cursorPositionOfFirstRowInCache_ = 0;
        }
        this.row_.setRowIndex(this.index_);
    }

    public void first() throws SQLException {
        this.first(false);
    }

    void first(boolean bl) throws SQLException {
        if (this.emptyChecked_ && !bl && this.firstBlock_) {
            this.index_ = 0;
        } else {
            this.fetch(2);
            this.firstBlock_ = true;
            this.lastBlock_ = false;
            this.index_ = 0;
            this.cursorPositionOfFirstRowInCache_ = 1;
        }
        this.row_.setRowIndex(this.index_);
    }

    public void last() throws SQLException {
        this.last(false);
    }

    void last(boolean bl) throws SQLException {
        if (this.lastBlock_ && this.cached_ > 0 && !bl) {
            this.index_ = this.cached_ - 1;
        } else {
            this.fetch(3);
            this.firstBlock_ = false;
            this.lastBlock_ = true;
            this.index_ = 0;
            this.cursorPositionOfFirstRowInCache_ = NOT_KNOWN;
        }
        this.row_.setRowIndex(this.index_);
    }

    public void next() throws SQLException {
        if (this.index_ < this.cached_ - 1) {
            ++this.index_;
        } else if (this.lastBlock_) {
            this.index_ = this.cached_;
        } else {
            int n = this.cached_;
            this.lastBlock_ = this.fetch(0);
            this.firstBlock_ = false;
            this.index_ = 0;
            this.cursorPositionOfFirstRowInCache_ = this.cursorPositionOfFirstRowInCache_ > 0 ? (this.cursorPositionOfFirstRowInCache_ += n) : 1;
        }
        this.row_.setRowIndex(this.index_);
    }

    public void previous() throws SQLException {
        if (this.index_ >= 1) {
            --this.index_;
        } else if (!this.firstBlock_) {
            if (this.cached_ > 1) {
                if (this.cursorPositionOfFirstRowInCache_ > 0) {
                    this.absolute(this.cursorPositionOfFirstRowInCache_);
                } else {
                    JDError.throwSQLException("HY000");
                }
            }
            this.firstBlock_ = this.fetch(1);
            this.lastBlock_ = false;
            this.index_ = this.cached_ - 1;
            this.cursorPositionOfFirstRowInCache_ = this.firstBlock_ ? 1 : --this.cursorPositionOfFirstRowInCache_;
        } else {
            this.index_ = -1;
        }
        this.row_.setRowIndex(this.index_);
    }

    public void relative(int n) throws SQLException {
        if (n != 0) {
            int n2 = this.index_ + n;
            if (n2 >= 0 && n2 < this.cached_) {
                this.index_ = n2;
            } else {
                if (this.cached_ > 1) {
                    if (this.cursorPositionOfFirstRowInCache_ > 0) {
                        this.absolute(this.cursorPositionOfFirstRowInCache_ + this.index_);
                    } else {
                        JDError.throwSQLException("HY000");
                    }
                }
                boolean bl = this.fetch(7, n);
                this.firstBlock_ = false;
                if (!bl) {
                    this.index_ = 0;
                    this.lastBlock_ = bl;
                }
                this.cursorPositionOfFirstRowInCache_ = this.cursorPositionOfFirstRowInCache_ > 0 ? (this.cursorPositionOfFirstRowInCache_ += n) : NOT_KNOWN;
            }
        }
        this.row_.setRowIndex(this.index_);
    }
}

