/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPAttributeIDList;
import com.ibm.as400.access.NPCPData;
import com.ibm.as400.access.NPCPID;
import com.ibm.as400.access.NPCPSelection;
import com.ibm.as400.access.NPCPSplFHandle;
import com.ibm.as400.access.NPCodePoint;
import com.ibm.as400.access.NPConversation;
import com.ibm.as400.access.NPDataStream;
import com.ibm.as400.access.NPSystem;
import com.ibm.as400.access.PrintObjectPageInputStreamImpl;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.SpooledFileImpl;
import com.ibm.as400.access.SpooledFileImplRemote;
import com.ibm.as400.access.Trace;
import java.io.IOException;

class PrintObjectPageInputStreamImplRemote
implements PrintObjectPageInputStreamImpl {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private NPConversation conversation_;
    private NPCPAttribute cpCPFMsg_;
    private NPCodePoint cpObjHndl_;
    private NPCPID cpObjID_;
    private int currentPage_ = 0;
    private int markLimit_ = 0;
    private boolean markSet_ = false;
    private int numberOfPages_ = 0;
    private boolean pagesEst_ = false;
    private int numBytes_ = 0;
    private NPSystem npSystem_;
    private int objectType_;
    private int offset_ = 0;
    private int offsetFromMark_ = 0;

    PrintObjectPageInputStreamImplRemote() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void createPrintObjectPageInputStream(SpooledFileImpl spooledFileImpl, PrintParameterList printParameterList) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        this.objectType_ = 1;
        this.npSystem_ = NPSystem.getSystem(((SpooledFileImplRemote)spooledFileImpl).getSystem());
        this.cpObjID_ = ((SpooledFileImplRemote)spooledFileImpl).getIDCodePoint();
        this.cpCPFMsg_ = new NPCPAttribute();
        this.cpObjHndl_ = new NPCPSplFHandle();
        NPDataStream nPDataStream = new NPDataStream(this.objectType_);
        nPDataStream.setAction(26);
        nPDataStream.addCodePoint(this.cpObjID_);
        NPCPSelection nPCPSelection = new NPCPSelection();
        if (printParameterList != null) {
            nPCPSelection.addUpdateAttributes(printParameterList.getAttrCodePoint());
        }
        nPCPSelection.setAttrValue(214, "*YES");
        nPDataStream.addCodePoint(nPCPSelection);
        NPDataStream nPDataStream2 = new NPDataStream(this.objectType_);
        nPDataStream2.addCodePoint(this.cpObjHndl_);
        nPDataStream2.addCodePoint(this.cpCPFMsg_);
        this.conversation_ = this.npSystem_.getConversation();
        boolean bl = false;
        try {
            int n = this.conversation_.makeRequest(nPDataStream, nPDataStream2);
            if (n != 0) {
                Trace.log(2, "Error opening SpooledFile; rc = " + n);
                throw new ErrorCompletingRequestException(1);
            }
            this.retrievePageInformation();
            this.currentPage_ = 1;
            bl = true;
            Object var9_8 = null;
            if (!bl) {
                if (this.npSystem_ != null) {
                    this.npSystem_.returnConversation(this.conversation_);
                }
                this.conversation_ = null;
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (!bl) {
                if (this.npSystem_ != null) {
                    this.npSystem_.returnConversation(this.conversation_);
                }
                this.conversation_ = null;
            }
            throw throwable;
        }
    }

    public int available() throws IOException {
        return this.numBytes_ - this.offset_;
    }

    public void close() throws IOException {
        if (this.conversation_ == null) {
            Trace.log(2, "Conversation is null.");
            throw new IOException();
        }
        NPDataStream nPDataStream = new NPDataStream(this.objectType_);
        nPDataStream.setAction(5);
        nPDataStream.addCodePoint(this.cpObjHndl_);
        NPDataStream nPDataStream2 = new NPDataStream(this.objectType_);
        nPDataStream2.addCodePoint(this.cpCPFMsg_);
        try {
            block7: {
                try {
                    int n = this.conversation_.makeRequest(nPDataStream, nPDataStream2);
                    if (n == 0) break block7;
                    Trace.log(2, "Error closing SpooledFile; rc = " + n);
                    this.npSystem_.returnConversation(this.conversation_);
                }
                catch (Exception exception) {
                    Trace.log(2, "Caught an Exception." + exception.toString());
                    throw new IOException(exception.toString());
                }
            }
            Object var5_5 = null;
            if (this.npSystem_ != null) {
                this.npSystem_.returnConversation(this.conversation_);
                this.npSystem_ = null;
            }
            this.conversation_ = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (this.npSystem_ != null) {
                this.npSystem_.returnConversation(this.conversation_);
                this.npSystem_ = null;
            }
            this.conversation_ = null;
            throw throwable;
        }
    }

    protected void finalize() throws Throwable {
        if (this.conversation_ != null) {
            NPDataStream nPDataStream = new NPDataStream(this.objectType_);
            nPDataStream.setAction(5);
            nPDataStream.addCodePoint(this.cpObjHndl_);
            AS400Server aS400Server = this.conversation_.getServer();
            if (aS400Server != null) {
                nPDataStream.setConverter(this.conversation_.getConverter());
                aS400Server.sendAndDiscardReply(nPDataStream);
            }
            if (this.npSystem_ != null) {
                this.npSystem_.returnConversation(this.conversation_);
                this.npSystem_ = null;
            }
            this.conversation_ = null;
        }
        super.finalize();
    }

    public int getCurrentPageNumber() {
        return this.currentPage_;
    }

    public int getNumberOfPages() {
        return this.numberOfPages_;
    }

    public boolean isPagesEstimated() {
        return this.pagesEst_;
    }

    public synchronized void mark(int n) {
        this.offsetFromMark_ = 0;
        int n2 = this.numBytes_ - this.offset_;
        if (n > n2) {
            n = n2;
        }
        this.markLimit_ = n;
        this.markSet_ = true;
    }

    public boolean nextPage() throws IOException {
        return this.selectPage(this.currentPage_ + 1);
    }

    public boolean previousPage() throws IOException {
        return this.selectPage(this.currentPage_ - 1);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        if (this.conversation_ == null) {
            Trace.log(2, "Conversation is null.");
            throw new IOException();
        }
        NPCPAttribute nPCPAttribute = new NPCPAttribute();
        nPCPAttribute.setAttrValue(125, n2);
        NPDataStream nPDataStream = new NPDataStream(this.objectType_);
        nPDataStream.setAction(3);
        nPDataStream.addCodePoint(this.cpObjHndl_);
        nPDataStream.addCodePoint(nPCPAttribute);
        NPCPData nPCPData = new NPCPData();
        nPCPData.setDataBuffer(byArray, 0, n);
        NPDataStream nPDataStream2 = new NPDataStream(this.objectType_);
        nPDataStream2.addCodePoint(nPCPData);
        nPDataStream2.addCodePoint(this.cpCPFMsg_);
        try {
            int n4 = this.conversation_.makeRequest(nPDataStream, nPDataStream2);
            switch (n4) {
                case 0: 
                case 18: {
                    n3 = nPCPData.getDataLength();
                    this.offsetFromMark_ += n3;
                    this.offset_ += n3;
                    break;
                }
                case 32: {
                    n3 = -1;
                    break;
                }
                case 19: {
                    n3 = -1;
                    break;
                }
                default: {
                    Trace.log(2, "Error received on read : " + Integer.toString(n4));
                    throw new IOException(Integer.toString(n4));
                }
            }
        }
        catch (Exception exception) {
            Trace.log(2, "Caught an Exception." + exception.toString());
            throw new IOException(exception.toString());
        }
        return n3;
    }

    public synchronized void reset() throws IOException {
        if (this.conversation_ == null) {
            Trace.log(2, "Conversation is null.");
            throw new IOException();
        }
        if (!this.markSet_) {
            Trace.log(2, "Mark not set.");
            throw new IOException();
        }
        if (this.markLimit_ == 0 || this.offsetFromMark_ > this.markLimit_) {
            Trace.log(4, "Stream has not been marked or mark has been invalidated.");
            throw new IOException();
        }
        if (this.offsetFromMark_ != 0) {
            this.seekFromCur(-this.offsetFromMark_);
        }
    }

    private void retrieveNumberOfPageBytes() throws IOException, RequestNotSupportedException {
        NPCPAttributeIDList nPCPAttributeIDList = new NPCPAttributeIDList();
        nPCPAttributeIDList.addAttrID(125);
        NPDataStream nPDataStream = new NPDataStream(this.objectType_);
        nPDataStream.addCodePoint(this.cpObjHndl_);
        nPDataStream.addCodePoint(nPCPAttributeIDList);
        nPDataStream.setAction(24);
        NPDataStream nPDataStream2 = new NPDataStream(this.objectType_);
        NPCPAttribute nPCPAttribute = new NPCPAttribute();
        nPDataStream2.addCodePoint(nPCPAttribute);
        try {
            Integer n;
            int n2 = this.conversation_.makeRequest(nPDataStream, nPDataStream2);
            if (n2 == 0) {
                n = nPCPAttribute.getIntValue(125);
                if (n == null) {
                    Trace.log(2, "Network Print Server does not support retrieving spooled file page length.");
                    throw new RequestNotSupportedException(this.conversation_.getAttribute(141), 1);
                }
            } else {
                Trace.log(2, "Network Print Server error retrieving spooled file page length. RC =" + n2);
                throw new RequestNotSupportedException(this.conversation_.getAttribute(141), 1);
            }
            this.numBytes_ = n;
        }
        catch (Exception exception) {
            Trace.log(2, "Caught an Exception." + exception.toString());
            throw new IOException(exception.toString());
        }
    }

    private void retrievePageInformation() throws IOException {
        block5: {
            if (this.conversation_ == null) {
                Trace.log(2, "Conversation is null.");
                throw new IOException();
            }
            NPCPAttributeIDList nPCPAttributeIDList = new NPCPAttributeIDList();
            nPCPAttributeIDList.addAttrID(111);
            nPCPAttributeIDList.addAttrID(218);
            nPCPAttributeIDList.addAttrID(125);
            NPDataStream nPDataStream = new NPDataStream(this.objectType_);
            nPDataStream.setAction(24);
            nPDataStream.addCodePoint(this.cpObjHndl_);
            nPDataStream.addCodePoint(nPCPAttributeIDList);
            NPDataStream nPDataStream2 = new NPDataStream(this.objectType_);
            NPCPAttribute nPCPAttribute = new NPCPAttribute();
            nPDataStream2.addCodePoint(nPCPAttribute);
            try {
                int n = this.conversation_.makeRequest(nPDataStream, nPDataStream2);
                if (n == 0) {
                    Integer n2 = nPCPAttribute.getIntValue(111);
                    String string = nPCPAttribute.getStringValue(218);
                    Integer n3 = nPCPAttribute.getIntValue(125);
                    if (n2 == null || string == null || n3 == null) {
                        Trace.log(2, "NPServer.TELL returned null page information!");
                        throw new RequestNotSupportedException(this.conversation_.getAttribute(141), 1);
                    }
                    this.numberOfPages_ = n2;
                    this.numBytes_ = n3;
                    this.pagesEst_ = string.equals("*YES");
                    break block5;
                }
                Trace.log(2, "Error received retrieving page information : " + Integer.toString(n));
                throw new IOException(Integer.toString(n));
            }
            catch (Exception exception) {
                Trace.log(2, "Caught an Exception." + exception.toString());
                throw new IOException(exception.toString());
            }
        }
    }

    public boolean selectPage(int n) throws IOException, IllegalArgumentException {
        if (this.conversation_ == null) {
            Trace.log(2, "Conversation is null.");
            throw new IOException();
        }
        if (this.currentPage_ == n && this.offset_ == 0) {
            return true;
        }
        if (n < 0) {
            Trace.log(2, "NPServer.SELECT_PAGE error: Page number negative");
            throw new IllegalArgumentException();
        }
        NPCPAttribute nPCPAttribute = new NPCPAttribute();
        nPCPAttribute.setAttrValue(215, n);
        NPDataStream nPDataStream = new NPDataStream(this.objectType_);
        nPDataStream.setAction(25);
        nPDataStream.addCodePoint(this.cpObjHndl_);
        nPDataStream.addCodePoint(nPCPAttribute);
        NPDataStream nPDataStream2 = new NPDataStream(this.objectType_);
        nPDataStream2.addCodePoint(this.cpCPFMsg_);
        try {
            int n2 = this.conversation_.makeRequest(nPDataStream, nPDataStream2);
            switch (n2) {
                case 0: {
                    this.currentPage_ = n;
                    this.markSet_ = false;
                    this.markLimit_ = 0;
                    this.offset_ = 0;
                    this.offsetFromMark_ = 0;
                    this.retrieveNumberOfPageBytes();
                    return true;
                }
                case 33: {
                    Trace.log(2, "NPServer.SELECT_PAGE error: Page out of range");
                    return false;
                }
            }
            Trace.log(2, "NPServer.SELECT_PAGE error: " + Integer.toString(n2));
            throw new IOException(Integer.toString(n2));
        }
        catch (Exception exception) {
            Trace.log(2, "Caught an Exception." + exception.toString());
            throw new IOException(exception.toString());
        }
    }

    private void seekFromCur(int n) throws IOException {
        NPCPAttribute nPCPAttribute = new NPCPAttribute();
        nPCPAttribute.setAttrValue(127, 2);
        nPCPAttribute.setAttrValue(126, n);
        NPDataStream nPDataStream = new NPDataStream(this.objectType_);
        nPDataStream.setAction(23);
        nPDataStream.addCodePoint(this.cpObjHndl_);
        nPDataStream.addCodePoint(nPCPAttribute);
        NPDataStream nPDataStream2 = new NPDataStream(this.objectType_);
        nPDataStream2.addCodePoint(this.cpCPFMsg_);
        try {
            int n2 = this.conversation_.makeRequest(nPDataStream, nPDataStream2);
            switch (n2) {
                case 0: {
                    this.offsetFromMark_ += n;
                    this.offset_ += n;
                    break;
                }
                default: {
                    Trace.log(2, "Seek from cur error " + Integer.toString(n2));
                    throw new IOException(Integer.toString(n2));
                }
            }
        }
        catch (Exception exception) {
            Trace.log(2, "Caught an Exception." + exception.toString());
            throw new IOException(exception.toString());
        }
    }

    public long skip(long l) throws IOException {
        if (this.conversation_ == null) {
            Trace.log(2, "Conversation is null.");
            throw new IOException();
        }
        int n = this.numBytes_ - this.offset_;
        if (l > (long)n) {
            l = n;
        }
        this.seekFromCur((int)l);
        return l;
    }
}

