/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.laf.BasePropertyHandler;
import org.pentaho.di.version.BuildVersion;

public class Const {
    private static Class<?> PKG = Const.class;
    @Deprecated
    public static final String VERSION = BuildVersion.getInstance().getVersion();
    public static final String COPYRIGHT_YEAR = "2014";
    public static final int TIMEOUT_GET_MILLIS = 50;
    public static final int TIMEOUT_PUT_MILLIS = 50;
    public static final int ROWS_UPDATE = 50000;
    public static final int ROWS_IN_ROWSET = 10000;
    public static final int FETCH_SIZE = 10000;
    public static final int SORT_SIZE = 5000;
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");
    public static final String CR = System.getProperty("line.separator");
    public static final String DOSCR = "\n\r";
    public static final String EMPTY_STRING = "";
    public static final String JAVA_VERSION = System.getProperty("java.vm.version");
    @Deprecated
    public static final String USER_HOME_DIRECTORY = Const.NVL(System.getProperty("KETTLE_HOME"), System.getProperty("user.home"));
    public static String JNDI_DIRECTORY = Const.NVL(System.getProperty("KETTLE_JNDI_ROOT"), System.getProperty("org.osjava.sj.root"));
    public static final String PLUGIN_BASE_FOLDERS_PROP = "KETTLE_PLUGIN_BASE_FOLDERS";
    public static final String DEFAULT_PLUGIN_BASE_FOLDERS = "plugins," + (Const.isEmpty(Const.getDIHomeDirectory()) ? "" : Const.getDIHomeDirectory() + FILE_SEPARATOR + "plugins,") + Const.getKettleDirectory() + FILE_SEPARATOR + "plugins";
    public static final Date MIN_DATE = new Date(-2208992400000L);
    public static final Date MAX_DATE = new Date(7258114799468L);
    public static final int MIN_YEAR = 1900;
    public static final int MAX_YEAR = 2199;
    public static final int RIGHT = 400;
    public static final int LENGTH = 350;
    public static final int MARGIN = 4;
    public static final int MIDDLE_PCT = 35;
    public static final int ARROW_WIDTH = 1;
    public static final int FORM_MARGIN = 5;
    public static final int SHADOW_SIZE = 4;
    public static final int SYMBOLSIZE = 10;
    public static final int MAX_FILE_HIST = 9;
    public static final Locale DEFAULT_LOCALE = Locale.getDefault();
    public static final char DEFAULT_DECIMAL_SEPARATOR = new DecimalFormatSymbols(DEFAULT_LOCALE).getDecimalSeparator();
    public static final char DEFAULT_GROUPING_SEPARATOR = new DecimalFormatSymbols(DEFAULT_LOCALE).getGroupingSeparator();
    public static final String DEFAULT_CURRENCY_SYMBOL = new DecimalFormatSymbols(DEFAULT_LOCALE).getCurrencySymbol();
    public static final String DEFAULT_NUMBER_FORMAT = ((DecimalFormat)NumberFormat.getInstance()).toPattern();
    public static final String NULL_STRING = "";
    public static final String NULL_NUMBER = "";
    public static final String NULL_DATE = "";
    public static final String NULL_BIGNUMBER = "";
    public static final String NULL_BOOLEAN = "";
    public static final String NULL_INTEGER = "";
    public static final String NULL_BINARY = "";
    public static final String NULL_NONE = "";
    public static final String CHEF_LOG_FILE = "chef";
    public static final String SPOON_LOG_FILE = "spoon";
    public static final String MENU_LOG_FILE = "menu";
    private static String[] tips;
    private static String[] dateFormats;
    private static String[] numberFormats;
    public static final String GENERALIZED_DATE_TIME_FORMAT = "yyyyddMM_hhmmss";
    public static final String GENERALIZED_DATE_TIME_FORMAT_MILLIS = "yyyyddMM_hhmmssSSS";
    public static final String XML_ENCODING = "UTF-8";
    public static final String[] STRING_TRANS_AND_JOB_FILTER_EXT;
    private static String[] STRING_TRANS_AND_JOB_FILTER_NAMES;
    public static final String STRING_TRANS_DEFAULT_EXT = "ktr";
    public static final String[] STRING_TRANS_FILTER_EXT;
    private static String[] STRING_TRANS_FILTER_NAMES;
    public static final String STRING_JOB_DEFAULT_EXT = "kjb";
    public static final String[] STRING_JOB_FILTER_EXT;
    private static String[] STRING_JOB_FILTER_NAMES;
    public static final String KETTLE_PROPERTIES = "kettle.properties";
    public static final String INTERNAL_VARIABLE_PREFIX = "Internal";
    public static final String INTERNAL_VARIABLE_KETTLE_VERSION = "Internal.Kettle.Version";
    public static final String INTERNAL_VARIABLE_KETTLE_BUILD_VERSION = "Internal.Kettle.Build.Version";
    public static final String INTERNAL_VARIABLE_KETTLE_BUILD_DATE = "Internal.Kettle.Build.Date";
    public static final String INTERNAL_VARIABLE_JOB_FILENAME_DIRECTORY = "Internal.Job.Filename.Directory";
    public static final String INTERNAL_VARIABLE_JOB_FILENAME_NAME = "Internal.Job.Filename.Name";
    public static final String INTERNAL_VARIABLE_JOB_NAME = "Internal.Job.Name";
    public static final String INTERNAL_VARIABLE_JOB_REPOSITORY_DIRECTORY = "Internal.Job.Repository.Directory";
    public static final String INTERNAL_VARIABLE_JOB_RUN_ID = "Internal.Job.Run.ID";
    public static final String INTERNAL_VARIABLE_JOB_RUN_ATTEMPTNR = "Internal.Job.Run.AttemptNr";
    public static final String[] INTERNAL_TRANS_VARIABLES;
    public static final String[] INTERNAL_JOB_VARIABLES;
    public static final String INTERNAL_VARIABLE_TRANSFORMATION_FILENAME_DIRECTORY = "Internal.Transformation.Filename.Directory";
    public static final String INTERNAL_VARIABLE_TRANSFORMATION_FILENAME_NAME = "Internal.Transformation.Filename.Name";
    public static final String INTERNAL_VARIABLE_TRANSFORMATION_NAME = "Internal.Transformation.Name";
    public static final String INTERNAL_VARIABLE_TRANSFORMATION_REPOSITORY_DIRECTORY = "Internal.Transformation.Repository.Directory";
    public static final String INTERNAL_VARIABLE_STEP_PARTITION_ID = "Internal.Step.Partition.ID";
    public static final String INTERNAL_VARIABLE_STEP_PARTITION_NR = "Internal.Step.Partition.Number";
    public static final String INTERNAL_VARIABLE_SLAVE_SERVER_NUMBER = "Internal.Slave.Transformation.Number";
    public static final String INTERNAL_VARIABLE_SLAVE_SERVER_NAME = "Internal.Slave.Server.Name";
    public static final String INTERNAL_VARIABLE_CLUSTER_SIZE = "Internal.Cluster.Size";
    public static final String INTERNAL_VARIABLE_STEP_UNIQUE_NUMBER = "Internal.Step.Unique.Number";
    public static final String INTERNAL_VARIABLE_CLUSTER_MASTER = "Internal.Cluster.Master";
    public static final String INTERNAL_VARIABLE_CLUSTER_RUN_ID = "Internal.Cluster.Run.ID";
    public static final String INTERNAL_VARIABLE_STEP_UNIQUE_COUNT = "Internal.Step.Unique.Count";
    public static final String INTERNAL_VARIABLE_STEP_NAME = "Internal.Step.Name";
    public static final String INTERNAL_VARIABLE_STEP_COPYNR = "Internal.Step.CopyNr";
    public static final int MAX_NR_LOG_LINES = 5000;
    public static final int MAX_NR_HISTORY_LINES = 50;
    public static final int HISTORY_LINES_FETCH_SIZE = 10;
    public static final int MAX_LOG_LINE_TIMEOUT_MINUTES = 720;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final int INFO = 3;
    public static final int NOTE_MARGIN = 5;
    public static final int MAX_UNDO = 100;
    public static final String KETTLE_VARIABLES_FILE = "kettle-variables.xml";
    public static final String KETTLE_LOG_SIZE_LIMIT = "KETTLE_LOG_SIZE_LIMIT";
    public static final String KETTLE_TRANS_LOG_DB = "KETTLE_TRANS_LOG_DB";
    public static final String KETTLE_TRANS_LOG_SCHEMA = "KETTLE_TRANS_LOG_SCHEMA";
    public static final String KETTLE_TRANS_LOG_TABLE = "KETTLE_TRANS_LOG_TABLE";
    public static final String KETTLE_JOB_LOG_DB = "KETTLE_JOB_LOG_DB";
    public static final String KETTLE_JOB_LOG_SCHEMA = "KETTLE_JOB_LOG_SCHEMA";
    public static final String KETTLE_JOB_LOG_TABLE = "KETTLE_JOB_LOG_TABLE";
    public static final String KETTLE_TRANS_PERFORMANCE_LOG_DB = "KETTLE_TRANS_PERFORMANCE_LOG_DB";
    public static final String KETTLE_TRANS_PERFORMANCE_LOG_SCHEMA = "KETTLE_TRANS_PERFORMANCE_LOG_SCHEMA";
    public static final String KETTLE_TRANS_PERFORMANCE_LOG_TABLE = "KETTLE_TRANS_PERFORMANCE_LOG_TABLE";
    public static final String KETTLE_JOBENTRY_LOG_DB = "KETTLE_JOBENTRY_LOG_DB";
    public static final String KETTLE_JOBENTRY_LOG_SCHEMA = "KETTLE_JOBENTRY_LOG_SCHEMA";
    public static final String KETTLE_JOBENTRY_LOG_TABLE = "KETTLE_JOBENTRY_LOG_TABLE";
    public static final String KETTLE_STEP_LOG_DB = "KETTLE_STEP_LOG_DB";
    public static final String KETTLE_STEP_LOG_SCHEMA = "KETTLE_STEP_LOG_SCHEMA";
    public static final String KETTLE_STEP_LOG_TABLE = "KETTLE_STEP_LOG_TABLE";
    public static final String KETTLE_CHANNEL_LOG_DB = "KETTLE_CHANNEL_LOG_DB";
    public static final String KETTLE_CHANNEL_LOG_SCHEMA = "KETTLE_CHANNEL_LOG_SCHEMA";
    public static final String KETTLE_CHANNEL_LOG_TABLE = "KETTLE_CHANNEL_LOG_TABLE";
    public static final String KETTLE_METRICS_LOG_DB = "KETTLE_METRICS_LOG_DB";
    public static final String KETTLE_METRICS_LOG_SCHEMA = "KETTLE_METRICS_LOG_SCHEMA";
    public static final String KETTLE_METRICS_LOG_TABLE = "KETTLE_METRICS_LOG_TABLE";
    public static final String KETTLE_CHECKPOINT_LOG_DB = "KETTLE_CHECKPOINT_LOG_DB";
    public static final String KETTLE_CHECKPOINT_LOG_SCHEMA = "KETTLE_CHECKPOINT_LOG_SCHEMA";
    public static final String KETTLE_CHECKPOINT_LOG_TABLE = "KETTLE_CHECKPOINT_LOG_TABLE";
    public static final String KETTLE_SHARED_OBJECTS = "KETTLE_SHARED_OBJECTS";
    public static final String KETTLE_EMPTY_STRING_DIFFERS_FROM_NULL = "KETTLE_EMPTY_STRING_DIFFERS_FROM_NULL";
    public static final String KETTLE_LENIENT_STRING_TO_NUMBER_CONVERSION = "KETTLE_LENIENT_STRING_TO_NUMBER_CONVERSION";
    public static final String KETTLE_COMPATIBILITY_DB_IGNORE_TIMEZONE = "KETTLE_COMPATIBILITY_DB_IGNORE_TIMEZONE";
    public static final String KETTLE_COMPATIBILITY_IMPORT_PATH_ADDITION_ON_VARIABLES = "KETTLE_COMPATIBILITY_IMPORT_PATH_ADDITION_ON_VARIABLES";
    public static final String KETTLE_COMPATIBILITY_TEXT_FILE_OUTPUT_APPEND_NO_HEADER = "KETTLE_COMPATIBILITY_TEXT_FILE_OUTPUT_APPEND_NO_HEADER";
    public static final String KETTLE_SYSTEM_HOSTNAME = "KETTLE_SYSTEM_HOSTNAME";
    public static final String KETTLE_MAX_LOG_SIZE_IN_LINES = "KETTLE_MAX_LOG_SIZE_IN_LINES";
    public static final String KETTLE_MAX_LOG_TIMEOUT_IN_MINUTES = "KETTLE_MAX_LOG_TIMEOUT_IN_MINUTES";
    public static final String KETTLE_REDIRECT_STDERR = "KETTLE_REDIRECT_STDERR";
    public static final String KETTLE_REDIRECT_STDOUT = "KETTLE_REDIRECT_STDOUT";
    public static final String KETTLE_CARTE_OBJECT_TIMEOUT_MINUTES = "KETTLE_CARTE_OBJECT_TIMEOUT_MINUTES";
    public static final String KETTLE_STEP_PERFORMANCE_SNAPSHOT_LIMIT = "KETTLE_STEP_PERFORMANCE_SNAPSHOT_LIMIT";
    public static final String KETTLE_MAX_JOB_TRACKER_SIZE = "KETTLE_MAX_JOB_TRACKER_SIZE";
    public static final String KETTLE_MAX_JOB_ENTRIES_LOGGED = "KETTLE_MAX_JOB_ENTRIES_LOGGED";
    public static final String KETTLE_MAX_LOGGING_REGISTRY_SIZE = "KETTLE_MAX_LOGGING_REGISTRY_SIZE";
    public static final String KETTLE_SAP_CONNECTION_FACTORY = "KETTLE_SAP_CONNECTION_FACTORY";
    public static final String KETTLE_SAP_CONNECTION_FACTORY_DEFAULT_NAME = "org.pentaho.di.trans.steps.sapinput.sap.SAPConnectionFactory";
    public static final String KETTLE_PLUGIN_CLASSES = "KETTLE_PLUGIN_CLASSES";
    public static final String KETTLE_PLUGIN_PACKAGES = "KETTLE_PLUGIN_PACKAGES";
    public static final String KETTLE_TRANS_ROWSET_SIZE = "KETTLE_TRANS_ROWSET_SIZE";
    public static final String VERSION_COMMENT_INITIAL_VERSION = "Creation of initial version";
    public static final String VERSION_COMMENT_EDIT_VERSION = "Modification by user";
    public static final String XML_FILE_KETTLE_STEPS = "kettle-steps.xml";
    public static final String KETTLE_CORE_STEPS_FILE = "KETTLE_CORE_STEPS_FILE";
    public static final String XML_FILE_KETTLE_PARTITION_PLUGINS = "kettle-partition-plugins.xml";
    public static final String KETTLE_CORE_JOBENTRIES_FILE = "KETTLE_CORE_JOBENTRIES_FILE";
    public static final String XML_FILE_KETTLE_SERVLETS = "kettle-servlets.xml";
    public static final String XML_FILE_KETTLE_VALUEMETA_PLUGINS = "kettle-valuemeta-plugins.xml";
    public static final String XML_FILE_KETTLE_PASSWORD_ENCODER_PLUGINS = "kettle-password-encoder-plugins.xml";
    public static final String KETTLE_VALUEMETA_PLUGINS_FILE = "KETTLE_VALUEMETA_PLUGINS_FILE";
    public static final String KETTLE_PASSWORD_ENCODER_PLUGIN = "KETTLE_PASSWORD_ENCODER_PLUGIN";
    public static final String KETTLE_PASSWORD_ENCODER_PLUGINS_FILE = "KETTLE_PASSWORD_ENCODER_PLUGINS_FILE";
    public static final String XML_FILE_KETTLE_LOGGING_PLUGINS = "kettle-logging-plugins.xml";
    public static final String KETTLE_LOGGING_PLUGINS_FILE = "KETTLE_LOGGING_PLUGINS_FILE";
    public static final String KETTLE_CORE_SERVLETS_FILE = "KETTLE_CORE_SERVLETS_FILE";
    public static final String KETTLE_ROWSET_GET_TIMEOUT = "KETTLE_ROWSET_GET_TIMEOUT";
    public static final String KETTLE_ROWSET_PUT_TIMEOUT = "KETTLE_ROWSET_PUT_TIMEOUT";
    public static final String KETTLE_BATCHING_ROWSET = "KETTLE_BATCHING_ROWSET";
    public static final String KETTLE_DISABLE_CONSOLE_LOGGING = "KETTLE_DISABLE_CONSOLE_LOGGING";
    public static final String XML_FILE_KETTLE_JOB_ENTRIES = "kettle-job-entries.xml";
    public static final String XML_FILE_KETTLE_REPOSITORIES = "kettle-repositories.xml";
    public static final String XML_FILE_KETTLE_DATABASE_TYPES = "kettle-database-types.xml";
    public static final String XML_FILE_KETTLE_COMPRESSION_PROVIDERS = "kettle-compression-providers.xml";
    public static final String XML_FILE_KETTLE_AUTHENTICATION_PROVIDERS = "kettle-authentication-providers.xml";
    public static final String XML_FILE_KETTLE_EXTENSION_POINTS = "kettle-extension-points.xml";
    public static final String KETTLE_TRANS_PAN_JVM_EXIT_CODE = "KETTLE_TRANS_PAN_JVM_EXIT_CODE";
    public static final String KETTLE_DEFAULT_NUMBER_FORMAT = "KETTLE_DEFAULT_NUMBER_FORMAT";
    public static final String KETTLE_DEFAULT_BIGNUMBER_FORMAT = "KETTLE_DEFAULT_BIGNUMBER_FORMAT";
    public static final String KETTLE_DEFAULT_INTEGER_FORMAT = "KETTLE_DEFAULT_INTEGER_FORMAT";
    public static final String KETTLE_DEFAULT_DATE_FORMAT = "KETTLE_DEFAULT_DATE_FORMAT";
    public static final String KETTLE_AGGREGATION_MIN_NULL_IS_VALUED = "KETTLE_AGGREGATION_MIN_NULL_IS_VALUED";
    public static final String KETTLE_AGGREGATION_ALL_NULLS_ARE_ZERO = "KETTLE_AGGREGATION_ALL_NULLS_ARE_ZERO";
    public static final String KETTLE_DEFAULT_TIMESTAMP_FORMAT = "KETTLE_DEFAULT_TIMESTAMP_FORMAT";
    public static final String KETTLE_COMPATIBILITY_SET_ERROR_ON_SPECIFIC_JOB_ENTRIES = "KETTLE_COMPATIBILITY_SET_ERROR_ON_SPECIFIC_JOB_ENTRIES";
    public static final String XML_FILE_KETTLE_IMPORT_RULES = "kettle-import-rules.xml";
    private static String[] emptyPaddedSpacesStrings;
    public static final ReleaseType RELEASE;
    public static final String PENTAHO_METASTORE_FOLDER = "PENTAHO_METASTORE_FOLDER";
    public static final String PENTAHO_METASTORE_NAME = "Pentaho Local Client Metastore";
    public static final String KETTLE_LOG_MARK_MAPPINGS = "KETTLE_LOG_MARK_MAPPINGS";
    public static final String KETTLE_CARTE_JETTY_ACCEPTORS = "KETTLE_CARTE_JETTY_ACCEPTORS";
    public static final String KETTLE_CARTE_JETTY_ACCEPT_QUEUE_SIZE = "KETTLE_CARTE_JETTY_ACCEPT_QUEUE_SIZE";
    public static final String KETTLE_CARTE_JETTY_RES_MAX_IDLE_TIME = "KETTLE_CARTE_JETTY_RES_MAX_IDLE_TIME";
    private static String cachedHostname;

    public static final double round(double f, int places) {
        return Const.round(f, places, 6);
    }

    public static final double round(double f, int places, int roundingMode) {
        if (f == Double.NaN || f == Double.NEGATIVE_INFINITY || f == Double.POSITIVE_INFINITY) {
            return f;
        }
        BigDecimal bdtemp = BigDecimal.valueOf(f);
        bdtemp = bdtemp.setScale(places, roundingMode);
        return bdtemp.doubleValue();
    }

    public static final int toInt(String str, int def) {
        int retval;
        try {
            retval = Integer.parseInt(str);
        }
        catch (Exception e) {
            retval = def;
        }
        return retval;
    }

    public static final long toLong(String str, long def) {
        long retval;
        try {
            retval = Long.parseLong(str);
        }
        catch (Exception e) {
            retval = def;
        }
        return retval;
    }

    public static final double toDouble(String str, double def) {
        double retval;
        try {
            retval = Double.parseDouble(str);
        }
        catch (Exception e) {
            retval = def;
        }
        return retval;
    }

    public static final Date toDate(String str, Date def) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS", Locale.US);
        try {
            return df.parse(str);
        }
        catch (ParseException e) {
            return def;
        }
    }

    public static final boolean isSpace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n' || Character.isWhitespace(c);
    }

    public static String ltrim(String source) {
        int from;
        if (source == null) {
            return null;
        }
        for (from = 0; from < source.length() && Const.isSpace(source.charAt(from)); ++from) {
        }
        return source.substring(from);
    }

    public static String rtrim(String source) {
        int max;
        if (source == null) {
            return null;
        }
        for (max = source.length(); max > 0 && Const.isSpace(source.charAt(max - 1)); --max) {
        }
        return source.substring(0, max);
    }

    public static final String trim(String str) {
        int min;
        if (str == null) {
            return null;
        }
        int max = str.length() - 1;
        for (min = 0; min <= max && Const.isSpace(str.charAt(min)); ++min) {
        }
        while (max >= 0 && Const.isSpace(str.charAt(max))) {
            --max;
        }
        if (max < min) {
            return "";
        }
        return str.substring(min, max + 1);
    }

    public static final String rightPad(String ret, int limit) {
        if (ret == null) {
            return Const.rightPad(new StringBuffer(), limit);
        }
        return Const.rightPad(new StringBuffer(ret), limit);
    }

    public static final String rightPad(StringBuffer ret, int limit) {
        int len = ret.length();
        if (len > limit) {
            ret.setLength(limit);
        } else {
            for (int l = len; l < limit; ++l) {
                ret.append(' ');
            }
        }
        return ret.toString();
    }

    public static final String replace(String string, String repl, String with) {
        StringBuffer str = new StringBuffer(string);
        for (int i = str.length() - 1; i >= 0; --i) {
            if (!str.substring(i).startsWith(repl)) continue;
            str.delete(i, i + repl.length());
            str.insert(i, with);
        }
        return str.toString();
    }

    public static void repl(StringBuffer str, String code, String repl) {
        int clength = code.length();
        for (int i = str.length() - clength; i >= 0; --i) {
            String look = str.substring(i, i + clength);
            if (!look.equalsIgnoreCase(code)) continue;
            str.replace(i, i + clength, repl);
        }
    }

    public static final int nrSpacesBefore(String field) {
        int nr;
        int len = field.length();
        for (nr = 0; nr < len && field.charAt(nr) == ' '; ++nr) {
        }
        return nr;
    }

    public static final int nrSpacesAfter(String field) {
        int nr;
        int len = field.length();
        for (nr = 0; nr < len && field.charAt(field.length() - 1 - nr) == ' '; ++nr) {
        }
        return nr;
    }

    public static final boolean onlySpaces(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (Const.isSpace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static final String getOS() {
        return System.getProperty("os.name");
    }

    public static String getQuoteCharByOS() {
        if (Const.isWindows()) {
            return "\"";
        }
        return "'";
    }

    public static String optionallyQuoteStringByOS(String string) {
        String quote = Const.getQuoteCharByOS();
        if (Const.isEmpty(string)) {
            return quote;
        }
        if (string.indexOf(quote) >= 0 || string.indexOf(32) < 0 && string.indexOf(61) < 0) {
            return string;
        }
        return quote + string + quote;
    }

    public static final boolean isWindows() {
        return Const.getOS().startsWith("Windows");
    }

    public static final boolean isLinux() {
        return Const.getOS().startsWith("Linux");
    }

    public static final boolean isOSX() {
        return Const.getOS().toUpperCase().contains("OS X");
    }

    public static final String getHostname() {
        if (cachedHostname != null) {
            return cachedHostname;
        }
        String systemHostname = EnvUtil.getSystemProperty(KETTLE_SYSTEM_HOSTNAME);
        if (!Const.isEmpty(systemHostname)) {
            cachedHostname = systemHostname;
            return systemHostname;
        }
        String lastHostname = "localhost";
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                InetAddress in;
                NetworkInterface nwi = en.nextElement();
                Enumeration<InetAddress> ip = nwi.getInetAddresses();
                while (ip.hasMoreElements() && ((lastHostname = (in = ip.nextElement()).getHostName()).equalsIgnoreCase("localhost") || lastHostname.indexOf(58) >= 0)) {
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        cachedHostname = lastHostname;
        return lastHostname;
    }

    public static final String getHostnameReal() {
        String systemHostname = EnvUtil.getSystemProperty(KETTLE_SYSTEM_HOSTNAME);
        if (!Const.isEmpty(systemHostname)) {
            return systemHostname;
        }
        if (Const.isWindows()) {
            return System.getenv("COMPUTERNAME");
        }
        String hostname = System.getenv("HOSTNAME");
        if (hostname != null) {
            return hostname;
        }
        try {
            Process pr = Runtime.getRuntime().exec("hostname");
            BufferedReader br = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            String line = br.readLine();
            if (line != null) {
                return line;
            }
            pr.waitFor();
            br.close();
        }
        catch (IOException e) {
            return Const.getHostname();
        }
        catch (InterruptedException e) {
            return Const.getHostname();
        }
        return Const.getHostname();
    }

    public static final String getIPAddress() throws Exception {
        Enumeration<NetworkInterface> enumInterfaces = NetworkInterface.getNetworkInterfaces();
        while (enumInterfaces.hasMoreElements()) {
            NetworkInterface nwi = enumInterfaces.nextElement();
            Enumeration<InetAddress> ip = nwi.getInetAddresses();
            while (ip.hasMoreElements()) {
                InetAddress in = ip.nextElement();
                if (in.isLoopbackAddress() || in.toString().indexOf(":") >= 0) continue;
                return in.getHostAddress();
            }
        }
        return "127.0.0.1";
    }

    public static final String getIPAddress(String networkInterfaceName) throws SocketException {
        NetworkInterface networkInterface = NetworkInterface.getByName(networkInterfaceName);
        Enumeration<InetAddress> ipAddresses = networkInterface.getInetAddresses();
        while (ipAddresses.hasMoreElements()) {
            InetAddress inetAddress = ipAddresses.nextElement();
            if (inetAddress.isLoopbackAddress() || inetAddress.toString().indexOf(":") >= 0) continue;
            String hostname = inetAddress.getHostAddress();
            return hostname;
        }
        return null;
    }

    public static final String getMACAddress() throws Exception {
        String ip = Const.getIPAddress();
        String mac = "none";
        String os = Const.getOS();
        String s = "";
        Boolean errorOccured = false;
        if (os.equalsIgnoreCase("Windows NT") || os.equalsIgnoreCase("Windows 2000") || os.equalsIgnoreCase("Windows XP") || os.equalsIgnoreCase("Windows 95") || os.equalsIgnoreCase("Windows 98") || os.equalsIgnoreCase("Windows Me") || os.startsWith("Windows")) {
            try {
                Process p = Runtime.getRuntime().exec("nbtstat -a " + ip);
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while (!Const.procDone(p)) {
                    while ((s = stdInput.readLine()) != null) {
                        if (s.indexOf("MAC") < 0) continue;
                        int idx = s.indexOf(61);
                        mac = s.substring(idx + 2);
                    }
                }
                stdInput.close();
            }
            catch (Exception e) {
                errorOccured = true;
            }
        } else if (os.equalsIgnoreCase("Linux")) {
            try {
                Process p = Runtime.getRuntime().exec("/sbin/ifconfig -a");
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while (!Const.procDone(p)) {
                    while ((s = stdInput.readLine()) != null) {
                        int idx = s.indexOf("HWaddr");
                        if (idx < 0) continue;
                        mac = s.substring(idx + 7);
                    }
                }
                stdInput.close();
            }
            catch (Exception e) {
                errorOccured = true;
            }
        } else if (os.equalsIgnoreCase("Solaris")) {
            try {
                Process p = Runtime.getRuntime().exec("/usr/sbin/ifconfig -a");
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while (!Const.procDone(p)) {
                    while ((s = stdInput.readLine()) != null) {
                        int idx = s.indexOf("ether");
                        if (idx < 0) continue;
                        mac = s.substring(idx + 6);
                    }
                }
                stdInput.close();
            }
            catch (Exception e) {
                errorOccured = true;
            }
        } else if (os.equalsIgnoreCase("HP-UX")) {
            try {
                Process p = Runtime.getRuntime().exec("/usr/sbin/lanscan -a");
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while (!Const.procDone(p)) {
                    while ((s = stdInput.readLine()) != null) {
                        if (s.indexOf("MAC") < 0) continue;
                        int idx = s.indexOf("0x");
                        mac = s.substring(idx + 2);
                    }
                }
                stdInput.close();
            }
            catch (Exception e) {
                errorOccured = true;
            }
        }
        return Const.trim(mac);
    }

    private static final boolean procDone(Process p) {
        try {
            p.exitValue();
            return true;
        }
        catch (IllegalThreadStateException e) {
            return false;
        }
    }

    public static final String getUserHomeDirectory() {
        return Const.NVL(System.getProperty("KETTLE_HOME"), System.getProperty("user.home"));
    }

    public static final String getKettleDirectory() {
        return Const.getUserHomeDirectory() + FILE_SEPARATOR + BasePropertyHandler.getProperty("userBaseDir", ".kettle");
    }

    public static final String getDIHomeDirectory() {
        return System.getProperty("DI_HOME");
    }

    public static final String getSharedObjectsFile() {
        return Const.getKettleDirectory() + FILE_SEPARATOR + "shared.xml";
    }

    public static final String getKettleLocalRepositoriesFile() {
        return "repositories.xml";
    }

    public static final String getKettleUserRepositoriesFile() {
        return Const.getKettleDirectory() + FILE_SEPARATOR + Const.getKettleLocalRepositoriesFile();
    }

    public static final String getKettleLocalCartePasswordFile() {
        return "pwd/kettle.pwd";
    }

    public static final String getKettleCartePasswordFile() {
        return Const.getKettleDirectory() + FILE_SEPARATOR + "kettle.pwd";
    }

    public static String getEnvironmentVariable(String variable, String deflt) {
        return System.getProperty(variable, deflt);
    }

    @Deprecated
    public static final String replEnv(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer str = new StringBuffer(string);
        int idx = str.indexOf("%%");
        while (idx >= 0) {
            int to = str.indexOf("%%", idx + 2);
            if (to >= 0) {
                String newval;
                String marker = str.substring(idx, to + 2);
                String var = str.substring(idx + 2, to);
                if (var != null && var.length() > 0 && (newval = Const.getEnvironmentVariable(var, null)) != null) {
                    str.replace(idx, to + 2, newval);
                    to += newval.length() - marker.length();
                }
            } else {
                to = idx;
            }
            idx = str.indexOf("%%", to + 1);
        }
        return str.toString();
    }

    @Deprecated
    public static final String[] replEnv(String[] string) {
        String[] retval = new String[string.length];
        for (int i = 0; i < string.length; ++i) {
            retval[i] = Const.replEnv(string[i]);
        }
        return retval;
    }

    public static final String NVL(String source, String def) {
        if (source == null || source.length() == 0) {
            return def;
        }
        return source;
    }

    public static final String nullToEmpty(String source) {
        if (source == null) {
            return "";
        }
        return source;
    }

    public static final int indexOfString(String lookup, String[] array) {
        if (array == null) {
            return -1;
        }
        if (lookup == null) {
            return -1;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!lookup.equalsIgnoreCase(array[i])) continue;
            return i;
        }
        return -1;
    }

    public static final int[] indexsOfStrings(String[] lookup, String[] array) {
        int[] indexes = new int[lookup.length];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = Const.indexOfString(lookup[i], array);
        }
        return indexes;
    }

    public static final int[] indexsOfFoundStrings(String[] lookup, String[] array) {
        ArrayList<Integer> indexesList = new ArrayList<Integer>();
        for (int i = 0; i < lookup.length; ++i) {
            int idx = Const.indexOfString(lookup[i], array);
            if (idx < 0) continue;
            indexesList.add(idx);
        }
        int[] indexes = new int[indexesList.size()];
        for (int i = 0; i < indexesList.size(); ++i) {
            indexes[i] = (Integer)indexesList.get(i);
        }
        return indexes;
    }

    public static final int indexOfString(String lookup, List<String> list) {
        if (list == null) {
            return -1;
        }
        for (int i = 0; i < list.size(); ++i) {
            String compare = list.get(i);
            if (!lookup.equalsIgnoreCase(compare)) continue;
            return i;
        }
        return -1;
    }

    public static final String[] sortStrings(String[] input) {
        Arrays.sort(input);
        return input;
    }

    public static final String[] splitString(String string, String separator) {
        ArrayList<String> list = new ArrayList<String>();
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        int sepLen = separator.length();
        int from = 0;
        int end = string.length() - sepLen + 1;
        for (int i = from; i < end; i += sepLen) {
            if (!string.substring(i, i + sepLen).equalsIgnoreCase(separator)) continue;
            list.add(Const.NVL(string.substring(from, i), ""));
            from = i + sepLen;
        }
        if (from + sepLen <= string.length()) {
            list.add(Const.NVL(string.substring(from, string.length()), ""));
        }
        return list.toArray(new String[list.size()]);
    }

    public static final String[] splitString(String string, char separator) {
        return Const.splitString(string, separator, false);
    }

    public static final String[] splitString(String string, char separator, boolean escape) {
        ArrayList<String> list = new ArrayList<String>();
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        int from = 0;
        int end = string.length();
        for (int i = from; i < end; ++i) {
            boolean found;
            boolean bl = found = string.charAt(i) == separator;
            if (found && escape && i > 0) {
                found &= string.charAt(i - 1) != '\\';
            }
            if (!found) continue;
            list.add(Const.NVL(string.substring(from, i), ""));
            from = i + 1;
        }
        if (from + 1 <= string.length()) {
            list.add(Const.NVL(string.substring(from, string.length()), ""));
        }
        return list.toArray(new String[list.size()]);
    }

    public static final String[] splitPath(String path, String separator) {
        int from;
        if (path == null || path.length() == 0 || path.equals(separator)) {
            return new String[0];
        }
        while (path.endsWith(separator)) {
            path = path.substring(0, path.length() - 1);
        }
        int sepLen = separator.length();
        int nr_separators = 1;
        for (int i = from = path.startsWith(separator) ? sepLen : 0; i < path.length(); i += sepLen) {
            if (!path.substring(i, i + sepLen).equalsIgnoreCase(separator)) continue;
            ++nr_separators;
        }
        String[] spath = new String[nr_separators];
        int nr = 0;
        for (int i = from; i < path.length(); i += sepLen) {
            if (!path.substring(i, i + sepLen).equalsIgnoreCase(separator)) continue;
            spath[nr] = path.substring(from, i);
            ++nr;
            from = i + sepLen;
        }
        if (nr < spath.length) {
            spath[nr] = path.substring(from);
        }
        if (spath.length == 0 && path.length() > 0) {
            spath = new String[]{path};
        }
        return spath;
    }

    public static String[] splitString(String stringToSplit, String delimiter, String enclosure) {
        ArrayList<String> splitList = null;
        if (stringToSplit == null) {
            return null;
        }
        if (delimiter == null) {
            return new String[]{stringToSplit};
        }
        String[] delimiterSplit = stringToSplit.split(Pattern.quote(delimiter));
        if (Const.isEmpty(enclosure)) {
            return delimiterSplit;
        }
        StringBuffer concatSplit = null;
        if (delimiterSplit != null && delimiterSplit.length > 0) {
            splitList = new ArrayList<String>();
            for (String currentSplit : delimiterSplit) {
                if (!currentSplit.contains(enclosure)) {
                    if (concatSplit != null) {
                        concatSplit.append(delimiter);
                        concatSplit.append(currentSplit);
                        continue;
                    }
                    splitList.add(currentSplit);
                    continue;
                }
                int numEnclosures = StringUtils.countMatches((String)currentSplit, (String)enclosure);
                boolean oddNumberOfEnclosures = numEnclosures % 2 != 0;
                boolean addSplit = false;
                if (concatSplit == null) {
                    concatSplit = new StringBuffer(currentSplit);
                    addSplit = !oddNumberOfEnclosures;
                } else {
                    concatSplit.append(delimiter);
                    concatSplit.append(currentSplit);
                    addSplit = oddNumberOfEnclosures;
                }
                if (!addSplit) continue;
                splitList.add(concatSplit.toString());
                concatSplit = null;
                addSplit = false;
            }
        }
        return splitList.toArray(new String[splitList.size()]);
    }

    public static final String[] getDistinctStrings(String[] strings) {
        if (strings == null) {
            return null;
        }
        if (strings.length == 0) {
            return new String[0];
        }
        String[] sorted = Const.sortStrings(strings);
        ArrayList<String> result = new ArrayList<String>();
        String previous = "";
        for (int i = 0; i < sorted.length; ++i) {
            if (!sorted[i].equalsIgnoreCase(previous)) {
                result.add(sorted[i]);
            }
            previous = sorted[i];
        }
        return result.toArray(new String[result.size()]);
    }

    public static final String getStackTracker(Throwable e) {
        return Const.getClassicStackTrace(e);
    }

    public static final String getClassicStackTrace(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        String string = stringWriter.toString();
        try {
            stringWriter.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return string;
    }

    public static String getCustomStackTrace(Throwable aThrowable) {
        StringBuilder result = new StringBuilder();
        String errorMessage = aThrowable.toString();
        result.append(errorMessage);
        if (!errorMessage.contains(CR)) {
            result.append(CR);
        }
        for (StackTraceElement element : aThrowable.getStackTrace()) {
            result.append(element);
            result.append(CR);
        }
        return result.toString();
    }

    public static final boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static final boolean isEmpty(StringBuffer string) {
        return string == null || string.length() == 0;
    }

    public static final boolean isEmpty(String[] strings) {
        return strings == null || strings.length == 0;
    }

    public static final boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static final boolean isEmpty(List<?> list) {
        return list == null || list.size() == 0;
    }

    public static final ClassLoader createNewClassLoader() throws KettleException {
        try {
            URL[] urls = new URL[]{};
            URLClassLoader ucl = new URLClassLoader(urls);
            return ucl;
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error during classloader creation", e);
        }
    }

    public static final byte[] createByteArray(int size) {
        return new byte[size];
    }

    public static final String initCap(String string) {
        StringBuffer change = new StringBuffer(string);
        boolean new_word = true;
        for (int i = 0; i < string.length(); ++i) {
            char upper;
            char lower = change.substring(i, i + 1).toLowerCase().charAt(0);
            char ch = upper = change.substring(i, i + 1).toUpperCase().charAt(0);
            if (new_word) {
                change.setCharAt(i, upper);
            } else {
                change.setCharAt(i, lower);
            }
            new_word = false;
            if (Character.isLetterOrDigit((int)ch) || ch == '_') continue;
            new_word = true;
        }
        return change.toString();
    }

    public static final String createFilename(String name) {
        StringBuffer filename = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isUnicodeIdentifierPart(c)) {
                filename.append(c);
                continue;
            }
            if (!Character.isWhitespace(c)) continue;
            filename.append('_');
        }
        return filename.toString().toLowerCase();
    }

    public static final String createFilename(String directory, String name, String extension) {
        if (directory.endsWith(FILE_SEPARATOR)) {
            return directory + Const.createFilename(name) + extension;
        }
        return directory + FILE_SEPARATOR + Const.createFilename(name) + extension;
    }

    public static final String createName(String filename) {
        if (Const.isEmpty(filename)) {
            return filename;
        }
        String pureFilename = Const.filenameOnly(filename);
        if (pureFilename.endsWith(".ktr") || pureFilename.endsWith(".kjb") || pureFilename.endsWith(".xml")) {
            pureFilename = pureFilename.substring(0, pureFilename.length() - 4);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < pureFilename.length(); ++i) {
            char c = pureFilename.charAt(i);
            if (Character.isUnicodeIdentifierPart(c)) {
                sb.append(c);
                continue;
            }
            if (Character.isWhitespace(c)) {
                sb.append(' ');
                continue;
            }
            if (c != '-') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String filenameOnly(String sFullPath) {
        if (Const.isEmpty(sFullPath)) {
            return sFullPath;
        }
        int idx = sFullPath.lastIndexOf(FILE_SEPARATOR);
        if (idx != -1) {
            return sFullPath.substring(idx + 1);
        }
        idx = sFullPath.lastIndexOf(47);
        if (idx != -1) {
            return sFullPath.substring(idx + 1);
        }
        return sFullPath;
    }

    public static String[] getTips() {
        if (tips == null) {
            int tipsOfDayCount = Const.toInt(BaseMessages.getString(PKG, "Const.TipOfDay.Count", new String[0]), 0);
            tips = new String[tipsOfDayCount];
            for (int i = 1; i <= tipsOfDayCount; ++i) {
                Const.tips[i - 1] = BaseMessages.getString(PKG, "Const.TipOfDay" + Integer.toString(i), new String[0]);
            }
        }
        return tips;
    }

    public static String[] getDateFormats() {
        if (dateFormats == null) {
            int dateFormatsCount = Const.toInt(BaseMessages.getString(PKG, "Const.DateFormat.Count", new String[0]), 0);
            dateFormats = new String[dateFormatsCount];
            for (int i = 1; i <= dateFormatsCount; ++i) {
                Const.dateFormats[i - 1] = BaseMessages.getString(PKG, "Const.DateFormat" + Integer.toString(i), new String[0]);
            }
        }
        return dateFormats;
    }

    public static String[] getNumberFormats() {
        if (numberFormats == null) {
            int numberFormatsCount = Const.toInt(BaseMessages.getString(PKG, "Const.NumberFormat.Count", new String[0]), 0);
            numberFormats = new String[numberFormatsCount + 1];
            Const.numberFormats[0] = DEFAULT_NUMBER_FORMAT;
            for (int i = 1; i <= numberFormatsCount; ++i) {
                Const.numberFormats[i] = BaseMessages.getString(PKG, "Const.NumberFormat" + Integer.toString(i), new String[0]);
            }
        }
        return numberFormats;
    }

    public static String[] getConversionFormats() {
        int x;
        String[] dats = Const.getDateFormats();
        String[] nums = Const.getNumberFormats();
        int totsize = dats.length + nums.length;
        String[] formats = new String[totsize];
        for (x = 0; x < dats.length; ++x) {
            formats[x] = dats[x];
        }
        for (x = 0; x < nums.length; ++x) {
            formats[dats.length + x] = nums[x];
        }
        return formats;
    }

    public static String[] getTransformationAndJobFilterNames() {
        if (STRING_TRANS_AND_JOB_FILTER_NAMES == null) {
            STRING_TRANS_AND_JOB_FILTER_NAMES = new String[]{BaseMessages.getString(PKG, "Const.FileFilter.TransformationJob", new String[0]), BaseMessages.getString(PKG, "Const.FileFilter.Transformations", new String[0]), BaseMessages.getString(PKG, "Const.FileFilter.Jobs", new String[0]), BaseMessages.getString(PKG, "Const.FileFilter.XML", new String[0]), BaseMessages.getString(PKG, "Const.FileFilter.All", new String[0])};
        }
        return STRING_TRANS_AND_JOB_FILTER_NAMES;
    }

    public static String[] getTransformationFilterNames() {
        if (STRING_TRANS_FILTER_NAMES == null) {
            STRING_TRANS_FILTER_NAMES = new String[]{BaseMessages.getString(PKG, "Const.FileFilter.Transformations", new String[0]), BaseMessages.getString(PKG, "Const.FileFilter.XML", new String[0]), BaseMessages.getString(PKG, "Const.FileFilter.All", new String[0])};
        }
        return STRING_TRANS_FILTER_NAMES;
    }

    public static String[] getJobFilterNames() {
        if (STRING_JOB_FILTER_NAMES == null) {
            STRING_JOB_FILTER_NAMES = new String[]{BaseMessages.getString(PKG, "Const.FileFilter.Jobs", new String[0]), BaseMessages.getString(PKG, "Const.FileFilter.XML", new String[0]), BaseMessages.getString(PKG, "Const.FileFilter.All", new String[0])};
        }
        return STRING_JOB_FILTER_NAMES;
    }

    public static long nanoTime() {
        return new Date().getTime() * 1000L;
    }

    public static String trimToType(String string, int trimType) {
        switch (trimType) {
            case 3: {
                return Const.trim(string);
            }
            case 1: {
                return Const.ltrim(string);
            }
            case 2: {
                return Const.rtrim(string);
            }
        }
        return string;
    }

    public static String safeAppendDirectory(String dir, String file) {
        boolean fileHasSeparator;
        boolean dirHasSeparator = dir.lastIndexOf(FILE_SEPARATOR) == dir.length();
        boolean bl = fileHasSeparator = file.indexOf(FILE_SEPARATOR) != 0;
        if (dirHasSeparator && !fileHasSeparator || !dirHasSeparator && fileHasSeparator) {
            return dir + file;
        }
        if (dirHasSeparator && fileHasSeparator) {
            return dir + file.substring(1);
        }
        return dir + FILE_SEPARATOR + file;
    }

    public static String[] getEmptyPaddedStrings() {
        if (emptyPaddedSpacesStrings == null) {
            emptyPaddedSpacesStrings = new String[250];
            for (int i = 0; i < emptyPaddedSpacesStrings.length; ++i) {
                Const.emptyPaddedSpacesStrings[i] = Const.rightPad("", i);
            }
        }
        return emptyPaddedSpacesStrings;
    }

    public static final int getPercentageFreeMemory() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        long totalFreeMemory = freeMemory + (maxMemory - allocatedMemory);
        int percentage = (int)Math.round(100.0 * (double)totalFreeMemory / (double)maxMemory);
        return percentage;
    }

    public static String removeDigits(String input) {
        if (Const.isEmpty(input)) {
            return null;
        }
        StringBuffer digitsOnly = new StringBuffer();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (Character.isDigit(c)) continue;
            digitsOnly.append(c);
        }
        return digitsOnly.toString();
    }

    public static String getDigitsOnly(String input) {
        if (Const.isEmpty(input)) {
            return null;
        }
        StringBuffer digitsOnly = new StringBuffer();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (!Character.isDigit(c)) continue;
            digitsOnly.append(c);
        }
        return digitsOnly.toString();
    }

    public static Date removeTimeFromDate(Date input) {
        if (input == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(false);
        calendar.setTime(input);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static String escapeXML(String content) {
        if (Const.isEmpty(content)) {
            return content;
        }
        return StringEscapeUtils.escapeXml((String)content);
    }

    public static String escapeHtml(String content) {
        if (Const.isEmpty(content)) {
            return content;
        }
        return StringEscapeUtils.escapeHtml((String)content);
    }

    public static String unEscapeHtml(String content) {
        if (Const.isEmpty(content)) {
            return content;
        }
        return StringEscapeUtils.unescapeHtml((String)content);
    }

    public static String unEscapeXml(String content) {
        if (Const.isEmpty(content)) {
            return content;
        }
        return StringEscapeUtils.unescapeXml((String)content);
    }

    public static String escapeSQL(String content) {
        if (Const.isEmpty(content)) {
            return content;
        }
        return StringEscapeUtils.escapeSql((String)content);
    }

    public static String removeCRLF(String in) {
        char[] inArray = in.toCharArray();
        StringBuffer out = new StringBuffer(inArray.length);
        for (int i = 0; i < inArray.length; ++i) {
            char c = inArray[i];
            if (c == '\n' || c == '\r') continue;
            out.append(c);
        }
        return out.toString();
    }

    public static String removeCR(String in) {
        char[] inArray = in.toCharArray();
        StringBuffer out = new StringBuffer(inArray.length);
        for (int i = 0; i < inArray.length; ++i) {
            char c = inArray[i];
            if (c == '\n') continue;
            out.append(c);
        }
        return out.toString();
    }

    public static String removeLF(String in) {
        char[] inArray = in.toCharArray();
        StringBuffer out = new StringBuffer(inArray.length);
        for (int i = 0; i < inArray.length; ++i) {
            char c = inArray[i];
            if (c == '\r') continue;
            out.append(c);
        }
        return out.toString();
    }

    public static String removeTAB(String in) {
        char[] inArray = in.toCharArray();
        StringBuffer out = new StringBuffer(inArray.length);
        for (int i = 0; i < inArray.length; ++i) {
            char c = inArray[i];
            if (c == '\t') continue;
            out.append(c);
        }
        return out.toString();
    }

    public static Date addTimeToDate(Date input, String time, String DateFormat2) throws Exception {
        if (Const.isEmpty(time)) {
            return input;
        }
        if (input == null) {
            return null;
        }
        String dateformatString = Const.NVL(DateFormat2, "HH:mm:ss");
        int t = Const.decodeTime(time, dateformatString);
        Date d = new Date(input.getTime() + (long)t);
        return d;
    }

    public static int decodeTime(String s, String DateFormat2) throws Exception {
        SimpleDateFormat f = new SimpleDateFormat(DateFormat2);
        TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
        f.setTimeZone(utcTimeZone);
        f.setLenient(false);
        ParsePosition p = new ParsePosition(0);
        Date d = f.parse(s, p);
        if (d == null) {
            throw new Exception("Invalid time value " + DateFormat2 + ": \"" + s + "\".");
        }
        return (int)d.getTime();
    }

    public static int getOccurenceString(String string, String searchFor) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        int counter = 0;
        int len = searchFor.length();
        if (len > 0) {
            int start = string.indexOf(searchFor);
            while (start != -1) {
                start = string.indexOf(searchFor, start + len);
            }
        }
        return counter;
    }

    public static String[] GetAvailableFontNames() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fonts = ge.getAllFonts();
        String[] FontName = new String[fonts.length];
        for (int i = 0; i < fonts.length; ++i) {
            FontName[i] = fonts[i].getFontName();
        }
        return FontName;
    }

    public static String getKettlePropertiesFileHeader() {
        StringBuilder out = new StringBuilder();
        out.append(BaseMessages.getString(PKG, "Props.Kettle.Properties.Sample.Line01", BuildVersion.getInstance().getVersion()) + CR);
        out.append(BaseMessages.getString(PKG, "Props.Kettle.Properties.Sample.Line02", new String[0]) + CR);
        out.append(BaseMessages.getString(PKG, "Props.Kettle.Properties.Sample.Line03", new String[0]) + CR);
        out.append(BaseMessages.getString(PKG, "Props.Kettle.Properties.Sample.Line04", new String[0]) + CR);
        out.append(BaseMessages.getString(PKG, "Props.Kettle.Properties.Sample.Line05", new String[0]) + CR);
        out.append(BaseMessages.getString(PKG, "Props.Kettle.Properties.Sample.Line06", new String[0]) + CR);
        out.append(BaseMessages.getString(PKG, "Props.Kettle.Properties.Sample.Line07", new String[0]) + CR);
        out.append(BaseMessages.getString(PKG, "Props.Kettle.Properties.Sample.Line08", new String[0]) + CR);
        out.append(BaseMessages.getString(PKG, "Props.Kettle.Properties.Sample.Line09", new String[0]) + CR);
        out.append(BaseMessages.getString(PKG, "Props.Kettle.Properties.Sample.Line10", new String[0]) + CR);
        return out.toString();
    }

    public static String protectXMLCDATA(String content) {
        if (Const.isEmpty(content)) {
            return content;
        }
        return "<![CDATA[" + content + "]]>";
    }

    public static int getOcuranceString(String string, String searchFor) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        Pattern p = Pattern.compile(searchFor);
        Matcher m = p.matcher(string);
        int count = 0;
        while (m.find()) {
            ++count;
        }
        return count;
    }

    public static String escapeXml(String content) {
        if (Const.isEmpty(content)) {
            return content;
        }
        return StringEscapeUtils.escapeXml((String)content);
    }

    public static String Lpad(String valueToPad, String filler, int size) {
        if (size == 0) {
            return valueToPad;
        }
        while (valueToPad.length() < size) {
            valueToPad = filler + valueToPad;
        }
        return valueToPad;
    }

    public static String Rpad(String valueToPad, String filler, int size) {
        if (size == 0) {
            return valueToPad;
        }
        while (valueToPad.length() < size) {
            valueToPad = valueToPad + filler;
        }
        return valueToPad;
    }

    public static boolean classIsOrExtends(Class<?> clazz, Class<?> superClass) {
        if (clazz.equals(Object.class)) {
            return false;
        }
        if (clazz.equals(superClass)) {
            return true;
        }
        return Const.classIsOrExtends(clazz.getSuperclass(), superClass);
    }

    static {
        STRING_TRANS_AND_JOB_FILTER_EXT = new String[]{"*.ktr;*.kjb;*.xml", "*.ktr;*.xml", "*.kjb;*.xml", "*.xml", "*.*"};
        STRING_TRANS_FILTER_EXT = new String[]{"*.ktr;*.xml", "*.xml", "*.*"};
        STRING_JOB_FILTER_EXT = new String[]{"*.kjb;*.xml", "*.xml", "*.*"};
        INTERNAL_TRANS_VARIABLES = new String[]{INTERNAL_VARIABLE_TRANSFORMATION_FILENAME_DIRECTORY, INTERNAL_VARIABLE_TRANSFORMATION_FILENAME_NAME, INTERNAL_VARIABLE_TRANSFORMATION_NAME, INTERNAL_VARIABLE_TRANSFORMATION_REPOSITORY_DIRECTORY};
        INTERNAL_JOB_VARIABLES = new String[]{INTERNAL_VARIABLE_JOB_FILENAME_DIRECTORY, INTERNAL_VARIABLE_JOB_FILENAME_NAME, INTERNAL_VARIABLE_JOB_NAME, INTERNAL_VARIABLE_JOB_REPOSITORY_DIRECTORY, INTERNAL_VARIABLE_JOB_RUN_ID, INTERNAL_VARIABLE_JOB_RUN_ATTEMPTNR};
        RELEASE = ReleaseType.GA;
    }

    public static enum ReleaseType {
        RELEASE_CANDIDATE{

            @Override
            public String getMessage() {
                return BaseMessages.getString(PKG, "Const.PreviewRelease.HelpAboutText", new String[0]);
            }
        }
        ,
        MILESTONE{

            @Override
            public String getMessage() {
                return BaseMessages.getString(PKG, "Const.Candidate.HelpAboutText", new String[0]);
            }
        }
        ,
        PREVIEW{

            @Override
            public String getMessage() {
                return BaseMessages.getString(PKG, "Const.Milestone.HelpAboutText", new String[0]);
            }
        }
        ,
        GA{

            @Override
            public String getMessage() {
                return BaseMessages.getString(PKG, "Const.GA.HelpAboutText", new String[0]);
            }
        };


        public abstract String getMessage();
    }
}

