/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.pentaho.di.cluster.HttpUtil;
import org.pentaho.di.core.jdbc.ThinDatabaseMetaData;
import org.pentaho.di.core.jdbc.ThinPreparedStatement;
import org.pentaho.di.core.jdbc.ThinStatement;
import org.pentaho.di.core.variables.Variables;

public class ThinConnection
implements Connection {
    public static final String ARG_WEBAPPNAME = "webappname";
    public static final String ARG_PROXYHOSTNAME = "proxyhostname";
    public static final String ARG_PROXYPORT = "proxyport";
    public static final String ARG_NONPROXYHOSTS = "nonproxyhosts";
    public static final String ARG_DEBUGTRANS = "debugtrans";
    public static final String ARG_DEBUGLOG = "debuglog";
    private String url;
    private String slaveBaseAddress;
    private String username;
    private String password;
    private String hostname;
    private String port;
    private Map<String, String> arguments;
    private String webAppName;
    private String proxyHostname;
    private String proxyPort;
    private String nonProxyHosts;
    private String debugTransFilename;
    private boolean debuggingRemoteLog;
    private String service;

    public ThinConnection(String url, String username, String password) throws SQLException {
        this.url = url;
        this.username = username;
        this.password = password;
    }

    public void testConnection() throws SQLException {
        try {
            int portColonIndex = this.url.indexOf(58, "jdbc:pdi://".length());
            this.hostname = this.url.substring("jdbc:pdi://".length(), portColonIndex);
            int kettleIndex = this.url.indexOf("/kettle", portColonIndex);
            this.port = this.url.substring(portColonIndex + 1, kettleIndex);
            int startIndex = this.url.indexOf(63, kettleIndex) + 1;
            this.arguments = new HashMap<String, String>();
            if (startIndex > 0) {
                String[] args;
                String path = this.url.substring(startIndex);
                for (String arg : args = path.split("\\&")) {
                    String[] parts = arg.split("=");
                    if (parts.length != 2) continue;
                    this.arguments.put(parts[0], parts[1]);
                }
            }
            this.webAppName = this.arguments.get(ARG_WEBAPPNAME);
            this.service = "/kettle";
            this.slaveBaseAddress = "http://" + this.hostname + ":" + this.port + this.service;
            this.proxyHostname = this.arguments.get(ARG_PROXYHOSTNAME);
            this.proxyPort = this.arguments.get(ARG_PROXYPORT);
            this.nonProxyHosts = this.arguments.get(ARG_NONPROXYHOSTS);
            this.debugTransFilename = this.arguments.get(ARG_DEBUGTRANS);
            this.debuggingRemoteLog = "true".equalsIgnoreCase(this.arguments.get(ARG_DEBUGLOG));
            HttpUtil.execService(new Variables(), this.hostname, this.port, this.webAppName, this.service + "/status/", this.username, this.password, this.proxyHostname, this.proxyPort, this.nonProxyHosts);
        }
        catch (Exception e) {
            throw new SQLException("Unable to de-compose slave server address for URL: " + this.slaveBaseAddress, e);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public void commit() throws SQLException {
        throw new SQLException("Transactions are not supported by the thin Kettle JDBC driver");
    }

    @Override
    public Array createArrayOf(String arg0, Object[] arg1) throws SQLException {
        throw new SQLException("Arrays are not supported by the thin Kettle JDBC driver");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLException("Creating BLOBs is not supported by the thin Kettle JDBC driver");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLException("Creating CLOBs is not supported by the thin Kettle JDBC driver");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLException("Creating NCLOBs is not supported by the thin Kettle JDBC driver");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLException("Creating SQL XML is not supported by the thin Kettle JDBC driver");
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new ThinStatement(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new ThinStatement(this, resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new ThinStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public Struct createStruct(String arg0, Object[] arg1) throws SQLException {
        throw new SQLException("Creating structs is not supported by the thin Kettle JDBC driver");
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return true;
    }

    @Override
    public String getCatalog() throws SQLException {
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return null;
    }

    @Override
    public String getClientInfo(String arg0) throws SQLException {
        return null;
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new ThinDatabaseMetaData(this);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return null;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return true;
    }

    @Override
    public boolean isValid(int arg0) throws SQLException {
        return false;
    }

    @Override
    public String nativeSQL(String arg0) throws SQLException {
        throw new SQLException("Native SQL statements are not supported by the thin Kettle JDBC driver");
    }

    @Override
    public CallableStatement prepareCall(String arg0) throws SQLException {
        throw new SQLException("Perpared calls are not supported by the thin Kettle JDBC driver");
    }

    @Override
    public CallableStatement prepareCall(String arg0, int arg1, int arg2) throws SQLException {
        throw new SQLException("Perpared calls are not supported by the thin Kettle JDBC driver");
    }

    @Override
    public CallableStatement prepareCall(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        throw new SQLException("Perpared calls are not supported by the thin Kettle JDBC driver");
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new ThinPreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new ThinPreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndex) throws SQLException {
        return new ThinPreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new ThinPreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new ThinPreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new ThinPreparedStatement(this, sql);
    }

    @Override
    public void releaseSavepoint(Savepoint arg0) throws SQLException {
        throw new SQLException("Transactions are not supported by the thin Kettle JDBC driver");
    }

    @Override
    public void rollback() throws SQLException {
        throw new SQLException("Transactions are not supported by the thin Kettle JDBC driver");
    }

    @Override
    public void rollback(Savepoint arg0) throws SQLException {
        throw new SQLException("Transactions are not supported by the thin Kettle JDBC driver");
    }

    @Override
    public void setAutoCommit(boolean auto) throws SQLException {
    }

    @Override
    public void setCatalog(String arg0) throws SQLException {
    }

    @Override
    public void setClientInfo(Properties arg0) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(String arg0, String arg1) throws SQLClientInfoException {
    }

    @Override
    public void setHoldability(int arg0) throws SQLException {
    }

    @Override
    public void setReadOnly(boolean arg0) throws SQLException {
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLException("Safepoints calls are not supported by the thin Kettle JDBC driver");
    }

    @Override
    public Savepoint setSavepoint(String arg0) throws SQLException {
        throw new SQLException("Safepoints calls are not supported by the thin Kettle JDBC driver");
    }

    @Override
    public void setTransactionIsolation(int arg0) throws SQLException {
        throw new SQLException("Transactions are not supported by the thin Kettle JDBC driver");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> arg0) throws SQLException {
    }

    public String getUrl() {
        return this.url;
    }

    public String getSlaveBaseAddress() {
        return this.slaveBaseAddress;
    }

    public void setSlaveBaseAddress(String slaveBaseAddress) {
        this.slaveBaseAddress = slaveBaseAddress;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String passsword) {
        this.password = passsword;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getPort() {
        return this.port;
    }

    public Map<String, String> getArguments() {
        return this.arguments;
    }

    public String getWebAppName() {
        return this.webAppName;
    }

    public String getProxyHostname() {
        return this.proxyHostname;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public String getService() {
        return this.service;
    }

    public String getDebugTransFilename() {
        return this.debugTransFilename;
    }

    public boolean isDebuggingRemoteLog() {
        return this.debuggingRemoteLog;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getSchema() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }
}

