/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.pentaho.di.core.exception.KettleSQLException;
import org.pentaho.di.core.jdbc.ThinConnection;
import org.pentaho.di.core.jdbc.ThinParameterMetaData;
import org.pentaho.di.core.jdbc.ThinStatement;
import org.pentaho.di.core.jdbc.ThinUtil;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;

public class ThinPreparedStatement
extends ThinStatement
implements PreparedStatement {
    private String sql;
    protected List<Integer> placeholderIndexes;
    protected ValueMetaInterface[] paramMeta;
    protected Object[] paramData;

    public ThinPreparedStatement(ThinConnection connection, String sql) throws SQLException {
        super(connection);
        this.sql = sql;
        this.analyzeSql();
    }

    public void analyzeSql() throws SQLException {
        try {
            this.placeholderIndexes = new ArrayList<Integer>();
            for (int index = 0; index < this.sql.length(); ++index) {
                if ((index = ThinUtil.skipChars(this.sql, index, '\'', '\"')) >= this.sql.length() || this.sql.charAt(index) != '?') continue;
                this.placeholderIndexes.add(index);
            }
            this.paramData = new Object[this.placeholderIndexes.size()];
            this.paramMeta = new ValueMetaInterface[this.placeholderIndexes.size()];
            for (int i = 0; i < this.placeholderIndexes.size(); ++i) {
                this.paramMeta[i] = new ValueMeta("param-" + (i + 1), 2);
            }
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    public String replaceSql() throws SQLException {
        try {
            StringBuilder newSql = new StringBuilder(this.sql);
            for (int i = this.placeholderIndexes.size() - 1; i >= 0; --i) {
                int index = this.placeholderIndexes.get(i);
                ValueMetaInterface valueMeta = this.paramMeta[i];
                if (valueMeta == null) {
                    throw new SQLException("Parameter " + (i + 1) + " was not specified");
                }
                String replacement = null;
                if (valueMeta.isNull(this.paramData[i])) {
                    replacement = "NULL";
                }
                switch (valueMeta.getType()) {
                    case 2: {
                        replacement = "'" + valueMeta.getString(this.paramData[i]) + "'";
                        break;
                    }
                    case 1: {
                        double d = valueMeta.getNumber(this.paramData[i]);
                        replacement = Double.toString(d);
                        break;
                    }
                    case 5: {
                        long l = valueMeta.getInteger(this.paramData[i]);
                        replacement = Long.toString(l);
                        break;
                    }
                    case 3: {
                        java.util.Date date = valueMeta.getDate(this.paramData[i]);
                        replacement = new SimpleDateFormat("'['yyyy/MM/dd HH:mm:ss.SSS']'").format(date);
                        break;
                    }
                    case 6: {
                        BigDecimal bd = valueMeta.getBigNumber(this.paramData[i]);
                        replacement = bd.toString();
                        break;
                    }
                    case 4: {
                        boolean b = valueMeta.getBoolean(this.paramData[i]);
                        replacement = b ? "TRUE" : "FALSE";
                        break;
                    }
                }
                if (replacement == null) {
                    throw new KettleSQLException("Unhandled data type: " + valueMeta.getTypeDesc() + " replacing parameter " + (i + 1));
                }
                newSql.replace(index, index + 1, replacement);
            }
            return newSql.toString();
        }
        catch (Exception e) {
            throw new SQLException("Unexpected enhancing SQL to include specified parameters", e);
        }
    }

    @Override
    public void addBatch() throws SQLException {
        throw new SQLException("Batch operations are not supported");
    }

    @Override
    public void clearParameters() throws SQLException {
        this.analyzeSql();
    }

    @Override
    public boolean execute() throws SQLException {
        return this.execute(this.replaceSql());
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.executeQuery(this.replaceSql());
    }

    @Override
    public int executeUpdate() throws SQLException {
        throw new SQLException("Update operations are not supported");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.resultSet.getMetaData();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return new ThinParameterMetaData(this);
    }

    @Override
    public void setArray(int nr, Array value) throws SQLException {
        throw new SQLException("Arrays are not supported");
    }

    @Override
    public void setAsciiStream(int nr, InputStream value) throws SQLException {
        throw new SQLException("ASCII Streams are not supported");
    }

    @Override
    public void setAsciiStream(int nr, InputStream value, int arg2) throws SQLException {
        throw new SQLException("ASCII Streams are not supported");
    }

    @Override
    public void setAsciiStream(int nr, InputStream value, long arg2) throws SQLException {
        throw new SQLException("ASCII Streams are not supported");
    }

    @Override
    public void setBigDecimal(int nr, BigDecimal value) throws SQLException {
        this.paramData[nr - 1] = value;
        this.paramMeta[nr - 1] = new ValueMeta("param-" + nr, 6);
    }

    @Override
    public void setBinaryStream(int nr, InputStream value) throws SQLException {
        throw new SQLException("Binary Streams are not supported");
    }

    @Override
    public void setBinaryStream(int nr, InputStream value, int arg2) throws SQLException {
        throw new SQLException("Binary Streams are not supported");
    }

    @Override
    public void setBinaryStream(int nr, InputStream value, long arg2) throws SQLException {
        throw new SQLException("Binary Streams are not supported");
    }

    @Override
    public void setBlob(int nr, Blob value) throws SQLException {
        throw new SQLException("BLOB parameters are not supported");
    }

    @Override
    public void setBlob(int nr, InputStream value) throws SQLException {
        throw new SQLException("BLOB parameters are not supported");
    }

    @Override
    public void setBlob(int nr, InputStream value, long arg2) throws SQLException {
        throw new SQLException("BLOB parameters are not supported");
    }

    @Override
    public void setBoolean(int nr, boolean value) throws SQLException {
        this.paramData[nr - 1] = value;
        this.paramMeta[nr - 1] = new ValueMeta("param-" + nr, 4);
    }

    @Override
    public void setByte(int nr, byte value) throws SQLException {
        this.paramData[nr - 1] = (long)value;
        this.paramMeta[nr - 1] = new ValueMeta("param-" + nr, 5);
    }

    @Override
    public void setBytes(int nr, byte[] value) throws SQLException {
        throw new SQLException("Binary parameters are not supported");
    }

    @Override
    public void setCharacterStream(int nr, Reader value) throws SQLException {
        throw new SQLException("Character stream parameters are not supported");
    }

    @Override
    public void setCharacterStream(int nr, Reader value, int arg2) throws SQLException {
        throw new SQLException("Character stream parameters are not supported");
    }

    @Override
    public void setCharacterStream(int nr, Reader value, long arg2) throws SQLException {
        throw new SQLException("Character stream parameters are not supported");
    }

    @Override
    public void setClob(int nr, Clob value) throws SQLException {
        throw new SQLException("CLOB parameters are not supported");
    }

    @Override
    public void setClob(int nr, Reader value) throws SQLException {
        throw new SQLException("CLOB parameters are not supported");
    }

    @Override
    public void setClob(int nr, Reader value, long arg2) throws SQLException {
        throw new SQLException("CLOB parameters are not supported");
    }

    @Override
    public void setDate(int nr, Date value) throws SQLException {
        this.paramData[nr - 1] = new java.util.Date(value.getTime());
        this.paramMeta[nr - 1] = new ValueMeta("param-" + nr, 3);
    }

    @Override
    public void setDate(int nr, Date value, Calendar calendar) throws SQLException {
        this.paramData[nr - 1] = new java.util.Date(value.getTime());
        this.paramMeta[nr - 1] = new ValueMeta("param-" + nr, 3);
    }

    @Override
    public void setDouble(int nr, double value) throws SQLException {
        this.paramData[nr - 1] = value;
        this.paramMeta[nr - 1] = new ValueMeta("param-" + nr, 1);
    }

    @Override
    public void setFloat(int nr, float value) throws SQLException {
        this.paramData[nr - 1] = (double)value;
        this.paramMeta[nr - 1] = new ValueMeta("param-" + nr, 1);
    }

    @Override
    public void setInt(int nr, int value) throws SQLException {
        this.paramData[nr - 1] = (long)value;
        this.paramMeta[nr - 1] = new ValueMeta("param-" + nr, 5);
    }

    @Override
    public void setLong(int nr, long value) throws SQLException {
        this.paramData[nr - 1] = value;
        this.paramMeta[nr - 1] = new ValueMeta("param-" + nr, 5);
    }

    @Override
    public void setNCharacterStream(int nr, Reader value) throws SQLException {
        throw new SQLException("NCharacter stream parameters are not supported");
    }

    @Override
    public void setNCharacterStream(int nr, Reader value, long arg2) throws SQLException {
        throw new SQLException("NCharacter stream parameters are not supported");
    }

    @Override
    public void setNClob(int nr, NClob value) throws SQLException {
        throw new SQLException("NCLOB parameters are not supported");
    }

    @Override
    public void setNClob(int nr, Reader value) throws SQLException {
        throw new SQLException("NCLOB parameters are not supported");
    }

    @Override
    public void setNClob(int nr, Reader value, long arg2) throws SQLException {
        throw new SQLException("NCLOB parameters are not supported");
    }

    @Override
    public void setNString(int nr, String value) throws SQLException {
        throw new SQLException("NString parameters are not supported");
    }

    @Override
    public void setNull(int nr, int sqlType) throws SQLException {
        this.paramData[nr - 1] = null;
        this.paramMeta[nr - 1] = ThinUtil.getValueMeta("param-" + nr, sqlType);
    }

    @Override
    public void setNull(int nr, int value, String arg2) throws SQLException {
        this.setNull(nr, value);
    }

    @Override
    public void setObject(int nr, Object value) throws SQLException {
        if (value == null) {
            throw new SQLException("Null values are not supported for the setObject() method");
        }
        if (value instanceof String) {
            this.setString(nr, (String)value);
        } else if (value instanceof Long) {
            this.setLong(nr, (Long)value);
        } else if (value instanceof Integer) {
            this.setInt(nr, (Integer)value);
        } else if (value instanceof Byte) {
            this.setByte(nr, (Byte)value);
        } else if (value instanceof Date) {
            this.setDate(nr, (Date)value);
        } else if (value instanceof Boolean) {
            this.setBoolean(nr, (Boolean)value);
        } else if (value instanceof Double) {
            this.setDouble(nr, (Double)value);
        } else if (value instanceof Float) {
            this.setFloat(nr, ((Float)value).floatValue());
        } else if (value instanceof BigDecimal) {
            this.setBigDecimal(nr, (BigDecimal)value);
        } else {
            throw new SQLException("value of class " + value.getClass().getName());
        }
    }

    @Override
    public void setObject(int nr, Object value, int arg2) throws SQLException {
        this.setObject(nr, value);
    }

    @Override
    public void setObject(int nr, Object value, int arg2, int arg3) throws SQLException {
        this.setObject(nr, value);
    }

    @Override
    public void setRef(int nr, Ref value) throws SQLException {
        throw new SQLException("REF parameters are not supported");
    }

    @Override
    public void setRowId(int nr, RowId value) throws SQLException {
        throw new SQLException("ROWID parameters are not supported");
    }

    @Override
    public void setSQLXML(int nr, SQLXML value) throws SQLException {
        throw new SQLException("SQLXML parameters are not supported");
    }

    @Override
    public void setShort(int nr, short value) throws SQLException {
        this.setLong(nr, value);
    }

    @Override
    public void setString(int nr, String value) throws SQLException {
        this.paramData[nr - 1] = value;
        this.paramMeta[nr - 1] = new ValueMeta("param-" + nr, 2);
    }

    @Override
    public void setTime(int nr, Time value) throws SQLException {
        this.paramData[nr - 1] = new java.util.Date(value.getTime());
        this.paramMeta[nr - 1] = new ValueMeta("param-" + nr, 3);
    }

    @Override
    public void setTime(int nr, Time value, Calendar arg2) throws SQLException {
        this.setTime(nr, value);
    }

    @Override
    public void setTimestamp(int nr, Timestamp value) throws SQLException {
        this.paramData[nr - 1] = new java.util.Date(value.getTime());
        this.paramMeta[nr - 1] = new ValueMeta("param-" + nr, 3);
    }

    @Override
    public void setTimestamp(int nr, Timestamp value, Calendar arg2) throws SQLException {
        this.setTimestamp(nr, value);
    }

    @Override
    public void setURL(int nr, URL value) throws SQLException {
        throw new SQLException("URL parameters are not supported");
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int nr, InputStream value, int arg2) throws SQLException {
        throw new SQLException("Unicode stream parameters are not supported");
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public ValueMetaInterface[] getParamMeta() {
        return this.paramMeta;
    }

    public Object[] getParamData() {
        return this.paramData;
    }
}

