/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.namedcluster;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.namedcluster.model.NamedCluster;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.persist.MetaStoreFactory;

public class NamedClusterManager {
    private static NamedClusterManager instance = new NamedClusterManager();
    private Map<IMetaStore, MetaStoreFactory<NamedCluster>> factoryMap = new HashMap<IMetaStore, MetaStoreFactory<NamedCluster>>();
    private NamedCluster clusterTemplate;

    private NamedClusterManager() {
    }

    public static NamedClusterManager getInstance() {
        return instance;
    }

    private MetaStoreFactory<NamedCluster> getMetaStoreFactory(IMetaStore metastore) {
        if (this.factoryMap.get(metastore) == null) {
            this.factoryMap.put(metastore, (MetaStoreFactory<NamedCluster>)new MetaStoreFactory(NamedCluster.class, metastore, "pentaho"));
        }
        return this.factoryMap.get(metastore);
    }

    public NamedCluster getClusterTemplate() {
        if (this.clusterTemplate == null) {
            this.clusterTemplate = new NamedCluster();
            this.clusterTemplate.setName("new cluster");
            this.clusterTemplate.setHdfsHost("localhost");
            this.clusterTemplate.setHdfsPort("8020");
            this.clusterTemplate.setHdfsUsername("user");
            this.clusterTemplate.setHdfsPassword("password");
            this.clusterTemplate.setJobTrackerHost("localhost");
            this.clusterTemplate.setJobTrackerPort("8032");
            this.clusterTemplate.setZooKeeperHost("localhost");
            this.clusterTemplate.setZooKeeperPort("2888");
            this.clusterTemplate.setOozieUrl("http://localhost:8080/oozie");
        }
        return this.clusterTemplate.clone();
    }

    public void setClusterTemplate(NamedCluster clusterTemplate) {
        this.clusterTemplate = clusterTemplate;
    }

    public void create(NamedCluster namedCluster, IMetaStore metastore) throws MetaStoreException {
        MetaStoreFactory<NamedCluster> factory = this.getMetaStoreFactory(metastore);
        factory.saveElement((Object)namedCluster);
    }

    public NamedCluster read(String clusterName, IMetaStore metastore) throws MetaStoreException {
        MetaStoreFactory<NamedCluster> factory = this.getMetaStoreFactory(metastore);
        return (NamedCluster)factory.loadElement(clusterName);
    }

    public void update(NamedCluster namedCluster, IMetaStore metastore) throws MetaStoreException {
        MetaStoreFactory<NamedCluster> factory = this.getMetaStoreFactory(metastore);
        factory.deleteElement(namedCluster.getName());
        factory.saveElement((Object)namedCluster);
    }

    public void delete(String clusterName, IMetaStore metastore) throws MetaStoreException {
        MetaStoreFactory<NamedCluster> factory = this.getMetaStoreFactory(metastore);
        factory.deleteElement(clusterName);
    }

    public List<NamedCluster> list(IMetaStore metastore) throws MetaStoreException {
        MetaStoreFactory<NamedCluster> factory = this.getMetaStoreFactory(metastore);
        return factory.getElements();
    }

    public List<String> listNames(IMetaStore metastore) throws MetaStoreException {
        MetaStoreFactory<NamedCluster> factory = this.getMetaStoreFactory(metastore);
        return factory.getElementNames();
    }

    public boolean contains(String clusterName, IMetaStore metastore) throws MetaStoreException {
        if (metastore == null) {
            return false;
        }
        for (String name : this.listNames(metastore)) {
            if (!name.equals(clusterName)) continue;
            return true;
        }
        return false;
    }
}

