/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.row;

import java.io.DataInputStream;
import java.util.Locale;
import java.util.TimeZone;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleEOFException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.i18n.BaseMessages;
import org.w3c.dom.Node;

public class ValueMeta
extends ValueMetaBase
implements ValueMetaInterface {
    private static Class<?> PKG = Const.class;
    public static final String DEFAULT_DATE_FORMAT_MASK = "yyyy/MM/dd HH:mm:ss.SSS";
    public static final String XML_META_TAG = "value-meta";
    public static final String XML_DATA_TAG = "value-data";
    public static final boolean EMPTY_STRING_AND_NULL_ARE_DIFFERENT = ValueMeta.convertStringToBoolean(Const.NVL(System.getProperty("KETTLE_EMPTY_STRING_DIFFERS_FROM_NULL", "N"), "N"));
    public static final String[] trimTypeCode = new String[]{"none", "left", "right", "both"};
    public static final String[] trimTypeDesc = new String[]{BaseMessages.getString(PKG, "ValueMeta.TrimType.None", new String[0]), BaseMessages.getString(PKG, "ValueMeta.TrimType.Left", new String[0]), BaseMessages.getString(PKG, "ValueMeta.TrimType.Right", new String[0]), BaseMessages.getString(PKG, "ValueMeta.TrimType.Both", new String[0])};
    public static final String[] SINGLE_BYTE_ENCODINGS = new String[]{"ISO8859_1", "Cp1252", "ASCII", "Cp037", "Cp273", "Cp277", "Cp278", "Cp280", "Cp284", "Cp285", "Cp297", "Cp420", "Cp424", "Cp437", "Cp500", "Cp737", "Cp775", "Cp850", "Cp852", "Cp855", "Cp856", "Cp857", "Cp858", "Cp860", "Cp861", "Cp862", "Cp863", "Cp865", "Cp866", "Cp869", "Cp870", "Cp871", "Cp875", "Cp918", "Cp921", "Cp922", "Cp1140", "Cp1141", "Cp1142", "Cp1143", "Cp1144", "Cp1145", "Cp1146", "Cp1147", "Cp1148", "Cp1149", "Cp1250", "Cp1251", "Cp1253", "Cp1254", "Cp1255", "Cp1257", "ISO8859_2", "ISO8859_3", "ISO8859_5", "ISO8859_5", "ISO8859_6", "ISO8859_7", "ISO8859_8", "ISO8859_9", "ISO8859_13", "ISO8859_15", "ISO8859_15_FDIS", "MacCentralEurope", "MacCroatian", "MacCyrillic", "MacDingbat", "MacGreek", "MacHebrew", "MacIceland", "MacRoman", "MacRomania", "MacSymbol", "MacTurkish", "MacUkraine"};

    public ValueMeta() {
        this(null, 0, -1, -1);
    }

    public ValueMeta(String name) {
        this(name, 0, -1, -1);
    }

    public ValueMeta(String name, int type) {
        this(name, type, -1, -1);
    }

    public ValueMeta(String name, int type, int storageType) {
        this(name, type, -1, -1);
        this.storageType = storageType;
        this.setDefaultConversionMask();
    }

    public ValueMeta(String name, int type, int length, int precision) {
        this.name = name;
        this.type = type;
        this.length = length;
        this.precision = precision;
        this.storageType = 0;
        this.sortedDescending = false;
        this.outputPaddingEnabled = false;
        this.decimalSymbol = "" + Const.DEFAULT_DECIMAL_SEPARATOR;
        this.groupingSymbol = "" + Const.DEFAULT_GROUPING_SEPARATOR;
        this.dateFormatLocale = Locale.getDefault();
        this.dateFormatTimeZone = TimeZone.getDefault();
        this.identicalFormat = true;
        this.bigNumberFormatting = true;
        this.lenientStringToNumber = ValueMeta.convertStringToBoolean(Const.NVL(System.getProperty("KETTLE_LENIENT_STRING_TO_NUMBER_CONVERSION", "N"), "N"));
        this.setDefaultConversionMask();
    }

    @Deprecated
    public ValueMeta(DataInputStream inputStream) throws KettleFileException, KettleEOFException {
        super(inputStream);
    }

    public ValueMeta(Node node) throws KettleException {
        super(node);
    }

    @Override
    @Deprecated
    public void setType(int type) {
        super.setType(type);
    }
}

