/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.sql;

import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleSQLException;
import org.pentaho.di.core.jdbc.ThinUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaAndData;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.sql.IifFunction;
import org.pentaho.di.core.sql.SQLAggregation;
import org.pentaho.di.core.sql.SQLFields;

public class SQLField {
    private String tableAlias;
    private String field;
    private String alias;
    private SQLAggregation aggregation;
    private ValueMetaInterface valueMeta;
    private boolean countStar;
    private boolean countDistinct;
    private boolean orderField;
    private boolean ascending;
    private String expression;
    private SQLFields selectFields;
    private Object valueData;
    private IifFunction iif;
    private int fieldIndex;

    public SQLField(String tableAlias, String field, String alias, SQLAggregation aggregation, ValueMetaInterface valueMeta) {
        this.tableAlias = tableAlias;
        this.field = field;
        this.alias = alias;
        this.aggregation = aggregation;
        this.valueMeta = valueMeta;
    }

    public SQLField(String tableAlias, String fieldClause, RowMetaInterface serviceFields) throws KettleSQLException {
        this(tableAlias, fieldClause, serviceFields, false);
    }

    public SQLField(String tableAlias, String fieldClause, RowMetaInterface serviceFields, boolean orderField) throws KettleSQLException {
        this(tableAlias, fieldClause, serviceFields, orderField, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SQLField(String tableAlias, String fieldClause, RowMetaInterface serviceFields, boolean orderField, SQLFields selectFields) throws KettleSQLException {
        this.tableAlias = tableAlias;
        this.orderField = orderField;
        this.selectFields = selectFields;
        List<String> strings = ThinUtil.splitClause(fieldClause, ' ', '\"', '(');
        if (strings.size() == 0) {
            throw new KettleSQLException("Unable to find a valid field");
        }
        if (strings.size() >= 1) {
            String value = strings.get(0);
            this.expression = this.field = ThinUtil.stripQuoteTableAlias(value, tableAlias);
            if (orderField) {
                if (strings.size() > 2) {
                    throw new KettleSQLException("Too many elements for an ORDER BY argument: [" + fieldClause + "]");
                }
                if (strings.size() == 2) {
                    String ascDesc = strings.get(1);
                    if ("ASC".equalsIgnoreCase(ascDesc)) {
                        this.ascending = true;
                    } else {
                        if (!"DESC".equalsIgnoreCase(ascDesc)) throw new KettleSQLException("Unable to recognize sort order [" + ascDesc + "]");
                        this.ascending = false;
                    }
                } else {
                    this.ascending = true;
                }
            } else {
                for (SQLAggregation agg : SQLAggregation.values()) {
                    if (!value.toUpperCase().startsWith(agg.getKeyWord() + "(")) continue;
                    this.aggregation = agg;
                    int openIndex = value.indexOf(40, agg.getKeyWord().length());
                    if (openIndex < 0) {
                        throw new KettleSQLException("No opening bracket found after keyword [" + this.aggregation.getKeyWord() + "] in clause [" + fieldClause + "]");
                    }
                    int closeIndex = value.indexOf(41, openIndex);
                    if (closeIndex < 0) {
                        throw new KettleSQLException("No closing bracket found after keyword [" + this.aggregation.getKeyWord() + "]");
                    }
                    this.field = ThinUtil.stripQuotes(Const.trim(value.substring(openIndex + 1, closeIndex)), '\"');
                    this.field = ThinUtil.stripQuoteTableAlias(this.field, tableAlias);
                    break;
                }
                if (SQLAggregation.COUNT == this.aggregation) {
                    if ("*".equals(this.field)) {
                        this.countStar = true;
                    }
                    if (this.field.toUpperCase().startsWith("DISTINCT ")) {
                        int lastSpaceIndex = this.field.lastIndexOf(32);
                        this.field = this.field.substring(lastSpaceIndex + 1);
                        this.field = ThinUtil.stripQuoteTableAlias(this.field, tableAlias);
                        this.countDistinct = true;
                    }
                    this.alias = Const.NVL(this.alias, this.expression);
                }
                if (strings.size() == 2) {
                    this.alias = ThinUtil.stripQuotes(Const.trim(strings.get(1)), '\"');
                }
                if (strings.size() == 3) {
                    if (!"as".equalsIgnoreCase(strings.get(1))) {
                        throw new KettleSQLException("AS keyword expected between the field and the alias in field clause: [" + fieldClause + "]");
                    }
                    this.alias = ThinUtil.stripQuotes(Const.trim(strings.get(2)), '\"');
                }
            }
        }
        if (this.countStar) return;
        if (orderField) {
            for (SQLField selectField : selectFields.getFields()) {
                if (!selectField.getExpression().equalsIgnoreCase(this.field)) continue;
                if (selectField.getAggregation() != null) {
                    switch (selectField.getAggregation()) {
                        case COUNT: {
                            this.valueMeta = new ValueMeta(this.field, 5, 15);
                            break;
                        }
                        case MIN: 
                        case MAX: 
                        case AVG: 
                        case SUM: {
                            this.valueMeta = selectField.getValueMeta();
                            break;
                        }
                    }
                    this.alias = selectField.getAlias();
                    continue;
                }
                this.field = selectField.getField();
                this.alias = selectField.getAlias();
            }
        }
        if (this.field.startsWith("IIF(")) {
            String arguments = this.field.substring(4, this.field.length() - 1);
            List<String> argsList = ThinUtil.splitClause(arguments, ',', '\'', '(');
            if (argsList.size() != 3) {
                throw new KettleSQLException("The IIF function requires exactly 3 arguments");
            }
            this.iif = new IifFunction(tableAlias, Const.trim(argsList.get(0)), Const.trim(argsList.get(1)), Const.trim(argsList.get(2)), serviceFields);
            return;
        } else if (this.field.toUpperCase().startsWith("CASE WHEN ") && this.field.toUpperCase().endsWith("END")) {
            String condition = Const.trim(ThinUtil.findClause(this.field, "WHEN", "THEN"));
            String trueClause = Const.trim(ThinUtil.findClause(this.field, "THEN", "ELSE"));
            String falseClause = Const.trim(ThinUtil.findClause(this.field, "ELSE", "END"));
            this.iif = new IifFunction(tableAlias, condition, trueClause, falseClause, serviceFields);
            return;
        } else {
            if (this.valueMeta == null) {
                this.valueMeta = serviceFields.searchValueMeta(this.field);
                if (orderField && selectFields != null) {
                    for (SQLField selectField : selectFields.getFields()) {
                        if (!this.field.equalsIgnoreCase(selectField.getAlias())) continue;
                        this.valueMeta = selectField.getValueMeta();
                        break;
                    }
                }
            }
            if (this.valueMeta != null) return;
            ValueMetaAndData vmad = ThinUtil.extractConstant(this.field);
            if (vmad == null) throw new KettleSQLException("The field with name [" + this.field + "] could not be found in the service output");
            this.valueMeta = vmad.getValueMeta();
            this.valueData = vmad.getValueData();
        }
    }

    public String getName() {
        return this.field;
    }

    public void setName(String name) {
        this.field = name;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public SQLAggregation getAggregation() {
        return this.aggregation;
    }

    public void setAggregation(SQLAggregation aggregation) {
        this.aggregation = aggregation;
    }

    public ValueMetaInterface getValueMeta() {
        return this.valueMeta;
    }

    public void setValueMeta(ValueMetaInterface valueMeta) {
        this.valueMeta = valueMeta;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public boolean isCountStar() {
        return this.countStar;
    }

    public void setCountStar(boolean countStar) {
        this.countStar = countStar;
    }

    public boolean isCountDistinct() {
        return this.countDistinct;
    }

    public void setCountDistinct(boolean countDistinct) {
        this.countDistinct = countDistinct;
    }

    public boolean isOrderField() {
        return this.orderField;
    }

    public void setOrderField(boolean orderField) {
        this.orderField = orderField;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public SQLFields getSelectFields() {
        return this.selectFields;
    }

    public void setSelectFields(SQLFields selectFields) {
        this.selectFields = selectFields;
    }

    public IifFunction getIif() {
        return this.iif;
    }

    public Object getValueData() {
        return this.valueData;
    }

    public void setValueData(Object valueData) {
        this.valueData = valueData;
    }

    public void setIif(IifFunction iif) {
        this.iif = iif;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public void setTableAlias(String tableAlias) {
        this.tableAlias = tableAlias;
    }

    public int getFieldIndex() {
        return this.fieldIndex;
    }

    public void setFieldIndex(int fieldIndex) {
        this.fieldIndex = fieldIndex;
    }

    public static SQLField searchSQLFieldByFieldOrAlias(List<SQLField> fields, String name) {
        for (SQLField field : fields) {
            if (!name.equalsIgnoreCase(field.getField()) && !name.equalsIgnoreCase(field.getAlias())) continue;
            return field;
        }
        return null;
    }
}

