/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import java.util.List;
import org.eigenbase.rel.RelInput;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.rel.SingleRel;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.sql.type.SqlTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectRel
extends SingleRel {
    private final String fieldName;

    public CollectRel(RelOptCluster cluster, RelNode child, String fieldName) {
        super(cluster, cluster.traitSetOf(Convention.NONE), child);
        this.fieldName = fieldName;
    }

    public CollectRel(RelInput input) {
        this(input.getCluster(), input.getInput(), input.getString("field"));
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (traitSet.comprises(Convention.NONE));
        return new CollectRel(this.getCluster(), CollectRel.sole(inputs), this.fieldName);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("field", this.fieldName);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    protected RelDataType deriveRowType() {
        return CollectRel.deriveCollectRowType(this, this.fieldName);
    }

    public static RelDataType deriveCollectRowType(SingleRel rel, String fieldName) {
        RelDataType childType = rel.getChild().getRowType();
        assert (childType.isStruct());
        RelDataType ret = SqlTypeUtil.createMultisetType(rel.getCluster().getTypeFactory(), childType, false);
        ret = rel.getCluster().getTypeFactory().createStructType(new RelDataType[]{ret}, new String[]{fieldName});
        return rel.getCluster().getTypeFactory().createTypeWithNullability(ret, false);
    }
}

