/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eigenbase.rel.RelInput;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.rel.SingleRel;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptCost;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.rex.RexLocalRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexProgram;
import org.eigenbase.rex.RexUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FilterRelBase
extends SingleRel {
    protected final RexNode condition;

    protected FilterRelBase(RelOptCluster cluster, RelTraitSet traits, RelNode child, RexNode condition) {
        super(cluster, traits, child);
        assert (condition != null);
        assert (RexUtil.isFlat(condition)) : condition;
        this.condition = condition;
    }

    protected FilterRelBase(RelInput input) {
        this(input.getCluster(), input.getTraitSet(), input.getInput(), input.getExpression("condition"));
    }

    @Override
    public List<RexNode> getChildExps() {
        return ImmutableList.of((Object)this.condition);
    }

    public RexNode getCondition() {
        return this.condition;
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        double dRows = RelMetadataQuery.getRowCount(this);
        double dCpu = RelMetadataQuery.getRowCount(this.getChild());
        double dIo = 0.0;
        return planner.getCostFactory().makeCost(dRows, dCpu, dIo);
    }

    @Override
    public double getRows() {
        return FilterRelBase.estimateFilteredRows(this.getChild(), this.condition);
    }

    public static double estimateFilteredRows(RelNode child, RexProgram program) {
        RexLocalRef programCondition = program.getCondition();
        RexNode condition = programCondition == null ? null : program.expandLocalRef(programCondition);
        return FilterRelBase.estimateFilteredRows(child, condition);
    }

    public static double estimateFilteredRows(RelNode child, RexNode condition) {
        return RelMetadataQuery.getRowCount(child) * RelMetadataQuery.getSelectivity(child, condition);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("condition", this.condition);
    }
}

