/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import java.util.Collections;
import java.util.List;
import org.eigenbase.rel.AbstractRelNode;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelVisitor;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SingleRel
extends AbstractRelNode {
    private RelNode child;

    protected SingleRel(RelOptCluster cluster, RelTraitSet traits, RelNode child) {
        super(cluster, traits);
        this.child = child;
    }

    public RelNode getChild() {
        return this.child;
    }

    @Override
    public List<RelNode> getInputs() {
        return Collections.singletonList(this.child);
    }

    @Override
    public double getRows() {
        return RelMetadataQuery.getRowCount(this.child);
    }

    @Override
    public void childrenAccept(RelVisitor visitor) {
        visitor.visit(this.child, 0, this);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).input("child", this.getChild());
    }

    @Override
    public void replaceInput(int ordinalInParent, RelNode rel) {
        assert (ordinalInParent == 0);
        this.child = rel;
    }

    @Override
    protected RelDataType deriveRowType() {
        return this.child.getRowType();
    }
}

