/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.metadata;

import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.hydromatic.optiq.BuiltinMethod;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.AggregateRelBase;
import org.eigenbase.rel.CorrelatorRel;
import org.eigenbase.rel.FilterRelBase;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.SortRel;
import org.eigenbase.rel.metadata.ReflectiveRelMetadataProvider;
import org.eigenbase.rel.metadata.RelMdUtil;
import org.eigenbase.rel.metadata.RelMetadataProvider;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.rel.rules.SemiJoinRel;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelMdUniqueKeys {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltinMethod.UNIQUE_KEYS.method, new RelMdUniqueKeys());

    private RelMdUniqueKeys() {
    }

    public Set<BitSet> getUniqueKeys(FilterRelBase rel, boolean ignoreNulls) {
        return RelMetadataQuery.getUniqueKeys(rel.getChild(), ignoreNulls);
    }

    public Set<BitSet> getUniqueKeys(SortRel rel, boolean ignoreNulls) {
        return RelMetadataQuery.getUniqueKeys(rel.getChild(), ignoreNulls);
    }

    public Set<BitSet> getUniqueKeys(CorrelatorRel rel, boolean ignoreNulls) {
        return RelMetadataQuery.getUniqueKeys(rel.getLeft(), ignoreNulls);
    }

    public Set<BitSet> getUniqueKeys(ProjectRelBase rel, boolean ignoreNulls) {
        HashMap<Integer, Integer> mapInToOutPos = new HashMap<Integer, Integer>();
        List<RexNode> projExprs = rel.getProjects();
        HashSet<BitSet> projUniqueKeySet = new HashSet<BitSet>();
        for (int i = 0; i < projExprs.size(); ++i) {
            RexNode projExpr = projExprs.get(i);
            if (!(projExpr instanceof RexInputRef)) continue;
            mapInToOutPos.put(((RexInputRef)projExpr).getIndex(), i);
        }
        if (mapInToOutPos.isEmpty()) {
            return projUniqueKeySet;
        }
        Set<BitSet> childUniqueKeySet = RelMetadataQuery.getUniqueKeys(rel.getChild(), ignoreNulls);
        if (childUniqueKeySet != null) {
            for (BitSet colMask : childUniqueKeySet) {
                BitSet tmpMask = new BitSet();
                boolean completeKeyProjected = true;
                for (int bit : BitSets.toIter(colMask)) {
                    if (mapInToOutPos.containsKey(bit)) {
                        tmpMask.set((Integer)mapInToOutPos.get(bit));
                        continue;
                    }
                    completeKeyProjected = false;
                    break;
                }
                if (!completeKeyProjected) continue;
                projUniqueKeySet.add(tmpMask);
            }
        }
        return projUniqueKeySet;
    }

    public Set<BitSet> getUniqueKeys(JoinRelBase rel, boolean ignoreNulls) {
        RelNode left = rel.getLeft();
        RelNode right = rel.getRight();
        HashSet<BitSet> retSet = new HashSet<BitSet>();
        Set<BitSet> leftSet = RelMetadataQuery.getUniqueKeys(left, ignoreNulls);
        HashSet<BitSet> rightSet = null;
        Set<BitSet> tmpRightSet = RelMetadataQuery.getUniqueKeys(right, ignoreNulls);
        int nFieldsOnLeft = left.getRowType().getFieldCount();
        if (tmpRightSet != null) {
            rightSet = new HashSet<BitSet>();
            for (BitSet colMask : tmpRightSet) {
                BitSet tmpMask = new BitSet();
                for (int bit : BitSets.toIter(colMask)) {
                    tmpMask.set(bit + nFieldsOnLeft);
                }
                rightSet.add(tmpMask);
            }
            if (leftSet != null) {
                for (BitSet colMaskRight : rightSet) {
                    for (BitSet colMaskLeft : leftSet) {
                        BitSet colMaskConcat = new BitSet();
                        colMaskConcat.or(colMaskLeft);
                        colMaskConcat.or(colMaskRight);
                        retSet.add(colMaskConcat);
                    }
                }
            }
        }
        BitSet leftJoinCols = new BitSet();
        BitSet rightJoinCols = new BitSet();
        RelMdUtil.findEquiJoinCols(left, right, rel.getCondition(), leftJoinCols, rightJoinCols);
        Boolean leftUnique = RelMetadataQuery.areColumnsUnique(left, leftJoinCols, ignoreNulls);
        Boolean rightUnique = RelMetadataQuery.areColumnsUnique(right, rightJoinCols, ignoreNulls);
        if (rightUnique != null && rightUnique.booleanValue() && leftSet != null && !rel.getJoinType().generatesNullsOnLeft()) {
            retSet.addAll(leftSet);
        }
        if (leftUnique != null && leftUnique.booleanValue() && rightSet != null && !rel.getJoinType().generatesNullsOnRight()) {
            retSet.addAll(rightSet);
        }
        return retSet;
    }

    public Set<BitSet> getUniqueKeys(SemiJoinRel rel, boolean ignoreNulls) {
        return RelMetadataQuery.getUniqueKeys(rel.getLeft(), ignoreNulls);
    }

    public Set<BitSet> getUniqueKeys(AggregateRelBase rel, boolean ignoreNulls) {
        HashSet<BitSet> retSet = new HashSet<BitSet>();
        if (rel.getGroupCount() > 0) {
            BitSet groupKey = new BitSet();
            for (int i = 0; i < rel.getGroupCount(); ++i) {
                groupKey.set(i);
            }
            retSet.add(groupKey);
        }
        return retSet;
    }

    public Set<BitSet> getUniqueKeys(RelNode rel, boolean ignoreNulls) {
        return null;
    }
}

