/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.metadata;

import java.util.BitSet;
import java.util.Set;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.metadata.BuiltInMetadata;
import org.eigenbase.rel.metadata.RelColumnOrigin;
import org.eigenbase.relopt.RelOptCost;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sql.SqlExplainLevel;
import org.eigenbase.stat.RelStatSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RelMetadataQuery {
    @Deprecated
    public static RelStatSource getStatistics(RelNode rel) {
        throw new UnsupportedOperationException();
    }

    public static Double getRowCount(RelNode rel) {
        BuiltInMetadata.RowCount metadata = rel.metadata(BuiltInMetadata.RowCount.class);
        Double result = metadata.getRowCount();
        return RelMetadataQuery.validateResult(result);
    }

    public static RelOptCost getCumulativeCost(RelNode rel) {
        BuiltInMetadata.CumulativeCost metadata = rel.metadata(BuiltInMetadata.CumulativeCost.class);
        return metadata.getCumulativeCost();
    }

    public static RelOptCost getNonCumulativeCost(RelNode rel) {
        BuiltInMetadata.NonCumulativeCost metadata = rel.metadata(BuiltInMetadata.NonCumulativeCost.class);
        return metadata.getNonCumulativeCost();
    }

    public static Double getPercentageOriginalRows(RelNode rel) {
        BuiltInMetadata.PercentageOriginalRows metadata = rel.metadata(BuiltInMetadata.PercentageOriginalRows.class);
        Double result = metadata.getPercentageOriginalRows();
        assert (RelMetadataQuery.isPercentage(result, true));
        return result;
    }

    public static Set<RelColumnOrigin> getColumnOrigins(RelNode rel, int column) {
        BuiltInMetadata.ColumnOrigin metadata = rel.metadata(BuiltInMetadata.ColumnOrigin.class);
        return metadata.getColumnOrigins(column);
    }

    public static Double getSelectivity(RelNode rel, RexNode predicate) {
        BuiltInMetadata.Selectivity metadata = rel.metadata(BuiltInMetadata.Selectivity.class);
        Double result = metadata.getSelectivity(predicate);
        assert (RelMetadataQuery.isPercentage(result, true));
        return result;
    }

    public static Set<BitSet> getUniqueKeys(RelNode rel) {
        BuiltInMetadata.UniqueKeys metadata = rel.metadata(BuiltInMetadata.UniqueKeys.class);
        return metadata.getUniqueKeys(false);
    }

    public static Set<BitSet> getUniqueKeys(RelNode rel, boolean ignoreNulls) {
        BuiltInMetadata.UniqueKeys metadata = rel.metadata(BuiltInMetadata.UniqueKeys.class);
        return metadata.getUniqueKeys(ignoreNulls);
    }

    public static Boolean areColumnsUnique(RelNode rel, BitSet columns) {
        BuiltInMetadata.ColumnUniqueness metadata = rel.metadata(BuiltInMetadata.ColumnUniqueness.class);
        return metadata.areColumnsUnique(columns, false);
    }

    public static Boolean areColumnsUnique(RelNode rel, BitSet columns, boolean ignoreNulls) {
        BuiltInMetadata.ColumnUniqueness metadata = rel.metadata(BuiltInMetadata.ColumnUniqueness.class);
        return metadata.areColumnsUnique(columns, ignoreNulls);
    }

    public static Double getPopulationSize(RelNode rel, BitSet groupKey) {
        BuiltInMetadata.PopulationSize metadata = rel.metadata(BuiltInMetadata.PopulationSize.class);
        Double result = metadata.getPopulationSize(groupKey);
        return RelMetadataQuery.validateResult(result);
    }

    public static Double getDistinctRowCount(RelNode rel, BitSet groupKey, RexNode predicate) {
        BuiltInMetadata.DistinctRowCount metadata = rel.metadata(BuiltInMetadata.DistinctRowCount.class);
        Double result = metadata.getDistinctRowCount(groupKey, predicate);
        return RelMetadataQuery.validateResult(result);
    }

    public static boolean isVisibleInExplain(RelNode rel, SqlExplainLevel explainLevel) {
        BuiltInMetadata.ExplainVisibility metadata = rel.metadata(BuiltInMetadata.ExplainVisibility.class);
        Boolean b = metadata.isVisibleInExplain(explainLevel);
        return b == null || b != false;
    }

    private static boolean isPercentage(Double result, boolean fail) {
        if (result != null) {
            double d = result;
            if (d < 0.0) {
                assert (!fail);
                return false;
            }
            if (d > 1.0) {
                assert (!fail);
                return false;
            }
        }
        return true;
    }

    private static boolean isNonNegative(Double result, boolean fail) {
        double d;
        if (result != null && (d = result.doubleValue()) < 0.0) {
            assert (!fail);
            return false;
        }
        return true;
    }

    private static Double validateResult(Double result) {
        if (result == null) {
            return null;
        }
        if (result.isInfinite()) {
            result = Double.MAX_VALUE;
        }
        assert (RelMetadataQuery.isNonNegative(result, true));
        if (result < 1.0) {
            result = 1.0;
        }
        return result;
    }
}

