/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import java.util.Collections;
import org.eigenbase.rel.CalcRel;
import org.eigenbase.rel.JoinRel;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.reltype.RelDataTypeField;

public final class ExtractJoinFilterRule
extends RelOptRule {
    public static final ExtractJoinFilterRule INSTANCE = new ExtractJoinFilterRule();

    private ExtractJoinFilterRule() {
        super(ExtractJoinFilterRule.operand(JoinRel.class, ExtractJoinFilterRule.any()));
    }

    public void onMatch(RelOptRuleCall call) {
        JoinRel joinRel = (JoinRel)call.rel(0);
        if (joinRel.getJoinType() != JoinRelType.INNER) {
            return;
        }
        if (joinRel.getCondition().isAlwaysTrue()) {
            return;
        }
        if (!joinRel.getSystemFieldList().isEmpty()) {
            return;
        }
        JoinRel cartesianJoinRel = new JoinRel(joinRel.getCluster(), joinRel.getLeft(), joinRel.getRight(), joinRel.getCluster().getRexBuilder().makeLiteral(true), joinRel.getJoinType(), Collections.<String>emptySet(), joinRel.isSemiJoinDone(), Collections.<RelDataTypeField>emptyList());
        RelNode filterRel = CalcRel.createFilter(cartesianJoinRel, joinRel.getCondition());
        call.transformTo(filterRel);
    }
}

