/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import java.util.Arrays;
import java.util.List;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlJoinOperator;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.type.SqlTypeName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlJoin
extends SqlCall {
    SqlNode left;
    SqlLiteral natural;
    SqlLiteral joinType;
    SqlNode right;
    SqlLiteral conditionType;
    SqlNode condition;

    public SqlJoin(SqlParserPos pos, SqlNode left, SqlLiteral natural, SqlLiteral joinType, SqlNode right, SqlLiteral conditionType, SqlNode condition) {
        super(pos);
        this.left = left;
        this.natural = natural;
        this.joinType = joinType;
        this.right = right;
        this.conditionType = conditionType;
        this.condition = condition;
        assert (natural.getTypeName() == SqlTypeName.BOOLEAN);
        assert (conditionType != null);
        assert (SqlLiteral.symbolValue(conditionType) instanceof SqlJoinOperator.ConditionType);
        assert (joinType != null);
        assert (SqlLiteral.symbolValue(joinType) instanceof SqlJoinOperator.JoinType);
    }

    @Override
    public SqlOperator getOperator() {
        return SqlStdOperatorTable.JOIN;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.JOIN;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return Arrays.asList(this.left, this.natural, this.joinType, this.right, this.conditionType, this.condition);
    }

    @Override
    public void setOperand(int i, SqlNode operand) {
        switch (i) {
            case 0: {
                this.left = operand;
                break;
            }
            case 1: {
                this.natural = (SqlLiteral)operand;
                break;
            }
            case 2: {
                this.joinType = (SqlLiteral)operand;
                break;
            }
            case 3: {
                this.right = operand;
                break;
            }
            case 4: {
                this.conditionType = (SqlLiteral)operand;
                break;
            }
            case 5: {
                this.condition = operand;
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    public final SqlNode getCondition() {
        return this.condition;
    }

    public final SqlJoinOperator.ConditionType getConditionType() {
        return (SqlJoinOperator.ConditionType)SqlLiteral.symbolValue(this.conditionType);
    }

    public SqlLiteral getConditionTypeNode() {
        return this.conditionType;
    }

    public final SqlJoinOperator.JoinType getJoinType() {
        return (SqlJoinOperator.JoinType)SqlLiteral.symbolValue(this.joinType);
    }

    public SqlLiteral getJoinTypeNode() {
        return this.joinType;
    }

    public final SqlNode getLeft() {
        return this.left;
    }

    public void setLeft(SqlNode left) {
        this.left = left;
    }

    public final boolean isNatural() {
        return SqlLiteral.booleanValue(this.natural);
    }

    public final SqlLiteral isNaturalNode() {
        return this.natural;
    }

    public final SqlNode getRight() {
        return this.right;
    }

    public void setRight(SqlNode right) {
        this.right = right;
    }
}

