/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.fun;

import org.eigenbase.reltype.RelDataType;
import org.eigenbase.resource.EigenbaseResource;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlFunction;
import org.eigenbase.sql.SqlFunctionCategory;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlOperatorBinding;
import org.eigenbase.sql.SqlSyntax;
import org.eigenbase.sql.type.OperandTypes;
import org.eigenbase.sql.type.SqlOperandTypeChecker;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.type.SqlTypeUtil;
import org.eigenbase.sql.validate.SqlMonotonicity;
import org.eigenbase.sql.validate.SqlValidatorScope;

public class SqlAbstractTimeFunction
extends SqlFunction {
    private static final SqlOperandTypeChecker OTC_CUSTOM = OperandTypes.or(OperandTypes.POSITIVE_INTEGER_LITERAL, OperandTypes.NILADIC);
    private final SqlTypeName typeName;

    protected SqlAbstractTimeFunction(String name, SqlTypeName typeName) {
        super(name, SqlKind.OTHER_FUNCTION, null, null, OTC_CUSTOM, SqlFunctionCategory.TIMEDATE);
        this.typeName = typeName;
    }

    public SqlSyntax getSyntax() {
        return SqlSyntax.FUNCTION_ID;
    }

    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataType type;
        int precision = 0;
        if (opBinding.getOperandCount() == 1 && SqlTypeUtil.isNumeric(type = opBinding.getOperandType(0))) {
            precision = opBinding.getIntLiteralOperand(0);
        }
        assert (precision >= 0);
        if (precision > 3) {
            throw opBinding.newError(EigenbaseResource.instance().ArgumentMustBeValidPrecision.ex(opBinding.getOperator().getName(), "0", String.valueOf(3)));
        }
        return opBinding.getTypeFactory().createSqlType(this.typeName, precision);
    }

    public SqlMonotonicity getMonotonicity(SqlCall call, SqlValidatorScope scope) {
        return SqlMonotonicity.INCREASING;
    }

    public boolean isDynamicFunction() {
        return true;
    }
}

