/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.fun;

import java.util.List;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.resource.EigenbaseResource;
import org.eigenbase.sql.SqlCallBinding;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlOperatorBinding;
import org.eigenbase.sql.fun.SqlMultisetValueConstructor;
import org.eigenbase.sql.type.SqlTypeUtil;
import org.eigenbase.sql.validate.SqlValidatorException;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlMapValueConstructor
extends SqlMultisetValueConstructor {
    public SqlMapValueConstructor() {
        super("MAP", SqlKind.MAP_VALUE_CONSTRUCTOR);
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        Pair<RelDataType, RelDataType> type = this.getComponentTypes(opBinding.getTypeFactory(), opBinding.collectOperandTypes());
        if (null == type) {
            return null;
        }
        return SqlTypeUtil.createMapType(opBinding.getTypeFactory(), (RelDataType)type.left, (RelDataType)type.right, false);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        List<RelDataType> argTypes = SqlTypeUtil.deriveAndCollectTypes(callBinding.getValidator(), callBinding.getScope(), callBinding.getCall().getOperandList());
        if (argTypes.size() == 0) {
            throw callBinding.newValidationError(new SqlValidatorException("Map requires at least 2 arguments", null));
        }
        if (argTypes.size() % 2 > 0) {
            throw callBinding.newValidationError(new SqlValidatorException("Map requires an even number of arguments", null));
        }
        Pair<RelDataType, RelDataType> componentType = this.getComponentTypes(callBinding.getTypeFactory(), argTypes);
        if (null == componentType.left || null == componentType.right) {
            if (throwOnFailure) {
                throw callBinding.newValidationError(EigenbaseResource.instance().NeedSameTypeParameter.ex());
            }
            return false;
        }
        return true;
    }

    private Pair<RelDataType, RelDataType> getComponentTypes(RelDataTypeFactory typeFactory, List<RelDataType> argTypes) {
        return Pair.of(typeFactory.leastRestrictive(Util.quotientList(argTypes, 2, 0)), typeFactory.leastRestrictive(Util.quotientList(argTypes, 2, 1)));
    }
}

