/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.type;

import org.eigenbase.sql.SqlOperandCountRange;

public abstract class SqlOperandCountRanges {
    public static SqlOperandCountRange of(int length) {
        return new RangeImpl(length, length);
    }

    public static SqlOperandCountRange between(int min, int max) {
        assert (min < max);
        return new RangeImpl(min, max);
    }

    public static SqlOperandCountRange any() {
        return new VariadicImpl();
    }

    private static class RangeImpl
    implements SqlOperandCountRange {
        private final int min;
        private final int max;

        public RangeImpl(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public boolean isValidCount(int count) {
            return count >= this.min && count <= this.max;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }
    }

    private static class VariadicImpl
    implements SqlOperandCountRange {
        private VariadicImpl() {
        }

        public boolean isValidCount(int count) {
            return true;
        }

        public int getMin() {
            return 0;
        }

        public int getMax() {
            return -1;
        }
    }
}

