/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.validate;

import java.util.ArrayList;
import java.util.List;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.resource.EigenbaseResource;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.validate.AbstractNamespace;
import org.eigenbase.sql.validate.SqlValidatorImpl;
import org.eigenbase.sql.validate.SqlValidatorNamespace;
import org.eigenbase.util.Util;

public class AliasNamespace
extends AbstractNamespace {
    protected final SqlCall call;

    protected AliasNamespace(SqlValidatorImpl validator, SqlCall call, SqlNode enclosingNode) {
        super(validator, enclosingNode);
        this.call = call;
        assert (call.getOperator() == SqlStdOperatorTable.AS);
    }

    protected RelDataType validateImpl() {
        ArrayList<String> nameList = new ArrayList<String>();
        List<SqlNode> operands = this.call.getOperandList();
        SqlValidatorNamespace childNs = this.validator.getNamespace(operands.get(0));
        RelDataType rowType = childNs.getRowTypeSansSystemColumns();
        for (SqlNode operand : Util.skip(operands, 2)) {
            String name = ((SqlIdentifier)operand).getSimple();
            if (nameList.contains(name)) {
                throw this.validator.newValidationError(operand, EigenbaseResource.instance().AliasListDuplicate.ex(name));
            }
            nameList.add(name);
        }
        if (nameList.size() != rowType.getFieldCount()) {
            throw this.validator.newValidationError(operands.get(2), EigenbaseResource.instance().AliasListDegree.ex(rowType.getFieldCount(), this.getString(rowType), nameList.size()));
        }
        ArrayList<RelDataType> typeList = new ArrayList<RelDataType>();
        for (RelDataTypeField field : rowType.getFieldList()) {
            typeList.add(field.getType());
        }
        return this.validator.getTypeFactory().createStructType(typeList, nameList);
    }

    private String getString(RelDataType rowType) {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        for (RelDataTypeField field : rowType.getFieldList()) {
            if (field.getIndex() > 0) {
                buf.append(", ");
            }
            buf.append("'");
            buf.append(field.getName());
            buf.append("'");
        }
        buf.append(")");
        return buf.toString();
    }

    public SqlNode getNode() {
        return this.call;
    }

    public String translate(String name) {
        RelDataType underlyingRowType = this.validator.getValidatedNodeType((SqlNode)this.call.operand(0));
        int i = 0;
        for (RelDataTypeField field : this.rowType.getFieldList()) {
            if (field.getName().equals(name)) {
                return underlyingRowType.getFieldList().get(i).getName();
            }
            ++i;
        }
        throw new AssertionError((Object)("unknown field '" + name + "' in rowtype " + underlyingRowType));
    }
}

