/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.validate;

import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.type.MultisetSqlType;
import org.eigenbase.sql.validate.AbstractNamespace;
import org.eigenbase.sql.validate.SqlValidatorImpl;
import org.eigenbase.sql.validate.SqlValidatorScope;
import org.eigenbase.util.Util;

public class CollectNamespace
extends AbstractNamespace {
    private final SqlCall child;
    private final SqlValidatorScope scope;

    CollectNamespace(SqlCall child, SqlValidatorScope scope, SqlNode enclosingNode) {
        super((SqlValidatorImpl)scope.getValidator(), enclosingNode);
        this.child = child;
        this.scope = scope;
    }

    protected RelDataType validateImpl() {
        RelDataType type = this.child.getOperator().deriveType(this.validator, this.scope, this.child);
        switch (this.child.getKind()) {
            case MULTISET_VALUE_CONSTRUCTOR: {
                boolean isNullable = type.isNullable();
                RelDataType componentType = ((MultisetSqlType)type).getComponentType();
                RelDataTypeFactory typeFactory = this.validator.getTypeFactory();
                if (componentType.isStruct()) {
                    return type;
                }
                RelDataType structType = typeFactory.createStructType(new RelDataType[]{type}, new String[]{this.validator.deriveAlias(this.child, 0)});
                RelDataType multisetType = typeFactory.createMultisetType(structType, -1L);
                return typeFactory.createTypeWithNullability(multisetType, isNullable);
            }
            case MULTISET_QUERY_CONSTRUCTOR: {
                assert (type instanceof MultisetSqlType && ((MultisetSqlType)type).getComponentType().isStruct()) : type;
                return type;
            }
        }
        throw Util.unexpected(this.child.getKind());
    }

    public SqlNode getNode() {
        return this.child;
    }

    public SqlValidatorScope getScope() {
        return this.scope;
    }
}

