/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util14;

import java.nio.ByteOrder;
import java.text.NumberFormat;
import org.eigenbase.resource.EigenbaseResource;
import org.eigenbase.util14.NumberUtil;

public class ConversionUtil {
    public static final String NATIVE_UTF16_CHARSET_NAME = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? "UTF-16BE" : "UTF-16LE";
    public static final String TEST_UNICODE_STRING = "\u03b1\u03bd\u03b8\u03c1\u03c9\u03c0\u03bf\u03c2";
    public static final String TEST_UNICODE_SQL_ESCAPED_LITERAL = "\\03B1\\03BD\\03B8\\03C1\\03C9\\03C0\\03BF\\03C2";

    private ConversionUtil() {
    }

    public static String toStringFromByteArray(byte[] value, int radix) {
        assert (2 == radix || 16 == radix) : "Make sure that the algorithm below works for your radix";
        if (0 == value.length) {
            return "";
        }
        int trick = radix * radix;
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < value.length; ++i) {
            ret.append(Integer.toString(trick | 0xFF & value[i], radix).substring(1));
        }
        return ret.toString().toUpperCase();
    }

    public static byte[] toByteArrayFromString(String value, int radix) {
        assert (16 == radix) : "Specified string to byte array conversion not supported yet";
        assert (value.length() % 2 == 0) : "Hex binary string must contain even number of characters";
        byte[] ret = new byte[value.length() / 2];
        for (int i = 0; i < ret.length; ++i) {
            int digit1 = Character.digit(value.charAt(i * 2), radix);
            int digit2 = Character.digit(value.charAt(i * 2 + 1), radix);
            assert (digit1 != -1 && digit2 != -1) : "String could not be converted to byte array";
            ret[i] = (byte)(digit1 * radix + digit2);
        }
        return ret;
    }

    public static String toStringFromApprox(double d, boolean isFloat) {
        NumberFormat nf = NumberUtil.getApproxFormatter(isFloat);
        return nf.format(d);
    }

    public static Boolean toBoolean(String str) {
        if (str == null) {
            return null;
        }
        if ((str = str.trim()).equalsIgnoreCase("TRUE")) {
            return Boolean.TRUE;
        }
        if (str.equalsIgnoreCase("FALSE")) {
            return Boolean.FALSE;
        }
        if (str.equalsIgnoreCase("UNKNOWN")) {
            return null;
        }
        throw EigenbaseResource.instance().InvalidBoolean.ex(str);
    }
}

