/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util14;

import java.sql.Timestamp;
import java.text.DateFormat;
import org.eigenbase.util14.DateTimeUtil;
import org.eigenbase.util14.ZonelessDatetime;

public class ZonelessTimestamp
extends ZonelessDatetime {
    private static final long serialVersionUID = -6829714640541648394L;
    protected final int precision;
    protected transient Timestamp tempTimestamp;

    public ZonelessTimestamp() {
        this.precision = 0;
    }

    public ZonelessTimestamp(int precision) {
        this.precision = precision;
    }

    public Object toJdbcObject() {
        return new Timestamp(this.getJdbcTimestamp(DateTimeUtil.DEFAULT_ZONE));
    }

    public String toString() {
        Timestamp ts = this.getTempTimestamp(this.getJdbcTimestamp(DateTimeUtil.DEFAULT_ZONE));
        return ts.toString().substring(0, 19);
    }

    public String toString(String format) {
        DateFormat formatter = this.getFormatter(format);
        Timestamp ts = this.getTempTimestamp(this.getTime());
        return formatter.format(ts);
    }

    public static ZonelessTimestamp parse(String s) {
        return ZonelessTimestamp.parse(s, "yyyy-MM-dd HH:mm:ss");
    }

    public static ZonelessTimestamp parse(String s, String format) {
        DateTimeUtil.PrecisionTime pt = DateTimeUtil.parsePrecisionDateTimeLiteral(s, format, DateTimeUtil.GMT_ZONE);
        if (pt == null) {
            return null;
        }
        ZonelessTimestamp zt = new ZonelessTimestamp(pt.getPrecision());
        zt.setZonelessTime(pt.getCalendar().getTime().getTime());
        return zt;
    }

    protected Timestamp getTempTimestamp(long value) {
        if (this.tempTimestamp == null) {
            this.tempTimestamp = new Timestamp(value);
        } else {
            this.tempTimestamp.setTime(value);
        }
        return this.tempTimestamp;
    }
}

