/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mongo;

import com.sun.security.auth.module.Krb5LoginModule;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class KerberosUtil {
    private static final String KERBEROS_APP_NAME = "pentaho";
    private static final String PENTAHO_JAAS_DEBUG = "PENTAHO_JAAS_DEBUG";
    private static final Map<String, String> LOGIN_CONFIG_BASE = new HashMap<String, String>();
    private static final Map<String, String> LOGIN_CONFIG_OPTS_KERBEROS_USER;
    private static final Map<String, String> LOGIN_CONFIG_OPTS_KERBEROS_KEYTAB;
    private static final AppConfigurationEntry CONFIG_ENTRY_PENTAHO_KERBEROS_USER;
    private static final AppConfigurationEntry[] CONFIG_ENTRIES_KERBEROS_USER;

    public static LoginContext loginAs(String principal) throws LoginException {
        return KerberosUtil.loginAs(JaasAuthenticationMode.KERBEROS_USER, principal, null);
    }

    public static LoginContext loginAs(JaasAuthenticationMode authMode, String principal, String keytabFile) throws LoginException {
        LoginContext lc;
        switch (authMode) {
            case EXTERNAL: {
                lc = new LoginContext(KERBEROS_APP_NAME);
            }
            case KERBEROS_USER: {
                Subject subject = new Subject();
                lc = new LoginContext(KERBEROS_APP_NAME, subject, null, new PentahoLoginConfiguration(CONFIG_ENTRIES_KERBEROS_USER));
                break;
            }
            case KERBEROS_KEYTAB: {
                lc = KerberosUtil.createLoginContextWithKeytab(principal, keytabFile);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported authentication mode: " + (Object)((Object)authMode));
            }
        }
        lc.login();
        return lc;
    }

    private static LoginContext createLoginContextWithKeytab(String principal, String keytabFile) throws LoginException {
        if (keytabFile == null) {
            throw new IllegalArgumentException("A keytab file is required to authenticate with Kerberos via keytab");
        }
        HashMap<String, String> keytabConfig = new HashMap<String, String>(LOGIN_CONFIG_OPTS_KERBEROS_KEYTAB);
        keytabConfig.put("keyTab", keytabFile);
        keytabConfig.put("principal", principal);
        AppConfigurationEntry config = new AppConfigurationEntry(Krb5LoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, keytabConfig);
        AppConfigurationEntry[] configEntries = new AppConfigurationEntry[]{config};
        Subject subject = new Subject();
        return new LoginContext(KERBEROS_APP_NAME, subject, null, new PentahoLoginConfiguration(configEntries));
    }

    static {
        if (Boolean.parseBoolean(System.getenv(PENTAHO_JAAS_DEBUG))) {
            LOGIN_CONFIG_BASE.put("debug", Boolean.TRUE.toString());
        }
        LOGIN_CONFIG_OPTS_KERBEROS_USER = new HashMap<String, String>(LOGIN_CONFIG_BASE);
        LOGIN_CONFIG_OPTS_KERBEROS_USER.put("doNotPrompt", Boolean.TRUE.toString());
        LOGIN_CONFIG_OPTS_KERBEROS_USER.put("useTicketCache", Boolean.TRUE.toString());
        LOGIN_CONFIG_OPTS_KERBEROS_USER.put("renewTGT", Boolean.TRUE.toString());
        String ticketCache = System.getenv("KRB5CCNAME");
        if (ticketCache != null) {
            LOGIN_CONFIG_OPTS_KERBEROS_USER.put("ticketCache", ticketCache);
        }
        LOGIN_CONFIG_OPTS_KERBEROS_KEYTAB = new HashMap<String, String>(LOGIN_CONFIG_BASE);
        LOGIN_CONFIG_OPTS_KERBEROS_KEYTAB.put("doNotPrompt", Boolean.TRUE.toString());
        LOGIN_CONFIG_OPTS_KERBEROS_KEYTAB.put("useKeyTab", Boolean.TRUE.toString());
        LOGIN_CONFIG_OPTS_KERBEROS_KEYTAB.put("storeKey", Boolean.TRUE.toString());
        LOGIN_CONFIG_OPTS_KERBEROS_KEYTAB.put("refreshKrb5Config", Boolean.TRUE.toString());
        CONFIG_ENTRY_PENTAHO_KERBEROS_USER = new AppConfigurationEntry(Krb5LoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, LOGIN_CONFIG_OPTS_KERBEROS_USER);
        CONFIG_ENTRIES_KERBEROS_USER = new AppConfigurationEntry[]{CONFIG_ENTRY_PENTAHO_KERBEROS_USER};
    }

    public static enum JaasAuthenticationMode {
        KERBEROS_USER,
        KERBEROS_KEYTAB,
        EXTERNAL;

    }

    private static class PentahoLoginConfiguration
    extends Configuration {
        private AppConfigurationEntry[] entries;

        public PentahoLoginConfiguration(AppConfigurationEntry[] entries) {
            if (entries == null) {
                throw new NullPointerException("AppConfigurationEntry[] is required");
            }
            this.entries = entries;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String ignored) {
            return this.entries;
        }
    }
}

