/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mongo;

import com.mongodb.DBObject;
import com.mongodb.ReadPreference;
import com.mongodb.TaggableReadPreference;
import java.util.ArrayList;
import java.util.Collection;

public enum NamedReadPreference {
    PRIMARY(ReadPreference.primary()),
    PRIMARY_PREFERRED(ReadPreference.primaryPreferred()),
    SECONDARY(ReadPreference.secondary()),
    SECONDARY_PREFERRED(ReadPreference.secondaryPreferred()),
    NEAREST(ReadPreference.nearest());

    private ReadPreference pref = null;

    private NamedReadPreference(ReadPreference pref) {
        this.pref = pref;
    }

    public String getName() {
        return this.pref.getName();
    }

    public ReadPreference getPreference() {
        return this.pref;
    }

    public static Collection<String> getPreferenceNames() {
        ArrayList<String> prefs = new ArrayList<String>();
        for (NamedReadPreference preference : NamedReadPreference.values()) {
            prefs.add(preference.getName());
        }
        return prefs;
    }

    public ReadPreference getTaggableReadPreference(DBObject firstTagSet, DBObject ... remainingTagSets) {
        switch (this) {
            case PRIMARY_PREFERRED: {
                return ReadPreference.primaryPreferred((DBObject)firstTagSet, (DBObject[])remainingTagSets);
            }
            case SECONDARY: {
                return ReadPreference.secondary((DBObject)firstTagSet, (DBObject[])remainingTagSets);
            }
            case SECONDARY_PREFERRED: {
                return ReadPreference.secondaryPreferred((DBObject)firstTagSet, (DBObject[])remainingTagSets);
            }
            case NEAREST: {
                return ReadPreference.nearest((DBObject)firstTagSet, (DBObject[])remainingTagSets);
            }
        }
        return this.pref instanceof TaggableReadPreference ? this.pref : null;
    }

    public static NamedReadPreference byName(String preferenceName) {
        NamedReadPreference foundPreference = null;
        for (NamedReadPreference preference : NamedReadPreference.values()) {
            if (!preference.getName().equalsIgnoreCase(preferenceName)) continue;
            foundPreference = preference;
            break;
        }
        return foundPreference;
    }
}

